/*
 * Decompiled with CFR 0.152.
 */
package android.app.smdt;

import android.app.smdt.IAppDeleteObserver;
import android.app.smdt.IAppInstallObserver;
import android.app.smdt.IOnclickListener;
import android.app.smdt.ISmdtManagerNew;
import android.app.smdt.LogcatFileManager;
import android.app.smdt.NetworkInfoData;
import android.app.smdt.SystemLogcat;
import android.app.smdt.WifiUtils;
import android.app.smdt.util.ErrorCode;
import android.app.smdt.util.MethodUtil;
import android.content.ContentResolver;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.hardware.Camera;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.List;

public class SmdtManager {
    private static SmdtManager instance;
    private ISmdtManagerNew mService;
    private Context mContext;
    private boolean isSystemApp = false;
    private IBinder.DeathRecipient mDeathRecipient = new IBinder.DeathRecipient(){

        public void binderDied() {
            if (SmdtManager.this.mService != null) {
                Log.e((String)"SMDTAPI", (String)"Binder Died!");
                SmdtManager.this.mService.asBinder().unlinkToDeath(SmdtManager.this.mDeathRecipient, 0);
                SmdtManager.this.mService = null;
            }
        }
    };
    public static final String LED_WHITE = "LED_WHITE";
    public static final String LED_RED = "LED_RED";
    public static final String LED_GREEN = "LED_GREEN";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SmdtManager create(Context context) {
        if (instance != null) return instance;
        Class<SmdtManager> clazz = SmdtManager.class;
        synchronized (SmdtManager.class) {
            instance = new SmdtManager(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    private SmdtManager(Context context) {
        this.mContext = context.getApplicationContext();
        this.getService();
        int uid = Binder.getCallingUid();
        if (uid == 1000) {
            this.isSystemApp = true;
        }
    }

    private boolean getService() {
        if (this.mService == null || !this.mService.asBinder().isBinderAlive()) {
            IBinder mIBinder = ServiceManager.getService((String)MethodUtil.SERVICENAME);
            this.mService = ISmdtManagerNew.Stub.asInterface(mIBinder);
            Log.d((String)"SMDTAPI", (String)("get service binder :" + this.mService));
            try {
                if (this.mService != null) {
                    mIBinder.linkToDeath(this.mDeathRecipient, 0);
                }
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        return this.mService != null && this.mService.asBinder().isBinderAlive();
    }

    private void DEBUG(int level, String msg) {
        if (!this.getService()) {
            return;
        }
        try {
            this.mService.sys_printApiDebug(level, msg);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public int getScreenNumber() {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.disp_getScreenModel();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    public int getHdmiinStatus() {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.disp_getHdmiInStatus();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    public int getExtendScreenWidth() {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.disp_getScreenWidth(1);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    public int getExtendScreenHeight() {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.disp_getScreenHeight(1);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    public String getSDpath() {
        if (!this.getService()) {
            return "";
        }
        try {
            return this.mService.dev_getSDcardPath();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return "";
        }
    }

    public String getUSBpath(int num) {
        if (!this.getService()) {
            return "";
        }
        try {
            List<String> usbList = this.mService.dev_getUdiskPath();
            if (usbList != null && usbList.size() >= num) {
                return usbList.get(num);
            }
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
        }
        return "";
    }

    public void unmountVolume(String path, boolean force, boolean removeEncryption) {
        if (!this.getService()) {
            return;
        }
        try {
            this.mService.dev_unmountExternalStorage(path, force, removeEncryption);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
        }
    }

    public int setHeadsetMicOnOff(int value) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_setInVolume(0, value == 1);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    public void shutDown() {
        if (!this.getService()) {
            return;
        }
        try {
            this.mService.sys_setPowerOff();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
        }
    }

    public String getMCUVersion() {
        if (!this.getService()) {
            return "";
        }
        try {
            return this.mService.info_getMCUVersion();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return null;
        }
    }

    public int smdtReadExtrnalGpioValue(int gpioNumber) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_getGpioValue(gpioNumber);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    public int smdtSetExtrnalGpioValue(int gpioNumber, boolean isTrue) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_setGpioDirection(gpioNumber, 1, isTrue ? 1 : 0);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    public void smdtSilentInstall(String path, Context context) {
        if (!this.getService()) {
            return;
        }
        try {
            this.mService.sys_doSilentInstallApp(path, null);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
        }
    }

    public String getUartPath(String serialPort) {
        if (!this.getService()) {
            return "";
        }
        try {
            return this.mService.dev_getUartPath(serialPort);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return null;
        }
    }

    public String getRunningMemory() {
        if (!this.getService()) {
            return "";
        }
        try {
            return this.mService.info_getTotalMemory();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return null;
        }
    }

    public String getInternalStorageMemory() {
        if (!this.getService()) {
            return "";
        }
        try {
            return this.mService.info_getTotalStorage();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return null;
        }
    }

    public String smdtGetSDcardPath(Context context) {
        if (!this.getService()) {
            return "";
        }
        try {
            return this.mService.dev_getSDcardPath();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return null;
        }
    }

    public String smdtGetUSBPath(Context context, int num) {
        if (!this.getService()) {
            return "";
        }
        try {
            List<String> list = this.mService.dev_getUdiskPath();
            if (num >= list.size()) {
                return "null";
            }
            return list.get(num).toString();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return null;
        }
    }

    public String getFormattedKernelVersion() {
        if (!this.getService()) {
            return "";
        }
        try {
            return this.mService.info_getKernelVersion();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return null;
        }
    }

    public void smdtReboot(String reason) {
        if (!this.getService()) {
            return;
        }
        try {
            this.mService.sys_setReboot();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
        }
    }

    public int smdtSetUSBEnable(int values) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.dev_setUSBEnable(values == 1);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    public int setUsbMode(int usb, int mode) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_setOTGMode(mode);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    public void setVolumeStates(int flag) {
        if (!this.getService()) {
            return;
        }
        try {
            this.mService.sys_setVolumeStates(flag);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
        }
    }

    public boolean setHdmiInAudioEnable(Context context, boolean enable) {
        if (!this.getService()) {
            return false;
        }
        try {
            return this.mService.disp_setHdmiInAudio(enable) == 1;
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return false;
        }
    }

    public void setPowerOffOnAlarm(String offTime, String OnTime) {
        if (!this.getService()) {
            return;
        }
        try {
            this.mService.sys_setPowerOffOnAlarm(offTime, OnTime, "1");
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
        }
    }

    public void smdtSetTimingSwitchMachine(String offTime, String OnTime, String enable) {
        if (!this.getService()) {
            return;
        }
        try {
            this.mService.sys_setPowerOffOnAlarm(offTime, OnTime, enable);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
        }
    }

    public void smdtSetEthIPAddress(String mIpaddr, String mMask, String mGw, String mDns) {
        if (!this.getService()) {
            return;
        }
        try {
            this.mService.net_setNetWorkModel("eth0", 1, mIpaddr, mGw, mMask, mDns, "");
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
        }
    }

    public void execSuCmd(String cmd) {
        if (!this.getService()) {
            return;
        }
        try {
            this.mService.sys_doSuCmd(cmd);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
        }
    }

    public String getAndroidBoardType() {
        if (!this.getService()) {
            return "";
        }
        try {
            return this.mService.info_getBoardType();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return "";
        }
    }

    public void setRotation(String str) {
        if (!this.getService()) {
            return;
        }
        try {
            this.mService.disp_setDisplayRotation(0, Integer.parseInt(str));
            this.mService.disp_setDisplayRotation(1, Integer.parseInt(str));
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
        }
    }

    public String getCurrentNetType() {
        if (!this.getService()) {
            return "";
        }
        try {
            return this.mService.net_getCurrentNetType();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return null;
        }
    }

    public String[] smdtGetSerialPorts() {
        if (!this.getService()) {
            return null;
        }
        try {
            return this.mService.dev_getSerialPorts();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return null;
        }
    }

    public void smdtReboot() {
        if (!this.getService()) {
            return;
        }
        try {
            this.mService.sys_setReboot();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
        }
    }

    public String smdtGetAPIVersion() {
        if (!this.getService()) {
            return "";
        }
        try {
            return this.mService.info_getApiVersion();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return null;
        }
    }

    public String getApiplatformVersion() {
        if (!this.getService()) {
            return "";
        }
        try {
            return this.mService.info_getApiVersion();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return null;
        }
    }

    public boolean setTimeFromNetwork(boolean autotiestatus, Context context) {
        if (!this.getService()) {
            return false;
        }
        try {
            return this.mService.sys_setNetworkTimeSync(autotiestatus) == ErrorCode.RET_API_OK;
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return false;
        }
    }

    public void setBrightness(ContentResolver resolver, int brightness) {
        if (!this.getService()) {
            return;
        }
        try {
            this.mService.disp_setLcdBackLight(0, brightness, 0, true);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
        }
    }

    public Bitmap onPreview(byte[] data, Camera camera) {
        Camera.Size size = camera.getParameters().getPreviewSize();
        int width = size.width;
        int height = size.height;
        YuvImage image = new YuvImage(data, 17, width, height, null);
        ByteArrayOutputStream os = new ByteArrayOutputStream(data.length);
        if (!image.compressToJpeg(new Rect(0, 0, width, height), 100, (OutputStream)os)) {
            return null;
        }
        byte[] tmp = os.toByteArray();
        Bitmap bmp = BitmapFactory.decodeByteArray((byte[])tmp, (int)0, (int)tmp.length);
        return bmp;
    }

    public int setTime(Context context, int year, int month, int day, int hourOfDay, int minute) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        if (month == 2 && day == 30) {
            return -1;
        }
        Calendar c = Calendar.getInstance();
        c.set(1, year);
        c.set(2, month - 1);
        c.set(5, day);
        c.set(11, hourOfDay);
        c.set(12, minute);
        try {
            return this.mService.sys_setTime(c.getTimeInMillis());
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    public int smdtSetStatusBar(Context context, boolean enable) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            if (this.mService.disp_setStatusBar(enable) == ErrorCode.RET_API_OK && this.mService.disp_setNavigationBar(enable) == ErrorCode.RET_API_OK) {
                return ErrorCode.RET_API_OK;
            }
            return ErrorCode.RET_API_ERR_NG;
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    public int smdtGetStatusBar(Context context) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            if (this.mService.disp_getStatusBar() == 1 && this.mService.disp_getNavigationBar() == 1) {
                return 1;
            }
            return 0;
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    public byte[] smdtReadExtROM(int deviceId, int areaId, int start_addr, int size) {
        if (!this.getService()) {
            return null;
        }
        try {
            return this.mService.dev_readPublicPartition(1, deviceId, areaId, start_addr, size);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return null;
        }
    }

    public int smdtWriteExtROM(int deviceId, int areaId, int start_addr, int size, byte[] buf) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.dev_writePublicPartition(1, deviceId, areaId, start_addr, size, buf);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    public String smdtGetDispParams(String key) {
        return "";
    }

    public int smdtSetDispParams(byte[] key, byte[] value) {
        return ErrorCode.RET_API_ERR_NG;
    }

    public int getScreenBrightness(Context context) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.disp_getLcdBackLight(0);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    public String getAndroidVersion() {
        if (!this.getService()) {
            return "";
        }
        try {
            return this.mService.info_getAndroidVersion();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return null;
        }
    }

    public String getAndroidDisplay() {
        if (!this.getService()) {
            return "";
        }
        try {
            return this.mService.info_getSoftwareVersion();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return null;
        }
    }

    public String getAndroidModel() {
        if (!this.getService()) {
            return "";
        }
        try {
            return this.mService.info_getModel();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return null;
        }
    }

    public String getFirmwareVersion() {
        if (!this.getService()) {
            return "";
        }
        try {
            return this.mService.info_getHardwareVersion();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return null;
        }
    }

    public boolean smdtSetVolume(Context context, int volume) {
        if (!this.getService()) {
            return false;
        }
        try {
            if (this.mService.sys_setVolume(volume) == ErrorCode.RET_API_OK) {
                return true;
            }
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
        }
        return false;
    }

    public int smdtGetVolume(Context context) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_getVolume();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    public boolean smdtSetMobileDataEnabled(Context context, boolean enabled) {
        if (!this.getService()) {
            return false;
        }
        try {
            return this.mService.net_setNetWork("mobile", enabled) == ErrorCode.RET_API_OK;
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return false;
        }
    }

    public void smdtInstallPackage(Context context, File packageFile) throws IOException {
        if (!this.getService()) {
            return;
        }
        try {
            this.mService.sys_doUpdatePackage(0, packageFile.getCanonicalPath());
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
        }
    }

    public void smdtRebootRecovery() {
        if (!this.getService()) {
            return;
        }
        try {
            this.mService.sys_rebootRecovery();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
        }
    }

    public int smdtGetScreenWidth(Context c) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.disp_getScreenWidth(0);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    public int smdtGetScreenHeight(Context c) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.disp_getScreenHeight(0);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    public String smdtGetEthIPAddress() {
        if (!this.getService()) {
            return "";
        }
        try {
            NetworkInfoData info = this.mService.net_getNetWorkInf("eth0");
            if (info != null) {
                return info.getIp();
            }
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
        }
        return "";
    }

    public String smdtGetEthMacAddress() {
        if (!this.getService()) {
            return "";
        }
        try {
            return this.mService.net_getMacAddress("eth0");
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return "";
        }
    }

    public int smdtWatchDogFeed() {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_setWatchDogFeed();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    public int smdtWatchDogEnable(char enable) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        boolean reuslt = false;
        if (enable == '\u0001') {
            reuslt = true;
        }
        try {
            return this.mService.sys_setWatchDog(reuslt, 0);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    public Bitmap smdtScreenShot(Context context) {
        if (!this.getService()) {
            return null;
        }
        try {
            return this.mService.disp_getScreenShotBitmap();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return null;
        }
    }

    public void smdtTakeScreenshot(String path, String name, Context context) {
        if (!this.getService()) {
            return;
        }
        String realPath = path + name;
        this.DEBUG(MethodUtil.DEBUG_LEVEL2, "smdtTakeScreenshot realPath" + realPath);
        try {
            this.mService.disp_getScreenShot(realPath);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
        }
    }

    public int getPreviewDegree(Context context) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_getPreviewDegree();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    public LogcatFileManager getLogcatInterface() {
        LogcatFileManager mLogcat = LogcatFileManager.getInstance();
        return mLogcat;
    }

    public void smdtGetSystemLogcat(String path) {
        this.DEBUG(MethodUtil.DEBUG_LEVEL2, "smdtGetSystemLogcat, path:" + path);
        SystemLogcat log = new SystemLogcat();
        log.setupTimer(path);
    }

    public WifiUtils getWifiInterface(Context context) {
        WifiUtils wifiUtils = new WifiUtils(context);
        return wifiUtils;
    }

    public int smdtSetControl(int type, int values) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_setControl(type, values == 1);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    public int smdtSetUsbPower(int type, int num, int values) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.dev_setUsbPower(type, num, values == 1);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    public void smdtSetEthernetState(boolean enable) {
        if (!this.getService()) {
            return;
        }
        try {
            this.mService.net_setNetWork("eth0", enable);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
        }
    }

    public boolean smdtGetEthernetState() {
        if (!this.getService()) {
            return false;
        }
        try {
            return this.mService.net_getNetWork("eth0") == 1;
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return false;
        }
    }

    public int smdtSetEDPBackLight(int values) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.disp_setLcdBackLightEnable(1, values == 1);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    public int smdtGetEDPBackLight() {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.disp_getLcdBackLightEnable(1);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    public int smdtSetLcdBackLight(int values) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.disp_setLcdBackLightEnable(0, values == 1);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    public int smdtGetLcdLightStatus() {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.disp_getLcdBackLightEnable(0);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    public int smdtSetGpioDirection(int gpioNumber, int direction, int value) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_setGpioDirection(gpioNumber, direction, value);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    public int smdtGetGpioDirection(int gpioNumber) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_getGpioDirection(gpioNumber);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    public int smdtSetXrm117xGpioValue(int gpioNumber, int value) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_setExGpioDirection(gpioNumber, 1, value);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    public int smdtGetXrm117xGpioValue(int gpioNumber) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_getExGpioValue(gpioNumber);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    public int smdtSetXrm117xGpioDirection(int gpioNumber, int direction, int value) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_setExGpioDirection(gpioNumber, direction, value);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    public int smdtGetXrm117xGpioDirection(int gpioNumber) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_getExGpioDirection(gpioNumber);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    public int smdtGetControlStatus(int type) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        if (type != 5 && !this.isSystemApp) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL2, "Prohibited use method (sys_getControl) , only support system app!");
            return ErrorCode.RET_API_ERR_NG;
        }
        try {
            return this.mService.sys_getControl(type);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    public int smdtReadGpioValue(int gpioNumber) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_getGpioValue(gpioNumber);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    public int smdtSetGpioValue(int gpioNumber, boolean isTrue) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_setGpioDirection(gpioNumber, 1, isTrue ? 1 : 0);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    public int smdtSetPowerOnOff(char off_h, char off_m, char on_h, char on_m, char enable) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_NG;
        }
        try {
            return this.mService.sys_setAutoPowerOnOffOld(off_h, off_m, on_h, on_m, enable);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return ErrorCode.RET_API_ERR_NG;
        }
    }

    public int setLedLighted(String ledColor, boolean lighted) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        int result = -1;
        this.DEBUG(MethodUtil.DEBUG_LEVEL2, "ledColor:" + ledColor + ",lighted:" + lighted);
        try {
            if (LED_WHITE.equals(ledColor)) {
                result = this.mService.sys_setControl(25, lighted);
            } else if (LED_RED.equals(ledColor)) {
                result = this.mService.sys_setControl(24, lighted);
            } else if (LED_GREEN.equals(ledColor)) {
                result = this.mService.sys_setControl(23, lighted);
            } else {
                this.DEBUG(MethodUtil.DEBUG_LEVEL2, "failed, error, unsupport led Color.");
            }
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        return result;
    }

    public int smdtSetPwmReg(int frequency, char ratio) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.disp_setLcdBackLight(1, ratio, frequency, true);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    public int smdtGetPwmRate() {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.disp_getLcdPwmFrequency(1);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    public int smdtGetPwmRatio() {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.disp_getLcdBackLight(1);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    public byte[] smdtPrivateReadInfo(int len, int offset) {
        if (!this.getService()) {
            return null;
        }
        if (!this.isSystemApp) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL2, "Prohibited use method (dev_readPrivatePartition) , only support system app!");
            return null;
        }
        try {
            return this.mService.dev_readPrivatePartition(0, 0, 0, offset, len);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return null;
        }
    }

    public int smdtPrivateWriteInfo(byte[] buf, int len, int offset) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        if (!this.isSystemApp) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL2, "Prohibited use method (dev_writePrivatePartition) , only support system app!");
            return ErrorCode.RET_API_ERR_NG;
        }
        try {
            return this.mService.dev_writePrivatePartition(0, 0, 0, offset, len, buf);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return -1;
        }
    }

    public byte[] smdtCustomerReadInfo(int len, int offset) {
        if (!this.getService()) {
            return null;
        }
        try {
            return this.mService.dev_readPublicPartition(0, 0, 0, offset, len);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return null;
        }
    }

    public int smdtCustomerWriteInfo(byte[] buf, int len, int offset) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.dev_writePublicPartition(0, 0, 0, offset, len, buf);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return -1;
        }
    }

    public byte[] smdtPublicReadInfo(int len, int offset) {
        if (!this.getService()) {
            return null;
        }
        try {
            return this.mService.dev_readMipsPartition(0, 0, 0, offset, len);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return null;
        }
    }

    public int smdtPublicWriteInfo(byte[] buf, int len, int offset) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.dev_writeMipsPartition(0, 0, 0, offset, len, buf);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return -1;
        }
    }

    public String GetWeVersion() {
        int value = 28672;
        return this.readSmdt(32, value);
    }

    public String GetWeType() {
        int value = 28704;
        return this.readSmdt(32, value);
    }

    private String readSmdt(int size, int offset) {
        String str = "";
        int cum = 0;
        try {
            byte[] data = this.smdtPrivateReadInfo(size, offset);
            if (data == null) {
                return str;
            }
            for (int i = 0; i < size; ++i) {
                if (data[i] != 0) continue;
                ++cum;
            }
            if (cum == size) {
                return str;
            }
            str = new String(data, "UTF-8");
            if (str != null) {
                str = str.replaceAll("[\\s+\r\n\t]", "");
            }
            return str;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setUSBDebug(boolean debug) {
        if (!this.getService()) {
            return;
        }
        try {
            this.mService.sys_setAdbDebug(1, debug);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
        }
    }

    public void setNetworkDebug(boolean debug) {
        if (!this.getService()) {
            return;
        }
        try {
            this.mService.sys_setAdbDebug(0, debug);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
        }
    }

    public void setGestureBar(boolean enable) {
        if (!this.getService()) {
            return;
        }
        try {
            this.mService.disp_setGestureBar(enable);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
        }
    }

    public boolean getGestureBar() {
        if (!this.getService()) {
            return false;
        }
        try {
            return this.mService.disp_getGestureBar() == 1;
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return false;
        }
    }

    public void setNtpServer(String server) {
        if (!this.getService()) {
            return;
        }
        try {
            this.mService.sys_setNtpServer(server);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
        }
    }

    public String getNtpServer() {
        if (!this.getService()) {
            return "";
        }
        try {
            return this.mService.sys_getNtpServer();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return null;
        }
    }

    public void setKeyReject(boolean reject) {
        if (!this.getService()) {
            return;
        }
        try {
            this.mService.sys_setKeyReport(!reject);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
        }
    }

    public void setTouchReject(boolean reject) {
        if (!this.getService()) {
            return;
        }
        try {
            this.mService.sys_setTouchReport(!reject);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
        }
    }

    public void hideSoftKeyboard(boolean hide) {
        if (!this.getService()) {
            return;
        }
        try {
            this.mService.sys_setSoftKeyboard(!hide);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
        }
    }

    public void installApp(String apkPath, InstallCallback installCallback) {
        if (!this.getService()) {
            return;
        }
        try {
            this.mService.sys_doSilentInstallApp(apkPath, installCallback);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
        }
    }

    public void uninstallApp(String packageName, DeleteCallback deleteCallback) {
        if (!this.getService()) {
            return;
        }
        try {
            this.mService.sys_doSilentUninstallApp(packageName, deleteCallback);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
        }
    }

    public void setAllowinstall(boolean allowed) {
        if (!this.getService()) {
            return;
        }
        try {
            this.mService.setAllowInstallOrUnInstall(0, allowed);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
        }
    }

    public boolean isAllowinstall() {
        if (!this.getService()) {
            return false;
        }
        try {
            return this.mService.getAllowInstallOrUnInstall(0) == 1;
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return false;
        }
    }

    public void setAllowUninstall(boolean allowed) {
        if (!this.getService()) {
            return;
        }
        try {
            this.mService.setAllowInstallOrUnInstall(1, allowed);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
        }
    }

    public boolean isAllowUninstall() {
        if (!this.getService()) {
            return false;
        }
        try {
            return this.mService.getAllowInstallOrUnInstall(1) == 1;
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return false;
        }
    }

    public void addInstallWhiteList(String packageName) {
        if (!this.getService()) {
            return;
        }
        try {
            this.mService.sys_addBlackWhiteList(packageName, 1, 1);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
        }
    }

    public void removeInstallWhiteList(String packageName) {
        if (!this.getService()) {
            return;
        }
        try {
            this.mService.sys_delBlackWhiteList(packageName, 1, 1);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
        }
    }

    public List<String> getInstallWhiteList() {
        if (!this.getService()) {
            return null;
        }
        try {
            return this.mService.sys_getBlackWhiteList(1, 1);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return null;
        }
    }

    public String getCpuFreq() {
        if (!this.getService()) {
            return "";
        }
        try {
            return this.mService.info_getCpuFrequency();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return null;
        }
    }

    public double getSystemCpuUsed() {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            String used = this.mService.info_getCpuUsage();
            return Double.parseDouble(used);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    public String getSystemAvailableMemory() {
        if (!this.getService()) {
            return null;
        }
        try {
            return this.mService.info_getAvailMemory();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return null;
        }
    }

    public double getAppMemory(int pid) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            String used = this.mService.info_getAppUsedMemory(pid);
            return Double.parseDouble(used);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    public void setOnKeyListener(OnClickListener listener) {
        if (!this.getService()) {
            return;
        }
        try {
            this.mService.sys_setOnKeyListener(listener);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
        }
    }

    public int getEncryptionResult(int cusResult) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.custom_getEncryptionResult(cusResult);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    public int smdtSendCard(String HID_value, String PID_value, int transformat) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.custom_sendWiegandCardHIDPID(HID_value, PID_value, transformat);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return -1;
        }
    }

    public int smdtSendCard(String idCard, int transformat) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.custom_sendWiegandCard(idCard, transformat);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return -1;
        }
    }

    public String smdtReadWiegandData() {
        if (!this.getService()) {
            return null;
        }
        try {
            return this.mService.custom_readWiegandDataStr();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "Remote Exception e:" + e.toString());
            return null;
        }
    }

    public static native int setRelayIoValue(int var0);

    public static native int getRelayIoValue();

    public static native int setRelayIoMode(int var0, int var1);

    public static native int getRelayIoMode();

    public static native int getLedState(int var0);

    public static native int setLedState(int var0, int var1);

    static {
        System.loadLibrary("smdtmanager_old-lib");
    }

    public static abstract class InstallCallback
    extends IAppInstallObserver.Stub {
    }

    public static abstract class OnClickListener
    extends IOnclickListener.Stub {
    }

    public static abstract class DeleteCallback
    extends IAppDeleteObserver.Stub {
    }
}

