/*
 * Decompiled with CFR 0.152.
 */
package com.blelib.ble;

import android.app.Application;
import android.content.Context;
import android.os.Environment;
import android.os.Handler;
import android.util.Log;
import androidx.annotation.RequiresPermission;
import com.blelib.bean.SanBuJiuHou;
import com.blelib.ble.BleDataUtil;
import com.blelib.ble.IDeviceInterface;
import com.blelib.ble.IMeasureListener;
import com.blelib.ble.IMeasureListenerHeatMap;
import com.blelib.ble.TimeOutHelper;
import com.opencsv.CSVWriter;
import com.taiyi.typulse.pulse.fastble.BleManager;
import com.taiyi.typulse.pulse.fastble.callback.BleNotifyCallback;
import com.taiyi.typulse.pulse.fastble.callback.BleWriteCallback;
import com.taiyi.typulse.pulse.fastble.data.BleDevice;
import com.taiyi.typulse.pulse.fastble.exception.BleException;
import com.taiyi.typulse.pulse.fastble.scan.BleScanRuleConfig;
import com.taiyi.typulse.pulse.fastble.utils.HexUtil;
import com.taiyi.typulse.tyusbsdk.pulse.TaiyiManager;
import com.taiyi.typulse.tyusbsdk.pulse.bean.PulseCharacter;
import com.taiyi.typulse.tyusbsdk.pulse.bean.PulseFigure;
import com.taiyi.typulse.tyusbsdk.pulse.bean.Pulsebean;
import com.taiyi.typulse.tyusbsdk.pulse.bean.TotalPulse;
import com.taiyi.typulse.tyusbsdk.pulse.util.LogUtil;
import com.taiyi.typulse.tyusbsdk.pulse.util.ToastUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class BleController {
    private boolean isConnected = false;
    private String fileName;
    private int connectedDeviceType = -1;
    private Application mApplication;
    private static final String TAG = "qxj BleController";
    public static final int HAND_LEFT = 0;
    public static final int HAND_RIGHT = 1;
    public static final String HELLO = "1";
    public static final String CANCEL = "a";
    public static final String RESTART = "3";
    private int battery;
    private int yjversion;
    private int sjversion;
    private int gjversion;
    private int channel;
    public static final String FIRMWARE_PATH = Environment.getExternalStorageDirectory() + File.separator + "ble_bin";
    private BleDevice bleDevice;
    public static final String DEV_SERVICE_UUID = "0000FFF0-0000-1000-8000-00805F9B34FB";
    public static final String DEV_DATA_BUFF_UUID = "0000FFF1-0000-1000-8000-00805F9B34FB";
    public static final String APP_DATA_BUFF_UUID = "0000FFF2-0000-1000-8000-00805F9B34FB";
    private byte[] byteHeader = new byte[]{-86, 85, -86, 85};
    private Integer writeSerial = 1;
    private byte[] payload;
    private int type;
    private int status;
    private short command_1 = 1;
    private short command_2 = (short)2;
    private short command_3 = (short)3;
    private short command_4 = (short)4;
    private short command_5 = (short)5;
    private short command_6 = (short)6;
    private short command_7 = (short)240;
    private short command_8 = (short)241;
    private short command_9 = (short)250;
    private int measureId = -1;
    private int hand = 0;
    private ArrayList<SanBuJiuHou> sanBuJiuHous = new ArrayList(9);
    private List<byte[]> sanBuJiuHouCommand = new ArrayList<byte[]>(9);
    private int commandPos = 0;
    private int currentMeasureStatus;
    private Handler mHandler = new Handler();
    private TimeOutHelper.ITimeOut timeoutListener = new TimeOutHelper.ITimeOut(){

        @Override
        public void onTimeOut() {
            LogUtil.e(BleController.TAG, "------ time out ------");
            BleController.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (BleController.this.mIMeasureListener != null) {
                        BleController.this.mIMeasureListener.onTimeOut();
                    }
                }
            });
        }

        @Override
        public void step(int step) {
            if (BleController.this.mIMeasureListener != null) {
                BleController.this.mIMeasureListener.onProgress(step);
            }
        }
    };
    private String uuid;
    private boolean isMeasuring;
    private int maxTimeOut = 160000;
    private TimeOutHelper mTimeOutHelper = new TimeOutHelper();
    private static BleController instance;
    private IDeviceInterface mIDeviceInterface;
    private IMeasureListener mIMeasureListener;
    private OnDataGetInterface mOnDataGetInterface;
    private PulseFigure pulseFigure;
    private Pulsebean pulsebean;
    private PulseCharacter pulseCharacter;
    private TotalPulse totalPulse;
    private boolean notify30 = false;
    private boolean notify20 = false;
    private boolean notify10 = false;
    private boolean isVersionGet = false;
    private List<String[]> csvData;
    private String PATH_ROOT = "";
    private String PATH_CSV = "/report/csv/";

    public String getFileName() {
        return this.fileName;
    }

    public void setConnected(boolean connected) {
        this.isConnected = connected;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public int getConnectedDeviceType() {
        return this.connectedDeviceType;
    }

    public void setConnectedDeviceType(int connectedDeviceType) {
        this.connectedDeviceType = connectedDeviceType;
    }

    public int getBattery() {
        return this.battery;
    }

    public int getYjversion() {
        return this.yjversion;
    }

    public int getSjversion() {
        return this.sjversion;
    }

    public int getGjversion() {
        return this.gjversion;
    }

    public int getChannel() {
        return this.channel;
    }

    private BleController() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BleController getInstance() {
        if (instance != null) return instance;
        Class<BleController> clazz = BleController.class;
        synchronized (BleController.class) {
            if (instance != null) return instance;
            instance = new BleController();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public boolean isMeasuring() {
        return this.isMeasuring;
    }

    public void init(Application app) {
        this.mApplication = app;
        this.PATH_ROOT = this.mApplication.getExternalCacheDir().getPath();
        BleManager.getInstance().init(app);
        BleManager.getInstance().enableLog(true).setReConnectCount(3, 5000L).setOperateTimeout(5000);
    }

    public BleController enableLog(boolean enable) {
        BleManager.getInstance().enableLog(enable);
        return this;
    }

    public BleController setReConnectCount(int count, long interval) {
        if (count > 10) {
            count = 10;
        }
        if (interval < 0L) {
            interval = 0L;
        }
        BleManager.getInstance().setReConnectCount(count, interval);
        return this;
    }

    public BleController setOperateTimeout(int timeout) {
        BleManager.getInstance().setOperateTimeout(timeout);
        return this;
    }

    public void initScanRule(BleScanRuleConfig config) {
        BleManager.getInstance().initScanRule(config);
    }

    public int getHand() {
        return this.hand;
    }

    public void cancelScan() {
        BleManager.getInstance().cancelScan();
    }

    public boolean isHasDevice() {
        return this.bleDevice != null;
    }

    private void initBle() {
        BleManager.getInstance().notify(this.bleDevice, DEV_SERVICE_UUID, DEV_DATA_BUFF_UUID, new BleNotifyCallback(){

            @Override
            public void onNotifySuccess() {
                LogUtil.w(BleController.TAG, "DEV_DATA_BUFF_UUID onNotifySuccess()");
            }

            @Override
            public void onNotifyFailure(BleException exception) {
                LogUtil.w(BleController.TAG, "DEV_DATA_BUFF_UUID:" + exception.toString());
            }

            @Override
            @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
            public void onCharacteristicChanged(byte[] data) {
                LogUtil.e(BleController.TAG, "onCharacteristicChanged: " + HexUtil.formatHexString(data));
                if (data != null) {
                    if (BleController.this.mOnDataGetInterface != null) {
                        BleController.this.mOnDataGetInterface.onDataGet(data);
                    }
                    if (BleController.this.payload == null) {
                        BleController.access$302(BleController.this, data);
                        if (BleDataUtil.checkValue(BleController.this.payload)) {
                            BleController.this.onDataReceived(BleController.this.payload);
                            BleController.access$302(BleController.this, null);
                        } else {
                            BleController.this.parseData(BleController.this.payload);
                        }
                    } else {
                        BleController.access$302(BleController.this, BleDataUtil.MergerArray(BleController.this.payload, data));
                        BleController.this.parseData(BleController.this.payload);
                    }
                }
            }
        });
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    private void parseData(byte[] data) {
        List<Integer> headerCount = BleDataUtil.getIndexListOf(data, this.byteHeader);
        if (headerCount.size() > 0) {
            int tempPosition = 0;
            for (int i = 0; i < headerCount.size(); ++i) {
                byte[] bytes = i != headerCount.size() - 1 ? BleDataUtil.SubArray(data, headerCount.get(i), headerCount.get(i + 1) - headerCount.get(i)) : BleDataUtil.SubArray(data, headerCount.get(i), data.length - headerCount.get(i));
                LogUtil.w(TAG, HexUtil.formatHexString(bytes));
                boolean b = BleDataUtil.checkValue(bytes);
                LogUtil.w(TAG, "DataUtil.checkValue(bytes):" + b + ",bytes.length:" + bytes.length);
                if (!b) continue;
                this.onDataReceived(bytes);
                tempPosition = i == headerCount.size() - 1 ? -1 : headerCount.get(i + 1);
            }
            this.payload = (byte[])(tempPosition != -1 ? BleDataUtil.SubArray(data, tempPosition, data.length - tempPosition) : null);
        }
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        LogUtil.w(TAG, "setuuid:" + uuid);
        this.uuid = uuid;
    }

    public void setMeasureId(int measureId) {
        this.measureId = measureId;
    }

    public void setHand(int hand) {
        this.hand = hand;
    }

    public void setIBLEInterface(IDeviceInterface anInterface) {
        this.mIDeviceInterface = anInterface;
    }

    public void setIMeasureListener(IMeasureListener iMeasureListener) {
        this.mIMeasureListener = iMeasureListener;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void setBleDevice(BleDevice bleDevice) {
        this.bleDevice = bleDevice;
        this.initBle();
    }

    public BleDevice getBleDevice() {
        return this.bleDevice;
    }

    public void setOnDataGetInterface(OnDataGetInterface onDataGetInterface) {
        this.mOnDataGetInterface = onDataGetInterface;
    }

    public void getStatus() {
        Log.w((String)TAG, (String)"getStatus()");
        byte[] byteTotal = BleDataUtil.getCommandBytes(this.byteHeader, this.writeSerial, null, this.command_1);
        this.write(byteTotal);
    }

    public void getVersion() {
        byte[] byteTotal = BleDataUtil.getCommandBytes(this.byteHeader, this.writeSerial, null, this.command_7);
        this.write(byteTotal);
    }

    public void startMeasure() {
        byte[] byArray;
        if (this.measureId == -1) {
            ToastUtil.show((Context)this.mApplication, "\u8bf7\u8f93\u5165\u6d4b\u91cfid");
            return;
        }
        if (this.csvData == null) {
            this.csvData = new ArrayList<String[]>();
        }
        if (!this.csvData.isEmpty()) {
            this.csvData.clear();
        }
        this.mTimeOutHelper.startTimer(this.timeoutListener, this.maxTimeOut);
        byte[] bytesId = BleDataUtil.intToBytes(this.measureId);
        if (this.hand == 0) {
            byte[] byArray2 = new byte[1];
            byArray = byArray2;
            byArray2[0] = 0;
        } else {
            byte[] byArray3 = new byte[1];
            byArray = byArray3;
            byArray3[0] = 1;
        }
        byte[] bytesHand = byArray;
        LogUtil.w(TAG, HexUtil.formatHexString(bytesHand));
        byte[] bytesStart = BleDataUtil.MergerArray(bytesId, bytesHand);
        byte[] byteTotal = BleDataUtil.getCommandBytes(this.byteHeader, this.writeSerial, bytesStart, this.command_3);
        this.write(byteTotal);
        this.isMeasuring = true;
        LogUtil.w(TAG, "\u5199\u5165\u5f00\u59cb\u6d4b\u91cf\u6570\u636e:");
        if (this.mIMeasureListener != null) {
            this.mIMeasureListener.onStartMeasure();
        }
    }

    public void getResult() {
        byte[] bytesId = BleDataUtil.intToBytes(this.measureId);
        LogUtil.w(TAG, "measureId:" + HexUtil.formatHexString(bytesId));
        byte[] byteTotal = BleDataUtil.getCommandBytes(this.byteHeader, this.writeSerial, bytesId, this.command_4);
        this.write(byteTotal);
        LogUtil.w(TAG, "\u5199\u5165\u83b7\u53d6\u7ed3\u679c\u6570\u636e:");
    }

    public void getSanBuJiuHou() {
        LogUtil.w(TAG, "\u4e09\u90e8\u4e5d\u4faf");
        byte[] bytesId = BleDataUtil.intToBytes(this.measureId);
        LogUtil.w(TAG, "measureId:" + HexUtil.formatHexString(bytesId));
        LogUtil.w(TAG, "measureId:" + BleDataUtil.byte2Int(bytesId));
        byte[] byteStep = this.sanBuJiuHouCommand.get(this.commandPos);
        byte[] bytesStart = BleDataUtil.MergerArray(bytesId, byteStep);
        byte[] byteTotal = BleDataUtil.getCommandBytes(this.byteHeader, this.writeSerial, bytesStart, this.command_5);
        this.write(byteTotal);
    }

    public void disconnect() {
        this.notify30 = false;
        this.notify20 = false;
        this.notify10 = false;
        this.isMeasuring = false;
        byte[] disconnect = new byte[]{1};
        byte[] byteTotal = BleDataUtil.getCommandBytes(this.byteHeader, this.writeSerial, disconnect, this.command_2);
        this.write(byteTotal);
    }

    public void stopMeasure() {
        this.isMeasuring = false;
        byte[] disconnect = new byte[]{2};
        byte[] byteTotal = BleDataUtil.getCommandBytes(this.byteHeader, this.writeSerial, disconnect, this.command_2);
        this.write(byteTotal);
    }

    public void cancelMeasure() {
        this.isMeasuring = false;
        byte[] cancel = new byte[]{3};
        byte[] byteTotal = BleDataUtil.getCommandBytes(this.byteHeader, this.writeSerial, cancel, this.command_2);
        this.write(byteTotal);
        if (this.mIMeasureListener != null) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    BleController.this.mIMeasureListener.onCancelMeasure();
                }
            });
        }
        this.mTimeOutHelper.stopTimer();
        this.clearData();
    }

    public void clearData() {
        this.isMeasuring = false;
        this.payload = null;
        this.writeSerial = 0;
        this.sanBuJiuHous.clear();
        this.pulsebean = null;
        this.pulseCharacter = null;
        this.pulseFigure = null;
        this.totalPulse = null;
    }

    public void recycle() {
        this.isVersionGet = false;
        this.notify30 = false;
        this.notify20 = false;
        this.notify10 = false;
        this.yjversion = 0;
        this.sjversion = 0;
        this.gjversion = 0;
        this.channel = 0;
        this.clearData();
        this.uuid = null;
        this.connectedDeviceType = -1;
        if (BleManager.getInstance().isConnected(this.bleDevice)) {
            BleManager.getInstance().disconnect(this.bleDevice);
        }
        this.bleDevice = null;
        if (this.mTimeOutHelper != null) {
            this.mTimeOutHelper.stopTimer();
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    private void onDataReceived(byte[] data) {
        LogUtil.w(TAG, "onDataReceived currentPayload.length:" + data.length);
        byte byteType = BleDataUtil.SubArray(data, 7, 1)[0];
        this.type = BleDataUtil.byteToInt(byteType);
        LogUtil.w(TAG, "onCharacteristicChanged type:" + this.type);
        switch (this.type) {
            case 1: {
                this.parseDeviceStatus(data);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                this.getPulseStr(data);
                break;
            }
            case 5: {
                LogUtil.e(TAG, "onSanBuJiuHouGet");
                this.onSanBuJiuHouGet(data);
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                LogUtil.w(TAG, "\u5bf9\u63a5\u6536\u5230\u7684\u62a5\u6587\u7684\u786e\u8ba4");
                break;
            }
            case 18: {
                this.onRealTimeWaveGet(data);
                break;
            }
            case 240: {
                this.parseVersion(data);
                break;
            }
            case 54: {
                LogUtil.w(TAG, "\u4ec5\u7ed8\u5236\u96f7\u8fbe\u56fe\u3001\u67f1\u72b6\u56fe\u65f6\u4f7f\u7528:" + HexUtil.formatHexString(data));
                byte[] result = BleDataUtil.SubArray(data, 8, data.length - 10);
                LogUtil.w(TAG, "\u4ec5\u7ed8\u5236\u96f7\u8fbe\u56fe\u3001\u67f1\u72b6\u56fe\u65f6\u4f7f\u7528:" + HexUtil.formatHexString(result));
                this.getPulseCharacter(result);
                break;
            }
            case 56: {
                this.getPulseFigure(data);
                LogUtil.w(TAG, "\u6570\u5b57\u7ed3\u679c:" + HexUtil.formatHexString(data));
                break;
            }
            case 58: {
                this.getTotalPulse(data);
                LogUtil.w(TAG, "\u603b\u8109\u7ed3\u679c:" + HexUtil.formatHexString(data));
                break;
            }
            case 70: {
                this.getHeatImg(data);
            }
        }
    }

    private void getPulseCharacter(byte[] result) {
        boolean hasKongShi = result.length > 36;
        this.pulseCharacter = new PulseCharacter();
        ArrayList<Integer> integers = new ArrayList<Integer>();
        if (hasKongShi) {
            for (int i = 0; i < 18; ++i) {
                short da = BleDataUtil.byteToShort(BleDataUtil.SubArray(result, i * 2, 2));
                integers.add(Integer.valueOf(da));
            }
            this.pulseCharacter.cun_amp_max = (Integer)integers.get(0);
            this.pulseCharacter.cun_emerge_force = (Integer)integers.get(1);
            this.pulseCharacter.cun_width = (Integer)integers.get(2);
            this.pulseCharacter.cun_a_w_ratio = (Integer)integers.get(3);
            this.pulseCharacter.cun_vital_pres = (Integer)integers.get(4);
            this.pulseCharacter.cun_solid = (Integer)integers.get(5);
            this.pulseCharacter.guan_amp_max = (Integer)integers.get(6);
            this.pulseCharacter.guan_emerge_force = (Integer)integers.get(7);
            this.pulseCharacter.guan_width = (Integer)integers.get(8);
            this.pulseCharacter.guan_a_w_ratio = (Integer)integers.get(9);
            this.pulseCharacter.guan_vital_pres = (Integer)integers.get(10);
            this.pulseCharacter.guan_solid = (Integer)integers.get(11);
            this.pulseCharacter.chi_amp_max = (Integer)integers.get(12);
            this.pulseCharacter.chi_emerge_force = (Integer)integers.get(13);
            this.pulseCharacter.chi_width = (Integer)integers.get(14);
            this.pulseCharacter.chi_a_w_ratio = (Integer)integers.get(15);
            this.pulseCharacter.chi_vital_pres = (Integer)integers.get(16);
            this.pulseCharacter.chi_solid = (Integer)integers.get(17);
        } else {
            for (int i = 0; i < 15; ++i) {
                short da = BleDataUtil.byteToShort(BleDataUtil.SubArray(result, i * 2, 2));
                integers.add(Integer.valueOf(da));
            }
            this.pulseCharacter.cun_amp_max = (Integer)integers.get(0);
            this.pulseCharacter.cun_emerge_force = (Integer)integers.get(1);
            this.pulseCharacter.cun_width = (Integer)integers.get(2);
            this.pulseCharacter.cun_a_w_ratio = (Integer)integers.get(3);
            this.pulseCharacter.cun_vital_pres = (Integer)integers.get(4);
            this.pulseCharacter.guan_amp_max = (Integer)integers.get(5);
            this.pulseCharacter.guan_emerge_force = (Integer)integers.get(6);
            this.pulseCharacter.guan_width = (Integer)integers.get(7);
            this.pulseCharacter.guan_a_w_ratio = (Integer)integers.get(8);
            this.pulseCharacter.guan_vital_pres = (Integer)integers.get(9);
            this.pulseCharacter.chi_amp_max = (Integer)integers.get(10);
            this.pulseCharacter.chi_emerge_force = (Integer)integers.get(11);
            this.pulseCharacter.chi_width = (Integer)integers.get(12);
            this.pulseCharacter.chi_a_w_ratio = (Integer)integers.get(13);
            this.pulseCharacter.chi_vital_pres = (Integer)integers.get(14);
        }
        LogUtil.w(TAG, "integers:" + this.pulseCharacter.toString());
    }

    private void getPulseStr(byte[] data) {
        byte[] result = BleDataUtil.SubArray(data, 12, data.length - 14);
        String pulseStr = new String(result, StandardCharsets.UTF_8);
        LogUtil.w(TAG, "PulseStr:" + pulseStr);
        try {
            this.pulsebean = new Pulsebean();
            JSONObject pulseObject = new JSONObject(pulseStr);
            this.pulsebean.success = pulseObject.getBoolean("success");
            this.pulsebean.heart_rate = pulseObject.getInt("heart_rate");
            this.pulsebean.desc = new Pulsebean.DescBean();
            String desc = pulseObject.getString("desc");
            JSONObject descObject = new JSONObject(desc);
            this.pulsebean.desc.cun = descObject.getString("cun");
            this.pulsebean.desc.guan = descObject.getString("guan");
            this.pulsebean.desc.chi = descObject.getString("chi");
            this.pulsebean.desc.shuchi = descObject.getString("shuchi");
            if (pulseObject.has("score")) {
                this.pulsebean.score = pulseObject.getInt("score");
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        if (!this.pulsebean.success) {
            if (this.mTimeOutHelper != null && this.timeoutListener != null) {
                this.mTimeOutHelper.stopTimer();
            }
            this.mIMeasureListener.onMeasureFailed(this.pulsebean);
        }
    }

    private void getPulseFigure(byte[] data) {
        byte heart;
        byte[] shuChi;
        byte[] byteCgcs;
        this.pulseFigure = new PulseFigure();
        boolean hasKongShi = data.length > 31;
        this.pulseFigure.cgcs = new ArrayList<PulseFigure.CGC>();
        if (hasKongShi) {
            byteCgcs = BleDataUtil.SubArray(data, 8, 24);
            shuChi = BleDataUtil.SubArray(data, 32, 2);
            heart = data[34];
        } else {
            byteCgcs = BleDataUtil.SubArray(data, 8, 18);
            shuChi = BleDataUtil.SubArray(data, 26, 2);
            heart = data[28];
        }
        int len = hasKongShi ? 8 : 6;
        for (int i = 0; i < 3; ++i) {
            PulseFigure.CGC cgc = new PulseFigure.CGC();
            cgc.xian = (float)BleDataUtil.byteToShort(BleDataUtil.SubArray(byteCgcs, i * len, 2)) / 100.0f;
            cgc.hua = (float)BleDataUtil.byteToShort(BleDataUtil.SubArray(byteCgcs, i * len + 2, 2)) / 100.0f;
            cgc.fu = (float)BleDataUtil.byteToShort(BleDataUtil.SubArray(byteCgcs, i * len + 4, 2)) / 100.0f;
            if (hasKongShi) {
                cgc.shi = (float)BleDataUtil.byteToShort(BleDataUtil.SubArray(byteCgcs, i * len + 6, 2)) / 100.0f;
            }
            cgc.shu = (float)BleDataUtil.byteToShort(shuChi) / 100.0f;
            this.pulseFigure.cgcs.add(cgc);
            LogUtil.w(TAG, "cgc:" + cgc.toString());
        }
        this.pulseFigure.heartRate = BleDataUtil.byteToInt(heart);
        LogUtil.w(TAG, "pulseFigure.heartRate:" + this.pulseFigure.heartRate);
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    private void getTotalPulse(byte[] data) {
        boolean hasKongShi = data.length > 34;
        this.totalPulse = new TotalPulse(hasKongShi);
        this.totalPulse.mMais = new ArrayList<TotalPulse.Mai>();
        if (hasKongShi) {
            byte[] result = BleDataUtil.SubArray(data, 8, 30);
            for (int i = 0; i < 10; ++i) {
                TotalPulse.Mai mai = new TotalPulse.Mai();
                byte[] level = BleDataUtil.SubArray(result, i * 3, 1);
                byte[] value = BleDataUtil.SubArray(result, 1 + i * 3, 2);
                mai.level = BleDataUtil.byteToInt(level[0]);
                mai.value = BleDataUtil.byteToShort(value);
                this.totalPulse.mMais.add(mai);
                LogUtil.w("BleController", "level:" + HexUtil.formatHexString(level));
                LogUtil.w("BleController", "level:" + BleDataUtil.byteToInt(level[0]));
                LogUtil.w("BleController", "value:" + HexUtil.formatHexString(value));
                LogUtil.w("BleController", "value:" + BleDataUtil.byteToShort(value));
            }
        } else {
            byte[] result = BleDataUtil.SubArray(data, 8, 24);
            for (int i = 0; i < 8; ++i) {
                TotalPulse.Mai mai = new TotalPulse.Mai();
                byte[] level = BleDataUtil.SubArray(result, i * 3, 1);
                byte[] value = BleDataUtil.SubArray(result, 1 + i * 3, 2);
                mai.level = BleDataUtil.byteToInt(level[0]);
                mai.value = BleDataUtil.byteToShort(value);
                this.totalPulse.mMais.add(mai);
                LogUtil.w("BleController", "level:" + HexUtil.formatHexString(level));
                LogUtil.w("BleController", "level:" + BleDataUtil.byteToInt(level[0]));
                LogUtil.w("BleController", "value:" + HexUtil.formatHexString(value));
                LogUtil.w("BleController", "value:" + BleDataUtil.byteToShort(value));
            }
        }
        if (this.csvData.isEmpty()) {
            if (this.mIMeasureListener != null) {
                this.mIMeasureListener.onPulseResult(this.pulsebean, this.pulseFigure, null, this.pulseCharacter, this.totalPulse);
                if (this.mTimeOutHelper != null && this.timeoutListener != null) {
                    this.mTimeOutHelper.stopTimer();
                }
            }
        } else {
            this.saveCsv();
        }
    }

    private void onRealTimeWaveGet(byte[] data) {
        LogUtil.w(TAG, "\u5b9e\u65f6\u8109\u640f\u6ce2 byte:" + data.length);
        LogUtil.w("BleController", "\u5b9e\u65f6\u8109\u640f\u6ce2:" + HexUtil.formatHexString(data));
        LogUtil.w(TAG, "\u5b9e\u65f6\u8109\u640f\u6ce2:" + Arrays.toString(data));
        if (data.length > 12) {
            int heart = BleDataUtil.byteToInt(data[8]);
            int ampLevelCun = BleDataUtil.byteToInt(data[9]);
            int widthLevelCun = BleDataUtil.byteToInt(data[10]);
            LogUtil.w(TAG, "ampLevelCun :" + ampLevelCun + "widthLevelCun :" + widthLevelCun);
            int[] waveCun = new int[]{ampLevelCun, widthLevelCun};
            int ampLevelGuan = BleDataUtil.byteToInt(data[11]);
            int widthLevelGuan = BleDataUtil.byteToInt(data[12]);
            LogUtil.w(TAG, "ampLevelGuan:" + ampLevelGuan + "widthLevelGuan:" + widthLevelGuan);
            int[] waveGuan = new int[]{ampLevelGuan, widthLevelGuan};
            int ampLevelChi = BleDataUtil.byteToInt(data[13]);
            int widthLevelChi = BleDataUtil.byteToInt(data[14]);
            LogUtil.w(TAG, "ampLevelChi:" + ampLevelChi + "widthLevelChi:" + widthLevelChi);
            int[] waveChi = new int[]{ampLevelChi, widthLevelChi};
            if (this.mIMeasureListener != null) {
                this.mIMeasureListener.onRealTimeWaveGet(waveCun, waveGuan, waveChi, heart);
            }
        }
    }

    private void onSanBuJiuHouGet(byte[] data) {
        byte[] result = BleDataUtil.SubArray(data, 14, data.length - 16);
        LogUtil.w(TAG, "result.length:" + result.length);
        SanBuJiuHou sanBuJiuHou = new SanBuJiuHou();
        sanBuJiuHou.data = HexUtil.formatHexString(result);
        LogUtil.w(TAG, "sanBuJiuHou.data :" + sanBuJiuHou.data);
        this.sanBuJiuHous.add(sanBuJiuHou);
        LogUtil.e(TAG, " getSanBuJiuHou();" + this.sanBuJiuHous.size());
        if (this.sanBuJiuHous.size() < 9) {
            ++this.commandPos;
            this.getSanBuJiuHou();
        } else {
            LogUtil.e(TAG, " getSanBuJiuHou() complete");
            if (this.pulsebean != null && this.pulseFigure != null) {
                if (this.mIMeasureListener != null) {
                    this.mIMeasureListener.onPulseResult(this.pulsebean, this.pulseFigure, this.sanBuJiuHous, null, null);
                }
                if (this.mTimeOutHelper != null && this.timeoutListener != null) {
                    this.mTimeOutHelper.stopTimer();
                }
                this.sanBuJiuHous.clear();
                this.commandPos = 0;
            } else {
                this.mIMeasureListener.onMeasureFailed(null);
            }
        }
    }

    private List<byte[]> getSubData(byte[] result) {
        ArrayList<byte[]> data = new ArrayList<byte[]>();
        while (result.length >= 10) {
            byte[] bytes = BleDataUtil.SubArray(result, 0, 10);
            data.add(bytes);
            result = BleDataUtil.SubArray(result, 10, result.length - 10);
        }
        return data;
    }

    private void parseDeviceStatus(byte[] bytes) {
        int battery;
        byte[] statusPayload = BleDataUtil.SubArray(bytes, 8, 2);
        this.status = BleDataUtil.byteToInt(statusPayload[0]);
        this.battery = battery = statusPayload[1];
        TaiyiManager.getInstance().onResult("", "deviceConnect", "", "");
        Log.w((String)TAG, (String)("battery:" + battery));
        if (this.mIDeviceInterface != null) {
            this.mIDeviceInterface.onStatus(this.status, battery);
            if (!this.isMeasuring && this.isVersionGet && (this.yjversion < 7022 || this.yjversion > 7024)) {
                this.onPowerChange(battery);
            }
            switch (this.status) {
                case 0: {
                    this.currentMeasureStatus = 0;
                    LogUtil.w(TAG, "idle");
                    break;
                }
                case 1: {
                    this.currentMeasureStatus = 1;
                    LogUtil.w(TAG, "\u5df2\u8fde\u63a5,\u5f53\u524d\u7535\u91cf:" + battery);
                    break;
                }
                case 2: {
                    if (this.currentMeasureStatus == 2) break;
                    this.currentMeasureStatus = 2;
                    LogUtil.w(TAG, "\u5f00\u59cb\u6d4b\u91cf");
                    break;
                }
                case 3: {
                    if (this.currentMeasureStatus == 3) break;
                    this.currentMeasureStatus = 3;
                    LogUtil.w(TAG, "\u9884\u52a0\u538b\u5b8c\u6210\uff08~5s\uff09");
                    break;
                }
                case 4: {
                    if (this.currentMeasureStatus == 4) break;
                    this.currentMeasureStatus = 4;
                    LogUtil.w(TAG, "\u6570\u636e\u91c7\u96c6\u5b8c\u6210\uff0860 ~ 80 s\uff09");
                    break;
                }
                case 5: {
                    if (this.currentMeasureStatus == 5) break;
                    this.currentMeasureStatus = 5;
                    LogUtil.w(TAG, "\u653e\u6c14\u590d\u4f4d\u5b8c\u6210\uff08~1 s\uff09");
                    this.getResult();
                    break;
                }
                case 240: {
                    LogUtil.w(TAG, "\u65e0\u7ed3\u679c\uff08\u5f85\u5b9a\uff0c\u672a\u4f7f\u7528\uff09");
                    break;
                }
                case 255: {
                    if (this.currentMeasureStatus == 255) break;
                    this.currentMeasureStatus = 255;
                    LogUtil.w(TAG, "\u4f20\u611f\u5668\u521d\u59cb\u5316\u5931\u8d25\u6216\u8bfb\u53d6\u9519\u8bef,\u8bf7\u91cd\u542f\u8bbe\u5907...");
                    this.recycle();
                    if (this.mIDeviceInterface == null) break;
                    this.mIDeviceInterface.onInitSensorFailed();
                }
            }
        }
    }

    private void getHeatImg(byte[] data) {
        String time;
        String force;
        LogUtil.w(TAG, "\u70ed\u56fe len:" + data.length);
        String[] rowData = new String[98];
        byte[] sensorData = BleDataUtil.SubArray(data, 8, 192);
        byte[] timeData = BleDataUtil.SubArray(data, 200, 4);
        byte[] forceData = BleDataUtil.SubArray(data, 204, 2);
        rowData[0] = force = Integer.toString(BleDataUtil.byteToShort(forceData));
        rowData[1] = time = Integer.toString(BleDataUtil.byte2Int(timeData));
        LogUtil.w(TAG, "\u70ed\u56fedata force:" + force);
        LogUtil.w(TAG, "\u70ed\u56fedata time:" + time);
        for (int i = 0; i < 96; ++i) {
            String valueStr;
            float valueShort = (float)BleDataUtil.byteToShort(BleDataUtil.SubArray(sensorData, i * 2, 2)) / 100.0f;
            rowData[i + 2] = valueStr = Float.toString(valueShort);
        }
        this.csvData.add(rowData);
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    protected void saveCsv() {
        String fileName;
        if (this.csvData.size() == 0) {
            LogUtil.w(TAG, "CSV\u65e0\u6570\u636e\u6216\u6b63\u5728\u6d4b\u8109\u4e2d...");
            if (this.mTimeOutHelper != null && this.timeoutListener != null) {
                this.mTimeOutHelper.stopTimer();
            }
            this.mIMeasureListener.onMeasureFailed(this.pulsebean);
            return;
        }
        LogUtil.w(TAG, "\u70ed\u56fe csvData size:" + this.csvData.size());
        String timeString = new SimpleDateFormat("yyMMddHHmmss").format(new Date(System.currentTimeMillis()));
        String handString = this.hand == 0 ? "L" : "R";
        this.fileName = fileName = timeString + "_" + this.bleDevice.getName() + "_" + handString + ".csv";
        File file = new File(this.PATH_ROOT + this.PATH_CSV);
        if (!file.exists()) {
            file.mkdirs();
        }
        String csv = file.getAbsolutePath() + File.separator + fileName;
        CSVWriter writer = null;
        try {
            writer = new CSVWriter((Writer)new FileWriter(csv));
            writer.writeAll(this.csvData);
            writer.close();
            this.csvData.clear();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        LogUtil.w(TAG, "\u4fdd\u5b58csv\u6210\u529f");
        if (this.mIMeasureListener != null) {
            ((IMeasureListenerHeatMap)this.mIMeasureListener).onPulseResult(this.pulsebean, this.pulseFigure, null, this.pulseCharacter, this.totalPulse, csv);
            if (this.mTimeOutHelper != null && this.timeoutListener != null) {
                this.mTimeOutHelper.stopTimer();
            }
        }
    }

    private void parseVersion(byte[] bytes) {
        LogUtil.w("BleController", "parseVersion");
        byte[] hardware = BleDataUtil.SubArray(bytes, 8, 4);
        byte[] firmware = BleDataUtil.SubArray(bytes, 12, 4);
        byte[] date = BleDataUtil.SubArray(bytes, 16, 2);
        this.yjversion = BleDataUtil.byte2Int(hardware);
        this.gjversion = BleDataUtil.byte2Int(firmware);
        this.sjversion = BleDataUtil.byteToShort(date);
        LogUtil.w(TAG, "\u786c\u4ef6\u7248\u672c \u539f\u59cb bytes:" + Arrays.toString(hardware));
        LogUtil.w(TAG, "\u786c\u4ef6\u7248\u672c \u5927\u7aef:" + this.yjversion);
        LogUtil.w(TAG, "\u786c\u4ef6\u7248\u672c \u5c0f\u7aef:" + BleDataUtil.byte2IntS(hardware));
        if (bytes.length == 22) {
            byte[] channelBytes = BleDataUtil.SubArray(bytes, 18, 2);
            this.channel = BleDataUtil.byteToShort(channelBytes);
        }
        if (this.mIDeviceInterface != null) {
            this.mIDeviceInterface.onVersion(this.yjversion, this.gjversion, this.sjversion, this.channel);
            this.isVersionGet = true;
        }
        LogUtil.w(TAG, "\u786c\u4ef6\u7248\u672c:" + this.yjversion);
        LogUtil.w(TAG, "\u56fa\u4ef6\u7248\u672c:" + this.gjversion);
        LogUtil.w(TAG, "\u6570\u636e\u7248\u672c:" + this.sjversion);
        LogUtil.w(TAG, "\u6e20\u9053\u53f7:" + this.channel);
    }

    private void write(byte[] bytes) {
        LogUtil.w("BleController", "write:" + HexUtil.formatHexString(bytes));
        BleManager.getInstance().write(this.bleDevice, DEV_SERVICE_UUID, APP_DATA_BUFF_UUID, bytes, new BleWriteCallback(){

            @Override
            public void onWriteSuccess(int current, int total, byte[] justWrite) {
                BleController.this.writeSerial = BleController.this.writeSerial + 1;
            }

            @Override
            public void onWriteFailure(BleException exception) {
                LogUtil.w("BleController", "exception:" + exception.toString());
            }
        });
    }

    private void onPowerChange(int battery) {
        Log.w((String)TAG, (String)"onPowerChange");
        this.battery = battery;
        if (battery < 30 && battery >= 20) {
            if (!this.notify30 && this.mIDeviceInterface != null) {
                this.mIDeviceInterface.onLowPowerNotify(30);
                this.notify30 = true;
            }
            this.notify20 = false;
            this.notify10 = false;
        } else if (battery < 20 && battery >= 10) {
            if (!this.notify20 && this.mIDeviceInterface != null) {
                this.mIDeviceInterface.onLowPowerNotify(20);
                this.notify20 = true;
            }
            this.notify30 = true;
            this.notify10 = false;
        } else if (battery < 10) {
            if (!this.notify10 && this.mIDeviceInterface != null) {
                this.mIDeviceInterface.onLowPowerNotify(10);
                this.notify10 = true;
            }
            this.notify30 = true;
            this.notify20 = true;
        } else {
            this.notify30 = false;
            this.notify20 = false;
            this.notify10 = false;
        }
        TaiyiManager.getInstance().onResult("", "deviceConnect", "", "");
    }

    static /* synthetic */ byte[] access$302(BleController x0, byte[] x1) {
        x0.payload = x1;
        return x1;
    }

    public static interface OnDataGetInterface {
        public void onDataGet(byte[] var1);
    }
}

