/*
 * Decompiled with CFR 0.152.
 */
package com.taiyi.typulse;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.blelib.ble.BleController;
import com.taiyi.typulse.PulseResult;
import com.taiyi.typulse.tyusbsdk.ResultListener;
import com.taiyi.typulse.tyusbsdk.pulse.TaiyiManager;
import com.taiyi.typulse.tyusbsdk.pulse.util.AppManager;
import com.taiyi.typulse.ui.MainMeasureActivity;
import com.taiyi.typulse.zhimai.ui.activity.MeasureMainActivity;
import io.dcloud.feature.uniapp.annotation.UniJSMethod;
import io.dcloud.feature.uniapp.bridge.UniJSCallback;
import io.dcloud.feature.uniapp.common.UniModule;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;

public class TyPulseManager
extends UniModule
implements TaiyiManager.SkipInterface,
ResultListener {
    private static final String TAG = "qxj TyPulseManager";
    private UniJSCallback measureCallback;
    private Handler mainHandler = new Handler(Looper.getMainLooper());
    private Context context;
    private String uid = "userid000067";
    private String patientName;
    private String patientAge;
    private String patientGender;
    private String patientId;
    private Activity currentActivity;
    private boolean autoOrientationEnabled = true;
    private int forcedOrientation = -1;

    @UniJSMethod(uiThread=false)
    public void initSDK(String appId, String appSecret, String uid, UniJSCallback callback) {
        this.context = this.mUniSDKInstance.getContext();
        if (StringUtils.isNotEmpty((CharSequence)uid)) {
            this.uid = uid;
        }
        this.getCurrentActity();
        Log.d((String)"qxj initSDK", (String)("appId:" + appId + " appSecret:" + appSecret + " uid:" + uid));
        TaiyiManager.getInstance().init(appId, appSecret, (Application)this.context.getApplicationContext());
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        result.put("message", "SDK\u521d\u59cb\u5316\u6210\u529f");
        if (callback != null) {
            callback.invoke(result);
        }
    }

    @UniJSMethod(uiThread=false)
    public void setPatientInfo(String name, String age, String gender, String id, UniJSCallback callback) {
        this.patientName = name;
        this.patientAge = age;
        this.patientGender = gender;
        this.patientId = id;
        TaiyiManager.getInstance().setPatientName(name);
        TaiyiManager.getInstance().setPatientGender(gender);
        try {
            TaiyiManager.getInstance().setPatientAge(Integer.parseInt(age));
        }
        catch (NumberFormatException e) {
            TaiyiManager.getInstance().setPatientAge(0);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        result.put("message", "\u60a3\u8005\u4fe1\u606f\u8bbe\u7f6e\u6210\u529f");
        if (callback != null) {
            callback.invoke(result);
        }
    }

    @UniJSMethod(uiThread=false)
    public void getDeviceInfo(UniJSCallback callback) {
        HashMap<String, Object> deviceInfo = new HashMap<String, Object>();
        deviceInfo.put("deviceName", TaiyiManager.getInstance().getDeviceName());
        deviceInfo.put("deviceId", TaiyiManager.getInstance().getDeviceID());
        deviceInfo.put("channel", BleController.getInstance().getChannel());
        deviceInfo.put("yjversion", BleController.getInstance().getYjversion());
        deviceInfo.put("isConnected", BleController.getInstance().isConnected());
        deviceInfo.put("battery", BleController.getInstance().getBattery());
        Log.d((String)TAG, (String)((Object)deviceInfo).toString());
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        result.put("success", Boolean.valueOf(true));
        result.put("data", deviceInfo);
        if (callback != null) {
            callback.invoke(result);
        }
    }

    @UniJSMethod(uiThread=true)
    public void startMeasure(UniJSCallback callback) {
        this.measureCallback = callback;
        Intent intent = new Intent(this.context, MainMeasureActivity.class);
        intent.putExtra("patientName", this.patientName);
        intent.putExtra("patientAge", this.patientAge);
        intent.putExtra("patientGender", this.patientGender);
        intent.putExtra("patientId", this.patientId);
        intent.addFlags(0x10000000);
        this.context.startActivity(intent);
    }

    @UniJSMethod(uiThread=false)
    public void toMeasure(UniJSCallback callback) {
        Log.d((String)TAG, (String)"toMeasure: \u5f00\u59cb\u8bbe\u7f6e\u6d4b\u8109\u56de\u8c03");
        this.measureCallback = callback;
        this.context = this.mUniSDKInstance.getContext();
        this.getCurrentActity();
        Log.d((String)TAG, (String)("toMeasure: measureCallback\u8bbe\u7f6e\u72b6\u6001: " + (this.measureCallback != null ? "\u5df2\u8bbe\u7f6e" : "\u672a\u8bbe\u7f6e")));
        Log.d((String)TAG, (String)("toMeasure: currentActivity: " + (this.currentActivity != null ? this.currentActivity.getClass().getSimpleName() : "null")));
        Log.d((String)TAG, (String)("toMeasure: uid: " + this.uid));
        int targetOrientation = -1;
        if (this.autoOrientationEnabled) {
            targetOrientation = this.getParentActivityOrientation();
            Log.d((String)TAG, (String)("toMeasure: \u81ea\u52a8\u5c4f\u5e55\u65b9\u5411\u6a21\u5f0f\uff0c\u83b7\u53d6\u5230\u5916\u5c42\u5e94\u7528\u65b9\u5411: " + this.getOrientationString(targetOrientation)));
        } else if (this.forcedOrientation != -1) {
            targetOrientation = this.forcedOrientation;
            Log.d((String)TAG, (String)("toMeasure: \u5f3a\u5236\u5c4f\u5e55\u65b9\u5411\u6a21\u5f0f\uff0c\u4f7f\u7528\u8bbe\u7f6e\u7684\u65b9\u5411: " + this.getOrientationString(targetOrientation)));
        }
        TaiyiManager.getInstance().toMeasure(this.uid, this.currentActivity, MeasureMainActivity.class, this, this, targetOrientation);
    }

    @UniJSMethod(uiThread=false)
    public void toTargetMeasure(String targetType, UniJSCallback callback) {
        this.measureCallback = callback;
        TaiyiManager.getInstance().setResultListener(new ResultListener(){

            @Override
            public void onResult(String pr, String cmdType, String measureId, String reportData) {
                TyPulseManager.this.handleMeasureResult(pr, measureId, reportData);
            }
        });
    }

    @UniJSMethod(uiThread=false)
    public void toDirectMeasure(UniJSCallback callback) {
        this.measureCallback = callback;
        this.getCurrentActity();
        TaiyiManager.getInstance().setResultListener(new ResultListener(){

            @Override
            public void onResult(String pr, String cmdType, String measureId, String reportData) {
                TyPulseManager.this.handleMeasureResult(pr, measureId, reportData);
            }
        });
        int targetOrientation = -1;
        if (this.autoOrientationEnabled) {
            targetOrientation = this.getParentActivityOrientation();
            Log.d((String)TAG, (String)("toDirectMeasure: \u81ea\u52a8\u5c4f\u5e55\u65b9\u5411\u6a21\u5f0f\uff0c\u83b7\u53d6\u5230\u5916\u5c42\u5e94\u7528\u65b9\u5411: " + this.getOrientationString(targetOrientation)));
        } else if (this.forcedOrientation != -1) {
            targetOrientation = this.forcedOrientation;
            Log.d((String)TAG, (String)("toDirectMeasure: \u5f3a\u5236\u5c4f\u5e55\u65b9\u5411\u6a21\u5f0f\uff0c\u4f7f\u7528\u8bbe\u7f6e\u7684\u65b9\u5411: " + this.getOrientationString(targetOrientation)));
        }
        TaiyiManager.getInstance().toDirectMeasure(this.uid, this.currentActivity, this, this, false, targetOrientation);
    }

    @UniJSMethod(uiThread=false)
    public void clearMeasure(UniJSCallback callback) {
        TaiyiManager.getInstance().clearMeasure();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        result.put("message", "\u6d4b\u91cf\u6570\u636e\u5df2\u6e05\u9664");
        if (callback != null) {
            callback.invoke(result);
        }
    }

    @UniJSMethod(uiThread=false)
    public void stopMeasure(UniJSCallback callback) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        result.put("message", "\u6d4b\u8109\u5df2\u505c\u6b62");
        if (callback != null) {
            callback.invoke(result);
        }
    }

    private void handleMeasureResult(String pr, String measureId, String reportData) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("type", "result");
        result.put("pr", pr);
        result.put("measureId", measureId);
        result.put("reportData", reportData);
        result.put("success", true);
        if (this.measureCallback != null) {
            this.mainHandler.post(() -> this.measureCallback.invoke((Object)result));
        }
    }

    public void onMeasureResult(PulseResult result) {
        if (this.measureCallback != null) {
            this.mainHandler.post(() -> this.measureCallback.invoke(result.toMap()));
        }
    }

    public void onMeasureProgress(int progress) {
        if (this.measureCallback != null) {
            HashMap<String, Object> progressData = new HashMap<String, Object>();
            progressData.put("type", "progress");
            progressData.put("progress", progress);
            this.mainHandler.post(() -> this.measureCallback.invoke((Object)progressData));
        }
    }

    public void onMeasureError(String error) {
        if (this.measureCallback != null) {
            HashMap<String, Object> errorData = new HashMap<String, Object>();
            errorData.put("type", "error");
            errorData.put("error", error);
            errorData.put("success", false);
            this.mainHandler.post(() -> this.measureCallback.invoke((Object)errorData));
        }
    }

    public void onActivityDestroy() {
        this.measureCallback = null;
    }

    @Override
    public void onSkip() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("type", "skip");
        result.put("success", true);
        result.put("message", "\u7528\u6237\u8df3\u8fc7\u4e86\u6d4b\u8109");
        if (this.measureCallback != null) {
            this.mainHandler.post(() -> this.measureCallback.invoke((Object)result));
        }
    }

    @Override
    public void onResult(String pr, String cmdType, String measureId, String reportData) {
        Log.d((String)TAG, (String)("onResult: \u6536\u5230\u6d4b\u91cf\u7ed3\u679c - cmdType: " + cmdType + ", measureId: " + measureId));
        Log.d((String)TAG, (String)("onResult: pr\u6570\u636e: " + (pr != null ? pr.substring(0, Math.min(pr.length(), 100)) + "..." : "null")));
        Log.d((String)TAG, (String)("onResult: reportData: " + (reportData != null ? reportData : "null")));
        if (this.measureCallback != null) {
            this.mainHandler.post(() -> {
                try {
                    Log.d((String)TAG, (String)"onResult: \u5f00\u59cb\u6784\u5efa\u56de\u8c03\u6570\u636e");
                    HashMap<String, Object> result = new HashMap<String, Object>();
                    result.put("success", true);
                    result.put("cmdType", cmdType != null ? cmdType : "pulseResult");
                    result.put("measureId", measureId != null ? measureId : "");
                    if (reportData != null && !reportData.isEmpty()) {
                        result.put("reportData", reportData);
                    }
                    if (pr != null && !pr.isEmpty()) {
                        result.put("pr", pr);
                    }
                    Log.d((String)TAG, (String)("onResult: \u6b63\u5728\u56de\u8c03\u7ed9uniapp: " + ((Object)result).toString()));
                    if (this.measureCallback instanceof UniJSCallback) {
                        try {
                            Method keepAliveMethod = this.measureCallback.getClass().getMethod("invokeAndKeepAlive", Object.class);
                            keepAliveMethod.invoke((Object)this.measureCallback, result);
                            Log.d((String)TAG, (String)"onResult: \u4f7f\u7528invokeAndKeepAlive\u56de\u8c03\u6267\u884c\u5b8c\u6210");
                        }
                        catch (NoSuchMethodException e) {
                            Log.d((String)TAG, (String)"onResult: invokeAndKeepAlive\u65b9\u6cd5\u4e0d\u5b58\u5728\uff0c\u4f7f\u7528\u666e\u901ainvoke");
                            this.measureCallback.invoke(result);
                            Log.d((String)TAG, (String)"onResult: \u666e\u901ainvoke\u56de\u8c03\u6267\u884c\u5b8c\u6210");
                        }
                        catch (Exception e) {
                            Log.e((String)TAG, (String)"onResult: invokeAndKeepAlive\u8c03\u7528\u5931\u8d25\uff0c\u56de\u9000\u5230\u666e\u901ainvoke", (Throwable)e);
                            this.measureCallback.invoke(result);
                            Log.d((String)TAG, (String)"onResult: \u56de\u9000invoke\u56de\u8c03\u6267\u884c\u5b8c\u6210");
                        }
                    } else {
                        this.measureCallback.invoke(result);
                        Log.d((String)TAG, (String)"onResult: \u6807\u51c6invoke\u56de\u8c03\u6267\u884c\u5b8c\u6210");
                    }
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)"onResult: \u56de\u8c03\u6267\u884c\u5f02\u5e38", (Throwable)e);
                    try {
                        HashMap<String, Object> errorResult = new HashMap<String, Object>();
                        errorResult.put("success", false);
                        errorResult.put("error", "\u56de\u8c03\u6570\u636e\u5904\u7406\u5f02\u5e38: " + e.getMessage());
                        errorResult.put("cmdType", "error");
                        this.measureCallback.invoke(errorResult);
                    }
                    catch (Exception ex) {
                        Log.e((String)TAG, (String)"onResult: \u9519\u8bef\u56de\u8c03\u4e5f\u5931\u8d25\u4e86", (Throwable)ex);
                    }
                }
            });
        } else {
            Log.w((String)TAG, (String)"onResult: measureCallback\u4e3anull\uff0c\u65e0\u6cd5\u56de\u8c03\u7ed9uniapp");
        }
    }

    @UniJSMethod(uiThread=false)
    public void setOrientationConfig(JSONObject options, UniJSCallback callback) {
        block17: {
            try {
                if (options != null) {
                    if (options.has("autoOrientation")) {
                        this.autoOrientationEnabled = options.getBoolean("autoOrientation");
                    }
                    if (options.has("orientation")) {
                        String orientation;
                        switch (orientation = options.getString("orientation")) {
                            case "portrait": {
                                this.forcedOrientation = 1;
                                break;
                            }
                            case "landscape": {
                                this.forcedOrientation = 0;
                                break;
                            }
                            default: {
                                this.forcedOrientation = -1;
                            }
                        }
                    }
                    HashMap<String, Object> result = new HashMap<String, Object>();
                    result.put("success", true);
                    result.put("autoOrientation", this.autoOrientationEnabled);
                    result.put("orientation", this.getOrientationString(this.forcedOrientation));
                    if (callback != null) {
                        callback.invoke(result);
                    }
                } else {
                    HashMap<String, Object> result = new HashMap<String, Object>();
                    result.put("success", false);
                    result.put("error", "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
                    if (callback != null) {
                        callback.invoke(result);
                    }
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("setOrientationConfig error: " + e.getMessage()), (Throwable)e);
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put("success", false);
                result.put("error", e.getMessage());
                if (callback == null) break block17;
                callback.invoke(result);
            }
        }
    }

    @UniJSMethod(uiThread=false)
    public void getOrientationConfig(UniJSCallback callback) {
        block4: {
            try {
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put("success", true);
                result.put("autoOrientation", this.autoOrientationEnabled);
                result.put("orientation", this.getOrientationString(this.forcedOrientation));
                this.getCurrentActity();
                if (this.currentActivity != null) {
                    int currentOrientation = this.currentActivity.getRequestedOrientation();
                    result.put("currentOrientation", this.getOrientationString(currentOrientation));
                    Configuration config = this.currentActivity.getResources().getConfiguration();
                    String currentScreenOrientation = config.orientation == 1 ? "portrait" : "landscape";
                    result.put("currentScreenOrientation", currentScreenOrientation);
                }
                if (callback != null) {
                    callback.invoke(result);
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("getOrientationConfig error: " + e.getMessage()), (Throwable)e);
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put("success", false);
                result.put("error", e.getMessage());
                if (callback == null) break block4;
                callback.invoke(result);
            }
        }
    }

    private int getParentActivityOrientation() {
        this.getCurrentActity();
        if (this.currentActivity != null) {
            if (this.autoOrientationEnabled) {
                return this.currentActivity.getRequestedOrientation();
            }
            return this.forcedOrientation;
        }
        return -1;
    }

    private String getOrientationString(int orientation) {
        switch (orientation) {
            case 1: {
                return "portrait";
            }
            case 0: {
                return "landscape";
            }
            case 2: {
                return "user";
            }
        }
        return "unspecified";
    }

    private void getCurrentActity() {
        this.currentActivity = null;
        this.currentActivity = this.context instanceof Activity ? (Activity)this.context : AppManager.getAppManager().currentActivity();
        if (this.currentActivity == null) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("success", false);
            result.put("error", "\u65e0\u6cd5\u83b7\u53d6\u5f53\u524dActivity");
            return;
        }
    }
}

