/*
 * Decompiled with CFR 0.152.
 */
package com.taiyi.typulse.receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.hardware.usb.UsbDevice;
import android.os.Parcelable;
import android.util.Log;

public class UsbDeviceReceiver
extends BroadcastReceiver {
    private static final String TAG = "UsbDeviceReceiver";

    public void onReceive(Context context, Intent intent) {
        UsbDevice device;
        String action = intent.getAction();
        if ("android.hardware.usb.action.USB_DEVICE_ATTACHED".equals(action)) {
            UsbDevice device2 = (UsbDevice)intent.getParcelableExtra("device");
            if (device2 != null) {
                Log.d((String)TAG, (String)("USB\u8bbe\u5907\u5df2\u8fde\u63a5: " + device2.getDeviceName()));
                Log.d((String)TAG, (String)("\u8bbe\u5907\u4fe1\u606f: VendorId=" + device2.getVendorId() + ", ProductId=" + device2.getProductId()));
                this.notifyDeviceConnected(context, device2);
            }
        } else if ("android.hardware.usb.action.USB_DEVICE_DETACHED".equals(action) && (device = (UsbDevice)intent.getParcelableExtra("device")) != null) {
            Log.d((String)TAG, (String)("USB\u8bbe\u5907\u5df2\u65ad\u5f00: " + device.getDeviceName()));
            this.notifyDeviceDisconnected(context, device);
        }
    }

    private void notifyDeviceConnected(Context context, UsbDevice device) {
        Intent localIntent = new Intent("com.taiyi.typulse.USB_DEVICE_CONNECTED");
        localIntent.putExtra("device", (Parcelable)device);
        context.sendBroadcast(localIntent);
    }

    private void notifyDeviceDisconnected(Context context, UsbDevice device) {
        Intent localIntent = new Intent("com.taiyi.typulse.USB_DEVICE_DISCONNECTED");
        localIntent.putExtra("device", (Parcelable)device);
        context.sendBroadcast(localIntent);
    }
}

