/*
 * Decompiled with CFR 0.152.
 */
package com.taiyi.typulse.tyusbsdk;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.PointF;
import android.graphics.drawable.Drawable;
import android.os.CountDownTimer;
import android.util.AttributeSet;
import android.view.View;
import com.taiyi.typulse.R;
import com.taiyi.typulse.tyusbsdk.pulse.util.LogUtil;

public class PressureViewNew
extends View {
    private Paint mTextPaint;
    private Paint mPressurePaint;
    private Paint mVioletLightPaint;
    private Paint mPressureAreaPaint;
    private Paint mPressureLinePaint;
    private Paint mPressureDottedLinePaint;
    private Paint bigRoundPointPaint;
    private Paint smallRoundPointPaint;
    private int violet;
    private int violetLight;
    private int orange;
    private int yellow;
    private Path mVioletLightPath;
    private Path mPressureLinePath;
    private float startX;
    private float startY;
    private float endX;
    private float endY;
    private float stepX;
    private float stepY;
    private float areaWidth;
    private float areaHeight;
    private float radius;
    private int xCount = 10;
    private int yCount = 11;
    private float mLineWidth;
    private Path mPressureAreaPath;
    private PathEffect mEffect;
    private int textSize;
    private String[] pressure;
    private String pressureUnit;
    private String[] times;
    private String timeUnit;
    private String measureTime;
    private Drawable bgVioletLightDrawable;
    private float pressureStepX;
    private float pressureStepY;
    private PointF pressurePoint = new PointF();
    private int steps = 0;
    CountDownTimer mCountDownTimer = new CountDownTimer(100000L, 200L){

        public void onTick(long millisUntilFinished) {
            PressureViewNew.this.steps++;
            float posX = PressureViewNew.this.startX + PressureViewNew.this.pressureStepX * (float)PressureViewNew.this.steps;
            if (posX > PressureViewNew.this.endX) {
                posX = PressureViewNew.this.endX;
            }
            ((PressureViewNew)PressureViewNew.this).pressurePoint.x = posX;
            if (PressureViewNew.this.steps % 50 == 35 && PressureViewNew.this.steps < 450) {
                if (PressureViewNew.this.areaHeight != 0.0f) {
                    PressureViewNew.this.radius = PressureViewNew.this.areaHeight / 2.0f;
                    PressureViewNew.this.postInvalidate();
                }
            } else if (PressureViewNew.this.steps % 50 == 45 && PressureViewNew.this.steps < 450 && PressureViewNew.this.areaHeight != 0.0f) {
                PressureViewNew.this.radius = PressureViewNew.this.areaHeight / 3.0f;
                PressureViewNew.this.postInvalidate();
            }
            PressureViewNew.this.postInvalidate();
        }

        public void onFinish() {
        }
    };

    public PressureViewNew(Context context) {
        this(context, null);
    }

    public PressureViewNew(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PressureViewNew(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.violet = this.getResources().getColor(R.color.violet_2);
        this.violetLight = this.getResources().getColor(R.color.violet_light);
        this.orange = this.getResources().getColor(R.color.orange);
        this.yellow = this.getResources().getColor(R.color.yellow);
        this.mPressurePaint = new Paint();
        this.mPressurePaint.setAntiAlias(true);
        this.mPressurePaint.setColor(this.getResources().getColor(R.color.black));
        this.mPressurePaint.setTextAlign(Paint.Align.RIGHT);
        this.mTextPaint = new Paint();
        this.mTextPaint.setAntiAlias(true);
        this.mTextPaint.setColor(this.getResources().getColor(R.color.black));
        this.mTextPaint.setTextAlign(Paint.Align.LEFT);
        this.mVioletLightPaint = new Paint();
        this.mVioletLightPaint.setAntiAlias(true);
        this.mVioletLightPaint.setColor(this.violetLight);
        this.mVioletLightPaint.setStyle(Paint.Style.STROKE);
        this.mPressureLinePaint = new Paint();
        this.mPressureLinePaint.setAntiAlias(true);
        this.mPressureLinePaint.setColor(this.violet);
        this.mPressureLinePaint.setStyle(Paint.Style.STROKE);
        this.mPressureDottedLinePaint = new Paint();
        this.mPressureDottedLinePaint.setAntiAlias(true);
        this.mPressureDottedLinePaint.setColor(this.violet);
        this.mPressureDottedLinePaint.setStyle(Paint.Style.STROKE);
        this.bigRoundPointPaint = new Paint();
        this.bigRoundPointPaint.setAntiAlias(true);
        this.bigRoundPointPaint.setColor(this.yellow);
        this.bigRoundPointPaint.setStyle(Paint.Style.STROKE);
        this.smallRoundPointPaint = new Paint();
        this.smallRoundPointPaint.setAntiAlias(true);
        this.smallRoundPointPaint.setColor(this.orange);
        this.smallRoundPointPaint.setStyle(Paint.Style.FILL);
        this.mPressureAreaPaint = new Paint();
        this.mPressureAreaPaint.setAntiAlias(true);
        this.mPressureAreaPaint.setColor(this.orange);
        this.mPressureAreaPaint.setStyle(Paint.Style.STROKE);
        this.mVioletLightPath = new Path();
        this.mPressureAreaPath = new Path();
        this.mPressureLinePath = new Path();
        this.pressure = this.getContext().getResources().getStringArray(R.array.pressure);
        this.pressureUnit = this.getContext().getResources().getString(R.string.pressure_unit);
        this.times = this.getContext().getResources().getStringArray(R.array.time);
        this.timeUnit = this.getContext().getResources().getString(R.string.time_unit);
        this.bgVioletLightDrawable = this.getResources().getDrawable(R.drawable.bg_trans_violet);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        int i;
        super.onSizeChanged(w, h, oldw, oldh);
        this.startX = (float)w * 0.118f;
        this.startY = (float)h * 0.884f;
        this.endX = (float)w * 0.967f;
        this.endY = (float)h * 0.028f;
        this.stepX = (this.endX - this.startX) / (float)this.xCount;
        this.stepY = (this.startY - this.endY) / (float)(this.yCount - 1);
        this.mLineWidth = (float)h * 0.004f;
        this.mVioletLightPaint.setStrokeWidth(this.mLineWidth);
        this.mPressureAreaPaint.setStrokeWidth(this.mLineWidth);
        this.bigRoundPointPaint.setStrokeWidth(this.mLineWidth);
        this.mPressureLinePaint.setStrokeWidth(this.mLineWidth);
        this.areaWidth = (float)h * 0.067f;
        this.areaHeight = (float)h * 0.046f;
        this.radius = this.areaHeight / 3.0f;
        LogUtil.w("PressureViewNew", "\u534a\u5f84:" + this.radius);
        this.mEffect = new DashPathEffect(new float[]{this.areaHeight / 2.0f, this.areaHeight / 3.0f}, 0.0f);
        this.mPressureAreaPaint.setPathEffect(this.mEffect);
        this.mPressureDottedLinePaint.setPathEffect(this.mEffect);
        this.pressureStepX = (this.endX - this.startX) / 500.0f;
        this.pressureStepY = (this.startY - this.endY) / 250.0f;
        LogUtil.w("PressureView", "pressureStepX:" + this.pressureStepX);
        LogUtil.w("PressureView", "pressureStepY:" + this.pressureStepY);
        LogUtil.w("PressureView", "pressureStepY:" + this.stepY);
        this.textSize = (int)((double)this.stepY * 0.3);
        this.mTextPaint.setTextSize((float)this.textSize);
        this.mPressurePaint.setTextSize((float)this.textSize);
        for (i = 0; i < 11; ++i) {
            this.mVioletLightPath.moveTo(this.startX, this.startY - this.stepY * (float)i);
            this.mVioletLightPath.lineTo(this.endX, this.startY - this.stepY * (float)i);
        }
        this.mPressureAreaPath.moveTo(this.startX + (this.stepX - this.areaWidth) / 2.0f, this.startY - this.mLineWidth);
        this.mPressureAreaPath.moveTo(this.startX + this.stepX, this.startY - this.mLineWidth);
        this.mPressureAreaPath.lineTo(this.startX + this.stepX - this.areaWidth, this.startY - this.mLineWidth);
        for (i = 0; i < 9; ++i) {
            this.mPressureAreaPath.lineTo(this.startX + this.stepX * (float)(i + 1) - this.areaWidth, this.startY - this.stepY * (float)(i + 1) - this.areaHeight - this.mLineWidth);
            if (i == 8) {
                this.mPressureAreaPath.lineTo(this.startX + this.stepX * (float)(i + 2), this.startY - this.stepY * (float)(i + 1) - this.areaHeight - this.mLineWidth);
                continue;
            }
            this.mPressureAreaPath.lineTo(this.startX + this.stepX * (float)(i + 2) - this.areaWidth, this.startY - this.stepY * (float)(i + 1) - this.areaHeight - this.mLineWidth);
        }
        for (i = 8; i > -1; --i) {
            if (i == 8) {
                this.mPressureAreaPath.lineTo(this.startX + this.stepX * (float)(i + 2), this.startY - this.stepY * (float)(i + 1) - this.mLineWidth);
            }
            this.mPressureAreaPath.lineTo(this.startX + this.stepX * (float)(i + 1), this.startY - this.stepY * (float)(i + 1) - this.mLineWidth);
            this.mPressureAreaPath.lineTo(this.startX + this.stepX * (float)(i + 1), this.startY - this.stepY * (float)i - this.mLineWidth);
        }
        this.mPressureLinePath.moveTo(this.startX, this.startY);
        LogUtil.w("PressureView", "x width:" + (this.endX - this.startX));
        LogUtil.w("PressureView", "start x:" + this.startX + ",end x:" + this.endX);
        LogUtil.w("PressureView", "x step:" + (this.endX - this.startX) / 500.0f);
        this.pressurePoint.x = this.startX;
        this.pressurePoint.y = this.startY;
    }

    protected void onDraw(Canvas canvas) {
        int i;
        super.onDraw(canvas);
        for (i = 0; i < this.pressure.length; ++i) {
            canvas.drawText(this.pressure[i], this.startX - (float)this.textSize, this.startY + (float)this.textSize / 2.0f - (this.startY + (float)this.textSize / 2.0f - this.endY - (float)this.textSize) / (float)(this.pressure.length - 1) * (float)i, this.mPressurePaint);
        }
        for (i = 0; i < this.times.length; ++i) {
            canvas.drawText(this.times[i], this.endX - (this.endX - this.startX) / (float)(this.times.length - 1) * (float)i, this.startY + (float)this.textSize * 1.3f, this.mPressurePaint);
        }
        canvas.drawText(this.pressureUnit, this.startX, this.endY + (float)this.textSize, this.mTextPaint);
        canvas.drawText(this.timeUnit, this.endX, this.startY - (float)this.textSize * 0.4f, this.mPressurePaint);
        canvas.drawLine(this.pressurePoint.x, this.startY, this.pressurePoint.x, this.endY, this.mPressureDottedLinePaint);
        canvas.drawPath(this.mPressureAreaPath, this.mPressureAreaPaint);
        this.drawFilledPath(canvas, this.mPressureAreaPath, this.bgVioletLightDrawable);
        canvas.drawPath(this.mVioletLightPath, this.mVioletLightPaint);
        canvas.drawPath(this.mPressureLinePath, this.mPressureLinePaint);
        canvas.drawCircle(this.pressurePoint.x, this.pressurePoint.y, this.radius + this.mLineWidth / 2.0f, this.bigRoundPointPaint);
        canvas.drawCircle(this.pressurePoint.x, this.pressurePoint.y, this.radius, this.smallRoundPointPaint);
    }

    protected void drawFilledPath(Canvas c, Path filledPath, Drawable drawable2) {
        int save = c.save();
        c.clipPath(filledPath);
        drawable2.setBounds((int)this.startX, (int)this.endY, (int)this.endX, (int)this.startY);
        drawable2.draw(c);
        c.restoreToCount(save);
    }

    public void addPressure(float pressure) {
        float posY = this.startY - pressure * this.pressureStepY;
        if (posY <= this.endY) {
            posY = this.endY;
        }
        this.pressurePoint.y = posY;
        this.mPressureLinePath.lineTo(this.pressurePoint.x, this.pressurePoint.y);
        this.postInvalidate();
    }

    public void start() {
        if (this.mCountDownTimer != null) {
            this.mCountDownTimer.start();
        }
    }

    public void finish() {
        if (this.mCountDownTimer != null) {
            this.mCountDownTimer.cancel();
            this.mCountDownTimer = null;
        }
    }
}

