/*
 * Decompiled with CFR 0.152.
 */
package com.taiyi.typulse.tyusbsdk;

import android.content.Context;
import android.graphics.drawable.ClipDrawable;
import android.os.CountDownTimer;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.taiyi.typulse.R;

public class RealTimeMeasureView
extends RelativeLayout {
    private ClipDrawable progressView;
    private LinearLayout indicatorView;
    private TextView countDownTextView;
    private CountDownTimer countDownTimer;
    private long beginTime = -1L;

    public RealTimeMeasureView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    private void init(Context context) {
        View layout2 = LayoutInflater.from((Context)context).inflate(R.layout.realtime_measure_view, (ViewGroup)this);
        ImageView progressImageView = (ImageView)layout2.findViewById(R.id.progressViewId);
        this.progressView = (ClipDrawable)progressImageView.getDrawable();
        this.indicatorView = (LinearLayout)this.findViewById(R.id.indicatorId);
        this.countDownTextView = (TextView)this.findViewById(R.id.countDownTextId);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.countDownTimer != null) {
            this.countDownTimer.cancel();
            this.countDownTimer = null;
        }
    }

    public void setProgressValue(int value) {
        float percent = (float)((double)value / 300.0);
        percent = percent > 1.0f ? 1.0f : percent;
        this.progressView.setLevel((int)(10000.0f * percent));
        this.updateIndicatorView(percent, value);
    }

    private void updateIndicatorView(float percent, int value) {
        RelativeLayout.LayoutParams lp = (RelativeLayout.LayoutParams)this.indicatorView.getLayoutParams();
        lp.bottomMargin = (int)((-7.0f + 171.0f * percent) * this.getContext().getResources().getDisplayMetrics().density);
        TextView valueView = (TextView)this.indicatorView.findViewById(R.id.indicatiorTextId);
        valueView.setText((CharSequence)String.valueOf(value));
        this.indicatorView.setLayoutParams((ViewGroup.LayoutParams)lp);
    }

    public void startTimerCountDown() {
        if (this.countDownTimer == null) {
            this.beginTime = System.currentTimeMillis();
            this.countDownTextView.setVisibility(0);
            final int[] beginSeconds = new int[]{100};
            this.countDownTextView.setText((CharSequence)(String.valueOf(beginSeconds[0]) + "s"));
            this.countDownTimer = new CountDownTimer(101000L, 1000L){

                public void onTick(long millisUntilFinished) {
                    beginSeconds[0] = beginSeconds[0] - 1;
                    RealTimeMeasureView.this.countDownTextView.setText((CharSequence)(String.valueOf(beginSeconds[0]) + "s"));
                }

                public void onFinish() {
                    RealTimeMeasureView.this.countDownTextView.setText((CharSequence)"0s");
                    RealTimeMeasureView.this.countDownTimer = null;
                }
            };
            this.countDownTimer.start();
        }
    }

    public float getNowTime() {
        if (this.beginTime == -1L) {
            return -1.0f;
        }
        long curTime = System.currentTimeMillis() - this.beginTime;
        return (float)((double)curTime / 1000.0);
    }
}

