/*
 * Decompiled with CFR 0.152.
 */
package com.taiyi.typulse.tyusbsdk;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.hardware.usb.UsbDevice;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.ActivityCompat;
import com.alibaba.sdk.android.oss.ClientException;
import com.alibaba.sdk.android.oss.ServiceException;
import com.alibaba.sdk.android.oss.callback.OSSCompletedCallback;
import com.alibaba.sdk.android.oss.model.PutObjectRequest;
import com.alibaba.sdk.android.oss.model.PutObjectResult;
import com.opencsv.CSVWriter;
import com.taiyi.typulse.tyusbsdk.CallbackInterface;
import com.taiyi.typulse.tyusbsdk.CountTimer;
import com.taiyi.typulse.tyusbsdk.CsvUploadItem;
import com.taiyi.typulse.tyusbsdk.HandType;
import com.taiyi.typulse.tyusbsdk.MeasureType;
import com.taiyi.typulse.tyusbsdk.OssFileUtil;
import com.taiyi.typulse.tyusbsdk.RealTimeDataItem;
import com.taiyi.typulse.tyusbsdk.RealTimeMeasureStatus;
import com.taiyi.typulse.tyusbsdk.TYDeviceConnectCallback;
import com.taiyi.typulse.tyusbsdk.TYDeviceSoftware;
import com.taiyi.typulse.tyusbsdk.TYUsbDeviceService;
import com.taiyi.typulse.tyusbsdk.pulse.bean.RealtimeWaveItem;
import com.taiyi.typulse.tyusbsdk.pulse.ui.BaseActivity;
import com.taiyi.typulse.tyusbsdk.pulse.util.LogUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class TYUsbDeviceActivity
extends BaseActivity {
    private MessageHandler mHandler;
    private UsbConnection usbConnection;
    private List recentData;
    private List csvData;
    CountTimer countTimer;
    private long measureTime;
    private long measureTickTime;
    private int BEFORE_M_REQUEST_CODE = 100;
    private int AFTER_M_REQUEST_CODE = 101;
    private boolean write_access = false;
    private boolean read_access = false;
    private boolean internet_access = false;
    private boolean isMeasureTimeOver = false;
    private CsvUploadItem tempItem;
    private RealTimeMeasureStatus currentMeasureStatus = null;
    private MeasureType measureType;
    Handler measureHandler = new Handler();
    Runnable measureRunnable = new Runnable(){

        @Override
        public void run() {
            if (TYUsbDeviceActivity.this.currentMeasureStatus != RealTimeMeasureStatus.START_MEASURE) {
                if (TYUsbDeviceActivity.this.recentData.size() > 0) {
                    TYUsbDeviceActivity.this.onMeasureInOtherStatus((String[])TYUsbDeviceActivity.this.recentData.get(0));
                }
            } else if (TYUsbDeviceActivity.this.countTimer == null) {
                TYUsbDeviceActivity.this.countTimer = new CountTimer(TYUsbDeviceActivity.this.measureTime, TYUsbDeviceActivity.this.measureTickTime, new CallbackInterface(){

                    @Override
                    public void onTick(long millisUntilFinished) {
                        LogUtil.i("TYUsbDeviceActivity", "Timer onTick");
                        LogUtil.i("TYUsbDeviceActivity", "Time Left:" + String.valueOf(millisUntilFinished));
                        if (TYUsbDeviceActivity.this.csvData.size() > 0) {
                            Object[] updatedData = (String[])TYUsbDeviceActivity.this.csvData.get(TYUsbDeviceActivity.this.csvData.size() - 1);
                            LogUtil.i("TYUsbDeviceActivity", Arrays.toString(updatedData));
                            TYUsbDeviceActivity.this.onMeasureDataReceived(TYUsbDeviceActivity.this.measureTime - millisUntilFinished, TYUsbDeviceActivity.this.measureTime, (String[])updatedData);
                        }
                    }

                    @Override
                    public void onFinish() {
                        LogUtil.i("TYUsbDeviceActivity", "Timer onFinish");
                        TYUsbDeviceActivity.this.countTimer = null;
                        TYUsbDeviceActivity.this.isMeasureTimeOver = true;
                    }
                });
                TYUsbDeviceActivity.this.countTimer.start();
            }
            TYUsbDeviceActivity.this.measureHandler.postDelayed(TYUsbDeviceActivity.this.measureRunnable, TYUsbDeviceActivity.this.measureTickTime);
        }
    };

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.recentData = new ArrayList();
        this.csvData = new ArrayList();
        this.setMeasureTotalTime(102000L);
        this.setMeasureTickTime(200L);
        this.checkPermission();
    }

    protected void onResume() {
        super.onResume();
        this.initConnectionHandle();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (this.usbConnection != null) {
            this.sendCancelMeasureCommand();
            this.unbindService(this.usbConnection);
            this.usbConnection = null;
        }
    }

    @Override
    protected int initLayoutResId() {
        return 0;
    }

    @Override
    protected void init() {
    }

    private void initConnectionHandle() {
        this.mHandler = new MessageHandler(this);
        this.usbConnection = new UsbConnection(this.mHandler);
        Intent intent = new Intent((Context)this, TYUsbDeviceService.class);
        this.bindService(intent, this.usbConnection, 1);
    }

    protected void setMeasureTotalTime(long millisSeconds) {
        this.measureTime = millisSeconds;
    }

    protected void setMeasureTickTime(long millisSeconds) {
        this.measureTickTime = millisSeconds;
    }

    public long getMeasureTotalTime() {
        return this.measureTime;
    }

    public long getMeasureTickTime() {
        return this.measureTickTime;
    }

    protected void onUsbAttached() {
    }

    protected void onUsbDetached() {
    }

    protected void onDevicePermissionGranted() {
    }

    protected void onDevicePermissionRejected() {
    }

    protected void onDeviceConnectedSuccessfully() {
    }

    protected void onDeviceConnectFailed() {
    }

    protected void onDeviceReceiveStatus(int status) {
    }

    protected void onDeviceReceiveVersion(TYDeviceSoftware software) {
    }

    protected void onDeviceReceiveName(String deviceName) {
    }

    protected void onMeasureStatusChanged(RealTimeMeasureStatus status) {
    }

    protected void onMeasureInOtherStatus(String[] measureData) {
    }

    protected void onMeasureDataReceived(long currentTime, long totalTime, String[] measureData) {
    }

    protected void onMeasureFinished() {
    }

    private void usbDetached() {
        if (this.countTimer != null) {
            this.measureHandler.removeCallbacks(this.measureRunnable);
            this.countTimer.cancel();
            this.countTimer = null;
        }
        this.onUsbDetached();
    }

    public void sendDeviceStatusCommad() {
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                if (TYUsbDeviceActivity.this.usbConnection.usbBinder.getSerialDeviceConnected()) {
                    TYUsbDeviceActivity.this.usbConnection.usbBinder.sendDeviceStatusCommad();
                }
            }
        }, 500L);
    }

    public void startMeasure(HandType hType, MeasureType mType) {
        if (mType == MeasureType.DROP_TYPE) {
            this.sendMeasureWaitCommand(hType);
        } else {
            this.sendMeasureCommand(hType);
        }
    }

    public void sendMeasureCommand(final HandType handType) {
        this.measureType = MeasureType.STEP_TYPE;
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                if (TYUsbDeviceActivity.this.countTimer == null && TYUsbDeviceActivity.this.usbConnection.usbBinder.getSerialDeviceConnected()) {
                    TYUsbDeviceActivity.this.usbConnection.usbBinder.sendMeasureWaitCommand(handType);
                    TYUsbDeviceActivity.this.countTimer = new CountTimer(TYUsbDeviceActivity.this.measureTime, TYUsbDeviceActivity.this.measureTickTime, new CallbackInterface(){

                        @Override
                        public void onTick(long millisUntilFinished) {
                            LogUtil.i("TYUsbDeviceActivity", "Timer onTick");
                            LogUtil.i("TYUsbDeviceActivity", "Time Left:" + String.valueOf(millisUntilFinished));
                            if (TYUsbDeviceActivity.this.csvData.size() > 0) {
                                Object[] updatedData = (String[])TYUsbDeviceActivity.this.csvData.get(TYUsbDeviceActivity.this.csvData.size() - 1);
                                LogUtil.i("TYUsbDeviceActivity", Arrays.toString(updatedData));
                                TYUsbDeviceActivity.this.onMeasureDataReceived(TYUsbDeviceActivity.this.measureTime - millisUntilFinished, TYUsbDeviceActivity.this.measureTime, (String[])updatedData);
                            }
                        }

                        @Override
                        public void onFinish() {
                            LogUtil.i("TYUsbDeviceActivity", "Timer onFinish");
                            TYUsbDeviceActivity.this.countTimer = null;
                            TYUsbDeviceActivity.this.sendCancelMeasureCommand();
                            TYUsbDeviceActivity.this.onMeasureFinished();
                        }
                    });
                    TYUsbDeviceActivity.this.countTimer.start();
                }
            }
        }, 500L);
    }

    public void sendMeasureWaitCommand(final HandType handType) {
        this.measureType = MeasureType.DROP_TYPE;
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                if (TYUsbDeviceActivity.this.usbConnection.usbBinder.getSerialDeviceConnected()) {
                    TYUsbDeviceActivity.this.usbConnection.usbBinder.sendMeasureWaitCommand(handType);
                }
                TYUsbDeviceActivity.this.measureRunnable.run();
            }
        }, 500L);
    }

    public void sendMeasureStartCommand() {
        if (this.usbConnection.usbBinder.getSerialDeviceConnected()) {
            this.usbConnection.usbBinder.sendMeasureStartCommand();
        }
    }

    public void sendCancelMeasureCommand() {
        if (this.usbConnection.usbBinder.getSerialDeviceConnected()) {
            this.usbConnection.usbBinder.sendCancelMeasureCommand();
        }
        if (this.countTimer != null) {
            this.measureHandler.removeCallbacks(this.measureRunnable);
            this.countTimer.cancel();
            this.countTimer = null;
        }
    }

    public void sendDeviceVersionCommand() {
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                if (TYUsbDeviceActivity.this.usbConnection.usbBinder.getSerialDeviceConnected()) {
                    TYUsbDeviceActivity.this.usbConnection.usbBinder.sendDeviceVersionCommand();
                }
            }
        }, 500L);
    }

    public void sendDeviceUpdateCommand() {
        if (this.usbConnection.usbBinder.getSerialDeviceConnected()) {
            this.usbConnection.usbBinder.sendDeviceUpdateCommand();
        }
    }

    public String getDeviceName() {
        if (this.usbConnection.usbBinder.getSerialDeviceConnected()) {
            return this.usbConnection.usbBinder.getDeviceName();
        }
        return "";
    }

    public HandType getCurrentHand() {
        return this.usbConnection.usbBinder.getCurrentHand();
    }

    private void onReceiveMaiData(List<String> maiDataArray) {
        if (this.measureType == MeasureType.DROP_TYPE) {
            if (this.recentData.size() < 25) {
                this.recentData.add(0, maiDataArray.toArray(new String[maiDataArray.size()]));
            } else {
                this.recentData.remove(this.recentData.size() - 1);
                this.recentData.add(0, maiDataArray.toArray(new String[maiDataArray.size()]));
            }
            if (this.currentMeasureStatus == RealTimeMeasureStatus.START_MEASURE) {
                this.csvData.add(maiDataArray.toArray(new String[maiDataArray.size()]));
            }
            this.checkMeasureStatus();
        } else {
            this.csvData.add(maiDataArray.toArray(new String[maiDataArray.size()]));
        }
    }

    private void checkMeasureStatus() {
        String[] currentMaiData;
        if (this.currentMeasureStatus == null) {
            this.currentMeasureStatus = RealTimeMeasureStatus.WAITING_INFLATE;
            this.onMeasureStatusChanged(RealTimeMeasureStatus.WAITING_INFLATE);
        } else if (this.currentMeasureStatus == RealTimeMeasureStatus.WAITING_INFLATE) {
            String[] currentMaiData2;
            if (this.recentData.size() == 25 && Integer.valueOf((currentMaiData2 = (String[])this.recentData.get(0))[98]) > 25000) {
                this.currentMeasureStatus = RealTimeMeasureStatus.COMPLETE_INFLATE;
                this.onMeasureStatusChanged(RealTimeMeasureStatus.COMPLETE_INFLATE);
            }
        } else if (this.currentMeasureStatus == RealTimeMeasureStatus.COMPLETE_INFLATE) {
            String[] currentMaiData3 = (String[])this.recentData.get(0);
            String[] lastMaiData = (String[])this.recentData.get(this.recentData.size() - 1);
            if (Math.abs(Integer.valueOf(currentMaiData3[98]) - Integer.valueOf(lastMaiData[98])) <= 200 && Integer.valueOf(currentMaiData3[98]) > 24000) {
                this.currentMeasureStatus = RealTimeMeasureStatus.START_MEASURE;
                this.onMeasureStatusChanged(RealTimeMeasureStatus.START_MEASURE);
                this.sendMeasureStartCommand();
            }
        } else if (this.currentMeasureStatus == RealTimeMeasureStatus.START_MEASURE && this.isMeasureTimeOver) {
            String[] currentMaiData4 = (String[])this.recentData.get(0);
            if (Integer.valueOf(currentMaiData4[98]) >= 4000) {
                this.currentMeasureStatus = RealTimeMeasureStatus.FINISH_MEASURE;
                this.onMeasureStatusChanged(RealTimeMeasureStatus.FINISH_MEASURE);
            } else {
                this.currentMeasureStatus = RealTimeMeasureStatus.END_MEASURE;
                this.onMeasureStatusChanged(RealTimeMeasureStatus.END_MEASURE);
                new Handler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        TYUsbDeviceActivity.this.sendCancelMeasureCommand();
                        TYUsbDeviceActivity.this.onMeasureFinished();
                    }
                }, 2000L);
            }
        } else if (this.currentMeasureStatus == RealTimeMeasureStatus.FINISH_MEASURE && Integer.valueOf((currentMaiData = (String[])this.recentData.get(0))[98]) < 4000) {
            this.currentMeasureStatus = RealTimeMeasureStatus.END_MEASURE;
            this.onMeasureStatusChanged(RealTimeMeasureStatus.END_MEASURE);
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    TYUsbDeviceActivity.this.sendCancelMeasureCommand();
                    TYUsbDeviceActivity.this.onMeasureFinished();
                }
            }, 2000L);
        }
    }

    protected void onReceiveRealTimeData(RealTimeDataItem realtimeData) {
    }

    protected void onReceivePeriodicFeatureData(List<Integer> indexArray) {
    }

    protected void onReceiveAmplitudeData(List<Integer> indexArray) {
    }

    protected void onRealTimeWaveGet(RealtimeWaveItem dataItem) {
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode == this.BEFORE_M_REQUEST_CODE) {
            ArrayList<String> permissionList = new ArrayList<String>();
            for (int i = 0; i < permissions.length; ++i) {
                String permission2 = permissions[i];
                int grantResult = grantResults[i];
                if (permission2.equals("android.permission.WRITE_EXTERNAL_STORAGE")) {
                    if (grantResult == 0) {
                        this.write_access = true;
                    } else {
                        this.write_access = false;
                        permissionList.add("android.permission.WRITE_EXTERNAL_STORAGE");
                    }
                }
                if (permission2.equals("android.permission.READ_EXTERNAL_STORAGE")) {
                    if (grantResult == 0) {
                        this.read_access = true;
                    } else {
                        this.read_access = false;
                        permissionList.add("android.permission.READ_EXTERNAL_STORAGE");
                    }
                }
                if (!permission2.equals("android.permission.INTERNET")) continue;
                if (grantResult == 0) {
                    this.internet_access = true;
                    continue;
                }
                this.internet_access = false;
                permissionList.add("android.permission.INTERNET");
            }
            if (this.write_access && this.read_access && this.internet_access && this.tempItem != null) {
                this.uploadCSVAction(this.tempItem.uid, this.tempItem.ossInterface, this.tempItem.csv, this.tempItem.fileName);
            }
        } else if (requestCode == this.AFTER_M_REQUEST_CODE) {
            for (int i = 0; i < permissions.length; ++i) {
                String permission3 = permissions[i];
                int grantResult = grantResults[i];
                if (!permission3.equals("android.permission.INTERNET")) continue;
                this.internet_access = grantResult == 0;
            }
            if (this.write_access && this.read_access && this.internet_access) {
                if (this.tempItem != null) {
                    this.uploadCSVAction(this.tempItem.uid, this.tempItem.ossInterface, this.tempItem.csv, this.tempItem.fileName);
                }
            } else if (!this.internet_access) {
                ActivityCompat.requestPermissions((Activity)this, (String[])new String[]{"android.permission.INTERNET"}, (int)this.BEFORE_M_REQUEST_CODE);
            }
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == this.AFTER_M_REQUEST_CODE && Build.VERSION.SDK_INT >= 30) {
            if (Environment.isExternalStorageManager()) {
                this.write_access = true;
                this.read_access = true;
            } else {
                Intent intent = new Intent();
                intent.setAction("android.settings.MANAGE_APP_ALL_FILES_ACCESS_PERMISSION");
                Uri uri = Uri.fromParts((String)"package", (String)this.getPackageName(), null);
                intent.setData(uri);
                this.startActivityForResult(intent, this.AFTER_M_REQUEST_CODE);
            }
            if (this.checkSelfPermission("android.permission.INTERNET") != 0) {
                this.internet_access = false;
                this.requestPermissions(new String[]{"android.permission.INTERNET"}, this.AFTER_M_REQUEST_CODE);
            } else {
                this.internet_access = true;
            }
            if (this.write_access && this.read_access && this.internet_access && this.tempItem != null) {
                this.uploadCSVAction(this.tempItem.uid, this.tempItem.ossInterface, this.tempItem.csv, this.tempItem.fileName);
            }
        }
    }

    private void checkPermission() {
        String dir = Environment.getExternalStorageDirectory().getAbsolutePath() + "/taiyi/";
        File file = new File(dir);
        if (!file.exists()) {
            file.mkdir();
        }
        if (Build.VERSION.SDK_INT >= 23 && Build.VERSION.SDK_INT < 30) {
            ArrayList<String> permissionList = new ArrayList<String>();
            if (this.checkSelfPermission("android.permission.WRITE_EXTERNAL_STORAGE") != 0) {
                this.write_access = false;
                permissionList.add("android.permission.WRITE_EXTERNAL_STORAGE");
            } else {
                this.write_access = true;
            }
            if (this.checkSelfPermission("android.permission.READ_EXTERNAL_STORAGE") != 0) {
                this.read_access = false;
                permissionList.add("android.permission.READ_EXTERNAL_STORAGE");
            } else {
                this.read_access = true;
            }
            if (this.checkSelfPermission("android.permission.INTERNET") != 0) {
                this.internet_access = false;
                permissionList.add("android.permission.INTERNET");
            } else {
                this.internet_access = true;
            }
            if (!(this.write_access && this.read_access && this.internet_access)) {
                this.requestPermissions(permissionList.toArray(new String[permissionList.size()]), this.BEFORE_M_REQUEST_CODE);
            }
        } else if (Build.VERSION.SDK_INT >= 30) {
            if (Environment.isExternalStorageManager()) {
                this.write_access = true;
                this.read_access = true;
            } else {
                Intent intent = new Intent();
                intent.setAction("android.settings.MANAGE_APP_ALL_FILES_ACCESS_PERMISSION");
                Uri uri = Uri.fromParts((String)"package", (String)this.getPackageName(), null);
                intent.setData(uri);
                this.startActivityForResult(intent, this.AFTER_M_REQUEST_CODE);
            }
            if (this.checkSelfPermission("android.permission.INTERNET") != 0) {
                this.internet_access = false;
                this.requestPermissions(new String[]{"android.permission.INTERNET"}, this.AFTER_M_REQUEST_CODE);
            } else {
                this.internet_access = true;
            }
        }
    }

    protected void uploadCSV(String uid, OssInterface ossInterface) {
        if (this.csvData.size() == 0 || this.countTimer != null) {
            LogUtil.i("TYUsbDeviceActivity", "CSV\u65e0\u6570\u636e\u6216\u6b63\u5728\u6d4b\u8109\u4e2d...");
            return;
        }
        if (ossInterface != null) {
            ossInterface.onStartUpload();
        }
        String timeString = new SimpleDateFormat("yyMMddHHmmss", Locale.US).format(new Date(System.currentTimeMillis()));
        String handString = this.usbConnection.usbBinder.getCurrentHand() == HandType.LEFT_HAND ? "L" : "R";
        String fileName = timeString + "_" + uid + "_" + this.usbConnection.usbBinder.getDeviceName() + "_" + handString + ".csv";
        String csv = Environment.getExternalStorageDirectory().getAbsolutePath() + "/taiyi/" + fileName;
        if (Build.VERSION.SDK_INT >= 23 && Build.VERSION.SDK_INT < 30) {
            ArrayList<String> permissionList = new ArrayList<String>();
            if (this.checkSelfPermission("android.permission.WRITE_EXTERNAL_STORAGE") != 0) {
                this.write_access = false;
                permissionList.add("android.permission.WRITE_EXTERNAL_STORAGE");
            } else {
                this.write_access = true;
            }
            if (this.checkSelfPermission("android.permission.READ_EXTERNAL_STORAGE") != 0) {
                this.read_access = false;
                permissionList.add("android.permission.READ_EXTERNAL_STORAGE");
            } else {
                this.read_access = true;
            }
            if (this.checkSelfPermission("android.permission.INTERNET") != 0) {
                this.internet_access = false;
                permissionList.add("android.permission.INTERNET");
            } else {
                this.internet_access = true;
            }
            if (this.write_access && this.read_access && this.internet_access) {
                this.uploadCSVAction(uid, ossInterface, csv, fileName);
            } else {
                this.tempItem = new CsvUploadItem(uid, ossInterface, csv, fileName);
                this.requestPermissions(permissionList.toArray(new String[permissionList.size()]), this.BEFORE_M_REQUEST_CODE);
            }
        } else if (Build.VERSION.SDK_INT >= 30) {
            if (Environment.isExternalStorageManager()) {
                this.write_access = true;
                this.read_access = true;
            } else {
                Intent intent = new Intent();
                intent.setAction("android.settings.MANAGE_APP_ALL_FILES_ACCESS_PERMISSION");
                Uri uri = Uri.fromParts((String)"package", (String)this.getPackageName(), null);
                intent.setData(uri);
                this.startActivityForResult(intent, this.AFTER_M_REQUEST_CODE);
            }
            if (this.checkSelfPermission("android.permission.INTERNET") != 0) {
                this.internet_access = false;
                this.requestPermissions(new String[]{"android.permission.INTERNET"}, this.AFTER_M_REQUEST_CODE);
            } else {
                this.internet_access = true;
            }
            if (this.write_access && this.read_access && this.internet_access) {
                this.uploadCSVAction(uid, ossInterface, csv, fileName);
            } else {
                this.tempItem = new CsvUploadItem(uid, ossInterface, csv, fileName);
            }
        }
    }

    private void uploadCSVAction(String uid, final OssInterface ossInterface, String csv, String fileName) {
        CSVWriter writer = null;
        try {
            writer = new CSVWriter((Writer)new FileWriter(csv));
            writer.writeAll(this.csvData);
            writer.close();
            this.csvData.clear();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            OssFileUtil.getInstance().upload(this.getApplicationContext(), "mai3/Csv/" + uid + "/" + fileName, csv, null, new OSSCompletedCallback<PutObjectRequest, PutObjectResult>(){

                public void onSuccess(final PutObjectRequest request, PutObjectResult result) {
                    Handler handler = new Handler(Looper.getMainLooper());
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            LogUtil.i("TYUsbDeviceActivity", "OSS\u4e0a\u4f20\u5b8c\u6210");
                            if (ossInterface != null) {
                                ossInterface.onSuccessUpload(OssFileUtil.endPoint + "/" + request.getBucketName() + "/" + request.getObjectKey());
                            }
                        }
                    });
                }

                public void onFailure(PutObjectRequest request, ClientException clientException, ServiceException serviceException) {
                    Handler handler = new Handler(Looper.getMainLooper());
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            if (ossInterface != null) {
                                ossInterface.onFailedUpload();
                            }
                        }
                    });
                }
            });
        }
        catch (ClientException e) {
            e.printStackTrace();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
    }

    private List<UsbDevice> findTYUsbDevices() {
        return this.usbConnection.usbBinder.findTYDevices();
    }

    protected void connectDefaultTYDevice(TYDeviceConnectCallback callback) {
        this.usbConnection.usbBinder.connectDefaultTYDevice(callback);
    }

    protected void disconnectCurrentTYDevice() {
        this.usbConnection.usbBinder.disconnectCurrentTYDevice();
    }

    private class UsbConnection
    implements ServiceConnection {
        private TYUsbDeviceService.TYUsbBinder usbBinder;
        private TYUsbDeviceService usbService;
        private MessageHandler handler;

        public UsbConnection(MessageHandler handler) {
            this.handler = handler;
        }

        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            this.usbBinder = (TYUsbDeviceService.TYUsbBinder)iBinder;
            this.usbService = this.usbBinder.getService();
            this.usbService.setHandler(this.handler);
            LogUtil.i("TYUsbDeviceActivity", "------TYUsbActivity Bind------");
        }

        public void onServiceDisconnected(ComponentName componentName) {
            LogUtil.i("TYUsbDeviceActivity", "------TYUsbActivity UnBind------");
        }
    }

    private static class MessageHandler
    extends Handler {
        private final WeakReference<TYUsbDeviceActivity> mActivity;

        private MessageHandler(TYUsbDeviceActivity activity) {
            this.mActivity = new WeakReference<TYUsbDeviceActivity>(activity);
        }

        public void handleMessage(@NonNull Message msg) {
            super.handleMessage(msg);
            switch (msg.what) {
                case 0: {
                    ((TYUsbDeviceActivity)((Object)this.mActivity.get())).onUsbAttached();
                    break;
                }
                case 1: {
                    ((TYUsbDeviceActivity)((Object)this.mActivity.get())).usbDetached();
                    break;
                }
                case 2: {
                    ((TYUsbDeviceActivity)((Object)this.mActivity.get())).onDevicePermissionGranted();
                    break;
                }
                case 3: {
                    ((TYUsbDeviceActivity)((Object)this.mActivity.get())).onDevicePermissionRejected();
                    break;
                }
                case 4: {
                    ((TYUsbDeviceActivity)((Object)this.mActivity.get())).onDeviceConnectedSuccessfully();
                    break;
                }
                case 5: {
                    ((TYUsbDeviceActivity)((Object)this.mActivity.get())).onDeviceConnectFailed();
                    break;
                }
                case 6: {
                    ((TYUsbDeviceActivity)((Object)this.mActivity.get())).onReceiveMaiData((List)msg.obj);
                    break;
                }
                case 7: {
                    ((TYUsbDeviceActivity)((Object)this.mActivity.get())).onReceiveRealTimeData((RealTimeDataItem)msg.obj);
                    break;
                }
                case 8: {
                    ((TYUsbDeviceActivity)((Object)this.mActivity.get())).onDeviceReceiveStatus((Integer)msg.obj);
                    break;
                }
                case 9: {
                    ((TYUsbDeviceActivity)((Object)this.mActivity.get())).onDeviceReceiveVersion((TYDeviceSoftware)msg.obj);
                    break;
                }
                case 10: {
                    if (((TYUsbDeviceActivity)((Object)this.mActivity.get())).usbConnection.usbBinder.getDeviceConnectCallback() == null) break;
                    ((TYUsbDeviceActivity)((Object)this.mActivity.get())).usbConnection.usbBinder.getDeviceConnectCallback().deviceConnectedSuccessCallback((String)msg.obj);
                    break;
                }
                case 11: {
                    ((TYUsbDeviceActivity)((Object)this.mActivity.get())).onReceivePeriodicFeatureData((List)msg.obj);
                    break;
                }
                case 12: {
                    ((TYUsbDeviceActivity)((Object)this.mActivity.get())).onReceiveAmplitudeData((List)msg.obj);
                    break;
                }
                case 13: {
                    ((TYUsbDeviceActivity)((Object)this.mActivity.get())).onRealTimeWaveGet((RealtimeWaveItem)msg.obj);
                }
            }
        }
    }

    public static interface OssInterface {
        public void onStartUpload();

        public void onSuccessUpload(String var1);

        public void onFailedUpload();
    }
}

