/*
 * Decompiled with CFR 0.152.
 */
package com.taiyi.typulse.tyusbsdk;

import android.annotation.SuppressLint;
import android.app.PendingIntent;
import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbManager;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import androidx.annotation.NonNull;
import com.felhr.usbserial.SerialInputStream;
import com.felhr.usbserial.SerialOutputStream;
import com.felhr.usbserial.UsbSerialDevice;
import com.taiyi.typulse.alg.RealTimeAlg;
import com.taiyi.typulse.pulse.fastble.utils.HexUtil;
import com.taiyi.typulse.tyusbsdk.ByteDataUtil;
import com.taiyi.typulse.tyusbsdk.CallbackInterface;
import com.taiyi.typulse.tyusbsdk.CountTimer;
import com.taiyi.typulse.tyusbsdk.HandType;
import com.taiyi.typulse.tyusbsdk.RealTimeDataItem;
import com.taiyi.typulse.tyusbsdk.TYDeviceConnectCallback;
import com.taiyi.typulse.tyusbsdk.TYDeviceSoftware;
import com.taiyi.typulse.tyusbsdk.TYError;
import com.taiyi.typulse.tyusbsdk.pulse.TaiyiManager;
import com.taiyi.typulse.tyusbsdk.pulse.bean.RealtimeWaveItem;
import com.taiyi.typulse.tyusbsdk.pulse.util.LogUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class TYUsbDeviceService
extends Service {
    private String TAG = "TY-USB-SERVICE";
    private int mProductId = 22336;
    private int mVendorId = 1155;
    public static final String ACTION_USB_ATTACHED = "android.hardware.usb.action.USB_DEVICE_ATTACHED";
    public static final String ACTION_USB_DETACHED = "android.hardware.usb.action.USB_DEVICE_DETACHED";
    private static final String ACTION_USB_PERMISSION = "com.android.example.USB_PERMISSION";
    public static final int MESSAGE_USB_ATTACHED = 0;
    public static final int MESSAGE_USB_DETACHED = 1;
    public static final int MESSAGE_USB_PERMISSION_GRANTED = 2;
    public static final int MESSAGE_USB_PERMISSION_REJECTED = 3;
    public static final int MESSAGE_DEVICE_CONNECT_SUCCESSFULLY = 4;
    public static final int MESSAGE_DEVICE_CONNECT_FAILED = 5;
    public static final int MESSAGE_READ_MAI_DATA = 6;
    public static final int MESSAGE_READ_REALTIME_DATA = 7;
    public static final int MESSAGE_READ_DEVICE_STATUS = 8;
    public static final int MESSAGE_READ_DEVICE_VERSION = 9;
    public static final int MESSAGE_READ_DEVICE_NAME = 10;
    public static final int MESSAGE_READ_PERIODIC_FEATURE = 11;
    public static final int MESSAGE_READ_AMPLITUDE_DATA = 12;
    public static final int MESSAGE_READ_REALTIMEWAVE_DATA = 13;
    private static final int BAUD_RATE = 9600;
    private IBinder usbBinder = new TYUsbBinder();
    private Handler mHandler;
    private UsbManager usbManager;
    private UsbDevice device;
    private UsbDeviceConnection deviceConnection;
    private UsbSerialDevice serialDevice;
    private boolean serialDeviceConnected;
    private TYDeviceConnectCallback deviceConnectCallback;
    private SerialInputStream serialInputStream;
    private SerialOutputStream serialOutputStream;
    private ReadThread readThread;
    private Handler writeHandler;
    private WriteThread writeThread;
    private HandType currentHand;
    private String deviceName = "";
    private CountTimer countTimer;
    private int lastCunEndTime = 0;
    private int lastGuanEndTime = 0;
    private int lastChiEndTime = 0;
    private final BroadcastReceiver usbReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals(TYUsbDeviceService.ACTION_USB_PERMISSION)) {
                LogUtil.d(TYUsbDeviceService.this.TAG, "ACTION_USB_PERMISSION");
                boolean granted = intent.getExtras().getBoolean("permission");
                if (granted) {
                    if (!TYUsbDeviceService.this.serialDeviceConnected) {
                        TYUsbDeviceService.this.deviceConnection = TYUsbDeviceService.this.usbManager.openDevice(TYUsbDeviceService.this.device);
                        new ConnectionThread().start();
                        new Handler().postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                TYUsbDeviceService.this.sendDeviceNameCommand();
                            }
                        }, 200L);
                        if (TYUsbDeviceService.this.countTimer == null) {
                            new Handler().postDelayed(new Runnable(){

                                @Override
                                public void run() {
                                    TYUsbDeviceService.this.countTimer = new CountTimer(36000000L, 500L, new CallbackInterface(){

                                        @Override
                                        public void onTick(long millisUntilFinished) {
                                            LogUtil.d(TYUsbDeviceService.this.TAG, "Send Heart Rate");
                                            TYUsbDeviceService.this.sendHeartRateCommand();
                                        }

                                        @Override
                                        public void onFinish() {
                                            LogUtil.d(TYUsbDeviceService.this.TAG, "onFinish");
                                            TYUsbDeviceService.this.countTimer = null;
                                        }
                                    });
                                    TYUsbDeviceService.this.countTimer.start();
                                }
                            }, 500L);
                        }
                    } else {
                        TYUsbDeviceService.this.deviceConnectCallback.deviceConnectedFailureCallback(TYError.DEVICE_ALREADY_CONNECTED);
                    }
                    TYUsbDeviceService.this.mHandler.obtainMessage(2).sendToTarget();
                } else {
                    TYUsbDeviceService.this.deviceConnectCallback.deviceConnectedFailureCallback(TYError.USB_AUTH_REJECTED);
                    TYUsbDeviceService.this.mHandler.obtainMessage(3).sendToTarget();
                }
            } else if (intent.getAction().equals(TYUsbDeviceService.ACTION_USB_ATTACHED)) {
                LogUtil.d(TYUsbDeviceService.this.TAG, "ACTION_USB_ATTACHED");
                TYUsbDeviceService.this.findTYDevices();
                if (TYUsbDeviceService.this.device != null && TYUsbDeviceService.this.device.getProductId() == TYUsbDeviceService.this.mProductId && TYUsbDeviceService.this.device.getVendorId() == TYUsbDeviceService.this.mVendorId) {
                    TYUsbDeviceService.this.mHandler.obtainMessage(0).sendToTarget();
                }
            } else if (intent.getAction().equals(TYUsbDeviceService.ACTION_USB_DETACHED)) {
                LogUtil.d(TYUsbDeviceService.this.TAG, "ACTION_USB_DETACHED");
                if (TYUsbDeviceService.this.device != null && TYUsbDeviceService.this.device.getProductId() == TYUsbDeviceService.this.mProductId && TYUsbDeviceService.this.device.getVendorId() == TYUsbDeviceService.this.mVendorId) {
                    TYUsbDeviceService.this.mHandler.obtainMessage(1).sendToTarget();
                }
                if (TYUsbDeviceService.this.serialDeviceConnected) {
                    TYUsbDeviceService.this.serialDevice.syncClose();
                    try {
                        TYUsbDeviceService.this.serialInputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    TYUsbDeviceService.this.serialInputStream = null;
                    TYUsbDeviceService.this.readThread.setKeep(false);
                    try {
                        TYUsbDeviceService.this.serialOutputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    TYUsbDeviceService.this.serialOutputStream = null;
                    TYUsbDeviceService.this.writeHandler.getLooper().quit();
                }
                TYUsbDeviceService.this.serialDeviceConnected = false;
                TYUsbDeviceService.this.deviceConnection = null;
                TYUsbDeviceService.this.device = null;
                if (TYUsbDeviceService.this.countTimer != null) {
                    TYUsbDeviceService.this.countTimer.cancel();
                    TYUsbDeviceService.this.countTimer = null;
                }
            }
        }
    };

    public IBinder onBind(Intent intent) {
        Log.i((String)this.TAG, (String)"-------onBind-------");
        return this.usbBinder;
    }

    public void onCreate() {
        super.onCreate();
        Log.i((String)this.TAG, (String)"-------onCreate-------");
        this.serialDeviceConnected = false;
        this.currentHand = HandType.LEFT_HAND;
        this.setBroadcastReceiver();
        this.usbManager = (UsbManager)this.getSystemService("usb");
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        Log.i((String)this.TAG, (String)"-------onStartCommand-------");
        return 2;
    }

    public boolean onUnbind(Intent intent) {
        Log.i((String)this.TAG, (String)"-------onUnbind-------");
        return super.onUnbind(intent);
    }

    public void onDestroy() {
        super.onDestroy();
        Log.i((String)this.TAG, (String)"-------onDestroy-------");
        this.unregisterReceiver(this.usbReceiver);
    }

    public void setHandler(Handler mHandler) {
        this.mHandler = mHandler;
    }

    private void setBroadcastReceiver() {
        IntentFilter filter = new IntentFilter();
        filter.addAction(ACTION_USB_PERMISSION);
        filter.addAction(ACTION_USB_DETACHED);
        filter.addAction(ACTION_USB_ATTACHED);
        this.registerReceiver(this.usbReceiver, filter);
    }

    private List<UsbDevice> findTYDevices() {
        if (this.usbManager == null) {
            return new ArrayList<UsbDevice>();
        }
        HashMap usbDevices = this.usbManager.getDeviceList();
        ArrayList<UsbDevice> tyDevices = new ArrayList<UsbDevice>();
        if (!usbDevices.isEmpty()) {
            for (Map.Entry entry : usbDevices.entrySet()) {
                UsbDevice device = (UsbDevice)entry.getValue();
                if (!UsbSerialDevice.isSupported((UsbDevice)device)) continue;
                tyDevices.add(device);
            }
        }
        if (tyDevices.size() > 0) {
            this.device = (UsbDevice)tyDevices.get(0);
        }
        return tyDevices;
    }

    private void connectDefaultTYDevice(TYDeviceConnectCallback callback) {
        this.deviceConnectCallback = callback;
        List<UsbDevice> devices = this.findTYDevices();
        if (this.device != null) {
            PendingIntent mPendingIntent = PendingIntent.getBroadcast((Context)this, (int)0, (Intent)new Intent(ACTION_USB_PERMISSION), (int)0x4000000);
            this.usbManager.requestPermission(this.device, mPendingIntent);
        } else {
            this.deviceConnectCallback.deviceConnectedFailureCallback(TYError.NONE_USB_DEVICES);
            this.deviceConnectCallback = null;
        }
    }

    private void write(byte[] data) {
        if (this.writeThread != null) {
            this.writeHandler.obtainMessage(0, (Object)data).sendToTarget();
        }
    }

    public void disconnectCurrentTYDevice() {
        if (this.serialDeviceConnected) {
            this.serialDevice.syncClose();
            try {
                this.serialInputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.serialInputStream = null;
            this.readThread.setKeep(false);
            try {
                this.serialOutputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.serialOutputStream = null;
            this.writeHandler.getLooper().quit();
        }
        if (this.countTimer != null) {
            this.countTimer.cancel();
            this.countTimer = null;
        }
        this.serialDeviceConnected = false;
        this.deviceConnection = null;
    }

    private void sendDeviceStatusCommad() {
        this.write(ByteDataUtil.hexToByteArray("AA55AA55060000010502"));
    }

    private void sendMeasureWaitCommand(HandType handType) {
        this.currentHand = handType;
        this.lastCunEndTime = 0;
        this.lastGuanEndTime = 0;
        this.lastChiEndTime = 0;
        if (handType == HandType.LEFT_HAND) {
            this.write(ByteDataUtil.hexToByteArray("AA55AA550b00000300000000000c02"));
        } else {
            this.write(ByteDataUtil.hexToByteArray("AA55AA550b00000300000000010d02"));
        }
    }

    private void sendMeasureStartCommand() {
        this.write(ByteDataUtil.hexToByteArray("AA55AA55060000111502"));
    }

    private void sendCancelMeasureCommand() {
        this.write(ByteDataUtil.hexToByteArray("AA55AA55060000020602"));
    }

    private void sendDeviceVersionCommand() {
        this.write(ByteDataUtil.hexToByteArray("AA55AA55060000040802"));
    }

    private void sendDeviceUpdateCommand() {
        this.write(ByteDataUtil.hexToByteArray("AA55AA55060000050902"));
    }

    private void sendDeviceNameCommand() {
        this.write(ByteDataUtil.hexToByteArray("AA55AA55060000060A02"));
    }

    private void sendHeartRateCommand() {
        this.write(ByteDataUtil.hexToByteArray("AA55AA55060000070B02"));
    }

    private class WriteThread
    extends Thread {
        private WriteThread() {
        }

        @Override
        @SuppressLint(value={"HandlerLeak"})
        public void run() {
            Looper.prepare();
            TYUsbDeviceService.this.writeHandler = new Handler(){

                public void handleMessage(@NonNull Message msg) {
                    byte[] data = (byte[])msg.obj;
                    LogUtil.i("TYUsbDeviceService", "\u53d1\u9001\u6307\u4ee4\u6570\u636e:" + ByteDataUtil.bytesToHex(data));
                    TYUsbDeviceService.this.serialOutputStream.write(data);
                }
            };
            Looper.loop();
            LogUtil.i("TYUsbDeviceService", "Write\u7ebf\u7a0b\u9000\u51fa");
        }
    }

    private class ReadThread
    extends Thread {
        private AtomicBoolean keep = new AtomicBoolean(true);
        public byte[] payload;
        private TransType mTransType = TransType.NORMAL;
        private byte[] byteHeader = new byte[]{-86, 85, -86, 85};
        private List<List<Short>> realTimeSourceData = new ArrayList<List<Short>>();

        private ReadThread() {
        }

        @Override
        public void run() {
            while (this.keep.get()) {
                if (TYUsbDeviceService.this.serialInputStream == null) {
                    return;
                }
                int value = TYUsbDeviceService.this.serialInputStream.read();
                if (value == -1) continue;
                byte[] data = ByteDataUtil.hexToByteArray(Integer.toHexString(value));
                if (this.mTransType == TransType.UPDATE) continue;
                if (this.payload == null) {
                    this.payload = data;
                    if (ByteDataUtil.checkValue(this.payload)) {
                        this.onDataReceived(this.payload);
                        this.payload = null;
                        continue;
                    }
                    if (!HexUtil.formatHexString(data).equals("43")) continue;
                    Log.w((String)TYUsbDeviceService.this.TAG, (String)"\u53ef\u4ee5\u5f00\u59cb\u56fa\u4ef6\u5347\u7ea7\u4e86");
                    continue;
                }
                this.payload = ByteDataUtil.MergerArray(this.payload, data);
                this.parseData(this.payload);
            }
            LogUtil.d(TYUsbDeviceService.this.TAG, "Read\u7ebf\u7a0b\u9000\u51fa");
        }

        private void onDataReceived(byte[] data) {
            LogUtil.d(TYUsbDeviceService.this.TAG, "onDataReceived currentPayload.length:" + data.length);
            byte byteType = ByteDataUtil.SubArray(data, 7, 1)[0];
            int type = ByteDataUtil.byteToInt(byteType);
            switch (type) {
                case 1: {
                    this.parseDeviceStatus(data);
                    break;
                }
                case 2: {
                    LogUtil.d(TYUsbDeviceService.this.TAG, HexUtil.formatHexString(data));
                    if (data.length < 215) {
                        return;
                    }
                    this.parseOriginalData(data);
                    break;
                }
                case 17: {
                    if (data.length < 215) {
                        return;
                    }
                    LogUtil.d(TYUsbDeviceService.this.TAG, HexUtil.formatHexString(data));
                    this.parseOriginalData(data);
                    break;
                }
                case 4: {
                    this.parseDeviceVersion(data);
                    break;
                }
                case 240: {
                    this.parseDeviceVersion(data);
                    break;
                }
                case 6: {
                    this.parseDeviceName(data);
                    break;
                }
                case 53: {
                    LogUtil.d(TYUsbDeviceService.this.TAG, HexUtil.formatHexString(data));
                    this.parseAmplitudeData(data);
                    break;
                }
                case 57: {
                    if (data.length < 34) {
                        return;
                    }
                    this.parsePeriodicFeatures(data);
                    break;
                }
                case 18: {
                    if (data.length < 13) {
                        return;
                    }
                    Log.d((String)"Realtime Wave", (String)HexUtil.formatHexString(data));
                    this.parseRealtimeWaveData(data);
                }
            }
        }

        private void parseData(byte[] data) {
            List<Integer> headerCount = ByteDataUtil.getIndexListOf(data, this.byteHeader);
            if (headerCount.size() > 0) {
                int tempPosition = 0;
                for (int i = 0; i < headerCount.size(); ++i) {
                    byte[] bytes = i != headerCount.size() - 1 ? ByteDataUtil.SubArray(data, headerCount.get(i), headerCount.get(i + 1) - headerCount.get(i)) : ByteDataUtil.SubArray(data, headerCount.get(i), data.length - headerCount.get(i));
                    boolean b = ByteDataUtil.checkValue(bytes);
                    if (!b) continue;
                    this.onDataReceived(bytes);
                    tempPosition = i == headerCount.size() - 1 ? -1 : headerCount.get(i + 1);
                }
                this.payload = (byte[])(tempPosition != -1 ? ByteDataUtil.SubArray(data, tempPosition, data.length - tempPosition) : null);
            }
        }

        private void parseDeviceStatus(byte[] bytes) {
            byte[] statusPayload = ByteDataUtil.SubArray(bytes, 8, 1);
            int status = ByteDataUtil.byteToInt(statusPayload[0]);
            TYUsbDeviceService.this.mHandler.obtainMessage(8, (Object)status).sendToTarget();
            switch (status) {
                case 0: {
                    LogUtil.d(TYUsbDeviceService.this.TAG, "idle");
                    break;
                }
                case 1: {
                    LogUtil.d(TYUsbDeviceService.this.TAG, "\u5df2\u8fde\u63a5");
                    break;
                }
                case 2: {
                    LogUtil.d(TYUsbDeviceService.this.TAG, "\u5f00\u59cb\u6d4b\u91cf");
                    break;
                }
                case 4: {
                    LogUtil.d(TYUsbDeviceService.this.TAG, "\u6570\u636e\u91c7\u96c6\u5b8c\u6210\uff0890 s\uff09");
                }
            }
        }

        private void parseOriginalData(byte[] data) {
            ArrayList<String> originalData = new ArrayList<String>();
            byte[] time = new byte[]{data[11], data[10], data[9], data[8]};
            String timeValue = Integer.toString(ByteDataUtil.byte2Int(time));
            originalData.add(timeValue);
            ArrayList<Short> rowData = new ArrayList<Short>();
            for (int i = 0; i < 99; ++i) {
                String pointValue;
                byte[] point = ByteDataUtil.SubArray(data, 12 + i * 2, 2);
                if (i < 96) {
                    pointValue = Integer.toString(ByteDataUtil.byteToInt2(point));
                    originalData.add(pointValue);
                    Short tempValue = 0;
                    try {
                        tempValue = Short.parseShort(pointValue);
                    }
                    catch (NumberFormatException nfe) {
                        tempValue = 0;
                    }
                    rowData.add(tempValue);
                    continue;
                }
                pointValue = Integer.toString(ByteDataUtil.byteToInt2(new byte[]{point[1], point[0]}));
                originalData.add(pointValue);
            }
            byte[] check = new byte[]{data[data.length - 1], data[data.length - 2]};
            String checkValue = Integer.toString(ByteDataUtil.byteToInt2(check));
            originalData.add(checkValue);
            TYUsbDeviceService.this.mHandler.obtainMessage(6, originalData).sendToTarget();
            if (this.realTimeSourceData.size() < 41) {
                this.realTimeSourceData.add(0, rowData);
            } else {
                this.realTimeSourceData.remove(this.realTimeSourceData.size() - 1);
                this.realTimeSourceData.add(0, rowData);
                short[] frameData = new short[96 * this.realTimeSourceData.size()];
                int frameDataIndex = 0;
                for (int j = 0; j < 96; ++j) {
                    for (int i = 0; i < this.realTimeSourceData.size(); ++i) {
                        List<Short> curData = this.realTimeSourceData.get(i);
                        Short f = curData.get(j);
                        frameData[frameDataIndex++] = f != null ? f : (short)0;
                    }
                }
                float[] realtimeData = RealTimeAlg.realTime50HzSoApi(frameData, 96, 41);
                ArrayList<Float> realtimeArray = new ArrayList<Float>(realtimeData.length);
                for (int i = 0; i < realtimeData.length; ++i) {
                    realtimeArray.add(new Float(realtimeData[i]));
                }
                TYUsbDeviceService.this.mHandler.obtainMessage(7, (Object)new RealTimeDataItem(timeValue, realtimeArray)).sendToTarget();
            }
        }

        private void parseDeviceVersion(byte[] bytes) {
            byte[] hardware = ByteDataUtil.reverse(ByteDataUtil.SubArray(bytes, 8, 4));
            byte[] firmware = ByteDataUtil.reverse(ByteDataUtil.SubArray(bytes, 12, 4));
            byte[] date = ByteDataUtil.reverse(ByteDataUtil.SubArray(bytes, 16, 2));
            int yjversion = ByteDataUtil.byte2Int(hardware);
            int gjversion = ByteDataUtil.byte2Int(firmware);
            short sjversion = ByteDataUtil.byteToShort(date);
            short channel = 0;
            if (bytes.length == 22) {
                byte[] channelBytes = ByteDataUtil.reverse(ByteDataUtil.SubArray(bytes, 18, 2));
                channel = ByteDataUtil.byteToShort(channelBytes);
            }
            TYDeviceSoftware software = new TYDeviceSoftware(yjversion, gjversion, sjversion, channel);
            TaiyiManager.getInstance().setHardware_version(String.valueOf(yjversion));
            TaiyiManager.getInstance().setFirmware_version(String.valueOf(gjversion));
            TaiyiManager.getInstance().setAlg_version(String.valueOf(sjversion));
            TYUsbDeviceService.this.mHandler.obtainMessage(9, (Object)software).sendToTarget();
            LogUtil.d(TYUsbDeviceService.this.TAG, "\u786c\u4ef6\u7248\u672c:" + yjversion);
            LogUtil.d(TYUsbDeviceService.this.TAG, "\u56fa\u4ef6\u7248\u672c:" + gjversion);
            LogUtil.d(TYUsbDeviceService.this.TAG, "\u6570\u636e\u7248\u672c:" + sjversion);
            LogUtil.d(TYUsbDeviceService.this.TAG, "\u6e20\u9053\u53f7:" + channel);
        }

        private void parseDeviceName(byte[] bytes) {
            byte[] nameBytes = ByteDataUtil.SubArray(bytes, 8, bytes.length - 10);
            LogUtil.d(TYUsbDeviceService.this.TAG, "\u8bbe\u5907\u540d\u79f0:" + HexUtil.formatHexString(bytes));
            TYUsbDeviceService.this.deviceName = ByteDataUtil.bytesToHex(nameBytes).toUpperCase(Locale.ROOT);
            TYUsbDeviceService.this.mHandler.obtainMessage(10, (Object)TYUsbDeviceService.this.deviceName).sendToTarget();
        }

        private void parseAmplitudeData(byte[] data) {
            if (data.length <= 27) {
                return;
            }
            ArrayList<Integer> indexArray = new ArrayList<Integer>();
            byte[] tStart = new byte[]{data[11], data[10], data[9], data[8]};
            byte[] periodMs = new byte[]{data[15], data[14], data[13], data[12]};
            byte[] cunAmp = new byte[]{data[17], data[16]};
            byte[] guanAmp = new byte[]{data[19], data[18]};
            byte[] chiAmp = new byte[]{data[21], data[20]};
            byte[] cunWidth = new byte[]{data[23], data[22]};
            byte[] guanWidth = new byte[]{data[25], data[24]};
            byte[] chiWidth = new byte[]{data[27], data[26]};
            int tStartValue = ByteDataUtil.byte2Int(tStart);
            int periodMsValue = ByteDataUtil.byte2Int(periodMs);
            int cunAmpValue = ByteDataUtil.byteToInt2(cunAmp);
            int guanAmpValue = ByteDataUtil.byteToInt2(guanAmp);
            int chiAmpValue = ByteDataUtil.byteToInt2(chiAmp);
            int cunWidthValue = ByteDataUtil.byteToInt2(cunWidth);
            int guanWidthValue = ByteDataUtil.byteToInt2(guanWidth);
            int chiWidthValue = ByteDataUtil.byteToInt2(chiWidth);
            indexArray.add(new Integer(tStartValue));
            indexArray.add(new Integer(cunAmpValue));
            indexArray.add(new Integer(guanAmpValue));
            indexArray.add(new Integer(chiAmpValue));
            LogUtil.i("TYUsbDeviceService", String.format(Locale.ROOT, "\u65f6\u95f4:%d; \u5468\u671f:%d; \u5bf8:%d,%d; \u5173:%d,%d; \u5c3a:%d,%d;", tStartValue, periodMsValue, cunAmpValue, cunWidthValue, guanAmpValue, guanWidthValue, chiAmpValue, chiWidthValue));
            TYUsbDeviceService.this.mHandler.obtainMessage(12, indexArray).sendToTarget();
        }

        private void parsePeriodicFeatures(byte[] data) {
            int chiEndTime;
            int chiStartTime;
            int guanEndTime;
            int guanStartTime;
            int cunEndTime;
            int cunStartTime;
            byte cunSN = data[8];
            byte guanSN = data[16];
            byte chiSN = data[24];
            byte[] cunTime = new byte[]{data[12], data[11], data[10], data[9]};
            byte[] guanTime = new byte[]{data[20], data[19], data[18], data[17]};
            byte[] chiTime = new byte[]{data[28], data[27], data[26], data[25]};
            byte[] cunPeriod = new byte[]{data[14], data[13]};
            byte[] guanPeriod = new byte[]{data[22], data[21]};
            byte[] chiPeriod = new byte[]{data[30], data[29]};
            byte cunWidth = data[15];
            byte guanWidth = data[23];
            byte chiWidth = data[31];
            int cunSNValue = ByteDataUtil.byteToInt(cunSN);
            int guanSNValue = ByteDataUtil.byteToInt(guanSN);
            int chiSNValue = ByteDataUtil.byteToInt(chiSN);
            int cunTimeValue = ByteDataUtil.byte2Int(cunTime);
            int guanTimeValue = ByteDataUtil.byte2Int(guanTime);
            int chiTimeValue = ByteDataUtil.byte2Int(chiTime);
            int cunPeriodValue = ByteDataUtil.byteToInt2(cunPeriod);
            int guanPeriodValue = ByteDataUtil.byteToInt2(guanPeriod);
            int chiPeriodValue = ByteDataUtil.byteToInt2(chiPeriod);
            int cunWidthValue = ByteDataUtil.byteToInt(cunWidth);
            int guanWidthValue = ByteDataUtil.byteToInt(guanWidth);
            int chiWidthValue = ByteDataUtil.byteToInt(chiWidth);
            ArrayList<Integer> indexArray = new ArrayList<Integer>();
            if (cunWidthValue > 0 && cunPeriodValue > 0) {
                cunStartTime = cunTimeValue + 400;
                cunEndTime = cunTimeValue + cunPeriodValue + 400;
                if (TYUsbDeviceService.this.lastCunEndTime > 0 && cunStartTime - TYUsbDeviceService.this.lastCunEndTime < 450) {
                    cunStartTime = TYUsbDeviceService.this.lastCunEndTime;
                }
            } else {
                cunStartTime = -1;
                cunEndTime = -1;
            }
            if (guanWidthValue > 0 && guanPeriodValue > 0) {
                guanStartTime = guanTimeValue + 400;
                guanEndTime = guanTimeValue + guanPeriodValue + 400;
                if (TYUsbDeviceService.this.lastGuanEndTime > 0 && guanStartTime - TYUsbDeviceService.this.lastGuanEndTime < 450) {
                    guanStartTime = TYUsbDeviceService.this.lastGuanEndTime;
                }
            } else {
                guanStartTime = -1;
                guanEndTime = -1;
            }
            if (chiWidthValue > 0 && chiPeriodValue > 0) {
                chiStartTime = chiTimeValue + 400;
                chiEndTime = chiTimeValue + chiPeriodValue + 400;
                if (TYUsbDeviceService.this.lastChiEndTime > 0 && chiStartTime - TYUsbDeviceService.this.lastChiEndTime < 450) {
                    chiStartTime = TYUsbDeviceService.this.lastChiEndTime;
                }
            } else {
                chiStartTime = -1;
                chiEndTime = -1;
            }
            TYUsbDeviceService.this.lastCunEndTime = cunEndTime;
            TYUsbDeviceService.this.lastGuanEndTime = guanEndTime;
            TYUsbDeviceService.this.lastChiEndTime = chiEndTime;
            indexArray.add(new Integer(cunStartTime));
            indexArray.add(new Integer(cunEndTime));
            indexArray.add(new Integer(guanStartTime));
            indexArray.add(new Integer(guanEndTime));
            indexArray.add(new Integer(chiStartTime));
            indexArray.add(new Integer(chiEndTime));
            LogUtil.i("TYUsbDeviceService", String.format(Locale.ROOT, "\u5bf8\u5468\u671f:%d,%d,%d,%d;\u5173\u5468\u671f:%d,%d,%d,%d;\u5c3a\u5468\u671f:%d,%d,%d,%d;", cunSNValue, cunTimeValue, cunTimeValue + cunPeriodValue, cunWidthValue, guanSNValue, guanTimeValue, guanTimeValue + guanPeriodValue, guanWidthValue, chiSNValue, chiTimeValue, chiTimeValue + chiPeriodValue, chiWidthValue));
            TYUsbDeviceService.this.mHandler.obtainMessage(11, indexArray).sendToTarget();
        }

        private void parseRealtimeWaveData(byte[] data) {
            int heart = ByteDataUtil.byteToInt(data[8]);
            int ampLevelCun = ByteDataUtil.byteToInt(data[9]);
            int widthLevelCun = ByteDataUtil.byteToInt(data[10]);
            LogUtil.d(TYUsbDeviceService.this.TAG, "ampLevelCun:" + ampLevelCun + " widthLevelCun:" + widthLevelCun);
            int[] waveCun = new int[]{ampLevelCun, widthLevelCun};
            int ampLevelGuan = ByteDataUtil.byteToInt(data[11]);
            int widthLevelGuan = ByteDataUtil.byteToInt(data[12]);
            LogUtil.d(TYUsbDeviceService.this.TAG, "ampLevelGuan:" + ampLevelGuan + " widthLevelGuan:" + widthLevelGuan);
            int[] waveGuan = new int[]{ampLevelGuan, widthLevelGuan};
            int ampLevelChi = ByteDataUtil.byteToInt(data[13]);
            int widthLevelChi = ByteDataUtil.byteToInt(data[14]);
            LogUtil.d(TYUsbDeviceService.this.TAG, "ampLevelChi:" + ampLevelChi + " widthLevelChi:" + widthLevelChi);
            int[] waveChi = new int[]{ampLevelChi, widthLevelChi};
            TYUsbDeviceService.this.mHandler.obtainMessage(13, (Object)new RealtimeWaveItem(heart, waveCun, waveGuan, waveChi)).sendToTarget();
        }

        public void setKeep(boolean keep) {
            this.keep.set(keep);
        }
    }

    public class TYUsbBinder
    extends Binder {
        public TYUsbDeviceService getService() {
            return TYUsbDeviceService.this;
        }

        public List<UsbDevice> findTYDevices() {
            return TYUsbDeviceService.this.findTYDevices();
        }

        public void connectDefaultTYDevice(TYDeviceConnectCallback callback) {
            TYUsbDeviceService.this.connectDefaultTYDevice(callback);
        }

        public void disconnectCurrentTYDevice() {
            TYUsbDeviceService.this.disconnectCurrentTYDevice();
        }

        public void writeData(byte[] data) {
            TYUsbDeviceService.this.write(data);
        }

        public String getDeviceName() {
            return TYUsbDeviceService.this.deviceName;
        }

        public boolean getSerialDeviceConnected() {
            return TYUsbDeviceService.this.serialDeviceConnected;
        }

        public TYDeviceConnectCallback getDeviceConnectCallback() {
            return TYUsbDeviceService.this.deviceConnectCallback;
        }

        public HandType getCurrentHand() {
            return TYUsbDeviceService.this.currentHand;
        }

        public void sendDeviceStatusCommad() {
            TYUsbDeviceService.this.sendDeviceStatusCommad();
        }

        public void sendMeasureWaitCommand(HandType handType) {
            TYUsbDeviceService.this.sendMeasureWaitCommand(handType);
        }

        public void sendMeasureStartCommand() {
            TYUsbDeviceService.this.sendMeasureStartCommand();
        }

        public void sendCancelMeasureCommand() {
            TYUsbDeviceService.this.sendCancelMeasureCommand();
        }

        public void sendDeviceVersionCommand() {
            TYUsbDeviceService.this.sendDeviceVersionCommand();
        }

        public void sendDeviceUpdateCommand() {
            TYUsbDeviceService.this.sendDeviceUpdateCommand();
        }

        public void sendDeviceNameCommand() {
            TYUsbDeviceService.this.sendDeviceNameCommand();
        }

        public void sendHeartRateCommand() {
            TYUsbDeviceService.this.sendHeartRateCommand();
        }
    }

    private class ConnectionThread
    extends Thread {
        private ConnectionThread() {
        }

        @Override
        public void run() {
            TYUsbDeviceService.this.serialDevice = UsbSerialDevice.createUsbSerialDevice((UsbDevice)TYUsbDeviceService.this.device, (UsbDeviceConnection)TYUsbDeviceService.this.deviceConnection);
            if (TYUsbDeviceService.this.serialDevice != null) {
                if (TYUsbDeviceService.this.serialDevice.syncOpen()) {
                    TYUsbDeviceService.this.serialDeviceConnected = true;
                    TYUsbDeviceService.this.serialDevice.setBaudRate(9600);
                    TYUsbDeviceService.this.serialDevice.setDataBits(8);
                    TYUsbDeviceService.this.serialDevice.setStopBits(1);
                    TYUsbDeviceService.this.serialDevice.setParity(0);
                    TYUsbDeviceService.this.serialDevice.setFlowControl(0);
                    TYUsbDeviceService.this.serialInputStream = TYUsbDeviceService.this.serialDevice.getInputStream();
                    TYUsbDeviceService.this.serialOutputStream = TYUsbDeviceService.this.serialDevice.getOutputStream();
                    TYUsbDeviceService.this.readThread = new ReadThread();
                    TYUsbDeviceService.this.readThread.start();
                    TYUsbDeviceService.this.writeThread = new WriteThread();
                    TYUsbDeviceService.this.writeThread.start();
                    TYUsbDeviceService.this.mHandler.obtainMessage(4).sendToTarget();
                } else {
                    TYUsbDeviceService.this.mHandler.obtainMessage(5).sendToTarget();
                }
            } else {
                TYUsbDeviceService.this.mHandler.obtainMessage(5).sendToTarget();
            }
            LogUtil.d(TYUsbDeviceService.this.TAG, "Connection\u7ebf\u7a0b\u9000\u51fa");
        }
    }

    public static enum TransType {
        NORMAL,
        UPDATE;

    }
}

