/*
 * Decompiled with CFR 0.152.
 */
package com.taiyi.typulse.tyusbsdk.pulse;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.util.Log;
import com.taiyi.typulse.tyusbsdk.ResultListener;
import com.taiyi.typulse.tyusbsdk.pulse.EventTestMaiMessage;
import com.taiyi.typulse.tyusbsdk.pulse.ui.HelpActivity;
import com.taiyi.typulse.tyusbsdk.pulse.ui.MeasureFlowActivity;
import com.taiyi.typulse.tyusbsdk.pulse.ui.MeasureHandsActivity;
import com.taiyi.typulse.tyusbsdk.pulse.ui.SuccessActivity;
import com.taiyi.typulse.tyusbsdk.pulse.util.AppManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.greenrobot.eventbus.EventBus;

public class TaiyiManager {
    private String appId;
    private String appSecret;
    private String uid;
    private String patientName;
    private int patientAge;
    private String patientGender;
    private String deviceName;
    private String deviceId;
    private String firmware_version;
    private String hardware_version;
    private String alg_version;
    private static TaiyiManager instance;
    private Context context;
    public static final int CAPTURE_REQUEST = 10101;
    public static final String CAPTURE_IMG_PATH = "img_path";
    private String pulseResult;
    private ResultListener mResultListener;
    private SkipInterface mSkipInterface;

    public void setResultListener(ResultListener listener) {
        Log.d((String)"TaiyiManager", (String)("setResultListener: \u8bbe\u7f6eResultListener - " + (listener != null ? listener.getClass().getSimpleName() : "null")));
        this.mResultListener = listener;
    }

    public void setSkipInterface(SkipInterface skipInterface) {
        this.mSkipInterface = skipInterface;
    }

    public void setPatientName(String name) {
        this.patientName = name;
    }

    public void setPatientAge(int age) {
        this.patientAge = age;
    }

    public void setPatientGender(String sex) {
        this.patientGender = sex;
    }

    public String getPatientName() {
        return this.patientName;
    }

    public int getPatientAge() {
        return this.patientAge;
    }

    public String getPatientGender() {
        return this.patientGender;
    }

    public void setPatientInfo(String name, int age, String gender) {
        this.patientName = name;
        this.patientAge = age;
        this.patientGender = gender;
    }

    public String getFirmware_version() {
        return this.firmware_version;
    }

    public String getHardware_version() {
        return this.hardware_version;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public String getDeviceID() {
        return this.deviceId;
    }

    public String getAlg_version() {
        return this.alg_version;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public void setFirmware_version(String firmware_version) {
        this.firmware_version = firmware_version;
    }

    public void setHardware_version(String hardware_version) {
        this.hardware_version = hardware_version;
    }

    public void setAlg_version(String alg_version) {
        this.alg_version = alg_version;
    }

    public void onResult(String pr, String cmdType, String measureId, String reportData) {
        Log.d((String)"TaiyiManager", (String)("onResult: \u6536\u5230\u6d4b\u91cf\u7ed3\u679c - cmdType: " + cmdType + ", measureId: " + measureId));
        Log.d((String)"TaiyiManager", (String)("onResult: mResultListener\u72b6\u6001: " + (this.mResultListener != null ? this.mResultListener.getClass().getSimpleName() : "null")));
        if (this.mResultListener != null) {
            Log.d((String)"TaiyiManager", (String)"onResult: \u6b63\u5728\u8c03\u7528mResultListener.onResult");
            this.mResultListener.onResult(pr, cmdType, measureId, reportData);
        } else {
            Log.w((String)"TaiyiManager", (String)"onResult: mResultListener\u4e3anull\uff0c\u65e0\u6cd5\u4f20\u9012\u6d4b\u91cf\u7ed3\u679c");
        }
    }

    private TaiyiManager() {
        if (Build.VERSION.SDK_INT >= 27) {
            this.closeAndroid10Dialog();
        }
    }

    @SuppressLint(value={"SoonBlockedPrivateApi", "PrivateApi", "DiscouragedPrivateApi"})
    private void closeAndroid10Dialog() {
        try {
            Class<?> aClass = Class.forName("android.content.pm.PackageParser$Package");
            Constructor<?> declaredConstructor = aClass.getDeclaredConstructor(String.class);
            declaredConstructor.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            Class<?> cls = Class.forName("android.app.ActivityThread");
            Method declaredMethod = cls.getDeclaredMethod("currentActivityThread", new Class[0]);
            declaredMethod.setAccessible(true);
            Object activityThread = declaredMethod.invoke(null, new Object[0]);
            Field mHiddenApiWarningShown = cls.getDeclaredField("mHiddenApiWarningShown");
            mHiddenApiWarningShown.setAccessible(true);
            mHiddenApiWarningShown.setBoolean(activityThread, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TaiyiManager getInstance() {
        if (instance != null) return instance;
        Class<TaiyiManager> clazz = TaiyiManager.class;
        synchronized (TaiyiManager.class) {
            if (instance != null) return instance;
            instance = new TaiyiManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void init(String appId, String appSecret, Application application) {
        this.appId = appId;
        this.appSecret = appSecret;
        this.context = application;
    }

    public void toTargetMeasure(String uid, Class targetActivity, Activity activity, SkipInterface skipInterface, ResultListener listener) {
        this.uid = uid;
        Intent intent = new Intent((Context)activity, targetActivity);
        activity.startActivity(intent);
        this.mSkipInterface = skipInterface;
        this.setResultListener(listener);
    }

    public void toTargetMeasure(String uid, Class targetActivity, Activity activity, SkipInterface skipInterface, ResultListener listener, int orientation) {
        this.uid = uid;
        if (orientation != -1) {
            activity.setRequestedOrientation(orientation);
        }
        Intent intent = new Intent((Context)activity, targetActivity);
        if (orientation != -1) {
            intent.putExtra("screen_orientation", orientation);
        }
        activity.startActivity(intent);
        this.mSkipInterface = skipInterface;
        this.setResultListener(listener);
    }

    public void toDirectMeasure(String uid, Activity activity, SkipInterface skipInterface, ResultListener listener, boolean isLeft) {
        this.uid = uid;
        Intent intent = new Intent((Context)activity, MeasureHandsActivity.class);
        intent.putExtra("autoTest", true);
        intent.putExtra("isAutoTestLeftHand", isLeft);
        activity.startActivity(intent);
        this.mSkipInterface = skipInterface;
        this.setResultListener(listener);
    }

    public void toDirectMeasure(String uid, Activity activity, SkipInterface skipInterface, ResultListener listener, boolean isLeft, int orientation) {
        this.uid = uid;
        if (orientation != -1) {
            activity.setRequestedOrientation(orientation);
        }
        Intent intent = new Intent((Context)activity, MeasureHandsActivity.class);
        intent.putExtra("autoTest", true);
        intent.putExtra("isAutoTestLeftHand", isLeft);
        if (orientation != -1) {
            intent.putExtra("screen_orientation", orientation);
        }
        activity.startActivity(intent);
        this.mSkipInterface = skipInterface;
        this.setResultListener(listener);
    }

    public void toGoMeasure(boolean isLeft) {
        if (isLeft) {
            EventBus.getDefault().post((Object)new EventTestMaiMessage(0));
        } else {
            EventBus.getDefault().post((Object)new EventTestMaiMessage(1));
        }
    }

    public SkipInterface getSkipInterface() {
        return this.mSkipInterface;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getUid() {
        return this.uid;
    }

    public String getAppSecret() {
        return this.appSecret;
    }

    public void toMeasure(String uid, Activity activity, Class target, SkipInterface skipInterface, ResultListener listener) {
        this.uid = uid;
        Intent intent = new Intent((Context)activity, target);
        activity.startActivity(intent);
        this.mSkipInterface = skipInterface;
        this.setResultListener(listener);
    }

    public void toMeasure(String uid, Activity activity, Class target, SkipInterface skipInterface, ResultListener listener, int orientation) {
        this.uid = uid;
        if (orientation != -1) {
            activity.setRequestedOrientation(orientation);
        }
        Intent intent = new Intent((Context)activity, target);
        if (orientation != -1) {
            intent.putExtra("screen_orientation", orientation);
        }
        activity.startActivity(intent);
        this.mSkipInterface = skipInterface;
        this.setResultListener(listener);
    }

    public void clearMeasure() {
        AppManager.finishActivity(MeasureFlowActivity.class);
        AppManager.finishActivity(HelpActivity.class);
        AppManager.finishActivity(SuccessActivity.class);
    }

    public String getPulseResult() {
        return this.pulseResult;
    }

    public void setPulseResult(String pulseResult) {
        this.pulseResult = pulseResult;
    }

    public static interface SkipInterface {
        public void onSkip();
    }
}

