/*
 * Decompiled with CFR 0.152.
 */
package com.taiyi.typulse.tyusbsdk.pulse.ui;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.provider.Settings;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.core.app.ActivityCompat;
import com.taiyi.typulse.R;
import com.taiyi.typulse.tyusbsdk.TYDeviceConnectCallback;
import com.taiyi.typulse.tyusbsdk.TYError;
import com.taiyi.typulse.tyusbsdk.TYUsbDeviceActivity;
import com.taiyi.typulse.tyusbsdk.pulse.TaiyiManager;
import com.taiyi.typulse.tyusbsdk.pulse.net.HttpImpl;
import com.taiyi.typulse.tyusbsdk.pulse.net.HttpUtil;
import com.taiyi.typulse.tyusbsdk.pulse.ui.HelpActivity;
import com.taiyi.typulse.tyusbsdk.pulse.ui.MeasureHandsActivity;
import com.taiyi.typulse.tyusbsdk.pulse.util.DialogTipUtil;
import com.taiyi.typulse.tyusbsdk.pulse.util.OnClickNoDoubleListener;

public class MainMeasureActivity
extends TYUsbDeviceActivity {
    ImageView mIvFinish;
    ImageView mIvLogo;
    ImageView mTvScan;
    TextView mTvSkip;

    @Override
    protected int initLayoutResId() {
        return R.layout.activity_main_measure;
    }

    @Override
    protected void init() {
        this.mIvFinish = (ImageView)this.findViewById(R.id.iv_finish);
        this.mIvLogo = (ImageView)this.findViewById(R.id.iv_logo);
        this.mTvScan = (ImageView)this.findViewById(R.id.tv_scan);
        this.mTvSkip = (TextView)this.findViewById(R.id.tv_skip);
        String androidId = Settings.Secure.getString((ContentResolver)this.getContentResolver(), (String)"android_id");
        TaiyiManager.getInstance().setDeviceId(androidId);
        this.initClick();
        this.getToken();
    }

    private void initClick() {
        this.mIvLogo.setOnClickListener((View.OnClickListener)new OnClickNoDoubleListener(){

            @Override
            public void onNoDoubleClick(View view) {
                Intent intent = new Intent((Context)MainMeasureActivity.this, HelpActivity.class);
                MainMeasureActivity.this.startActivity(intent);
            }
        });
        this.mIvFinish.setOnClickListener((View.OnClickListener)new OnClickNoDoubleListener(){

            @Override
            public void onNoDoubleClick(View view) {
                MainMeasureActivity.this.finish();
            }
        });
        this.mTvScan.setOnClickListener((View.OnClickListener)new OnClickNoDoubleListener(){

            @Override
            public void onNoDoubleClick(View view) {
                MainMeasureActivity.this.connectUSBMaiDevice();
            }
        });
        this.mTvSkip.setOnClickListener((View.OnClickListener)new OnClickNoDoubleListener(){

            @Override
            public void onNoDoubleClick(View view) {
                TaiyiManager.getInstance().clearMeasure();
                if (TaiyiManager.getInstance().getSkipInterface() != null) {
                    TaiyiManager.getInstance().getSkipInterface().onSkip();
                }
            }
        });
    }

    public void onBackPressed() {
    }

    private void connectUSBMaiDevice() {
        this.connectDefaultTYDevice(new TYDeviceConnectCallback(){

            @Override
            public void deviceConnectedSuccessCallback(String deviceName) {
                Toast.makeText((Context)MainMeasureActivity.this, (CharSequence)("\u5df2\u8fde\u63a5\u8bbe\u5907" + deviceName), (int)0).show();
                TaiyiManager.getInstance().setDeviceName(deviceName);
                Intent intent = new Intent((Context)MainMeasureActivity.this, MeasureHandsActivity.class);
                intent.putExtra("deviceName", deviceName);
                MainMeasureActivity.this.startActivity(intent);
            }

            @Override
            public void deviceConnectedFailureCallback(TYError error) {
                if (error == TYError.NONE_USB_DEVICES) {
                    Toast.makeText((Context)MainMeasureActivity.this, (CharSequence)"\u6ca1\u6709\u8fde\u63a5\u592a\u4e00\u8109\u8bbe\u5907", (int)0).show();
                } else if (error == TYError.USB_AUTH_REJECTED) {
                    Toast.makeText((Context)MainMeasureActivity.this, (CharSequence)"\u60a8\u62d2\u7edd\u8fde\u63a5\u8be5\u8bbe\u5907", (int)0).show();
                } else if (error == TYError.DEVICE_ALREADY_CONNECTED) {
                    Toast.makeText((Context)MainMeasureActivity.this, (CharSequence)"\u60a8\u5df2\u8fde\u63a5\u8be5\u8bbe\u5907", (int)0).show();
                }
            }
        });
    }

    private void getToken() {
        HttpUtil.getInstance().getRequestQueue((Context)this).check(new HttpImpl<String>(){

            @Override
            public void showError(String error) {
                DialogTipUtil.showSelectDialog((Context)MainMeasureActivity.this, MainMeasureActivity.this.getString(R.string.dialog_tip_tip), MainMeasureActivity.this.getString(R.string.measure_skip_tip_1), R.string.measure_skip, R.string.dialog_tip_retry, new DialogTipUtil.OptionClickCallback_I(){

                    @Override
                    public void leftClick() {
                        TaiyiManager.getInstance().clearMeasure();
                        if (TaiyiManager.getInstance().getSkipInterface() != null) {
                            TaiyiManager.getInstance().getSkipInterface().onSkip();
                        }
                        MainMeasureActivity.this.finish();
                    }

                    @Override
                    public void rightClick() {
                        MainMeasureActivity.this.getToken();
                    }
                });
            }

            @Override
            public void showResponse(String response) {
                HttpUtil.AuthorizationValue = response;
                if (ActivityCompat.checkSelfPermission((Context)MainMeasureActivity.this, (String)"android.permission.WRITE_EXTERNAL_STORAGE") != 0) {
                    MainMeasureActivity.this.popupPermissionTip("android.permission.WRITE_EXTERNAL_STORAGE", R.string.permission_storage_2);
                }
            }
        });
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (grantResults.length == 0 || grantResults[0] != 0) {
            this.popupPermissionTip("android.permission.WRITE_EXTERNAL_STORAGE", R.string.permission_storage_2);
        }
    }
}

