/*
 * Decompiled with CFR 0.152.
 */
package com.taiyi.typulse.tyusbsdk.pulse.ui;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.http.SslError;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.webkit.JavascriptInterface;
import android.webkit.SslErrorHandler;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;
import com.taiyi.typulse.R;
import com.taiyi.typulse.tyusbsdk.pulse.TaiyiManager;
import com.taiyi.typulse.tyusbsdk.pulse.net.HttpImpl;
import com.taiyi.typulse.tyusbsdk.pulse.net.HttpUtil;
import com.taiyi.typulse.tyusbsdk.pulse.net.TokenOverDueHttpImpl;
import com.taiyi.typulse.tyusbsdk.pulse.ui.BaseActivity;
import com.taiyi.typulse.tyusbsdk.pulse.util.AppManager;
import com.taiyi.typulse.tyusbsdk.pulse.util.DialogTipUtil;
import com.taiyi.typulse.tyusbsdk.pulse.util.LogUtil;
import com.taiyi.typulse.tyusbsdk.pulse.util.OnClickNoDoubleListener;
import com.taiyi.typulse.tyusbsdk.pulse.util.ProgressDialogUtil;
import com.taiyi.typulse.tyusbsdk.pulse.util.ToastUtil;
import org.json.JSONException;
import org.json.JSONObject;

public class SuccessActivity
extends BaseActivity {
    private static final String TAG = "qxj SuccessActivity";
    ImageView mIvBack1;
    TextView mTvTitle;
    ProgressBar mProgress;
    TextView mTvCommit;
    WebView mWeb;
    private String measureId = "";
    private String url = "https://hybrid.reborn-tech.com/";
    private String singleUrl = "https://hybrid.reborn-tech.com/report.html#/single";

    @Override
    protected int initLayoutResId() {
        return R.layout.activity_success;
    }

    @Override
    @SuppressLint(value={"ClickableViewAccessibility", "CheckResult"})
    protected void init() {
        this.mIvBack1 = (ImageView)this.findViewById(R.id.iv_back);
        this.mTvTitle = (TextView)this.findViewById(R.id.tv_title);
        this.mProgress = (ProgressBar)this.findViewById(R.id.progress);
        this.mTvCommit = (TextView)this.findViewById(R.id.tv_commit);
        this.mWeb = (WebView)this.findViewById(R.id.web);
        this.setupWebView();
        this.measureId = this.getIntent().getStringExtra("measureId");
        this.getToken();
        this.mIvBack1.setOnClickListener((View.OnClickListener)new OnClickNoDoubleListener(){

            @Override
            public void onNoDoubleClick(View view) {
                SuccessActivity.this.finish();
            }
        });
        this.mTvCommit.setOnClickListener((View.OnClickListener)new OnClickNoDoubleListener(){

            @Override
            public void onNoDoubleClick(View view) {
                SuccessActivity.this.getCombinedReportDesc(SuccessActivity.this.measureId);
            }
        });
    }

    private void getToken() {
        HttpUtil.getInstance().getRequestQueue((Context)this).webViewCheck(new HttpImpl<String>(){

            @Override
            public void showError(String error) {
                DialogTipUtil.showSelectDialog((Context)SuccessActivity.this, SuccessActivity.this.getString(R.string.dialog_tip_tip), SuccessActivity.this.getString(R.string.measure_skip_tip_1), R.string.measure_skip, R.string.dialog_tip_retry, new DialogTipUtil.OptionClickCallback_I(){

                    @Override
                    public void leftClick() {
                        TaiyiManager.getInstance().clearMeasure();
                        if (TaiyiManager.getInstance().getSkipInterface() != null) {
                            TaiyiManager.getInstance().getSkipInterface().onSkip();
                        }
                        SuccessActivity.this.finish();
                    }

                    @Override
                    public void rightClick() {
                        SuccessActivity.this.getToken();
                    }
                });
            }

            @Override
            public void showResponse(String response) {
                HttpUtil.AuthorizationValue = response;
                SuccessActivity.this.url = SuccessActivity.this.url + ("report.html#/?mid=" + SuccessActivity.this.measureId + "&access_session=" + response + "&appId=" + TaiyiManager.getInstance().getAppId());
                SuccessActivity.this.mWeb.loadUrl(SuccessActivity.this.url);
                LogUtil.w("qxj SuccessActivity showResponse", "url:" + SuccessActivity.this.url);
            }
        });
    }

    public void getCombinedReportDesc(final String combiledId) {
        HttpUtil.getInstance().getPulseTotalDesc(combiledId, new TokenOverDueHttpImpl<String>(){

            @Override
            public void overdue() {
            }

            @Override
            public void showError(String error) {
                DialogTipUtil.showSelectDialog((Context)SuccessActivity.this, SuccessActivity.this.getString(R.string.dialog_tip_tip), SuccessActivity.this.getString(R.string.measure_skip_tip_1), R.string.measure_skip, R.string.dialog_tip_retry, new DialogTipUtil.OptionClickCallback_I(){

                    @Override
                    public void leftClick() {
                        TaiyiManager.getInstance().clearMeasure();
                        if (TaiyiManager.getInstance().getSkipInterface() != null) {
                            TaiyiManager.getInstance().getSkipInterface().onSkip();
                        }
                        SuccessActivity.this.finish();
                    }

                    @Override
                    public void rightClick() {
                        SuccessActivity.this.getCombinedReportDesc(combiledId);
                    }
                });
            }

            @Override
            public void showResponse(String response) {
                Log.d((String)"qxj showResponse ", (String)response);
                if (response == null) {
                    LogUtil.e("SuccessActivity", "Response is null");
                    DialogTipUtil.showIKnow((Context)SuccessActivity.this, "\u670d\u52a1\u5668\u54cd\u5e94\u4e3a\u7a7a", new DialogTipUtil.CommonCallback_I(){

                        @Override
                        public void onSuccess(String str) {
                            SuccessActivity.this.finish();
                        }
                    });
                    return;
                }
                if (response.trim().isEmpty()) {
                    LogUtil.e("SuccessActivity", "Response is empty");
                    DialogTipUtil.showIKnow((Context)SuccessActivity.this, "\u670d\u52a1\u5668\u54cd\u5e94\u4e3a\u7a7a\u5b57\u7b26\u4e32", new DialogTipUtil.CommonCallback_I(){

                        @Override
                        public void onSuccess(String str) {
                            SuccessActivity.this.finish();
                        }
                    });
                    return;
                }
                try {
                    String cleanResponse = response.trim();
                    if (cleanResponse.startsWith("\ufeff")) {
                        cleanResponse = cleanResponse.substring(1);
                    }
                    JSONObject jsonObject = new JSONObject(cleanResponse);
                    LogUtil.d(SuccessActivity.TAG, "JSON parsed successfully, adding URLs");
                    String jsonString = jsonObject.toString();
                    String pulseResult = TaiyiManager.getInstance().getPulseResult();
                    LogUtil.d(SuccessActivity.TAG, "\u51c6\u5907\u8c03\u7528TaiyiManager.onResult - measureId: " + SuccessActivity.this.measureId);
                    LogUtil.d(SuccessActivity.TAG, "pulseResult: " + (pulseResult != null ? "\u6709\u6570\u636e" : "null"));
                    LogUtil.d(SuccessActivity.TAG, "jsonString\u957f\u5ea6: " + (jsonString != null ? jsonString.length() : 0));
                    TaiyiManager.getInstance().onResult(pulseResult, "pulseResult", SuccessActivity.this.measureId, jsonString);
                    LogUtil.d(SuccessActivity.TAG, "\u5df2\u8c03\u7528TaiyiManager.onResult");
                    if (TextUtils.isEmpty((CharSequence)pulseResult)) {
                        LogUtil.w(SuccessActivity.TAG, "pulse result null");
                        ToastUtil.show((Context)SuccessActivity.this, "\u6d4b\u91cf\u7684\u8109\u640f\u6570\u636e\u4e3anull");
                    } else {
                        LogUtil.w(SuccessActivity.TAG, TaiyiManager.getInstance().getPulseResult());
                    }
                    AppManager.getAppManager().finishAllActivity();
                }
                catch (JSONException e) {
                    String errorDetail = "JSON\u89e3\u6790\u9519\u8bef: " + e.getMessage();
                    errorDetail = response.length() > 100 ? errorDetail + "\n\u54cd\u5e94\u524d100\u5b57\u7b26: " + response.substring(0, 100) : errorDetail + "\n\u5b8c\u6574\u54cd\u5e94: " + response;
                    DialogTipUtil.showIKnow((Context)SuccessActivity.this, errorDetail, new DialogTipUtil.CommonCallback_I(){

                        @Override
                        public void onSuccess(String str) {
                            SuccessActivity.this.finish();
                        }
                    });
                }
                catch (Exception e) {
                    LogUtil.e(SuccessActivity.TAG, "General error: " + e.getMessage());
                    Toast.makeText((Context)SuccessActivity.this, (CharSequence)e.getMessage(), (int)1).show();
                    DialogTipUtil.showIKnow((Context)SuccessActivity.this, "\u5904\u7406\u54cd\u5e94\u65f6\u53d1\u751f\u9519\u8bef: " + e.getMessage(), new DialogTipUtil.CommonCallback_I(){

                        @Override
                        public void onSuccess(String str) {
                            SuccessActivity.this.finish();
                        }
                    });
                }
            }
        });
    }

    private void setupWebView() {
        this.setWebViewSettings();
        this.setWebClient();
        this.addJsInterface();
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private void setWebViewSettings() {
        WebSettings settings = this.mWeb.getSettings();
        settings.setJavaScriptEnabled(true);
        settings.setUseWideViewPort(true);
        settings.setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NARROW_COLUMNS);
        settings.setLoadWithOverviewMode(true);
        settings.setUserAgentString("TaiyiMai");
        this.mWeb.setVerticalScrollBarEnabled(false);
        this.mWeb.setHorizontalScrollBarEnabled(false);
    }

    private void setWebClient() {
        this.mWeb.setWebChromeClient(new WebChromeClient(){

            public void onReceivedTitle(WebView view, String title) {
                super.onReceivedTitle(view, title);
                SuccessActivity.this.mTvTitle.setText((CharSequence)title);
            }

            public void onProgressChanged(WebView view, int newProgress) {
                super.onProgressChanged(view, newProgress);
                if (SuccessActivity.this.mProgress != null) {
                    SuccessActivity.this.mProgress.setProgress(newProgress);
                }
            }
        });
        this.mWeb.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                view.loadUrl(url);
                return true;
            }

            public void onPageStarted(WebView view, String url, Bitmap favicon) {
                super.onPageStarted(view, url, favicon);
                if (SuccessActivity.this.mProgress != null) {
                    SuccessActivity.this.mProgress.setVisibility(0);
                }
                ProgressDialogUtil.show((Context)SuccessActivity.this, SuccessActivity.this.getString(R.string.loading));
            }

            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
                if (SuccessActivity.this.mProgress != null) {
                    SuccessActivity.this.mProgress.setVisibility(8);
                }
                ProgressDialogUtil.close();
            }

            public void onReceivedSslError(WebView webView, SslErrorHandler sslErrorHandler, SslError sslError) {
                super.onReceivedSslError(webView, sslErrorHandler, sslError);
                sslErrorHandler.proceed();
            }

            public void onReceivedError(WebView webView, WebResourceRequest webResourceRequest, WebResourceError webResourceError) {
                super.onReceivedError(webView, webResourceRequest, webResourceError);
                ProgressDialogUtil.close();
            }
        });
    }

    private void addJsInterface() {
        this.mWeb.addJavascriptInterface((Object)new WebAppInterface(), "android");
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (this.mWeb != null) {
            this.mWeb.destroy();
        }
        if (this.mProgress != null) {
            this.mProgress = null;
        }
    }

    class WebAppInterface {
        WebAppInterface() {
        }

        @JavascriptInterface
        public void loadFinished() {
            LogUtil.w(SuccessActivity.TAG, "loadFinished");
            ProgressDialogUtil.close();
        }
    }
}

