/*
 * Decompiled with CFR 0.152.
 */
package com.taiyi.typulse.tyusbsdk.pulse.util;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.os.Process;
import java.util.Stack;

public class AppManager {
    private static Stack<Activity> activityStack;
    private static AppManager instance;

    private AppManager() {
    }

    public static AppManager getAppManager() {
        if (instance == null) {
            instance = new AppManager();
        }
        return instance;
    }

    public void addActivity(Activity activity) {
        if (activityStack == null) {
            activityStack = new Stack();
        }
        activityStack.add(activity);
    }

    public Activity currentActivity() {
        if (activityStack != null && !activityStack.isEmpty()) {
            return (Activity)activityStack.lastElement();
        }
        return null;
    }

    public void finishActivity() {
        if (activityStack != null && !activityStack.isEmpty()) {
            Activity activity = (Activity)activityStack.lastElement();
            AppManager.finishActivity(activity);
        }
    }

    public static void finishActivity(Activity activity) {
        if (activity != null && !activity.isFinishing()) {
            activityStack.remove(activity);
            activity.finish();
            activity = null;
        }
    }

    public static void finishActivity(Class<?> cls) {
        for (Activity activity : activityStack) {
            if (!activity.getClass().equals(cls)) continue;
            AppManager.finishActivity(activity);
            break;
        }
    }

    public void finishAllActivity() {
        int size = activityStack.size();
        for (int i = 0; i < size; ++i) {
            if (null == activityStack.get(i)) continue;
            ((Activity)activityStack.get(i)).finish();
        }
        activityStack.clear();
    }

    public Activity getActivity(Class<?> cls) {
        if (activityStack != null) {
            for (Activity activity : activityStack) {
                if (!activity.getClass().equals(cls)) continue;
                return activity;
            }
        }
        return null;
    }

    public static Stack<Activity> getActivitys() {
        return activityStack;
    }

    public void AppExit(Context context) {
        try {
            this.finishAllActivity();
            Process.killProcess((int)Process.myPid());
            System.exit(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getActivityCount() {
        int count = activityStack.size();
        return count;
    }

    public void removeActivity(Activity activity) {
        if (activityStack == null) {
            return;
        }
        if (activityStack.contains(activity)) {
            activityStack.remove(activity);
        }
        if (activity != null && !activity.isFinishing()) {
            activity.finish();
            activity = null;
        }
    }

    public static boolean isDestroy(Activity activity) {
        return activity == null || activity.isFinishing() || Build.VERSION.SDK_INT >= 17 && activity.isDestroyed();
    }
}

