/*
 * Decompiled with CFR 0.152.
 */
package com.taiyi.typulse.tyusbsdk.pulse.util;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;

public class AutoScrollRecyclerView
extends RecyclerView {
    private static final String TAG = AutoScrollRecyclerView.class.getSimpleName();
    private static final int SPEED = 100;
    private UniformSpeedInterpolator mInterpolator = new UniformSpeedInterpolator();
    private int mSpeedDx;
    private int mSpeedDy;
    private int mCurrentSpeed = 100;
    private boolean mLoopEnabled;
    private boolean mReverse;
    private boolean mIsOpenAuto;
    private boolean mCanTouch = true;
    private boolean mPointTouch;
    private boolean mReady = false;
    private boolean mInflate;

    public AutoScrollRecyclerView(Context context) {
        this(context, null);
    }

    public AutoScrollRecyclerView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public AutoScrollRecyclerView(Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public void openAutoScroll() {
        this.openAutoScroll(this.mCurrentSpeed, false);
    }

    public void openAutoScroll(int speed, boolean reverse) {
        this.mReverse = reverse;
        this.mCurrentSpeed = speed;
        this.mIsOpenAuto = true;
        this.notifyLayoutManager();
        this.startScroll();
    }

    public void setCanTouch(boolean b) {
        this.mCanTouch = b;
    }

    public boolean canTouch() {
        return this.mCanTouch;
    }

    public void setLoopEnabled(boolean loopEnabled) {
        this.mLoopEnabled = loopEnabled;
        this.getAdapter().notifyDataSetChanged();
        this.startScroll();
    }

    public boolean isLoopEnabled() {
        return this.mLoopEnabled;
    }

    public void setReverse(boolean reverse) {
        this.mReverse = reverse;
        this.notifyLayoutManager();
        this.startScroll();
    }

    public boolean getReverse() {
        return this.mReverse;
    }

    private void startScroll() {
        if (!this.mIsOpenAuto) {
            return;
        }
        if (this.getScrollState() == 2) {
            return;
        }
        if (this.mInflate && this.mReady) {
            this.mSpeedDy = 0;
            this.mSpeedDx = 0;
            this.smoothScroll();
        }
    }

    private void smoothScroll() {
        int absSpeed = Math.abs(this.mCurrentSpeed);
        int d = this.mReverse ? -absSpeed : absSpeed;
        this.smoothScrollBy(d, d, this.mInterpolator);
    }

    private void notifyLayoutManager() {
        RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
        if (layoutManager instanceof LinearLayoutManager) {
            ((LinearLayoutManager)layoutManager).setReverseLayout(this.mReverse);
        } else {
            ((StaggeredGridLayoutManager)layoutManager).setReverseLayout(this.mReverse);
        }
    }

    public void swapAdapter(RecyclerView.Adapter adapter, boolean removeAndRecycleExistingViews) {
        super.swapAdapter((RecyclerView.Adapter)this.generateAdapter(adapter), removeAndRecycleExistingViews);
        this.mReady = true;
    }

    public void setAdapter(RecyclerView.Adapter adapter) {
        super.setAdapter((RecyclerView.Adapter)this.generateAdapter(adapter));
        this.mReady = true;
    }

    public boolean onInterceptTouchEvent(MotionEvent e) {
        if (this.mCanTouch) {
            switch (e.getAction()) {
                case 0: {
                    this.mPointTouch = true;
                    break;
                }
                case 1: 
                case 3: {
                    if (!this.mIsOpenAuto) break;
                    return true;
                }
            }
            return super.onInterceptTouchEvent(e);
        }
        return true;
    }

    public boolean onTouchEvent(MotionEvent e) {
        if (this.mCanTouch) {
            switch (e.getAction()) {
                case 1: 
                case 3: {
                    if (!this.mIsOpenAuto) break;
                    this.mPointTouch = false;
                    this.smoothScroll();
                    return true;
                }
            }
            return super.onTouchEvent(e);
        }
        return true;
    }

    public boolean performClick() {
        return super.performClick();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.startScroll();
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mInflate = true;
    }

    public void onScrolled(int dx, int dy) {
        boolean vertical;
        if (this.mPointTouch) {
            this.mSpeedDx = 0;
            this.mSpeedDy = 0;
            return;
        }
        if (dx == 0) {
            this.mSpeedDy += dy;
            vertical = true;
        } else {
            this.mSpeedDx += dx;
            vertical = false;
        }
        if (vertical) {
            if (Math.abs(this.mSpeedDy) >= Math.abs(this.mCurrentSpeed)) {
                this.mSpeedDy = 0;
                this.smoothScroll();
            }
        } else if (Math.abs(this.mSpeedDx) >= Math.abs(this.mCurrentSpeed)) {
            this.mSpeedDx = 0;
            this.smoothScroll();
        }
    }

    @NonNull
    private NestingRecyclerViewAdapter generateAdapter(RecyclerView.Adapter adapter) {
        return new NestingRecyclerViewAdapter(this, adapter);
    }

    private static class UniformSpeedInterpolator
    implements Interpolator {
        private UniformSpeedInterpolator() {
        }

        public float getInterpolation(float input) {
            return input;
        }
    }

    private static class NestingRecyclerViewAdapter<VH extends RecyclerView.ViewHolder>
    extends RecyclerView.Adapter<VH> {
        private AutoScrollRecyclerView mRecyclerView;
        RecyclerView.Adapter<VH> mAdapter;

        NestingRecyclerViewAdapter(AutoScrollRecyclerView recyclerView, RecyclerView.Adapter<VH> adapter) {
            this.mAdapter = adapter;
            this.mRecyclerView = recyclerView;
        }

        public VH onCreateViewHolder(ViewGroup parent, int viewType) {
            return (VH)this.mAdapter.onCreateViewHolder(parent, viewType);
        }

        public void registerAdapterDataObserver(RecyclerView.AdapterDataObserver observer) {
            super.registerAdapterDataObserver(observer);
            this.mAdapter.registerAdapterDataObserver(observer);
        }

        public void unregisterAdapterDataObserver(RecyclerView.AdapterDataObserver observer) {
            super.unregisterAdapterDataObserver(observer);
            this.mAdapter.unregisterAdapterDataObserver(observer);
        }

        public void onBindViewHolder(VH holder, int position) {
            this.mAdapter.onBindViewHolder(holder, this.generatePosition(position));
        }

        public void setHasStableIds(boolean hasStableIds) {
            super.setHasStableIds(hasStableIds);
            this.mAdapter.setHasStableIds(hasStableIds);
        }

        public int getItemCount() {
            return this.getLoopEnable() ? Integer.MAX_VALUE : this.mAdapter.getItemCount();
        }

        public int getItemViewType(int position) {
            return this.mAdapter.getItemViewType(this.generatePosition(position));
        }

        public long getItemId(int position) {
            return this.mAdapter.getItemId(this.generatePosition(position));
        }

        private int generatePosition(int position) {
            return this.getLoopEnable() ? this.getActualPosition(position) : position;
        }

        private int getActualPosition(int position) {
            int itemCount = this.mAdapter.getItemCount();
            return position >= itemCount ? position % itemCount : position;
        }

        private boolean getLoopEnable() {
            return this.mRecyclerView.mLoopEnabled;
        }
    }
}

