/*
 * Decompiled with CFR 0.152.
 */
package com.taiyi.typulse.tyusbsdk.pulse.util;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.text.TextUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;

public class OsUtil {
    private static Boolean isHW;
    private static Boolean isXM;
    public static final String ROM_MIUI = "MIUI";
    public static final String ROM_EMUI = "EMUI";
    public static final String ROM_FLYME = "FLYME";
    public static final String ROM_OPPO = "OPPO";
    public static final String ROM_SMARTISAN = "SMARTISAN";
    public static final String ROM_VIVO = "VIVO";
    public static final String ROM_QIKU = "QIKU";
    private static final String KEY_VERSION_MIUI = "ro.miui.ui.version.name";
    private static final String KEY_VERSION_EMUI = "ro.build.version.emui";
    private static final String KEY_VERSION_OPPO = "ro.build.version.opporom";
    private static final String KEY_VERSION_SMARTISAN = "ro.smartisan.version";
    private static final String KEY_VERSION_VIVO = "ro.vivo.os.version";
    private static String sName;
    private static String sVersion;

    public static boolean isXM(Context context) {
        if (isXM == null) {
            if (OsUtil.getPhoneModel(context).contains("MI") || OsUtil.getPhoneModel(context).contains("mi")) {
                isXM = true;
                return true;
            }
            isXM = false;
            return false;
        }
        return isXM;
    }

    public static boolean isHW(Context context) {
        if (isHW == null) {
            if (OsUtil.getProperty(KEY_VERSION_EMUI, "unknown").contains("EmotionUI")) {
                isHW = true;
                return true;
            }
            isHW = false;
            return false;
        }
        return isHW;
    }

    public static String getPhoneModel(Context context) {
        PackageManager packageManager = context.getPackageManager();
        String packageName = context.getPackageName();
        PackageInfo packageInfo = null;
        try {
            packageInfo = packageManager.getPackageInfo(packageName, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return Build.MODEL;
    }

    public static String getSystemModel() {
        return Build.MODEL;
    }

    public static String getDeviceBrand() {
        return Build.BRAND;
    }

    public static String getOSVersion() {
        return Build.VERSION.RELEASE;
    }

    public static int getSDK_INT() {
        return Build.VERSION.SDK_INT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getProperty(String key, String defaultValue) {
        String value = defaultValue;
        try {
            Class<?> c = Class.forName("android.os.SystemProperties");
            Method get = c.getMethod("get", String.class, String.class);
            value = (String)get.invoke(c, key, "unknown");
            return value;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            return value;
        }
    }

    public static boolean isEmui() {
        return OsUtil.check(ROM_EMUI);
    }

    public static boolean isMiui() {
        return OsUtil.check(ROM_MIUI);
    }

    public static boolean isVivo() {
        return OsUtil.check(ROM_VIVO);
    }

    public static boolean isOppo() {
        return OsUtil.check(ROM_OPPO);
    }

    public static boolean isFlyme() {
        return OsUtil.check(ROM_FLYME);
    }

    public static boolean is360() {
        return OsUtil.check(ROM_QIKU) || OsUtil.check("360");
    }

    public static boolean isSmartisan() {
        return OsUtil.check(ROM_SMARTISAN);
    }

    public static String getName() {
        if (sName == null) {
            OsUtil.check("");
        }
        return sName;
    }

    public static String getVersion() {
        if (sVersion == null) {
            OsUtil.check("");
        }
        return sVersion;
    }

    public static boolean check(String rom) {
        if (sName != null) {
            return sName.equals(rom);
        }
        sVersion = OsUtil.getProp(KEY_VERSION_MIUI);
        if (!TextUtils.isEmpty((CharSequence)sVersion)) {
            sName = ROM_MIUI;
        } else {
            sVersion = OsUtil.getProp(KEY_VERSION_EMUI);
            if (!TextUtils.isEmpty((CharSequence)sVersion)) {
                sName = ROM_EMUI;
            } else {
                sVersion = OsUtil.getProp(KEY_VERSION_OPPO);
                if (!TextUtils.isEmpty((CharSequence)sVersion)) {
                    sName = ROM_OPPO;
                } else {
                    sVersion = OsUtil.getProp(KEY_VERSION_VIVO);
                    if (!TextUtils.isEmpty((CharSequence)sVersion)) {
                        sName = ROM_VIVO;
                    } else {
                        sVersion = OsUtil.getProp(KEY_VERSION_SMARTISAN);
                        if (!TextUtils.isEmpty((CharSequence)sVersion)) {
                            sName = ROM_SMARTISAN;
                        } else {
                            sVersion = Build.DISPLAY;
                            if (sVersion.toUpperCase().contains(ROM_FLYME)) {
                                sName = ROM_FLYME;
                            } else {
                                sVersion = "unknown";
                                sName = Build.MANUFACTURER.toUpperCase();
                            }
                        }
                    }
                }
            }
        }
        return sName.equals(rom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getProp(String name) {
        String line = null;
        BufferedReader input = null;
        try {
            Process p = Runtime.getRuntime().exec("getprop " + name);
            input = new BufferedReader(new InputStreamReader(p.getInputStream()), 1024);
            line = input.readLine();
            input.close();
        }
        catch (IOException ex) {
            String string2 = null;
            return string2;
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return line;
    }
}

