/*
 * Decompiled with CFR 0.152.
 */
package com.taiyi.typulse.tyusbsdk.pulse.util;

import android.util.Log;
import java.sql.Time;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.StringTokenizer;

public class QTimeUtil {
    public static final long MS_PER_SEC = 60000L;
    public static final long MS_PER_MINUTE = 60000L;
    public static final long MS_PER_HOUR = 3600000L;
    public static final long MS_PER_DAY = 86400000L;

    public static Calendar toCalendarNoHour(long timeInMs) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeInMillis(timeInMs);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    public static Date toDateNoHour(long timeInMs) {
        return new Date(QTimeUtil.toCalendarNoHour(timeInMs).getTimeInMillis());
    }

    public static Date strToDatetime(String timeStr) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm", Locale.getDefault());
        try {
            return format.parse(timeStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date strToYMD(String timeStr) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
        try {
            return format.parse(timeStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date strToDate(String timeStr) {
        if (timeStr.contains(":")) {
            return QTimeUtil.strToDatetime(timeStr);
        }
        if (timeStr.contains(".") || timeStr.length() > 16) {
            return QTimeUtil.strToDatetime(timeStr.substring(0, 16));
        }
        return QTimeUtil.strToYMD(timeStr);
    }

    public static Time strToHourMin(String timeStr) {
        StringTokenizer st = new StringTokenizer(timeStr, ":");
        int hour = Integer.parseInt(st.nextToken());
        int min = Integer.parseInt(st.nextToken());
        return new Time(hour, min, 0);
    }

    public static String toHourStr(long stamp) {
        SimpleDateFormat format = new SimpleDateFormat("HH:mm", Locale.getDefault());
        return format.format(new Date(stamp));
    }

    public static String toHourStr(Date stamp) {
        SimpleDateFormat format = new SimpleDateFormat("HH:mm", Locale.getDefault());
        return format.format(stamp);
    }

    public static String toDatetimeStr(long stamp) {
        Log.w((String)"QTimeUtil", (String)("stamp:" + stamp));
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
        SimpleDateFormat format1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Log.w((String)"QTimeUtil", (String)format.format(new Date(stamp)));
        Log.w((String)"QTimeUtil", (String)format1.format(new Date(stamp)));
        return format.format(new Date(stamp));
    }

    public static String toDatetimeStrYMD(long stamp) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 HH:mm:ss", Locale.getDefault());
        return format.format(new Date(stamp));
    }

    public static String toDatetimeStr() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
        return format.format(new Date());
    }

    public static String toDatetimeStr1(long stamp) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm", Locale.getDefault());
        return format.format(new Date(stamp));
    }

    public static String toDateTimeStr2(long stamp) {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd-HH-mm-ss", Locale.getDefault());
        return format.format(new Date(stamp));
    }

    public static String toYMDString(long stamp) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
        return format.format(new Date(stamp));
    }

    public static String toYMDString(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
        return format.format(date);
    }

    public static String toDatetimeStr(Date stamp) {
        return QTimeUtil.toDatetimeStr(stamp.getTime());
    }

    public static String toYMDString(String str) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
        Date date = null;
        try {
            date = format.parse(str);
            return format.format(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String toYMDHMSString() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss", Locale.getDefault());
        return format.format(new Date());
    }

    public static String toYMDHMString() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 HH:mm", Locale.getDefault());
        return format.format(new Date());
    }

    public static String toYMDHMS1String() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 HH:mm:ss", Locale.getDefault());
        return format.format(new Date());
    }

    public static String toYMDHMString(String date) {
        return QTimeUtil.toYMD(date) + " " + QTimeUtil.toHM(date);
    }

    public static String toYMD(String string2) {
        if (string2.contains(" ")) {
            string2 = string2.split(" ")[0];
        }
        String[] split = string2.split("-");
        return split[0] + "\u5e74" + (split[1].startsWith("0") ? split[1].replace("0", "") : split[1]) + "\u6708" + (split[2].startsWith("0") ? split[2].replace("0", "") : split[2]) + "\u65e5";
    }

    public static String toYMD() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
        String string2 = format.format(new Date());
        if (string2.contains(" ")) {
            string2 = string2.split(" ")[0];
        }
        String[] split = string2.split("-");
        return split[0] + "\u5e74" + (split[1].startsWith("0") ? split[1].replace("0", "") : split[1]) + "\u6708" + (split[2].startsWith("0") ? split[2].replace("0", "") : split[2]) + "\u65e5";
    }

    public static String toYMSplit() {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMM", Locale.getDefault());
        return format.format(new Date());
    }

    public static String toHM(String string2) {
        if (string2.contains(" ")) {
            string2 = string2.split(" ")[1];
        }
        String[] split = string2.split(":");
        return split[0] + ":" + split[1];
    }

    public static int intYear() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(System.currentTimeMillis());
        return calendar.get(1);
    }

    public static int intMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(System.currentTimeMillis());
        return calendar.get(2) + 1;
    }

    public static int intDay() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(System.currentTimeMillis());
        return calendar.get(5);
    }

    public static int intHour() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(System.currentTimeMillis());
        return calendar.get(11);
    }

    public static int intMin() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(System.currentTimeMillis());
        return calendar.get(12);
    }

    public static String getTimeZone() {
        Date date = new Date();
        SimpleDateFormat format = new SimpleDateFormat("ZZZZ", Locale.getDefault());
        return format.format(date).replace("GMT", "UTC");
    }
}

