/*
 * Decompiled with CFR 0.152.
 */
package com.taiyi.typulse.tyusbsdk.pulse.util.goods;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.Interpolator;
import com.taiyi.typulse.tyusbsdk.pulse.util.DensityUtil;
import com.taiyi.typulse.tyusbsdk.pulse.util.LoadingRenderer;

public class BalloonLoadingRenderer
extends LoadingRenderer {
    private static final String PERCENT_SIGN = "%";
    private static final Interpolator ACCELERATE_INTERPOLATOR = new AccelerateInterpolator();
    private static final float START_INHALE_DURATION_OFFSET = 0.4f;
    private static final float DEFAULT_WIDTH = 200.0f;
    private static final float DEFAULT_HEIGHT = 150.0f;
    private static final float DEFAULT_STROKE_WIDTH = 2.0f;
    private static final float DEFAULT_GAS_TUBE_WIDTH = 48.0f;
    private static final float DEFAULT_GAS_TUBE_HEIGHT = 20.0f;
    private static final float DEFAULT_CANNULA_WIDTH = 13.0f;
    private static final float DEFAULT_CANNULA_HEIGHT = 37.0f;
    private static final float DEFAULT_CANNULA_OFFSET_Y = 3.0f;
    private static final float DEFAULT_CANNULA_MAX_OFFSET_Y = 15.0f;
    private static final float DEFAULT_PIPE_BODY_WIDTH = 16.0f;
    private static final float DEFAULT_PIPE_BODY_HEIGHT = 36.0f;
    private static final float DEFAULT_BALLOON_WIDTH = 38.0f;
    private static final float DEFAULT_BALLOON_HEIGHT = 48.0f;
    private static final float DEFAULT_RECT_CORNER_RADIUS = 2.0f;
    private static final int DEFAULT_BALLOON_COLOR = Color.parseColor((String)"#ffF3C211");
    private static final int DEFAULT_GAS_TUBE_COLOR = Color.parseColor((String)"#ff174469");
    private static final int DEFAULT_PIPE_BODY_COLOR = Color.parseColor((String)"#aa2369B1");
    private static final int DEFAULT_CANNULA_COLOR = Color.parseColor((String)"#ff174469");
    private static final float DEFAULT_TEXT_SIZE = 7.0f;
    private static final long ANIMATION_DURATION = 3333L;
    private final Paint mPaint = new Paint();
    private final RectF mCurrentBounds = new RectF();
    private final RectF mGasTubeBounds = new RectF();
    private final RectF mPipeBodyBounds = new RectF();
    private final RectF mCannulaBounds = new RectF();
    private final RectF mBalloonBounds = new RectF();
    private final Rect mProgressBounds = new Rect();
    private float mTextSize;
    private float mProgress;
    private String mProgressText;
    private float mGasTubeWidth;
    private float mGasTubeHeight;
    private float mCannulaWidth;
    private float mCannulaHeight;
    private float mCannulaMaxOffsetY;
    private float mCannulaOffsetY;
    private float mPipeBodyWidth;
    private float mPipeBodyHeight;
    private float mBalloonWidth;
    private float mBalloonHeight;
    private float mRectCornerRadius;
    private float mStrokeWidth;
    private int mBalloonColor;
    private int mGasTubeColor;
    private int mCannulaColor;
    private int mPipeBodyColor;

    private BalloonLoadingRenderer(Context context) {
        super(context);
        this.init(context);
        this.setupPaint();
    }

    private void init(Context context) {
        this.mTextSize = DensityUtil.dip2px(context, 7.0f);
        this.mWidth = DensityUtil.dip2px(context, 200.0f);
        this.mHeight = DensityUtil.dip2px(context, 150.0f);
        this.mStrokeWidth = DensityUtil.dip2px(context, 2.0f);
        this.mGasTubeWidth = DensityUtil.dip2px(context, 48.0f);
        this.mGasTubeHeight = DensityUtil.dip2px(context, 20.0f);
        this.mCannulaWidth = DensityUtil.dip2px(context, 13.0f);
        this.mCannulaHeight = DensityUtil.dip2px(context, 37.0f);
        this.mCannulaOffsetY = DensityUtil.dip2px(context, 3.0f);
        this.mCannulaMaxOffsetY = DensityUtil.dip2px(context, 15.0f);
        this.mPipeBodyWidth = DensityUtil.dip2px(context, 16.0f);
        this.mPipeBodyHeight = DensityUtil.dip2px(context, 36.0f);
        this.mBalloonWidth = DensityUtil.dip2px(context, 38.0f);
        this.mBalloonHeight = DensityUtil.dip2px(context, 48.0f);
        this.mRectCornerRadius = DensityUtil.dip2px(context, 2.0f);
        this.mBalloonColor = DEFAULT_BALLOON_COLOR;
        this.mGasTubeColor = DEFAULT_GAS_TUBE_COLOR;
        this.mCannulaColor = DEFAULT_CANNULA_COLOR;
        this.mPipeBodyColor = DEFAULT_PIPE_BODY_COLOR;
        this.mProgressText = "10%";
        this.mDuration = 3333L;
    }

    private void setupPaint() {
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStrokeWidth(this.mStrokeWidth);
    }

    @Override
    protected void draw(Canvas canvas, Rect bounds) {
        int saveCount = canvas.save();
        RectF arcBounds = this.mCurrentBounds;
        arcBounds.set(bounds);
        this.mPaint.setColor(this.mGasTubeColor);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth(this.mStrokeWidth);
        canvas.drawPath(this.createGasTubePath(this.mGasTubeBounds), this.mPaint);
        this.mPaint.setColor(this.mBalloonColor);
        this.mPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        canvas.drawPath(this.createBalloonPath(this.mBalloonBounds, this.mProgress), this.mPaint);
        this.mPaint.setColor(this.mGasTubeColor);
        this.mPaint.setTextSize(this.mTextSize);
        this.mPaint.setStrokeWidth(this.mStrokeWidth / 5.0f);
        canvas.drawText(this.mProgressText, arcBounds.centerX() - (float)this.mProgressBounds.width() / 2.0f, this.mGasTubeBounds.centerY() + (float)this.mProgressBounds.height() / 2.0f, this.mPaint);
        this.mPaint.setColor(this.mCannulaColor);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth(this.mStrokeWidth);
        canvas.drawPath(this.createCannulaHeadPath(this.mCannulaBounds), this.mPaint);
        this.mPaint.setStyle(Paint.Style.FILL);
        canvas.drawPath(this.createCannulaBottomPath(this.mCannulaBounds), this.mPaint);
        this.mPaint.setColor(this.mPipeBodyColor);
        this.mPaint.setStyle(Paint.Style.FILL);
        canvas.drawRoundRect(this.mPipeBodyBounds, this.mRectCornerRadius, this.mRectCornerRadius, this.mPaint);
        canvas.restoreToCount(saveCount);
    }

    @Override
    protected void computeRender(float renderProgress) {
        RectF arcBounds = this.mCurrentBounds;
        this.mGasTubeBounds.set(arcBounds.centerX() - this.mGasTubeWidth / 2.0f, arcBounds.centerY(), arcBounds.centerX() + this.mGasTubeWidth / 2.0f, arcBounds.centerY() + this.mGasTubeHeight);
        this.mPipeBodyBounds.set(arcBounds.centerX() + this.mGasTubeWidth / 2.0f - this.mPipeBodyWidth / 2.0f, arcBounds.centerY() - this.mPipeBodyHeight, arcBounds.centerX() + this.mGasTubeWidth / 2.0f + this.mPipeBodyWidth / 2.0f, arcBounds.centerY());
        this.mCannulaBounds.set(arcBounds.centerX() + this.mGasTubeWidth / 2.0f - this.mCannulaWidth / 2.0f, arcBounds.centerY() - this.mCannulaHeight - this.mCannulaOffsetY, arcBounds.centerX() + this.mGasTubeWidth / 2.0f + this.mCannulaWidth / 2.0f, arcBounds.centerY() - this.mCannulaOffsetY);
        float insetX = this.mBalloonWidth * 0.333f * (1.0f - this.mProgress);
        float insetY = this.mBalloonHeight * 0.667f * (1.0f - this.mProgress);
        this.mBalloonBounds.set(arcBounds.centerX() - this.mGasTubeWidth / 2.0f - this.mBalloonWidth / 2.0f + insetX, arcBounds.centerY() - this.mBalloonHeight + insetY, arcBounds.centerX() - this.mGasTubeWidth / 2.0f + this.mBalloonWidth / 2.0f - insetX, arcBounds.centerY());
        if (renderProgress <= 0.4f) {
            this.mCannulaBounds.offset(0.0f, -this.mCannulaMaxOffsetY * renderProgress / 0.4f);
            this.mProgress = 0.0f;
            this.mProgressText = "10%";
            this.mPaint.setTextSize(this.mTextSize);
            this.mPaint.getTextBounds(this.mProgressText, 0, this.mProgressText.length(), this.mProgressBounds);
        } else {
            float exhaleProgress = ACCELERATE_INTERPOLATOR.getInterpolation(1.0f - (renderProgress - 0.4f) / 0.6f);
            this.mCannulaBounds.offset(0.0f, -this.mCannulaMaxOffsetY * exhaleProgress);
            this.mProgress = 1.0f - exhaleProgress;
            this.mProgressText = this.adjustProgress((int)(exhaleProgress * 100.0f)) + PERCENT_SIGN;
            this.mPaint.setTextSize(this.mTextSize);
            this.mPaint.getTextBounds(this.mProgressText, 0, this.mProgressText.length(), this.mProgressBounds);
        }
    }

    private int adjustProgress(int progress) {
        progress = progress / 10 * 10;
        if ((progress = 100 - progress + 10) > 100) {
            progress = 100;
        }
        return progress;
    }

    private Path createGasTubePath(RectF gasTubeRect) {
        Path path = new Path();
        path.moveTo(gasTubeRect.left, gasTubeRect.top);
        path.lineTo(gasTubeRect.left, gasTubeRect.bottom);
        path.lineTo(gasTubeRect.right, gasTubeRect.bottom);
        path.lineTo(gasTubeRect.right, gasTubeRect.top);
        return path;
    }

    private Path createCannulaHeadPath(RectF cannulaRect) {
        Path path = new Path();
        path.moveTo(cannulaRect.left, cannulaRect.top);
        path.lineTo(cannulaRect.right, cannulaRect.top);
        path.moveTo(cannulaRect.centerX(), cannulaRect.top);
        path.lineTo(cannulaRect.centerX(), cannulaRect.bottom - 0.833f * cannulaRect.width());
        return path;
    }

    private Path createCannulaBottomPath(RectF cannulaRect) {
        RectF cannulaHeadRect = new RectF(cannulaRect.left, cannulaRect.bottom - 0.833f * cannulaRect.width(), cannulaRect.right, cannulaRect.bottom);
        Path path = new Path();
        path.addRoundRect(cannulaHeadRect, this.mRectCornerRadius, this.mRectCornerRadius, Path.Direction.CCW);
        return path;
    }

    private Path createBalloonPath(RectF balloonRect, float progress) {
        Path path = new Path();
        path.moveTo(balloonRect.centerX(), balloonRect.bottom);
        float progressWidth = balloonRect.width() * progress;
        float progressHeight = balloonRect.height() * progress;
        float leftIncrementX1 = progressWidth * -0.48f;
        float leftIncrementY1 = progressHeight * 0.75f;
        float leftIncrementX2 = progressWidth * -0.03f;
        float leftIncrementY2 = progressHeight * -1.6f;
        float leftIncrementX3 = progressWidth * 0.9f;
        float leftIncrementY3 = progressHeight * -1.0f;
        path.cubicTo(balloonRect.left + balloonRect.width() * 0.25f + leftIncrementX1, balloonRect.centerY() - balloonRect.height() * 0.4f + leftIncrementY1, balloonRect.left - balloonRect.width() * 0.2f + leftIncrementX2, balloonRect.centerY() + balloonRect.height() * 1.15f + leftIncrementY2, balloonRect.left - balloonRect.width() * 0.4f + leftIncrementX3, balloonRect.bottom + leftIncrementY3);
        float rightIncrementX1 = progressWidth * 1.51f;
        float rightIncrementY1 = progressHeight * -0.05f;
        float rightIncrementX2 = progressWidth * 0.03f;
        float rightIncrementY2 = progressHeight * 0.5f;
        float rightIncrementX3 = 0.0f;
        float rightIncrementY3 = 0.0f;
        path.cubicTo(balloonRect.left - balloonRect.width() * 0.38f + rightIncrementX1, balloonRect.centerY() - balloonRect.height() * 0.4f + rightIncrementY1, balloonRect.left + balloonRect.width() * 1.1f + rightIncrementX2, balloonRect.centerY() - balloonRect.height() * 0.15f + rightIncrementY2, balloonRect.left + balloonRect.width() * 0.5f + rightIncrementX3, balloonRect.bottom + rightIncrementY3);
        return path;
    }

    @Override
    protected void setAlpha(int alpha) {
        this.mPaint.setAlpha(alpha);
    }

    @Override
    protected void setColorFilter(ColorFilter cf) {
        this.mPaint.setColorFilter(cf);
    }

    @Override
    protected void reset() {
    }

    public static class Builder {
        private Context mContext;

        public Builder(Context mContext) {
            this.mContext = mContext;
        }

        public BalloonLoadingRenderer build() {
            BalloonLoadingRenderer loadingRenderer = new BalloonLoadingRenderer(this.mContext);
            return loadingRenderer;
        }
    }
}

