/*
 * Decompiled with CFR 0.152.
 */
package com.taiyi.typulse.tyusbsdk.pulse.util.scenery;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import androidx.interpolator.view.animation.FastOutLinearInInterpolator;
import androidx.interpolator.view.animation.FastOutSlowInInterpolator;
import com.taiyi.typulse.tyusbsdk.pulse.util.DensityUtil;
import com.taiyi.typulse.tyusbsdk.pulse.util.LoadingRenderer;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class DayNightLoadingRenderer
extends LoadingRenderer {
    private static final Interpolator MATERIAL_INTERPOLATOR = new FastOutSlowInInterpolator();
    private static final Interpolator LINEAR_INTERPOLATOR = new LinearInterpolator();
    private static final Interpolator DECELERATE_INTERPOLATOR = new DecelerateInterpolator();
    private static final Interpolator ACCELERATE_INTERPOLATOR = new AccelerateInterpolator();
    private static final Interpolator FASTOUTLINEARIN_INTERPOLATOR = new FastOutLinearInInterpolator();
    private static final Interpolator[] INTERPOLATORS = new Interpolator[]{LINEAR_INTERPOLATOR, DECELERATE_INTERPOLATOR, ACCELERATE_INTERPOLATOR, FASTOUTLINEARIN_INTERPOLATOR, MATERIAL_INTERPOLATOR};
    private static final int MAX_ALPHA = 255;
    private static final int DEGREE_360 = 360;
    private static final int MAX_SUN_RAY_COUNT = 12;
    private static final float DEFAULT_WIDTH = 200.0f;
    private static final float DEFAULT_HEIGHT = 150.0f;
    private static final float DEFAULT_STROKE_WIDTH = 2.5f;
    private static final float DEFAULT_SUN$MOON_RADIUS = 12.0f;
    private static final float DEFAULT_STAR_RADIUS = 2.5f;
    private static final float DEFAULT_SUN_RAY_LENGTH = 10.0f;
    private static final float DEFAULT_SUN_RAY_OFFSET = 3.0f;
    public static final float STAR_RISE_PROGRESS_OFFSET = 0.2f;
    public static final float STAR_DECREASE_PROGRESS_OFFSET = 0.8f;
    public static final float STAR_FLASH_PROGRESS_PERCENTAGE = 0.2f;
    private static final float MAX_SUN_ROTATE_DEGREE = 120.0f;
    private static final float MAX_MOON_ROTATE_DEGREE = 60.0f;
    private static final float SUN_RAY_INTERVAL_DEGREE = 2.1818182f;
    private static final float SUN_RISE_DURATION_OFFSET = 0.143f;
    private static final float SUN_ROTATE_DURATION_OFFSET = 0.492f;
    private static final float SUN_DECREASE_DURATION_OFFSET = 0.57f;
    private static final float MOON_RISE_DURATION_OFFSET = 0.713f;
    private static final float MOON_DECREASE_START_DURATION_OFFSET = 0.935f;
    private static final float MOON_DECREASE_END_DURATION_OFFSET = 1.0f;
    private static final float STAR_RISE_START_DURATION_OFFSET = 0.684f;
    private static final float STAR_DECREASE_START_DURATION_OFFSET = 1.0f;
    private static final int DEFAULT_COLOR = Color.parseColor((String)"#ff21fd8e");
    private static final long ANIMATION_DURATION = 5111L;
    private final Random mRandom = new Random();
    private final List<StarHolder> mStarHolders = new ArrayList<StarHolder>();
    private final Paint mPaint = new Paint();
    private final RectF mTempBounds = new RectF();
    private final Animator.AnimatorListener mAnimatorListener = new AnimatorListenerAdapter(){

        public void onAnimationRepeat(Animator animator) {
            super.onAnimationRepeat(animator);
        }
    };
    private int mCurrentColor;
    private float mMaxStarOffsets;
    private float mStrokeWidth;
    private float mStarRadius;
    private float mSun$MoonRadius;
    private float mSunCoordinateY;
    private float mMoonCoordinateY;
    private float mSunRayEndCoordinateY;
    private float mSunRayStartCoordinateY;
    private float mInitSun$MoonCoordinateY;
    private float mMaxSun$MoonRiseDistance;
    private float mSunRayRotation;
    private float mMoonRotation;
    private boolean mIsExpandSunRay;
    private boolean mShowStar;
    private int mSunRayCount;

    private DayNightLoadingRenderer(Context context) {
        super(context);
        this.init(context);
        this.setupPaint();
        this.addRenderListener(this.mAnimatorListener);
    }

    private void init(Context context) {
        this.mWidth = DensityUtil.dip2px(context, 200.0f);
        this.mHeight = DensityUtil.dip2px(context, 150.0f);
        this.mStrokeWidth = DensityUtil.dip2px(context, 2.5f);
        this.mStarRadius = DensityUtil.dip2px(context, 2.5f);
        this.mSun$MoonRadius = DensityUtil.dip2px(context, 12.0f);
        this.mInitSun$MoonCoordinateY = this.mHeight + this.mSun$MoonRadius + this.mStrokeWidth * 2.0f;
        this.mMaxSun$MoonRiseDistance = this.mHeight / 2.0f + this.mSun$MoonRadius;
        this.mSunRayStartCoordinateY = this.mInitSun$MoonCoordinateY - this.mMaxSun$MoonRiseDistance - this.mSun$MoonRadius - this.mStrokeWidth - DensityUtil.dip2px(context, 3.0f);
        this.mSunRayEndCoordinateY = this.mSunRayStartCoordinateY - DensityUtil.dip2px(context, 10.0f) + this.mStrokeWidth;
        this.mSunCoordinateY = this.mInitSun$MoonCoordinateY;
        this.mMoonCoordinateY = this.mInitSun$MoonCoordinateY;
        this.mCurrentColor = DEFAULT_COLOR;
        this.mDuration = 5111L;
    }

    private void setupPaint() {
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStrokeWidth(this.mStrokeWidth);
        this.mPaint.setStrokeJoin(Paint.Join.ROUND);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
    }

    @Override
    protected void draw(Canvas canvas, Rect bounds) {
        int i;
        int saveCount = canvas.save();
        RectF arcBounds = this.mTempBounds;
        arcBounds.set(bounds);
        this.mPaint.setAlpha(255);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setColor(this.mCurrentColor);
        if (this.mSunCoordinateY < this.mInitSun$MoonCoordinateY) {
            canvas.drawCircle(arcBounds.centerX(), this.mSunCoordinateY, this.mSun$MoonRadius, this.mPaint);
        }
        if (this.mMoonCoordinateY < this.mInitSun$MoonCoordinateY) {
            int moonSaveCount = canvas.save();
            canvas.rotate(this.mMoonRotation, arcBounds.centerX(), this.mMoonCoordinateY);
            canvas.drawPath(this.createMoonPath(arcBounds.centerX(), this.mMoonCoordinateY), this.mPaint);
            canvas.restoreToCount(moonSaveCount);
        }
        for (i = 0; i < this.mSunRayCount; ++i) {
            int sunRaySaveCount = canvas.save();
            canvas.rotate(45.0f - this.mSunRayRotation + (float)((this.mIsExpandSunRay ? i : 12 - i) * 360 / 12), arcBounds.centerX(), this.mSunCoordinateY);
            canvas.drawLine(arcBounds.centerX(), this.mSunRayStartCoordinateY, arcBounds.centerX(), this.mSunRayEndCoordinateY, this.mPaint);
            canvas.restoreToCount(sunRaySaveCount);
        }
        if (this.mShowStar) {
            if (this.mStarHolders.isEmpty()) {
                this.initStarHolders(arcBounds);
            }
            for (i = 0; i < this.mStarHolders.size(); ++i) {
                this.mPaint.setStyle(Paint.Style.FILL);
                this.mPaint.setAlpha(this.mStarHolders.get((int)i).mAlpha);
                canvas.drawCircle(this.mStarHolders.get((int)i).mCurrentPoint.x, this.mStarHolders.get((int)i).mCurrentPoint.y, this.mStarRadius, this.mPaint);
            }
        }
        canvas.restoreToCount(saveCount);
    }

    @Override
    protected void computeRender(float renderProgress) {
        if (renderProgress <= 0.143f) {
            float sunRiseProgress = renderProgress / 0.143f;
            this.mSunCoordinateY = this.mInitSun$MoonCoordinateY - this.mMaxSun$MoonRiseDistance * MATERIAL_INTERPOLATOR.getInterpolation(sunRiseProgress);
            this.mMoonCoordinateY = this.mInitSun$MoonCoordinateY;
            this.mShowStar = false;
        }
        if (renderProgress <= 0.492f && renderProgress > 0.143f) {
            float sunRotateProgress = (renderProgress - 0.143f) / 0.349f;
            this.mSunRayRotation = sunRotateProgress * 120.0f;
            if ((int)(this.mSunRayRotation / 2.1818182f) <= 12) {
                this.mIsExpandSunRay = true;
                this.mSunRayCount = (int)(this.mSunRayRotation / 2.1818182f);
            }
            if ((int)((120.0f - this.mSunRayRotation) / 2.1818182f) <= 12) {
                this.mIsExpandSunRay = false;
                this.mSunRayCount = (int)((120.0f - this.mSunRayRotation) / 2.1818182f);
            }
        }
        if (renderProgress <= 0.57f && renderProgress > 0.492f) {
            float sunDecreaseProgress = (renderProgress - 0.492f) / 0.07799998f;
            this.mSunCoordinateY = this.mInitSun$MoonCoordinateY - this.mMaxSun$MoonRiseDistance * (1.0f - ACCELERATE_INTERPOLATOR.getInterpolation(sunDecreaseProgress));
        }
        if (renderProgress <= 0.713f && renderProgress > 0.57f) {
            float moonRiseProgress = (renderProgress - 0.57f) / 0.143f;
            this.mMoonRotation = MATERIAL_INTERPOLATOR.getInterpolation(moonRiseProgress) * 60.0f;
            this.mSunCoordinateY = this.mInitSun$MoonCoordinateY;
            this.mMoonCoordinateY = this.mInitSun$MoonCoordinateY - this.mMaxSun$MoonRiseDistance * MATERIAL_INTERPOLATOR.getInterpolation(moonRiseProgress);
        }
        if (renderProgress <= 1.0f && renderProgress > 0.684f) {
            StarHolder starHolder;
            int i;
            float starProgress = (renderProgress - 0.684f) / 0.31599998f;
            if (starProgress <= 0.2f) {
                for (i = 0; i < this.mStarHolders.size(); ++i) {
                    starHolder = this.mStarHolders.get(i);
                    starHolder.mCurrentPoint.y = starHolder.mPoint.y - (1.0f - starHolder.mInterpolator.getInterpolation(starProgress * 5.0f)) * (this.mMaxStarOffsets * 0.65f);
                    starHolder.mCurrentPoint.x = starHolder.mPoint.x;
                }
            }
            if (starProgress > 0.2f && starProgress < 0.8f) {
                for (i = 0; i < this.mStarHolders.size(); ++i) {
                    starHolder = this.mStarHolders.get(i);
                    if (!(starHolder.mFlashOffset < starProgress) || !(starProgress < starHolder.mFlashOffset + 0.2f)) continue;
                    starHolder.mAlpha = (int)(255.0f * MATERIAL_INTERPOLATOR.getInterpolation(Math.abs(starProgress - (starHolder.mFlashOffset + 0.1f)) / 0.1f));
                }
            }
            if (starProgress >= 0.8f) {
                for (i = 0; i < this.mStarHolders.size(); ++i) {
                    starHolder = this.mStarHolders.get(i);
                    starHolder.mCurrentPoint.y = starHolder.mPoint.y + starHolder.mInterpolator.getInterpolation((starProgress - 0.8f) * 5.0f) * this.mMaxStarOffsets;
                    starHolder.mCurrentPoint.x = starHolder.mPoint.x;
                }
            }
            this.mShowStar = true;
        }
        if (renderProgress <= 1.0f && renderProgress > 0.935f) {
            float moonDecreaseProgress = (renderProgress - 0.935f) / 0.065f;
            this.mMoonCoordinateY = this.mInitSun$MoonCoordinateY - this.mMaxSun$MoonRiseDistance * (1.0f - ACCELERATE_INTERPOLATOR.getInterpolation(moonDecreaseProgress));
        }
    }

    @Override
    protected void setAlpha(int alpha) {
        this.mPaint.setAlpha(alpha);
    }

    @Override
    protected void setColorFilter(ColorFilter cf) {
        this.mPaint.setColorFilter(cf);
    }

    @Override
    protected void reset() {
    }

    private void initStarHolders(RectF currentBounds) {
        this.mStarHolders.add(new StarHolder(0.3f, new PointF(currentBounds.left + currentBounds.width() * 0.175f, currentBounds.top + currentBounds.height() * 0.0934f)));
        this.mStarHolders.add(new StarHolder(0.2f, new PointF(currentBounds.left + currentBounds.width() * 0.175f, currentBounds.top + currentBounds.height() * 0.62f)));
        this.mStarHolders.add(new StarHolder(0.2f, new PointF(currentBounds.left + currentBounds.width() * 0.2525f, currentBounds.top + currentBounds.height() * 0.43f)));
        this.mStarHolders.add(new StarHolder(0.5f, new PointF(currentBounds.left + currentBounds.width() * 0.4075f, currentBounds.top + currentBounds.height() * 0.0934f)));
        this.mStarHolders.add(new StarHolder(new PointF(currentBounds.left + currentBounds.width() * 0.825f, currentBounds.top + currentBounds.height() * 0.04f)));
        this.mStarHolders.add(new StarHolder(new PointF(currentBounds.left + currentBounds.width() * 0.7075f, currentBounds.top + currentBounds.height() * 0.147f)));
        this.mStarHolders.add(new StarHolder(new PointF(currentBounds.left + currentBounds.width() * 0.3475f, currentBounds.top + currentBounds.height() * 0.2567f)));
        this.mStarHolders.add(new StarHolder(0.6f, new PointF(currentBounds.left + currentBounds.width() * 0.5825f, currentBounds.top + currentBounds.height() * 0.277f)));
        this.mStarHolders.add(new StarHolder(new PointF(currentBounds.left + currentBounds.width() * 0.84f, currentBounds.top + currentBounds.height() * 0.32f)));
        this.mStarHolders.add(new StarHolder(new PointF(currentBounds.left + currentBounds.width() * 0.8f, currentBounds.top + currentBounds.height() / 0.502f)));
        this.mStarHolders.add(new StarHolder(0.6f, new PointF(currentBounds.left + currentBounds.width() * 0.7f, currentBounds.top + currentBounds.height() * 0.473f)));
        this.mMaxStarOffsets = currentBounds.height();
    }

    private Path createMoonPath(float moonCenterX, float moonCenterY) {
        RectF moonRectF = new RectF(moonCenterX - this.mSun$MoonRadius, moonCenterY - this.mSun$MoonRadius, moonCenterX + this.mSun$MoonRadius, moonCenterY + this.mSun$MoonRadius);
        Path path = new Path();
        path.addArc(moonRectF, -90.0f, 180.0f);
        path.quadTo(moonCenterX + this.mSun$MoonRadius / 2.0f, moonCenterY, moonCenterX, moonCenterY - this.mSun$MoonRadius);
        return path;
    }

    private class StarHolder {
        public int mAlpha = 255;
        public PointF mCurrentPoint = new PointF();
        public final PointF mPoint;
        public final float mFlashOffset;
        public final Interpolator mInterpolator;

        public StarHolder(PointF point) {
            this(1.0f, point);
        }

        public StarHolder(float flashOffset, PointF mPoint) {
            this.mPoint = mPoint;
            this.mFlashOffset = flashOffset;
            this.mInterpolator = INTERPOLATORS[DayNightLoadingRenderer.this.mRandom.nextInt(INTERPOLATORS.length)];
        }
    }

    public static class Builder {
        private Context mContext;

        public Builder(Context mContext) {
            this.mContext = mContext;
        }

        public DayNightLoadingRenderer build() {
            DayNightLoadingRenderer loadingRenderer = new DayNightLoadingRenderer(this.mContext);
            return loadingRenderer;
        }
    }
}

