/*
 * Decompiled with CFR 0.152.
 */
package com.taiyi.typulse.tyusbsdk.pulse.util.shapechange;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathMeasure;
import android.graphics.Rect;
import android.graphics.RectF;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import com.taiyi.typulse.tyusbsdk.pulse.util.DensityUtil;
import com.taiyi.typulse.tyusbsdk.pulse.util.LoadingRenderer;

public class CircleBroodLoadingRenderer
extends LoadingRenderer {
    private final Interpolator MOTHER_MOVE_INTERPOLATOR = new MotherMoveInterpolator();
    private final Interpolator CHILD_MOVE_INTERPOLATOR = new ChildMoveInterpolator();
    private final Interpolator ACCELERATE_INTERPOLATOR03 = new AccelerateInterpolator(0.3f);
    private final Interpolator ACCELERATE_INTERPOLATOR05 = new AccelerateInterpolator(0.5f);
    private final Interpolator ACCELERATE_INTERPOLATOR08 = new AccelerateInterpolator(0.8f);
    private final Interpolator ACCELERATE_INTERPOLATOR10 = new AccelerateInterpolator(1.0f);
    private final Interpolator DECELERATE_INTERPOLATOR03 = new DecelerateInterpolator(0.3f);
    private final Interpolator DECELERATE_INTERPOLATOR05 = new DecelerateInterpolator(0.5f);
    private final Interpolator DECELERATE_INTERPOLATOR08 = new DecelerateInterpolator(0.8f);
    private final Interpolator DECELERATE_INTERPOLATOR10 = new DecelerateInterpolator(1.0f);
    private float STAGE_MOTHER_FORWARD_TOP_LEFT = 0.34f;
    private float STAGE_MOTHER_BACKWARD_TOP_LEFT = 0.5f;
    private float STAGE_MOTHER_FORWARD_BOTTOM_LEFT = 0.65f;
    private float STAGE_MOTHER_BACKWARD_BOTTOM_LEFT = 0.833f;
    private float STAGE_CHILD_DELAY = 0.1f;
    private float STAGE_CHILD_PRE_FORWARD_TOP_LEFT = 0.26f;
    private float STAGE_CHILD_FORWARD_TOP_LEFT = 0.34f;
    private float STAGE_CHILD_PRE_BACKWARD_TOP_LEFT = 0.42f;
    private float STAGE_CHILD_BACKWARD_TOP_LEFT = 0.5f;
    private float STAGE_CHILD_FORWARD_BOTTOM_LEFT = 0.7f;
    private float STAGE_CHILD_BACKWARD_BOTTOM_LEFT = 0.9f;
    private final float OVAL_BEZIER_FACTOR = 0.55152f;
    private final float DEFAULT_WIDTH = 200.0f;
    private final float DEFAULT_HEIGHT = 150.0f;
    private final float MAX_MATHER_OVAL_SIZE = 19.0f;
    private final float MIN_CHILD_OVAL_RADIUS = 5.0f;
    private final float MAX_MATHER_SHAPE_CHANGE_FACTOR = 0.8452f;
    private final int DEFAULT_OVAL_COLOR = Color.parseColor((String)"#FFBE1C23");
    private final int DEFAULT_OVAL_DEEP_COLOR = Color.parseColor((String)"#FFB21721");
    private final int DEFAULT_BACKGROUND_COLOR = Color.parseColor((String)"#FFE3C172");
    private final int DEFAULT_BACKGROUND_DEEP_COLOR = Color.parseColor((String)"#FFE2B552");
    private final long ANIMATION_DURATION = 4111L;
    private final Paint mPaint = new Paint();
    private final RectF mCurrentBounds = new RectF();
    private final Path mMotherOvalPath = new Path();
    private final Path mMotherMovePath = new Path();
    private final Path mChildMovePath = new Path();
    private final float[] mMotherPosition = new float[2];
    private final float[] mChildPosition = new float[2];
    private final PathMeasure mMotherMovePathMeasure = new PathMeasure();
    private final PathMeasure mChildMovePathMeasure = new PathMeasure();
    private float mChildOvalRadius;
    private float mBasicChildOvalRadius;
    private float mMaxMotherOvalSize;
    private float mMotherOvalHalfWidth;
    private float mMotherOvalHalfHeight;
    private float mChildLeftXOffset;
    private float mChildLeftYOffset;
    private float mChildRightXOffset;
    private float mChildRightYOffset;
    private int mOvalColor;
    private int mOvalDeepColor;
    private int mBackgroundColor;
    private int mBackgroundDeepColor;
    private int mCurrentOvalColor;
    private int mCurrentBackgroundColor;
    private int mRevealCircleRadius;
    private int mMaxRevealCircleRadius;
    private int mRotateDegrees;
    private float mStageMotherForwardTopLeftLength;
    private float mStageMotherBackwardTopLeftLength;
    private float mStageMotherForwardBottomLeftLength;
    private float mStageMotherBackwardBottomLeftLength;
    private float mStageChildPreForwardTopLeftLength;
    private float mStageChildForwardTopLeftLength;
    private float mStageChildPreBackwardTopLeftLength;
    private float mStageChildBackwardTopLeftLength;
    private float mStageChildForwardBottomLeftLength;
    private float mStageChildBackwardBottomLeftLength;

    private CircleBroodLoadingRenderer(Context context) {
        super(context);
        this.init(context);
        this.setupPaint();
    }

    private void init(Context context) {
        this.mWidth = DensityUtil.dip2px(context, 200.0f);
        this.mHeight = DensityUtil.dip2px(context, 150.0f);
        this.mMaxMotherOvalSize = DensityUtil.dip2px(context, 19.0f);
        this.mBasicChildOvalRadius = DensityUtil.dip2px(context, 5.0f);
        this.mOvalColor = this.DEFAULT_OVAL_COLOR;
        this.mOvalDeepColor = this.DEFAULT_OVAL_DEEP_COLOR;
        this.mBackgroundColor = this.DEFAULT_BACKGROUND_COLOR;
        this.mBackgroundDeepColor = this.DEFAULT_BACKGROUND_DEEP_COLOR;
        this.mMotherOvalHalfWidth = this.mMaxMotherOvalSize;
        this.mMotherOvalHalfHeight = this.mMaxMotherOvalSize;
        this.mMaxRevealCircleRadius = (int)(Math.sqrt(this.mWidth * this.mWidth + this.mHeight * this.mHeight) / 2.0 + 1.0);
        this.mDuration = 4111L;
    }

    private void setupPaint() {
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setStrokeWidth(1.0f);
    }

    @Override
    protected void draw(Canvas canvas, Rect bounds) {
        int saveCount = canvas.save();
        RectF arcBounds = this.mCurrentBounds;
        arcBounds.set(bounds);
        canvas.drawColor(this.mCurrentBackgroundColor);
        if (this.mRevealCircleRadius > 0) {
            this.mPaint.setColor(this.mCurrentBackgroundColor == this.mBackgroundColor ? this.mBackgroundDeepColor : this.mBackgroundColor);
            canvas.drawCircle(arcBounds.centerX(), arcBounds.centerY(), (float)this.mRevealCircleRadius, this.mPaint);
        }
        this.mPaint.setColor(this.mCurrentOvalColor);
        int motherSaveCount = canvas.save();
        canvas.rotate((float)this.mRotateDegrees, this.mMotherPosition[0], this.mMotherPosition[1]);
        canvas.drawPath(this.createMotherPath(), this.mPaint);
        canvas.drawPath(this.createLinkPath(), this.mPaint);
        canvas.restoreToCount(motherSaveCount);
        int childSaveCount = canvas.save();
        canvas.rotate((float)this.mRotateDegrees, this.mChildPosition[0], this.mChildPosition[1]);
        canvas.drawPath(this.createChildPath(), this.mPaint);
        canvas.restoreToCount(childSaveCount);
        canvas.restoreToCount(saveCount);
    }

    private Path createMotherPath() {
        this.mMotherOvalPath.reset();
        this.mMotherOvalPath.addOval(new RectF(this.mMotherPosition[0] - this.mMotherOvalHalfWidth, this.mMotherPosition[1] - this.mMotherOvalHalfHeight, this.mMotherPosition[0] + this.mMotherOvalHalfWidth, this.mMotherPosition[1] + this.mMotherOvalHalfHeight), Path.Direction.CW);
        return this.mMotherOvalPath;
    }

    private Path createChildPath() {
        float bezierOffset = this.mChildOvalRadius * 0.55152f;
        Path path = new Path();
        path.moveTo(this.mChildPosition[0], this.mChildPosition[1] - this.mChildOvalRadius);
        path.cubicTo(this.mChildPosition[0] - bezierOffset - this.mChildLeftXOffset, this.mChildPosition[1] - this.mChildOvalRadius, this.mChildPosition[0] - this.mChildOvalRadius - this.mChildLeftXOffset, this.mChildPosition[1] - bezierOffset + this.mChildLeftYOffset, this.mChildPosition[0] - this.mChildOvalRadius - this.mChildLeftXOffset, this.mChildPosition[1]);
        path.cubicTo(this.mChildPosition[0] - this.mChildOvalRadius - this.mChildLeftXOffset, this.mChildPosition[1] + bezierOffset - this.mChildLeftYOffset, this.mChildPosition[0] - bezierOffset - this.mChildLeftXOffset, this.mChildPosition[1] + this.mChildOvalRadius, this.mChildPosition[0], this.mChildPosition[1] + this.mChildOvalRadius);
        path.cubicTo(this.mChildPosition[0] + bezierOffset + this.mChildRightXOffset, this.mChildPosition[1] + this.mChildOvalRadius, this.mChildPosition[0] + this.mChildOvalRadius + this.mChildRightXOffset, this.mChildPosition[1] + bezierOffset - this.mChildRightYOffset, this.mChildPosition[0] + this.mChildOvalRadius + this.mChildRightXOffset, this.mChildPosition[1]);
        path.cubicTo(this.mChildPosition[0] + this.mChildOvalRadius + this.mChildRightXOffset, this.mChildPosition[1] - bezierOffset + this.mChildRightYOffset, this.mChildPosition[0] + bezierOffset + this.mChildRightXOffset, this.mChildPosition[1] - this.mChildOvalRadius, this.mChildPosition[0], this.mChildPosition[1] - this.mChildOvalRadius);
        return path;
    }

    private Path createLinkPath() {
        Path path = new Path();
        float bezierOffset = this.mMotherOvalHalfWidth * 0.55152f;
        float distance = (float)Math.sqrt(Math.pow(this.mMotherPosition[0] - this.mChildPosition[0], 2.0) + Math.pow(this.mMotherPosition[1] - this.mChildPosition[1], 2.0));
        if (distance <= this.mMotherOvalHalfWidth + this.mChildOvalRadius * 1.2f && distance >= this.mMotherOvalHalfWidth - this.mChildOvalRadius * 1.2f) {
            float maxOffsetY = 2.0f * this.mChildOvalRadius * 1.2f;
            float offsetRate = (distance - (this.mMotherOvalHalfWidth - this.mChildOvalRadius * 1.2f)) / maxOffsetY;
            float mMotherOvalOffsetY = this.mMotherOvalHalfHeight - offsetRate * (this.mMotherOvalHalfHeight - this.mChildOvalRadius) * 0.85f;
            this.mMotherOvalPath.addOval(new RectF(this.mMotherPosition[0] - this.mMotherOvalHalfWidth, this.mMotherPosition[1] - mMotherOvalOffsetY, this.mMotherPosition[0] + this.mMotherOvalHalfWidth, this.mMotherPosition[1] + mMotherOvalOffsetY), Path.Direction.CW);
            float mMotherXOffset = distance - this.mMotherOvalHalfWidth + this.mChildOvalRadius;
            float distanceUltraLeft = (float)Math.sqrt(Math.pow(this.mMotherPosition[0] - this.mMotherOvalHalfWidth - this.mChildPosition[0], 2.0) + Math.pow(this.mMotherPosition[1] - this.mChildPosition[1], 2.0));
            float distanceUltraRight = (float)Math.sqrt(Math.pow(this.mMotherPosition[0] + this.mMotherOvalHalfWidth - this.mChildPosition[0], 2.0) + Math.pow(this.mMotherPosition[1] - this.mChildPosition[1], 2.0));
            path.moveTo(this.mMotherPosition[0], this.mMotherPosition[1] + mMotherOvalOffsetY);
            if (distanceUltraRight < distanceUltraLeft) {
                path.cubicTo(this.mMotherPosition[0] + bezierOffset + mMotherXOffset, this.mMotherPosition[1] + mMotherOvalOffsetY, this.mMotherPosition[0] + distance + this.mChildOvalRadius, this.mMotherPosition[1] + this.mChildOvalRadius * 1.5f, this.mMotherPosition[0] + distance + this.mChildOvalRadius, this.mMotherPosition[1]);
                path.cubicTo(this.mMotherPosition[0] + distance + this.mChildOvalRadius, this.mMotherPosition[1] - this.mChildOvalRadius * 1.5f, this.mMotherPosition[0] + bezierOffset + mMotherXOffset, this.mMotherPosition[1] - mMotherOvalOffsetY, this.mMotherPosition[0], this.mMotherPosition[1] - mMotherOvalOffsetY);
            } else {
                path.cubicTo(this.mMotherPosition[0] - bezierOffset - mMotherXOffset, this.mMotherPosition[1] + mMotherOvalOffsetY, this.mMotherPosition[0] - distance - this.mChildOvalRadius, this.mMotherPosition[1] + this.mChildOvalRadius * 1.5f, this.mMotherPosition[0] - distance - this.mChildOvalRadius, this.mMotherPosition[1]);
                path.cubicTo(this.mMotherPosition[0] - distance - this.mChildOvalRadius, this.mMotherPosition[1] - this.mChildOvalRadius * 1.5f, this.mMotherPosition[0] - bezierOffset - mMotherXOffset, this.mMotherPosition[1] - mMotherOvalOffsetY, this.mMotherPosition[0], this.mMotherPosition[1] - mMotherOvalOffsetY);
            }
            path.lineTo(this.mMotherPosition[0], this.mMotherPosition[1] + mMotherOvalOffsetY);
        }
        return path;
    }

    @Override
    protected void computeRender(float renderProgress) {
        if (this.mCurrentBounds.isEmpty()) {
            return;
        }
        if (this.mMotherMovePath.isEmpty()) {
            this.mMotherMovePath.set(this.createMotherMovePath());
            this.mMotherMovePathMeasure.setPath(this.mMotherMovePath, false);
            this.mChildMovePath.set(this.createChildMovePath());
            this.mChildMovePathMeasure.setPath(this.mChildMovePath, false);
        }
        float motherMoveProgress = this.MOTHER_MOVE_INTERPOLATOR.getInterpolation(renderProgress);
        this.mMotherMovePathMeasure.getPosTan(this.getCurrentMotherMoveLength(motherMoveProgress), this.mMotherPosition, null);
        this.mMotherOvalHalfWidth = this.mMaxMotherOvalSize;
        this.mMotherOvalHalfHeight = this.mMaxMotherOvalSize * this.getMotherShapeFactor(motherMoveProgress);
        float childMoveProgress = this.CHILD_MOVE_INTERPOLATOR.getInterpolation(renderProgress);
        this.mChildMovePathMeasure.getPosTan(this.getCurrentChildMoveLength(childMoveProgress), this.mChildPosition, null);
        this.setupChildParams(childMoveProgress);
        this.mRotateDegrees = (int)Math.toDegrees(Math.atan((this.mMotherPosition[1] - this.mChildPosition[1]) / (this.mMotherPosition[0] - this.mChildPosition[0])));
        this.mRevealCircleRadius = this.getCurrentRevealCircleRadius(renderProgress);
        this.mCurrentOvalColor = this.getCurrentOvalColor(renderProgress);
        this.mCurrentBackgroundColor = this.getCurrentBackgroundColor(renderProgress);
    }

    private void setupChildParams(float input) {
        this.mChildOvalRadius = this.mBasicChildOvalRadius;
        this.mChildRightXOffset = 0.0f;
        this.mChildLeftXOffset = 0.0f;
        if (input <= this.STAGE_CHILD_PRE_FORWARD_TOP_LEFT) {
            if ((double)input >= 0.25) {
                float shapeProgress = (input - 0.25f) / 0.01f;
                this.mChildLeftXOffset = (1.0f - shapeProgress) * this.mChildOvalRadius * 0.25f;
            } else {
                this.mChildLeftXOffset = this.mChildOvalRadius * 0.25f;
            }
        } else if (input <= this.STAGE_CHILD_FORWARD_TOP_LEFT) {
            if (input > 0.275f && input < 0.285f) {
                float shapeProgress = (input - 0.275f) / 0.01f;
                this.mChildLeftXOffset = shapeProgress * this.mChildOvalRadius * 0.25f;
            } else if (input > 0.285f) {
                this.mChildLeftXOffset = this.mChildOvalRadius * 0.25f;
            }
        } else if (input <= this.STAGE_CHILD_PRE_BACKWARD_TOP_LEFT) {
            if (input > 0.38f) {
                float radiusProgress = (input - 0.38f) / 0.04f;
                this.mChildOvalRadius = this.mBasicChildOvalRadius * (1.0f + radiusProgress);
            }
        } else if (input <= this.STAGE_CHILD_BACKWARD_TOP_LEFT) {
            if (input < 0.46f) {
                float radiusProgress = (input - 0.42f) / 0.04f;
                this.mChildOvalRadius = this.mBasicChildOvalRadius * (2.0f - radiusProgress);
            }
        } else if (input <= this.STAGE_CHILD_FORWARD_BOTTOM_LEFT) {
            if (input > 0.65f) {
                float radiusProgress = (input - 0.65f) / 0.05f;
                this.mChildOvalRadius = this.mBasicChildOvalRadius * (1.0f + radiusProgress);
            }
        } else if (input <= this.STAGE_CHILD_BACKWARD_BOTTOM_LEFT) {
            if (input < 0.71f) {
                this.mChildOvalRadius = this.mBasicChildOvalRadius * 2.0f;
            } else if (input < 0.76f) {
                float radiusProgress = (input - 0.71f) / 0.05f;
                this.mChildOvalRadius = this.mBasicChildOvalRadius * (2.0f - radiusProgress);
            }
        }
        this.mChildRightYOffset = this.mChildRightXOffset / 2.5f;
        this.mChildLeftYOffset = this.mChildLeftXOffset / 2.5f;
    }

    private float getMotherShapeFactor(float input) {
        float shapeProgress = input <= this.STAGE_MOTHER_FORWARD_TOP_LEFT ? input / this.STAGE_MOTHER_FORWARD_TOP_LEFT : (input <= this.STAGE_MOTHER_BACKWARD_TOP_LEFT ? (input - this.STAGE_MOTHER_FORWARD_TOP_LEFT) / (this.STAGE_MOTHER_BACKWARD_TOP_LEFT - this.STAGE_MOTHER_FORWARD_TOP_LEFT) : (input <= this.STAGE_MOTHER_FORWARD_BOTTOM_LEFT ? (input - this.STAGE_MOTHER_BACKWARD_TOP_LEFT) / (this.STAGE_MOTHER_FORWARD_BOTTOM_LEFT - this.STAGE_MOTHER_BACKWARD_TOP_LEFT) : (input <= this.STAGE_MOTHER_BACKWARD_BOTTOM_LEFT ? (input - this.STAGE_MOTHER_FORWARD_BOTTOM_LEFT) / (this.STAGE_MOTHER_BACKWARD_BOTTOM_LEFT - this.STAGE_MOTHER_FORWARD_BOTTOM_LEFT) : 1.0f)));
        return shapeProgress < 0.5f ? 1.0f - 0.1548f * shapeProgress * 2.0f : 0.8452f + 0.1548f * (shapeProgress - 0.5f) * 2.0f;
    }

    private float getCurrentMotherMoveLength(float input) {
        float currentStartDistance = 0.0f;
        float currentStageDistance = 0.0f;
        float currentStateStartProgress = 0.0f;
        float currentStateEndProgress = 0.0f;
        if (input > 0.0f) {
            currentStartDistance += currentStageDistance;
            currentStageDistance = this.mStageMotherForwardTopLeftLength;
            currentStateStartProgress = 0.0f;
            currentStateEndProgress = this.STAGE_MOTHER_FORWARD_TOP_LEFT;
        }
        if (input > this.STAGE_MOTHER_FORWARD_TOP_LEFT) {
            currentStartDistance += currentStageDistance;
            currentStageDistance = this.mStageMotherBackwardTopLeftLength;
            currentStateStartProgress = this.STAGE_MOTHER_FORWARD_TOP_LEFT;
            currentStateEndProgress = this.STAGE_MOTHER_BACKWARD_TOP_LEFT;
        }
        if (input > this.STAGE_MOTHER_BACKWARD_TOP_LEFT) {
            currentStartDistance += currentStageDistance;
            currentStageDistance = this.mStageMotherForwardBottomLeftLength;
            currentStateStartProgress = this.STAGE_MOTHER_BACKWARD_TOP_LEFT;
            currentStateEndProgress = this.STAGE_MOTHER_FORWARD_BOTTOM_LEFT;
        }
        if (input > this.STAGE_MOTHER_FORWARD_BOTTOM_LEFT) {
            currentStartDistance += currentStageDistance;
            currentStageDistance = this.mStageMotherBackwardBottomLeftLength;
            currentStateStartProgress = this.STAGE_MOTHER_FORWARD_BOTTOM_LEFT;
            currentStateEndProgress = this.STAGE_MOTHER_BACKWARD_BOTTOM_LEFT;
        }
        if (input > this.STAGE_MOTHER_BACKWARD_BOTTOM_LEFT) {
            return currentStartDistance + currentStageDistance;
        }
        return currentStartDistance + (input - currentStateStartProgress) / (currentStateEndProgress - currentStateStartProgress) * currentStageDistance;
    }

    private float getCurrentChildMoveLength(float input) {
        float currentStartDistance = 0.0f;
        float currentStageDistance = 0.0f;
        float currentStateStartProgress = 0.0f;
        float currentStateEndProgress = 0.0f;
        if (input > 0.0f) {
            currentStartDistance += currentStageDistance;
            currentStageDistance = this.mStageChildPreForwardTopLeftLength;
            currentStateStartProgress = 0.0f;
            currentStateEndProgress = this.STAGE_CHILD_PRE_FORWARD_TOP_LEFT;
        }
        if (input > this.STAGE_CHILD_PRE_FORWARD_TOP_LEFT) {
            currentStartDistance += currentStageDistance;
            currentStageDistance = this.mStageChildForwardTopLeftLength;
            currentStateStartProgress = this.STAGE_CHILD_PRE_FORWARD_TOP_LEFT;
            currentStateEndProgress = this.STAGE_CHILD_FORWARD_TOP_LEFT;
        }
        if (input > this.STAGE_CHILD_FORWARD_TOP_LEFT) {
            currentStartDistance += currentStageDistance;
            currentStageDistance = this.mStageChildPreBackwardTopLeftLength;
            currentStateStartProgress = this.STAGE_CHILD_FORWARD_TOP_LEFT;
            currentStateEndProgress = this.STAGE_CHILD_PRE_BACKWARD_TOP_LEFT;
        }
        if (input > this.STAGE_CHILD_PRE_BACKWARD_TOP_LEFT) {
            currentStartDistance += currentStageDistance;
            currentStageDistance = this.mStageChildBackwardTopLeftLength;
            currentStateStartProgress = this.STAGE_CHILD_PRE_BACKWARD_TOP_LEFT;
            currentStateEndProgress = this.STAGE_CHILD_BACKWARD_TOP_LEFT;
        }
        if (input > this.STAGE_CHILD_BACKWARD_TOP_LEFT) {
            currentStartDistance += currentStageDistance;
            currentStageDistance = this.mStageChildForwardBottomLeftLength;
            currentStateStartProgress = this.STAGE_CHILD_BACKWARD_TOP_LEFT;
            currentStateEndProgress = this.STAGE_CHILD_FORWARD_BOTTOM_LEFT;
        }
        if (input > this.STAGE_CHILD_FORWARD_BOTTOM_LEFT) {
            currentStartDistance += currentStageDistance;
            currentStageDistance = this.mStageChildBackwardBottomLeftLength;
            currentStateStartProgress = this.STAGE_CHILD_FORWARD_BOTTOM_LEFT;
            currentStateEndProgress = this.STAGE_CHILD_BACKWARD_BOTTOM_LEFT;
        }
        if (input > this.STAGE_CHILD_BACKWARD_BOTTOM_LEFT) {
            return currentStartDistance + currentStageDistance;
        }
        return currentStartDistance + (input - currentStateStartProgress) / (currentStateEndProgress - currentStateStartProgress) * currentStageDistance;
    }

    private Path createMotherMovePath() {
        Path path = new Path();
        float centerX = this.mCurrentBounds.centerX();
        float centerY = this.mCurrentBounds.centerY();
        float currentPathLength = 0.0f;
        path.moveTo(centerX, centerY);
        path.quadTo(centerX - this.mMotherOvalHalfWidth * 2.0f, centerY, centerX - this.mMotherOvalHalfWidth * 2.0f, centerY - this.mMotherOvalHalfHeight);
        this.mStageMotherForwardTopLeftLength = this.getRestLength(path, currentPathLength);
        path.quadTo(centerX - this.mMotherOvalHalfWidth * 1.0f, centerY - this.mMotherOvalHalfHeight, centerX, centerY);
        this.mStageMotherBackwardTopLeftLength = this.getRestLength(path, currentPathLength += this.mStageMotherForwardTopLeftLength);
        path.quadTo(centerX, centerY + this.mMotherOvalHalfHeight, centerX - this.mMotherOvalHalfWidth / 2.0f, centerY + this.mMotherOvalHalfHeight * 1.1f);
        this.mStageMotherForwardBottomLeftLength = this.getRestLength(path, currentPathLength += this.mStageMotherBackwardTopLeftLength);
        path.quadTo(centerX - this.mMotherOvalHalfWidth / 2.0f, centerY + this.mMotherOvalHalfHeight * 0.6f, centerX, centerY);
        this.mStageMotherBackwardBottomLeftLength = this.getRestLength(path, currentPathLength += this.mStageMotherForwardBottomLeftLength);
        return path;
    }

    private Path createChildMovePath() {
        Path path = new Path();
        float centerX = this.mCurrentBounds.centerX();
        float centerY = this.mCurrentBounds.centerY();
        float currentPathLength = 0.0f;
        path.moveTo(centerX, centerY);
        path.lineTo(centerX + this.mMotherOvalHalfWidth * 0.75f, centerY);
        this.mStageChildPreForwardTopLeftLength = this.getRestLength(path, currentPathLength);
        path.quadTo(centerX - this.mMotherOvalHalfWidth * 0.5f, centerY, centerX - this.mMotherOvalHalfWidth * 2.0f, centerY - this.mMotherOvalHalfHeight);
        this.mStageChildForwardTopLeftLength = this.getRestLength(path, currentPathLength += this.mStageChildPreForwardTopLeftLength);
        path.lineTo(centerX - this.mMotherOvalHalfWidth * 2.0f + this.mMotherOvalHalfWidth * 0.2f, centerY - this.mMotherOvalHalfHeight);
        path.quadTo(centerX - this.mMotherOvalHalfWidth * 2.5f, centerY - this.mMotherOvalHalfHeight * 2.0f, centerX - this.mMotherOvalHalfWidth * 1.5f, centerY - this.mMotherOvalHalfHeight * 2.25f);
        this.mStageChildPreBackwardTopLeftLength = this.getRestLength(path, currentPathLength += this.mStageChildForwardTopLeftLength);
        path.quadTo(centerX - this.mMotherOvalHalfWidth * 0.2f, centerY - this.mMotherOvalHalfHeight * 2.25f, centerX, centerY);
        this.mStageChildBackwardTopLeftLength = this.getRestLength(path, currentPathLength += this.mStageChildPreBackwardTopLeftLength);
        path.cubicTo(centerX, centerY + this.mMotherOvalHalfHeight, centerX - this.mMotherOvalHalfWidth, centerY + this.mMotherOvalHalfHeight * 2.5f, centerX - this.mMotherOvalHalfWidth * 1.5f, centerY + this.mMotherOvalHalfHeight * 2.5f);
        this.mStageChildForwardBottomLeftLength = this.getRestLength(path, currentPathLength += this.mStageChildBackwardTopLeftLength);
        path.cubicTo(centerX - this.mMotherOvalHalfWidth * 2.0f, centerY + this.mMotherOvalHalfHeight * 2.5f, centerX - this.mMotherOvalHalfWidth * 3.0f, centerY + this.mMotherOvalHalfHeight * 0.8f, centerX, centerY);
        this.mStageChildBackwardBottomLeftLength = this.getRestLength(path, currentPathLength += this.mStageChildForwardBottomLeftLength);
        return path;
    }

    private int getCurrentRevealCircleRadius(float input) {
        int result = 0;
        if (input > 0.44f && input < 0.48f) {
            result = (int)((input - 0.44f) / 0.04f * (float)this.mMaxRevealCircleRadius);
        }
        if (input > 0.81f && input < 0.85f) {
            result = (int)((input - 0.81f) / 0.04f * (float)this.mMaxRevealCircleRadius);
        }
        return result;
    }

    private int getCurrentBackgroundColor(float input) {
        return input < 0.48f || input > 0.85f ? this.mBackgroundColor : this.mBackgroundDeepColor;
    }

    private int getCurrentOvalColor(float input) {
        int result;
        if (input < 0.5f) {
            result = this.mOvalColor;
        } else if (input < 0.75f) {
            float colorProgress = (input - 0.5f) / 0.2f;
            result = this.evaluateColorChange(colorProgress, this.mOvalColor, this.mOvalDeepColor);
        } else if (input < 0.85f) {
            result = this.mOvalDeepColor;
        } else {
            float colorProgress = (input - 0.9f) / 0.1f;
            result = this.evaluateColorChange(colorProgress, this.mOvalDeepColor, this.mOvalColor);
        }
        return result;
    }

    private int evaluateColorChange(float fraction, int startValue, int endValue) {
        int startA = startValue >> 24 & 0xFF;
        int startR = startValue >> 16 & 0xFF;
        int startG = startValue >> 8 & 0xFF;
        int startB = startValue & 0xFF;
        int endA = endValue >> 24 & 0xFF;
        int endR = endValue >> 16 & 0xFF;
        int endG = endValue >> 8 & 0xFF;
        int endB = endValue & 0xFF;
        return startA + (int)(fraction * (float)(endA - startA)) << 24 | startR + (int)(fraction * (float)(endR - startR)) << 16 | startG + (int)(fraction * (float)(endG - startG)) << 8 | startB + (int)(fraction * (float)(endB - startB));
    }

    private float getRestLength(Path path, float startD) {
        Path tempPath = new Path();
        PathMeasure pathMeasure = new PathMeasure(path, false);
        pathMeasure.getSegment(startD, pathMeasure.getLength(), tempPath, true);
        pathMeasure.setPath(tempPath, false);
        return pathMeasure.getLength();
    }

    @Override
    protected void setAlpha(int alpha) {
        this.mPaint.setAlpha(alpha);
    }

    @Override
    protected void setColorFilter(ColorFilter cf) {
        this.mPaint.setColorFilter(cf);
    }

    @Override
    protected void reset() {
    }

    private class MotherMoveInterpolator
    implements Interpolator {
        private MotherMoveInterpolator() {
        }

        public float getInterpolation(float input) {
            float result = input <= CircleBroodLoadingRenderer.this.STAGE_MOTHER_FORWARD_TOP_LEFT ? CircleBroodLoadingRenderer.this.ACCELERATE_INTERPOLATOR10.getInterpolation(input * 2.941f) / 2.941f : (input <= CircleBroodLoadingRenderer.this.STAGE_MOTHER_BACKWARD_TOP_LEFT ? 0.34f + CircleBroodLoadingRenderer.this.DECELERATE_INTERPOLATOR10.getInterpolation((input - 0.34f) * 6.25f) / 6.25f : (input <= CircleBroodLoadingRenderer.this.STAGE_MOTHER_FORWARD_BOTTOM_LEFT ? 0.5f + CircleBroodLoadingRenderer.this.ACCELERATE_INTERPOLATOR03.getInterpolation((input - 0.5f) * 6.666f) / 4.0f : (input <= CircleBroodLoadingRenderer.this.STAGE_MOTHER_BACKWARD_BOTTOM_LEFT ? 0.75f + CircleBroodLoadingRenderer.this.DECELERATE_INTERPOLATOR03.getInterpolation((input - 0.65f) * 5.46f) / 4.0f : 1.0f)));
            return result;
        }
    }

    private class ChildMoveInterpolator
    implements Interpolator {
        private ChildMoveInterpolator() {
        }

        public float getInterpolation(float input) {
            if (input < CircleBroodLoadingRenderer.this.STAGE_CHILD_DELAY) {
                return 0.0f;
            }
            float result = input <= CircleBroodLoadingRenderer.this.STAGE_CHILD_PRE_FORWARD_TOP_LEFT ? CircleBroodLoadingRenderer.this.DECELERATE_INTERPOLATOR10.getInterpolation((input - 0.1f) * 6.25f) / 3.846f : (input <= CircleBroodLoadingRenderer.this.STAGE_CHILD_FORWARD_TOP_LEFT ? 0.26f + CircleBroodLoadingRenderer.this.ACCELERATE_INTERPOLATOR10.getInterpolation((input - 0.26f) * 12.5f) / 12.5f : (input <= CircleBroodLoadingRenderer.this.STAGE_CHILD_PRE_BACKWARD_TOP_LEFT ? 0.34f + CircleBroodLoadingRenderer.this.DECELERATE_INTERPOLATOR08.getInterpolation((input - 0.34f) * 12.5f) / 12.5f : (input <= CircleBroodLoadingRenderer.this.STAGE_CHILD_BACKWARD_TOP_LEFT ? 0.42f + CircleBroodLoadingRenderer.this.ACCELERATE_INTERPOLATOR08.getInterpolation((input - 0.42f) * 12.5f) / 12.5f : (input <= CircleBroodLoadingRenderer.this.STAGE_CHILD_FORWARD_BOTTOM_LEFT ? 0.5f + CircleBroodLoadingRenderer.this.DECELERATE_INTERPOLATOR05.getInterpolation((input - 0.5f) * 5.0f) / 5.0f : (input <= CircleBroodLoadingRenderer.this.STAGE_CHILD_BACKWARD_BOTTOM_LEFT ? 0.7f + CircleBroodLoadingRenderer.this.ACCELERATE_INTERPOLATOR05.getInterpolation((input - 0.7f) * 5.0f) / 3.33f : 1.0f)))));
            return result;
        }
    }

    public static class Builder {
        private Context mContext;

        public Builder(Context mContext) {
            this.mContext = mContext;
        }

        public CircleBroodLoadingRenderer build() {
            CircleBroodLoadingRenderer loadingRenderer = new CircleBroodLoadingRenderer(this.mContext);
            return loadingRenderer;
        }
    }
}

