/*
 * Decompiled with CFR 0.152.
 */
package com.taiyi.typulse.tyusbsdk.pulse.util.statusbar;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.util.AttributeSet;
import android.widget.LinearLayout;
import androidx.annotation.Nullable;
import com.taiyi.typulse.R;

public class StatusBarHeightView
extends LinearLayout {
    private int statusBarHeight;
    private int type;

    public StatusBarHeightView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public StatusBarHeightView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    public StatusBarHeightView(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    private void init(@Nullable AttributeSet attrs) {
        int resourceId = this.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (Build.VERSION.SDK_INT >= 19) {
            if (resourceId > 0) {
                this.statusBarHeight = this.getResources().getDimensionPixelSize(resourceId);
            }
        } else {
            this.statusBarHeight = 0;
        }
        if (attrs != null) {
            TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.StatusBarHeightView);
            this.type = typedArray.getInt(R.styleable.StatusBarHeightView_use_type, 0);
            typedArray.recycle();
        }
        if (this.type == 1) {
            this.setPadding(this.getPaddingLeft(), this.statusBarHeight, this.getPaddingRight(), this.getPaddingBottom());
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.type == 0) {
            this.setMeasuredDimension(StatusBarHeightView.getDefaultSize((int)this.getSuggestedMinimumWidth(), (int)widthMeasureSpec), this.statusBarHeight);
        } else {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }
}

