/*
 * Decompiled with CFR 0.152.
 */
package com.taiyi.typulse.tyusbsdk.pulse.util.statusbar;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import com.taiyi.typulse.tyusbsdk.pulse.util.OsUtil;
import com.taiyi.typulse.tyusbsdk.pulse.util.statusbar.StatusBarUtil;
import com.taiyi.typulse.tyusbsdk.pulse.util.statusbar.SystemBarTintManager;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class StatusBarUtil {
    public static final int TYPE_MIUI = 0;
    public static final int TYPE_FLYME = 1;
    public static final int TYPE_M = 3;

    public static void setStatusBarColor(Activity activity, int colorId) {
        if (Build.VERSION.SDK_INT >= 21) {
            Window window = activity.getWindow();
            window.setStatusBarColor(colorId);
        } else if (Build.VERSION.SDK_INT >= 19) {
            StatusBarUtil.setTranslucentStatus(activity);
            SystemBarTintManager systemBarTintManager = new SystemBarTintManager(activity);
            systemBarTintManager.setStatusBarTintEnabled(true);
            systemBarTintManager.setStatusBarTintColor(colorId);
        }
    }

    @TargetApi(value=19)
    public static void setTranslucentStatus(Activity activity) {
        if (Build.VERSION.SDK_INT >= 21) {
            Window window = activity.getWindow();
            View decorView = window.getDecorView();
            int option = 1280;
            decorView.setSystemUiVisibility(option);
            window.addFlags(Integer.MIN_VALUE);
            window.setStatusBarColor(0);
        } else if (Build.VERSION.SDK_INT >= 19) {
            Window window = activity.getWindow();
            WindowManager.LayoutParams attributes = window.getAttributes();
            int flagTranslucentStatus = 0x4000000;
            attributes.flags |= flagTranslucentStatus;
            window.setAttributes(attributes);
        }
    }

    public static void setRootViewFitsSystemWindows(Activity activity, boolean fitSystemWindows) {
        ViewGroup rootView;
        ViewGroup winContent;
        if (Build.VERSION.SDK_INT >= 19 && (winContent = (ViewGroup)activity.findViewById(0x1020002)).getChildCount() > 0 && (rootView = (ViewGroup)winContent.getChildAt(0)) != null) {
            rootView.setFitsSystemWindows(fitSystemWindows);
        }
    }

    public static boolean setStatusBarDarkTheme(Activity activity, boolean dark) {
        if (Build.VERSION.SDK_INT >= 19) {
            if (Build.VERSION.SDK_INT >= 23) {
                StatusBarUtil.setStatusBarFontIconDark(activity, 3, dark);
            } else if (OsUtil.isMiui()) {
                StatusBarUtil.setStatusBarFontIconDark(activity, 0, dark);
            } else if (OsUtil.isFlyme()) {
                StatusBarUtil.setStatusBarFontIconDark(activity, 1, dark);
            } else {
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean setStatusBarFontIconDark(Activity activity, @ViewType int type, boolean dark) {
        switch (type) {
            case 0: {
                return StatusBarUtil.setMiuiUI(activity, dark);
            }
            case 1: {
                return StatusBarUtil.setFlymeUI(activity, dark);
            }
        }
        return StatusBarUtil.setCommonUI(activity, dark);
    }

    public static boolean setCommonUI(Activity activity, boolean dark) {
        View decorView;
        if (Build.VERSION.SDK_INT >= 23 && (decorView = activity.getWindow().getDecorView()) != null) {
            int vis = decorView.getSystemUiVisibility();
            vis = dark ? (vis |= 0x2000) : (vis &= 0xFFFFDFFF);
            if (decorView.getSystemUiVisibility() != vis) {
                decorView.setSystemUiVisibility(vis);
            }
            return true;
        }
        return false;
    }

    public static boolean setFlymeUI(Activity activity, boolean dark) {
        try {
            Window window = activity.getWindow();
            WindowManager.LayoutParams lp = window.getAttributes();
            Field darkFlag = WindowManager.LayoutParams.class.getDeclaredField("MEIZU_FLAG_DARK_STATUS_BAR_ICON");
            Field meizuFlags = WindowManager.LayoutParams.class.getDeclaredField("meizuFlags");
            darkFlag.setAccessible(true);
            meizuFlags.setAccessible(true);
            int bit = darkFlag.getInt(null);
            int value = meizuFlags.getInt(lp);
            value = dark ? (value |= bit) : (value &= ~bit);
            meizuFlags.setInt(lp, value);
            window.setAttributes(lp);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean setMiuiUI(Activity activity, boolean dark) {
        try {
            Window window = activity.getWindow();
            Class<?> clazz = activity.getWindow().getClass();
            Class<?> layoutParams = Class.forName("android.view.MiuiWindowManager$LayoutParams");
            Field field = layoutParams.getField("EXTRA_FLAG_STATUS_BAR_DARK_MODE");
            int darkModeFlag = field.getInt(layoutParams);
            Method extraFlagField = clazz.getDeclaredMethod("setExtraFlags", Integer.TYPE, Integer.TYPE);
            extraFlagField.setAccessible(true);
            if (dark) {
                extraFlagField.invoke((Object)window, darkModeFlag, darkModeFlag);
            } else {
                extraFlagField.invoke((Object)window, 0, darkModeFlag);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static int getStatusBarHeight(Context context) {
        int result = 0;
        int resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            result = context.getResources().getDimensionPixelSize(resourceId);
        }
        return result;
    }
}

