/*
 * Decompiled with CFR 0.152.
 */
package com.taiyi.typulse.zhimai.ui.widget;

import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RadialGradient;
import android.graphics.Shader;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import com.taiyi.typulse.R;

public class GradientView
extends View {
    private Paint mPaint = new Paint();
    private float centerX;
    private float centerY;
    private float radius;
    private int colorCenter;
    private int color;
    private int color1;
    private int color2;
    private int color4;
    private int colorBorder;
    private float width;
    private float rate1 = 0.01f;
    private float rate2 = 0.5f;
    private float rate3 = 0.8f;
    private float rate4 = 1.0f;
    private float strokenWidth;
    private ValueAnimator mAnimator;

    public GradientView(Context context) {
        this(context, null);
    }

    public GradientView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.mPaint.setAntiAlias(true);
        this.colorCenter = ContextCompat.getColor((Context)context, (int)R.color.violet);
        this.mPaint.setColor(this.colorCenter);
        this.color = ContextCompat.getColor((Context)context, (int)R.color.gray);
        this.color1 = ContextCompat.getColor((Context)context, (int)R.color.gray_trans1);
        this.color2 = ContextCompat.getColor((Context)context, (int)R.color.gray_trans2);
        this.color4 = ContextCompat.getColor((Context)context, (int)R.color.gray_trans4);
        this.colorBorder = 0;
        this.mPaint.setStyle(Paint.Style.STROKE);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.width = (float)w * 0.88f;
        this.centerX = (float)w / 2.0f;
        this.centerY = (float)h / 2.0f;
        this.radius = (float)h / 2.0f;
        RadialGradient gradient = new RadialGradient(this.centerX, this.centerY, (float)h / 2.0f, new int[]{this.color, this.color1, this.color2, this.colorBorder}, new float[]{this.rate1, this.rate2, this.rate3, this.rate4}, Shader.TileMode.CLAMP);
        this.mPaint.setShader((Shader)gradient);
        this.strokenWidth = this.width;
        this.mPaint.setStrokeWidth(this.strokenWidth);
        this.mAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        this.mAnimator.setDuration(110000L);
        this.mAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float value = ((Float)animation.getAnimatedValue()).floatValue();
                GradientView.this.strokenWidth = GradientView.this.width * (1.0f - value);
                GradientView.this.mPaint.setStrokeWidth(GradientView.this.strokenWidth);
                GradientView.this.invalidate();
            }
        });
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.drawCircle(this.centerX, this.centerY, this.radius, this.mPaint);
    }

    public void end() {
        if (this.mAnimator != null) {
            this.mAnimator.end();
        }
    }

    public void pause() {
        if (this.mAnimator != null) {
            this.mAnimator.pause();
        }
    }

    public void start() {
        if (this.mAnimator != null) {
            this.mAnimator.start();
        }
    }
}

