/*
 * Decompiled with CFR 0.152.
 */
package com.taiyi.typulse.zhimai.ui.widget;

import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.BlurMaskFilter;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.MaskFilter;
import android.graphics.Paint;
import android.graphics.Shader;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import com.taiyi.typulse.R;
import com.taiyi.typulse.zhimai.common.util.AppSizeCalUtil;
import com.taiyi.typulse.zhimai.ui.widget.Ball;
import java.util.ArrayList;
import java.util.List;

public class Pulse3View
extends View {
    private ValueAnimator mAnimator;
    private double secs = 0.015;
    private Paint circleSmallPaint;
    private float progressWidth;
    private float progressMargin;
    private float bottomCircleBigRadius;
    private float bottomCircleSmallRadius;
    private Paint textPaint;
    private int baseline;
    private int text = 0;
    private Paint areaPaint;
    private Paint areaPaintBorder;
    private float endRangeY;
    private int centerX;
    private int centerY;
    private List<Ball> mBalls;
    private int ballCount = 20;
    private float range;

    public Pulse3View(Context context) {
        this(context, null);
    }

    public Pulse3View(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        this.mAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        this.circleSmallPaint = new Paint();
        this.circleSmallPaint.setAntiAlias(true);
        this.circleSmallPaint.setStyle(Paint.Style.FILL);
        this.circleSmallPaint.setColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.yellow));
        this.textPaint = new Paint();
        this.textPaint.setColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.white));
        this.textPaint.setAntiAlias(true);
        this.areaPaint = new Paint();
        this.areaPaintBorder = new Paint();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.centerX = w / 2;
        this.centerY = h / 2;
        this.progressWidth = (float)w * 0.025f;
        this.progressMargin = this.progressWidth * 1.5f;
        this.bottomCircleBigRadius = (float)w * 0.08f;
        this.bottomCircleSmallRadius = (float)w * 0.06f;
        this.initBubblingEffect();
        this.range = (float)this.centerY - this.endRangeY;
        this.initAnimate();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width;
        int height = width = (int)((float)AppSizeCalUtil.getWidth(this.getContext()) * 1.0f * 2.0f / 3.0f);
        width = this.reSize(width, widthMeasureSpec);
        height = this.reSize(height, widthMeasureSpec);
        this.setMeasuredDimension(width, height);
    }

    private int reSize(int size, int measureSpec) {
        int specMode = View.MeasureSpec.getMode((int)measureSpec);
        int specSize = View.MeasureSpec.getSize((int)measureSpec);
        switch (specMode) {
            case 0: {
                return size;
            }
            case -2147483648: {
                if (size <= specSize) {
                    return size;
                }
                return specSize;
            }
            case 0x40000000: {
                return specSize;
            }
        }
        return size;
    }

    private void initAnimate() {
        this.mAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                for (Ball ball : Pulse3View.this.mBalls) {
                    if (ball.x <= ball.leftRangeX) {
                        ball.directRight = true;
                    } else if (ball.x >= ball.rightRangeX) {
                        ball.directRight = false;
                    }
                    ball.x = ball.directRight ? (float)((double)ball.x + (double)ball.vx * Pulse3View.this.secs) : (float)((double)ball.x - (double)ball.vx * Pulse3View.this.secs);
                    ball.y = (float)((double)ball.y - (double)ball.vy * Pulse3View.this.secs);
                    ball.paint.setAlpha((int)((ball.y - Pulse3View.this.endRangeY) * 1.0f / Pulse3View.this.range * 255.0f));
                    if (!(ball.y < ball.rangeY)) continue;
                    ball.reset();
                }
                Pulse3View.this.invalidate();
            }
        });
        this.mAnimator.setRepeatCount(-1);
    }

    private void initBubblingEffect() {
        this.initBalls();
        this.initHalo();
        this.initValue();
        this.initDashArea();
    }

    private void initValue() {
        this.textPaint.setTextSize(this.progressWidth * 1.5f);
        this.textPaint.setTextAlign(Paint.Align.CENTER);
        Paint.FontMetrics fontMetrics = this.textPaint.getFontMetrics();
        float textTop = fontMetrics.top;
        float textBottom = fontMetrics.bottom;
        this.baseline = (int)((float)this.centerY - textTop / 2.0f - textBottom / 2.0f);
    }

    private void initDashArea() {
        LinearGradient gradient = new LinearGradient((float)this.centerX, (float)this.centerY, (float)this.centerX, this.endRangeY, ContextCompat.getColor((Context)this.getContext(), (int)R.color.yellow_trans1), ContextCompat.getColor((Context)this.getContext(), (int)R.color.yellow_trans2), Shader.TileMode.CLAMP);
        this.areaPaint.setShader((Shader)gradient);
        this.areaPaint.setStrokeWidth(this.bottomCircleSmallRadius * 1.6f);
        LinearGradient gradient1 = new LinearGradient((float)this.centerX, (float)this.centerY, (float)this.centerX, this.endRangeY, ContextCompat.getColor((Context)this.getContext(), (int)R.color.yellow_trans3), ContextCompat.getColor((Context)this.getContext(), (int)R.color.yellow_trans4), Shader.TileMode.CLAMP);
        this.areaPaintBorder.setShader((Shader)gradient1);
        this.areaPaintBorder.setStrokeWidth(this.bottomCircleSmallRadius * 0.2f);
    }

    private void initHalo() {
        BlurMaskFilter maskFilter = new BlurMaskFilter((this.bottomCircleBigRadius - this.bottomCircleSmallRadius) * 1.5f, BlurMaskFilter.Blur.SOLID);
        this.circleSmallPaint.setMaskFilter((MaskFilter)maskFilter);
        float startX = this.getX(225);
        float startY = this.getY(225);
        float endX = this.getX(45);
        float endY = this.getY(45);
        LinearGradient linearGradient = new LinearGradient(startX, startY, endX, endY, ContextCompat.getColor((Context)this.getContext(), (int)R.color.yellow), ContextCompat.getColor((Context)this.getContext(), (int)R.color.orange), Shader.TileMode.CLAMP);
        this.circleSmallPaint.setShader((Shader)linearGradient);
        this.setLayerType(1, this.circleSmallPaint);
    }

    private void initBalls() {
        this.endRangeY = (float)this.centerY - this.bottomCircleSmallRadius * 5.0f;
        this.mBalls = new ArrayList<Ball>();
        float startX = (float)this.centerX - this.bottomCircleSmallRadius * 0.8f;
        for (int i = 0; i < this.ballCount; ++i) {
            Ball ball = new Ball(startX, (int)(this.bottomCircleSmallRadius * 1.6f), this.centerY, this.endRangeY, this.getContext());
            this.mBalls.add(ball);
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawBubbling(canvas);
    }

    private void drawBubbling(Canvas canvas) {
        canvas.drawLine((float)this.centerX, (float)this.centerY, (float)this.centerX, (float)this.centerY - this.bottomCircleSmallRadius * 5.0f, this.areaPaint);
        canvas.drawLine((float)this.centerX - this.bottomCircleSmallRadius * 0.9f, (float)this.centerY, (float)this.centerX - this.bottomCircleSmallRadius * 0.9f, this.endRangeY, this.areaPaintBorder);
        canvas.drawLine((float)this.centerX + this.bottomCircleSmallRadius * 0.9f, (float)this.centerY, (float)this.centerX + this.bottomCircleSmallRadius * 0.9f, this.endRangeY, this.areaPaintBorder);
        for (Ball ball : this.mBalls) {
            canvas.drawCircle(ball.x, ball.y, (float)ball.radius, ball.paint);
        }
        canvas.drawCircle((float)this.centerX, (float)this.centerY, this.bottomCircleSmallRadius, this.circleSmallPaint);
        canvas.drawText(this.text + "%", (float)this.centerX, (float)this.baseline, this.textPaint);
    }

    public void setProgress(int text) {
        this.text = text;
        this.invalidate();
    }

    public void start() {
        if (this.mAnimator != null) {
            this.mAnimator.start();
        }
    }

    public void stop() {
        if (this.mAnimator != null) {
            this.mAnimator.cancel();
        }
    }

    public void pause() {
        if (this.mAnimator != null && this.isStarted()) {
            this.mAnimator.pause();
        }
    }

    public void resume() {
        if (this.mAnimator != null && this.mAnimator.isPaused()) {
            this.mAnimator.resume();
        }
    }

    private boolean isStarted() {
        return this.mAnimator.isStarted();
    }

    private int getX(int degree) {
        int x = (int)((double)this.centerX + (double)this.bottomCircleSmallRadius * Math.cos(Math.PI / 180 * (double)degree));
        return x;
    }

    private int getY(int degree) {
        int y = (int)((double)this.centerY + (double)this.bottomCircleSmallRadius * Math.sin(Math.PI / 180 * (double)degree));
        return y;
    }

    public void end() {
        if (this.mAnimator != null) {
            this.mAnimator.end();
        }
    }
}

