/*
 * Decompiled with CFR 0.152.
 */
package com.ba.camera;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Point;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import android.util.Rational;
import android.util.Size;
import android.view.Display;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import android.view.WindowManager;
import androidx.camera.core.Camera;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.FocusMeteringAction;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.MeteringPoint;
import androidx.camera.core.Preview;
import androidx.camera.core.UseCase;
import androidx.camera.core.ZoomState;
import androidx.camera.lifecycle.ProcessCameraProvider;
import androidx.camera.view.PreviewView;
import androidx.core.content.ContextCompat;
import androidx.lifecycle.LifecycleOwner;
import com.ba.camera.analyser.BaCameraAnalyser;
import com.ba.camera.model.BaCameraConfig;
import com.ba.camera.utils.BeepManager;
import com.ba.camera.utils.BitmapUtil;
import com.ba.camera.utils.PCU;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.File;

public class CameraManager {
    private static final int HOVER_TAP_TIMEOUT = 150;
    private static final int HOVER_TAP_SLOP = 20;
    private ListenableFuture<ProcessCameraProvider> cameraProviderFuture;
    private LifecycleOwner mLifecycleOwner;
    private Camera mCamera;
    private long mLastHoveTapTime;
    private boolean isClickTap;
    private float mDownX;
    private float mDownY;
    private PreviewView mPreviewView;
    private BaCameraAnalyser barcodeAnalyser;
    private Context mContext;
    private BaCameraConfig scanConfig;
    private BeepManager beepManager;
    private boolean isAutoZoomEnabled = false;
    private String autoZoomMode = "FACE";
    private float currentZoomRatio = 1.0f;
    private long lastAutoZoomTime = 0L;
    private static final long AUTO_ZOOM_INTERVAL = 500L;
    private Handler autoZoomHandler;
    private Runnable autoZoomRunnable;
    private boolean isCurrentlyFacingFront = false;
    CameraSelector cameraSelector;
    private ScaleGestureDetector.OnScaleGestureListener mOnScaleGestureListener = new ScaleGestureDetector.SimpleOnScaleGestureListener(){

        public boolean onScale(ScaleGestureDetector detector) {
            float scale = detector.getScaleFactor();
            if (CameraManager.this.mCamera != null) {
                float ratio = ((ZoomState)CameraManager.this.mCamera.getCameraInfo().getZoomState().getValue()).getZoomRatio();
                CameraManager.this.zoomTo(ratio * scale);
            }
            return true;
        }
    };
    ImageCapture imageCapture;

    public static CameraManager getInstance(Context mContext, PreviewView mPreviewView) {
        return new CameraManager(mContext, mPreviewView);
    }

    public CameraManager(Context mContext, PreviewView mPreviewView) {
        this.mContext = mContext;
        this.mPreviewView = mPreviewView;
        this.initDatas();
    }

    public void setScanConfig(BaCameraConfig config) {
        this.scanConfig = config;
        this.beepManager.setPlayBeep(this.scanConfig.isShowBeep());
        this.beepManager.setVibrate(this.scanConfig.isShowVibrate());
        if (this.scanConfig != null) {
            this.isAutoZoomEnabled = this.scanConfig.isAutoZoomEnabled();
            this.autoZoomMode = this.scanConfig.getAutoZoomMode();
        }
        this.initBarcodeAnalyser();
    }

    private void initDatas() {
        this.mLifecycleOwner = (LifecycleOwner)this.mContext;
        this.beepManager = new BeepManager(this.mContext);
        this.initScaleGesture();
        this.initAutoZoomTimer();
    }

    private void initAutoZoomTimer() {
        this.autoZoomHandler = new Handler(Looper.getMainLooper());
        this.autoZoomRunnable = new Runnable(){

            @Override
            public void run() {
                if (CameraManager.this.isAutoZoomEnabled && CameraManager.this.mCamera != null) {
                    CameraManager.this.performAutoZoom();
                    CameraManager.this.autoZoomHandler.postDelayed((Runnable)this, 500L);
                }
            }
        };
    }

    public void startCamera() {
        this.cameraProviderFuture = ProcessCameraProvider.getInstance((Context)this.mContext);
        PCU.abc((Activity)this.mContext);
        this.cameraProviderFuture.addListener(new Runnable(){

            @Override
            public void run() {
                boolean useFrontCamera = CameraManager.this.scanConfig.isFacingFront();
                if (CameraManager.this.scanConfig.isTablet()) {
                    useFrontCamera = false;
                    Log.i((String)"CameraManager", (String)"Tablet device detected, using rear camera by default");
                }
                CameraManager.this.bindPreview(useFrontCamera);
            }
        }, ContextCompat.getMainExecutor((Context)this.mContext));
    }

    public void switchCamera() {
        try {
            if (this.scanConfig != null && this.scanConfig.isTablet()) {
                Log.w((String)"CameraManager", (String)"Tablet device only supports rear camera, cannot switch");
                return;
            }
            this.bindPreview(!this.isCurrentlyFacingFront);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setCameraFacing(boolean useFrontCamera) {
        try {
            if (this.scanConfig != null && this.scanConfig.isTablet() && useFrontCamera) {
                Log.w((String)"CameraManager", (String)"Tablet device only supports rear camera, forcing rear camera");
                this.bindPreview(false);
                return;
            }
            this.bindPreview(useFrontCamera);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void bindPreview(boolean isFacingFront) {
        try {
            if (this.scanConfig != null && this.scanConfig.isTablet()) {
                isFacingFront = false;
                Log.i((String)"CameraManager", (String)"Tablet device detected, using rear camera");
            }
            this.isCurrentlyFacingFront = isFacingFront;
            ProcessCameraProvider cameraProvider = (ProcessCameraProvider)this.cameraProviderFuture.get();
            Preview preview = new Preview.Builder().build();
            preview.setSurfaceProvider(this.mPreviewView.getSurfaceProvider());
            CameraSelector.Builder builder = new CameraSelector.Builder();
            if (isFacingFront) {
                builder.requireLensFacing(0);
            } else {
                builder.requireLensFacing(1);
            }
            this.cameraSelector = builder.build();
            if (this.mCamera != null) {
                ((ProcessCameraProvider)this.cameraProviderFuture.get()).unbindAll();
            }
            if (Build.VERSION.SDK_INT >= 17) {
                Size targetResolution;
                ImageCapture.Builder imageCaptureBuilder = new ImageCapture.Builder().setTargetRotation(this.mPreviewView.getDisplay().getRotation());
                if (this.scanConfig != null && (targetResolution = this.getOptimalResolution(this.scanConfig.getCaptureQuality())) != null) {
                    imageCaptureBuilder.setTargetResolution(targetResolution);
                }
                this.imageCapture = imageCaptureBuilder.build();
            }
            this.mCamera = cameraProvider.bindToLifecycle(this.mLifecycleOwner, this.cameraSelector, new UseCase[]{this.imageCapture, preview});
            if (this.isAutoZoomEnabled) {
                this.startAutoZoomTimer();
                Log.i((String)"CameraManager", (String)("Auto zoom restarted after camera binding, mode: " + this.autoZoomMode));
            }
        }
        catch (Exception e) {
            Log.e((String)"CameraManager", (String)("Error in bindPreview: " + e.getMessage()));
        }
    }

    private void initBarcodeAnalyser() {
        this.barcodeAnalyser = new BaCameraAnalyser();
        this.barcodeAnalyser.setPreviewView(this.mPreviewView);
        PCU.abc((Activity)this.mContext);
    }

    public void playBeepSoundAndVibrate() {
        this.beepManager.playBeepSoundAndVibrate();
    }

    private void initScaleGesture() {
        final ScaleGestureDetector scaleGestureDetector = new ScaleGestureDetector(this.mContext, this.mOnScaleGestureListener);
        this.mPreviewView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent event) {
                CameraManager.this.handlePreviewViewClickTap(event);
                PCU.abc((Activity)CameraManager.this.mContext);
                if (CameraManager.this.scanConfig != null && CameraManager.this.scanConfig.isSupportZoom()) {
                    return scaleGestureDetector.onTouchEvent(event);
                }
                return false;
            }
        });
    }

    private void handlePreviewViewClickTap(MotionEvent event) {
        if (event.getPointerCount() == 1) {
            switch (event.getAction()) {
                case 0: {
                    this.isClickTap = true;
                    this.mDownX = event.getX();
                    this.mDownY = event.getY();
                    this.mLastHoveTapTime = System.currentTimeMillis();
                    break;
                }
                case 2: {
                    this.isClickTap = this.distance(this.mDownX, this.mDownY, event.getX(), event.getY()) < 20.0f;
                    break;
                }
                case 1: {
                    if (!this.isClickTap || this.mLastHoveTapTime + 150L <= System.currentTimeMillis()) break;
                    this.startFocusAndMetering(event.getX(), event.getY());
                }
            }
        }
    }

    private float distance(float aX, float aY, float bX, float bY) {
        float xDiff = aX - bX;
        float yDiff = aY - bY;
        return (float)Math.sqrt(xDiff * xDiff + yDiff * yDiff);
    }

    public void zoomTo(float ratio) {
        if (this.mCamera != null) {
            ZoomState zoomState = (ZoomState)this.mCamera.getCameraInfo().getZoomState().getValue();
            float maxRatio = zoomState.getMaxZoomRatio();
            float minRatio = zoomState.getMinZoomRatio();
            float zoom = Math.max(Math.min(ratio, maxRatio), minRatio);
            this.mCamera.getCameraControl().setZoomRatio(zoom);
        }
    }

    private void startFocusAndMetering(float x, float y) {
        if (this.mCamera != null) {
            MeteringPoint point = this.mPreviewView.getMeteringPointFactory().createPoint(x, y);
            this.mCamera.getCameraControl().startFocusAndMetering(new FocusMeteringAction.Builder(point).build());
        }
    }

    private Size getOptimalResolution(String quality) {
        try {
            WindowManager wm = (WindowManager)this.mContext.getSystemService("window");
            Display display = wm.getDefaultDisplay();
            Point screenSize = new Point();
            display.getSize(screenSize);
            int screenWidth = Math.max(screenSize.x, screenSize.y);
            int screenHeight = Math.min(screenSize.x, screenSize.y);
            if ("HIGH".equals(quality)) {
                if (screenWidth >= 1920) {
                    return new Size(1920, 1080);
                }
                if (screenWidth >= 1600) {
                    return new Size(1600, 900);
                }
                return new Size(1280, 720);
            }
            if ("MEDIUM".equals(quality)) {
                if (screenWidth >= 1280) {
                    return new Size(1280, 720);
                }
                return new Size(1024, 576);
            }
            if ("LOW".equals(quality)) {
                return new Size(640, 480);
            }
        }
        catch (Exception e) {
            Log.e((String)"CameraManager", (String)("Error getting optimal resolution: " + e.getMessage()));
        }
        return new Size(1280, 720);
    }

    public void performAutoZoom() {
        if (!this.isAutoZoomEnabled || this.mCamera == null) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastAutoZoomTime < 500L) {
            return;
        }
        this.lastAutoZoomTime = currentTime;
        try {
            ZoomState zoomState;
            float targetZoomRatio = this.calculateOptimalZoomRatio();
            if (Math.abs(targetZoomRatio - this.currentZoomRatio) > 0.05f && (zoomState = (ZoomState)this.mCamera.getCameraInfo().getZoomState().getValue()) != null) {
                boolean supportsOpticalZoom;
                float maxRatio = zoomState.getMaxZoomRatio();
                float minRatio = zoomState.getMinZoomRatio();
                boolean bl = supportsOpticalZoom = maxRatio > 1.0f;
                if (supportsOpticalZoom) {
                    this.currentZoomRatio = Math.max(Math.min(targetZoomRatio, maxRatio), minRatio);
                    this.mCamera.getCameraControl().setZoomRatio(this.currentZoomRatio);
                    Log.i((String)"CameraManager", (String)("Performing optical zoom: mode=" + this.autoZoomMode + ", target=" + targetZoomRatio + ", actual=" + this.currentZoomRatio + ", max=" + maxRatio + ", min=" + minRatio));
                } else {
                    this.applyDigitalZoom(targetZoomRatio);
                    this.currentZoomRatio = 1.0f;
                    this.mCamera.getCameraControl().setZoomRatio(this.currentZoomRatio);
                    Log.i((String)"CameraManager", (String)("Performing digital zoom: mode=" + this.autoZoomMode + ", target=" + targetZoomRatio + ", digital_scale=" + targetZoomRatio + ", optical=" + this.currentZoomRatio));
                }
            }
        }
        catch (Exception e) {
            Log.e((String)"CameraManager", (String)("Auto zoom error: " + e.getMessage()));
        }
    }

    private float calculateOptimalZoomRatio() {
        boolean isTabletDevice;
        boolean bl = isTabletDevice = this.scanConfig != null && this.scanConfig.isTablet();
        if ("TONGUE".equals(this.autoZoomMode)) {
            return isTabletDevice ? 2.8f : 2.5f;
        }
        if ("FACE".equals(this.autoZoomMode)) {
            return isTabletDevice ? 1.0f : 1.0f;
        }
        return isTabletDevice ? 1.0f : 1.0f;
    }

    public void setAutoZoomEnabled(boolean enabled, String mode) {
        this.isAutoZoomEnabled = enabled;
        String string = this.autoZoomMode = mode != null ? mode : "FACE";
        if (enabled && this.mCamera != null) {
            this.startAutoZoomTimer();
            this.forcePerformAutoZoom();
        } else {
            this.stopAutoZoomTimer();
            if (this.mCamera != null) {
                this.mCamera.getCameraControl().setZoomRatio(1.0f);
                this.currentZoomRatio = 1.0f;
            }
            this.resetDigitalZoom();
        }
    }

    public void forcePerformAutoZoom() {
        if (!this.isAutoZoomEnabled || this.mCamera == null) {
            return;
        }
        try {
            float targetZoomRatio;
            this.currentZoomRatio = targetZoomRatio = this.calculateOptimalZoomRatio();
            ZoomState zoomState = (ZoomState)this.mCamera.getCameraInfo().getZoomState().getValue();
            if (zoomState != null) {
                boolean supportsOpticalZoom;
                float maxRatio = zoomState.getMaxZoomRatio();
                float minRatio = zoomState.getMinZoomRatio();
                boolean bl = supportsOpticalZoom = maxRatio > 1.0f;
                if (supportsOpticalZoom) {
                    this.currentZoomRatio = Math.max(Math.min(this.currentZoomRatio, maxRatio), minRatio);
                    this.mCamera.getCameraControl().setZoomRatio(this.currentZoomRatio);
                    Log.i((String)"CameraManager", (String)("Force performing optical zoom: mode=" + this.autoZoomMode + ", target=" + targetZoomRatio + ", actual=" + this.currentZoomRatio + ", max=" + maxRatio + ", min=" + minRatio));
                } else {
                    this.applyDigitalZoom(targetZoomRatio);
                    this.currentZoomRatio = 1.0f;
                    this.mCamera.getCameraControl().setZoomRatio(this.currentZoomRatio);
                    Log.i((String)"CameraManager", (String)("Force performing digital zoom: mode=" + this.autoZoomMode + ", target=" + targetZoomRatio + ", digital_scale=" + targetZoomRatio + ", optical=" + this.currentZoomRatio));
                }
            }
            this.lastAutoZoomTime = System.currentTimeMillis();
        }
        catch (Exception e) {
            Log.e((String)"CameraManager", (String)("Force auto zoom error: " + e.getMessage()));
        }
    }

    private void applyDigitalZoom(float zoomRatio) {
        if (this.mPreviewView != null) {
            this.mPreviewView.animate().scaleX(zoomRatio).scaleY(zoomRatio).setDuration(300L).start();
            Log.i((String)"CameraManager", (String)("Applied digital zoom: scale=" + zoomRatio));
        }
    }

    private void resetDigitalZoom() {
        if (this.mPreviewView != null) {
            this.mPreviewView.animate().scaleX(1.0f).scaleY(1.0f).setDuration(300L).start();
            Log.i((String)"CameraManager", (String)"Reset digital zoom to 1.0");
        }
    }

    private void startAutoZoomTimer() {
        if (this.autoZoomHandler != null && this.autoZoomRunnable != null) {
            this.stopAutoZoomTimer();
            this.autoZoomHandler.postDelayed(this.autoZoomRunnable, 500L);
        }
    }

    private void stopAutoZoomTimer() {
        if (this.autoZoomHandler != null && this.autoZoomRunnable != null) {
            this.autoZoomHandler.removeCallbacks(this.autoZoomRunnable);
        }
    }

    public void openLight() {
        if (this.mCamera != null) {
            this.mCamera.getCameraControl().enableTorch(true);
        }
    }

    public void closeLight() {
        if (this.mCamera != null) {
            this.mCamera.getCameraControl().enableTorch(false);
        }
    }

    public void stopCamera() {
        try {
            if (this.cameraProviderFuture != null) {
                ((ProcessCameraProvider)this.cameraProviderFuture.get()).unbindAll();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void release() {
        try {
            this.stopAutoZoomTimer();
            this.mPreviewView = null;
            this.mLifecycleOwner = null;
            this.stopCamera();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean takePhoto(String path, boolean isFull) {
        return this.takePhoto(path, isFull, true, 0.0f);
    }

    public boolean takePhoto(String path, boolean isFull, boolean isPreviewSize, float zoom) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            path = this.mContext.getExternalFilesDir("") + "/temp.jpg";
        }
        return this.barcodeAnalyser.takePhoto(path, isFull, isPreviewSize, zoom);
    }

    public void setTargetRotation(int rotation) {
        if (this.imageCapture != null) {
            this.imageCapture.setTargetRotation(rotation);
        } else {
            Log.e((String)"CameraManager", (String)"ImageCapture is not initialized");
        }
    }

    public void takePicture(String path, ImageCapture.OnImageSavedCallback imageSavedCallback) {
        this.takePicture(path, null, imageSavedCallback);
    }

    public void takePicture(String path, Rational rational, ImageCapture.OnImageSavedCallback imageSavedCallback) {
        if (this.imageCapture == null) {
            return;
        }
        if (rational != null) {
            this.imageCapture.setCropAspectRatio(rational);
        }
        if (Build.VERSION.SDK_INT >= 17) {
            if (TextUtils.isEmpty((CharSequence)path)) {
                path = this.mContext.getExternalFilesDir("") + "/temp.jpg";
            }
            File file = new File(path);
            ImageCapture.OutputFileOptions outputFileOptions = new ImageCapture.OutputFileOptions.Builder(file).build();
            this.imageCapture.takePicture(outputFileOptions, ContextCompat.getMainExecutor((Context)this.mContext), imageSavedCallback);
        }
    }

    public boolean cropToPreview(String path, boolean isPreviewSize) {
        return this.cropToPreview(path, isPreviewSize, 0.0f);
    }

    public boolean cropToPreview(String path, boolean isPreviewSize, float zoom) {
        try {
            Bitmap bitmapS = BitmapFactory.decodeFile((String)path);
            Bitmap bitmapC = this.cropToPreview(bitmapS, isPreviewSize, zoom);
            File fileImg = new File(path);
            BitmapUtil.saveBitmap(bitmapC, fileImg);
            return true;
        }
        catch (Exception var7) {
            var7.printStackTrace();
            return false;
        }
    }

    public Bitmap cropToPreview(Bitmap bitmap, boolean isPreviewSize, float zoom) {
        if (this.mPreviewView != null) {
            int height = this.mPreviewView.getHeight();
            int width = this.mPreviewView.getWidth();
            if ((float)bitmap.getHeight() / (float)bitmap.getWidth() > (float)this.mPreviewView.getHeight() / (float)this.mPreviewView.getWidth()) {
                int newHeight = bitmap.getWidth() * height / width;
                bitmap = this.cropBitmap(bitmap, bitmap.getWidth(), newHeight);
            } else if ((float)bitmap.getHeight() / (float)bitmap.getWidth() < (float)this.mPreviewView.getHeight() / (float)this.mPreviewView.getWidth()) {
                int newWith = bitmap.getHeight() * width / height;
                bitmap = this.cropBitmap(bitmap, newWith, bitmap.getHeight());
            }
            if (isPreviewSize) {
                bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)width, (int)height, (boolean)true);
            } else if (zoom > 0.0f) {
                bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)((int)((float)bitmap.getWidth() * zoom)), (int)((int)((float)bitmap.getHeight() * zoom)), (boolean)true);
            }
        }
        return bitmap;
    }

    private Bitmap cropBitmap(Bitmap bitmap, int cropWidth, int cropHeight) {
        int w = bitmap.getWidth();
        int h = bitmap.getHeight();
        return Bitmap.createBitmap((Bitmap)bitmap, (int)((w - cropWidth) / 2), (int)((h - cropHeight) / 2), (int)cropWidth, (int)cropHeight, null, (boolean)false);
    }
}

