/*
 * Decompiled with CFR 0.152.
 */
package com.ba.camera;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import android.util.Rational;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.ImageCaptureException;
import androidx.camera.view.PreviewView;
import com.alibaba.fastjson.JSONObject;
import com.ba.camera.CameraManager;
import com.ba.camera.model.BaCameraConfig;
import com.theartofdev.edmodo.cropper.CropImage;
import io.dcloud.feature.uniapp.UniSDKInstance;
import io.dcloud.feature.uniapp.annotation.UniJSMethod;
import io.dcloud.feature.uniapp.bridge.UniJSCallback;
import io.dcloud.feature.uniapp.ui.action.AbsComponentData;
import io.dcloud.feature.uniapp.ui.component.AbsVContainer;
import io.dcloud.feature.uniapp.ui.component.UniComponent;
import io.dcloud.feature.uniapp.ui.component.UniComponentProp;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class CameraView
extends UniComponent<PreviewView> {
    private static final int REQUEST_CODE_PERMISSION_CAMERA = 10011;
    private Context mContext;
    private BaCameraConfig mScanConfig;
    boolean isCrop = false;
    int scaleW = 806;
    int scaleH = 1240;
    private CameraManager cameraManager;
    private PreviewView mPreviewView;
    UniJSCallback mListenerCallback;
    UniJSCallback mTakePictureCallback;
    boolean takePicIng = false;

    @UniJSMethod
    public void setListener(UniJSCallback callback) {
        this.mListenerCallback = callback;
    }

    @UniJSMethod
    public void takePicture(UniJSCallback callback, JSONObject options) {
        this.mTakePictureCallback = callback;
        try {
            String path = "";
            if (options != null) {
                if (options.containsKey((Object)"path")) {
                    path = options.getString("path");
                }
                if (options.containsKey((Object)"isCrop")) {
                    this.isCrop = options.getBooleanValue("isCrop");
                }
                if (options.containsKey((Object)"scaleW")) {
                    this.scaleW = options.getInteger("scaleW");
                }
                if (options.containsKey((Object)"scaleH")) {
                    this.scaleH = options.getInteger("scaleH");
                }
            }
            this.onTakePicture(path);
        }
        catch (Exception e) {
            this.onResult(callback, false, "error");
        }
    }

    @UniJSMethod
    public void switchCamera(UniJSCallback callback, JSONObject options) {
        try {
            this.cameraManager.switchCamera();
            this.onResult(callback, true, "success");
        }
        catch (Exception e) {
            this.onResult(callback, false, "error");
        }
    }

    @UniJSMethod
    public void setCameraFacing(UniJSCallback callback, JSONObject options) {
        try {
            if (options != null && options.containsKey((Object)"useFrontCamera")) {
                boolean useFrontCamera = options.getBooleanValue("useFrontCamera");
                this.cameraManager.setCameraFacing(useFrontCamera);
                BaCameraConfig.Builder builder = new BaCameraConfig.Builder().isFacingFront(useFrontCamera).setSupportZoom(this.mScanConfig != null ? this.mScanConfig.isSupportZoom() : true).setCaptureQuality(this.mScanConfig != null ? this.mScanConfig.getCaptureQuality() : "HIGH").setTablet(this.mScanConfig != null ? this.mScanConfig.isTablet() : false);
                if (this.mScanConfig != null) {
                    builder.setAutoZoomEnabled(this.mScanConfig.isAutoZoomEnabled()).setAutoZoomMode(this.mScanConfig.getAutoZoomMode());
                }
                this.mScanConfig = builder.builder();
                this.cameraManager.setScanConfig(this.mScanConfig);
                this.onResult(callback, true, "success");
            } else {
                this.onResult(callback, false, "Missing useFrontCamera parameter");
            }
        }
        catch (Exception e) {
            this.onResult(callback, false, "error: " + e.getMessage());
        }
    }

    @UniJSMethod
    public void setCaptureQuality(UniJSCallback callback, JSONObject options) {
        try {
            if (options != null && options.containsKey((Object)"quality")) {
                String quality = options.getString("quality");
                if ("HIGH".equals(quality) || "MEDIUM".equals(quality) || "LOW".equals(quality)) {
                    BaCameraConfig.Builder builder = new BaCameraConfig.Builder().setCaptureQuality(quality).isFacingFront(this.mScanConfig != null ? this.mScanConfig.isFacingFront() : true).setSupportZoom(this.mScanConfig != null ? this.mScanConfig.isSupportZoom() : true).setAutoZoomEnabled(this.mScanConfig != null ? this.mScanConfig.isAutoZoomEnabled() : false).setAutoZoomMode(this.mScanConfig != null ? this.mScanConfig.getAutoZoomMode() : "FACE").setTablet(this.mScanConfig != null ? this.mScanConfig.isTablet() : false).isShowToast(this.mScanConfig != null ? this.mScanConfig.isShowToast() : true).isShowVibrate(this.mScanConfig != null ? this.mScanConfig.isShowVibrate() : false);
                    this.mScanConfig = builder.builder();
                    this.cameraManager.setScanConfig(this.mScanConfig);
                    this.cameraManager.stopCamera();
                    this.cameraManager.startCamera();
                    this.onResult(callback, true, "success");
                } else {
                    this.onResult(callback, false, "Invalid quality parameter. Use HIGH, MEDIUM, or LOW");
                }
            } else {
                this.onResult(callback, false, "Missing quality parameter");
            }
        }
        catch (Exception e) {
            this.onResult(callback, false, "error: " + e.getMessage());
        }
    }

    @UniJSMethod
    public void setAutoZoom(UniJSCallback callback, JSONObject options) {
        try {
            if (options != null) {
                boolean enabled = options.getBooleanValue("enabled");
                String mode = options.getString("mode");
                if (mode == null || !mode.equals("FACE") && !mode.equals("TONGUE")) {
                    mode = "FACE";
                }
                BaCameraConfig.Builder builder = new BaCameraConfig.Builder().setAutoZoomEnabled(enabled).setAutoZoomMode(mode).isFacingFront(this.mScanConfig != null ? this.mScanConfig.isFacingFront() : true).setSupportZoom(this.mScanConfig != null ? this.mScanConfig.isSupportZoom() : true).setCaptureQuality(this.mScanConfig != null ? this.mScanConfig.getCaptureQuality() : "HIGH").setTablet(this.mScanConfig != null ? this.mScanConfig.isTablet() : false).isShowToast(this.mScanConfig != null ? this.mScanConfig.isShowToast() : true).isShowVibrate(this.mScanConfig != null ? this.mScanConfig.isShowVibrate() : false);
                this.mScanConfig = builder.builder();
                this.cameraManager.setScanConfig(this.mScanConfig);
                this.cameraManager.setAutoZoomEnabled(enabled, mode);
                if (enabled) {
                    this.cameraManager.performAutoZoom();
                }
                this.onResult(callback, true, "success");
            } else {
                this.onResult(callback, false, "Missing parameters");
            }
        }
        catch (Exception e) {
            this.onResult(callback, false, "error: " + e.getMessage());
        }
    }

    @UniJSMethod
    public void performAutoZoom(UniJSCallback callback) {
        try {
            this.cameraManager.forcePerformAutoZoom();
            this.onResult(callback, true, "success");
        }
        catch (Exception e) {
            this.onResult(callback, false, "error: " + e.getMessage());
        }
    }

    @UniJSMethod
    public void forceAutoZoom(UniJSCallback callback) {
        try {
            this.cameraManager.forcePerformAutoZoom();
            this.onResult(callback, true, "force zoom success");
        }
        catch (Exception e) {
            this.onResult(callback, false, "force zoom error: " + e.getMessage());
        }
    }

    public CameraView(UniSDKInstance instance, AbsVContainer parent, AbsComponentData componentData) {
        super(instance, parent, componentData);
    }

    protected PreviewView initComponentHostView(@NonNull Context context) {
        this.mContext = context;
        this.mPreviewView = new PreviewView(context);
        return this.mPreviewView;
    }

    @UniComponentProp(name="load")
    public void onLoad(JSONObject options) {
        BaCameraConfig.Builder builder = new BaCameraConfig.Builder();
        if (options != null) {
            if (options.containsKey((Object)"isToast")) {
                builder.isShowToast(options.getBoolean("isToast"));
            }
            if (options.containsKey((Object)"isShowVibrate")) {
                builder.isShowVibrate(options.getBoolean("isShowVibrate"));
            }
            if (options.containsKey((Object)"isShowBeep")) {
                builder.isShowBeep(options.getBoolean("isShowBeep"));
            }
            if (options.containsKey((Object)"zoom")) {
                builder.setSupportZoom(options.getBoolean("zoom"));
            }
            if (options.containsKey((Object)"captureQuality")) {
                builder.setCaptureQuality(options.getString("captureQuality"));
            }
            if (options.containsKey((Object)"autoZoomEnabled")) {
                builder.setAutoZoomEnabled(options.getBoolean("autoZoomEnabled"));
            }
            if (options.containsKey((Object)"autoZoomMode")) {
                builder.setAutoZoomMode(options.getString("autoZoomMode"));
            }
            if (options.containsKey((Object)"isTablet")) {
                builder.setTablet(options.getBoolean("isTablet"));
            }
        }
        if (this.mScanConfig == null) {
            this.mScanConfig = builder.builder();
        }
        this.initCamera();
        this.initPermission();
    }

    public void onActivityPause() {
        super.onActivityPause();
    }

    public void onActivityResume() {
        super.onActivityResume();
    }

    public void onActivityDestroy() {
        this.cameraManager.release();
        super.onActivityDestroy();
    }

    private void initPermission() {
        if (Build.VERSION.SDK_INT >= 23) {
            if (this.mContext.checkSelfPermission("android.permission.CAMERA") != 0) {
                ((Activity)this.mContext).requestPermissions(new String[]{"android.permission.CAMERA"}, 10011);
            } else {
                this.startCamera();
            }
        } else {
            this.startCamera();
        }
    }

    private void initCamera() {
        this.cameraManager = CameraManager.getInstance(this.mContext, this.mPreviewView);
        this.cameraManager.setScanConfig(this.mScanConfig);
    }

    private void startCamera() {
        this.cameraManager.startCamera();
        if (this.mScanConfig != null && this.mScanConfig.isAutoZoomEnabled()) {
            this.cameraManager.setAutoZoomEnabled(true, this.mScanConfig.getAutoZoomMode());
        }
    }

    private void onTakePicture(String path) {
        if (this.takePicIng) {
            return;
        }
        this.takePicIng = true;
        if (TextUtils.isEmpty((CharSequence)path)) {
            path = this.mContext.getExternalFilesDir("") + "/temp_" + System.currentTimeMillis() + ".jpg";
        }
        Rational rational = null;
        rational = new Rational(this.mPreviewView.getMeasuredWidth(), this.mPreviewView.getMeasuredHeight());
        if (this.scaleW > 0 && this.scaleH > 0) {
            rational = new Rational(this.scaleW, this.scaleH);
        }
        final String finalPath = path;
        this.cameraManager.takePicture(path, rational, new ImageCapture.OnImageSavedCallback(){

            public void onImageSaved(@NonNull ImageCapture.OutputFileResults outputFileResults) {
                CameraView.this.takePicIng = false;
                CameraView.this.cameraManager.playBeepSoundAndVibrate();
                CameraView.this.compressImage(finalPath, 20);
                if (CameraView.this.isCrop) {
                    File file = new File(finalPath);
                    Uri sourceUri = Uri.fromFile((File)file);
                    Uri destinationUri = Uri.fromFile((File)new File(finalPath));
                    CropImage.activity((Uri)sourceUri).setAutoZoomEnabled(false).setCropMenuCropButtonTitle((CharSequence)"\u786e\u5b9a").setAllowRotation(false).setFixAspectRatio(false).setAllowFlipping(false).setOutputCompressQuality(10).setOutputUri(destinationUri).start((Activity)CameraView.this.mContext);
                } else {
                    CameraView.this.finishSuccess(finalPath);
                }
            }

            public void onError(@NonNull ImageCaptureException exception) {
                CameraView.this.takePicIng = false;
                CameraView.this.onResult(CameraView.this.mTakePictureCallback, false, exception.getMessage());
            }
        });
    }

    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 203) {
            CropImage.ActivityResult result = CropImage.getActivityResult((Intent)data);
            if (resultCode == -1) {
                Uri resultUri = result.getUri();
                this.finishSuccess(resultUri.getPath());
            } else if (resultCode == 204) {
                Exception exception = result.getError();
            }
        }
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        switch (requestCode) {
            case 10011: {
                if (grantResults[0] == 0) {
                    this.startCamera();
                    break;
                }
                Toast.makeText((Context)this.mContext, (CharSequence)"\u521d\u59cb\u5316\u76f8\u673a\u5931\u8d25,\u76f8\u673a\u6743\u9650\u88ab\u62d2\u7edd", (int)0).show();
                this.finishFailed("\u521d\u59cb\u5316\u76f8\u673a\u5931\u8d25,\u76f8\u673a\u6743\u9650\u88ab\u62d2\u7edd");
                break;
            }
        }
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
    }

    private void finishFailed(String errorMsg) {
        if (this.mListenerCallback != null) {
            JSONObject result = new JSONObject();
            result.put("action", (Object)"error");
            result.put("msg", (Object)errorMsg);
            this.mListenerCallback.invokeAndKeepAlive((Object)result);
        }
    }

    private void finishSuccess(String path) {
        if (this.mScanConfig.isShowToast() && !TextUtils.isEmpty((CharSequence)path)) {
            Toast.makeText((Context)this.mContext, (CharSequence)path, (int)0).show();
        }
        if (this.mTakePictureCallback != null) {
            JSONObject data = new JSONObject();
            data.put("path", (Object)path);
            this.onResult(this.mTakePictureCallback, true, "success", data);
        }
    }

    private void onResult(UniJSCallback callback, boolean ok, String msg) {
        this.onResult(callback, ok, msg, null);
    }

    private void onResult(UniJSCallback callback, boolean ok, String msg, JSONObject data) {
        if (callback == null) {
            return;
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("ok", (Object)ok);
        jsonObject.put("msg", (Object)msg);
        if (data != null) {
            jsonObject.put("data", (Object)data);
        }
        callback.invokeAndKeepAlive((Object)jsonObject);
    }

    private void compressImage(String imagePath, int quality) {
        try {
            ExifInterface exif = new ExifInterface(imagePath);
            int orientation = exif.getAttributeInt("Orientation", 1);
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = false;
            Bitmap bitmap = BitmapFactory.decodeFile((String)imagePath, (BitmapFactory.Options)options);
            if (orientation != 1) {
                int rotationDegrees = 0;
                switch (orientation) {
                    case 6: {
                        rotationDegrees = 90;
                        break;
                    }
                    case 3: {
                        rotationDegrees = 180;
                        break;
                    }
                    case 8: {
                        rotationDegrees = 270;
                    }
                }
                Matrix matrix = new Matrix();
                matrix.postRotate((float)rotationDegrees);
                bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
            }
            FileOutputStream out = new FileOutputStream(imagePath);
            bitmap.compress(Bitmap.CompressFormat.JPEG, quality, (OutputStream)out);
            out.flush();
            out.close();
            bitmap.recycle();
        }
        catch (IOException e) {
            Log.e((String)"CameraView", (String)("Image compression failed: " + e.getMessage()));
        }
    }
}

