/*
 * Decompiled with CFR 0.152.
 */
package com.ba.camera.model;

import java.io.Serializable;

public class BaCameraConfig
implements Serializable {
    private static final long serialVersionUID = -5260676142223049891L;
    private int targetSize = 0;
    private boolean isShowCloseBtn = true;
    private boolean isFacingFront = true;
    private boolean isShowToast;
    private boolean showBeep;
    private boolean showVibrate;
    private boolean isSupportZoom = true;
    private boolean showLightController = true;
    private boolean isFullScreenScan = true;
    private String statusBarColor = "#00000000";
    private boolean statusBarDarkMode = false;
    private String captureQuality = "HIGH";
    private boolean autoZoomEnabled = false;
    private String autoZoomMode = "TONGUE";
    private boolean isTablet = false;

    private BaCameraConfig() {
    }

    private BaCameraConfig(Builder builder) {
        this.targetSize = builder.targetSize;
        this.isShowCloseBtn = builder.isShowCloseBtn;
        this.isFacingFront = builder.isFacingFront;
        this.isShowToast = builder.isShowToast;
        this.showBeep = builder.showBeep;
        this.showVibrate = builder.showVibrate;
        this.showLightController = builder.showLightController;
        this.isFullScreenScan = builder.isFullScreenScan;
        this.isSupportZoom = builder.isSupportZoom;
        this.statusBarColor = builder.statusBarColor;
        this.statusBarDarkMode = builder.statusBarDarkMode;
        this.captureQuality = builder.captureQuality;
        this.autoZoomEnabled = builder.autoZoomEnabled;
        this.autoZoomMode = builder.autoZoomMode;
        this.isTablet = builder.isTablet;
    }

    public String getStatusBarColor() {
        return this.statusBarColor;
    }

    public boolean isStatusBarDarkMode() {
        return this.statusBarDarkMode;
    }

    public boolean isShowToast() {
        return this.isShowToast;
    }

    public int getTargetSize() {
        return this.targetSize;
    }

    public boolean isShowCloseBtn() {
        return this.isShowCloseBtn;
    }

    public boolean isFacingFront() {
        return this.isFacingFront;
    }

    public boolean isShowBeep() {
        return this.showBeep;
    }

    public boolean isShowVibrate() {
        return this.showVibrate;
    }

    public boolean isShowLightController() {
        return this.showLightController;
    }

    public boolean isFullScreenScan() {
        return this.isFullScreenScan;
    }

    public boolean isSupportZoom() {
        return this.isSupportZoom;
    }

    public String getCaptureQuality() {
        return this.captureQuality;
    }

    public boolean isAutoZoomEnabled() {
        return this.autoZoomEnabled;
    }

    public String getAutoZoomMode() {
        return this.autoZoomMode;
    }

    public boolean isTablet() {
        return this.isTablet;
    }

    public static class Builder {
        private int targetSize = 0;
        private boolean isShowCloseBtn = true;
        private boolean isFacingFront = true;
        private boolean isShowToast = false;
        private boolean showBeep = false;
        private boolean showVibrate = true;
        private boolean showLightController = true;
        private boolean isFullScreenScan = true;
        private boolean isSupportZoom = true;
        private String statusBarColor = "#00000000";
        private boolean statusBarDarkMode = false;
        private String captureQuality = "HIGH";
        private boolean autoZoomEnabled = false;
        private String autoZoomMode = "FACE";
        private boolean isTablet = false;

        public BaCameraConfig builder() {
            return new BaCameraConfig(this);
        }

        public Builder setStatusBarConfigs(String statusBarColor, boolean statusBarDarkMode) {
            this.statusBarColor = statusBarColor;
            this.statusBarDarkMode = statusBarDarkMode;
            return this;
        }

        public Builder isShowToast(boolean isShowToast) {
            this.isShowToast = isShowToast;
            return this;
        }

        public Builder setTargetSize(int targetSize) {
            this.targetSize = targetSize;
            return this;
        }

        public Builder isShowCloseBtn(boolean isShowCloseBtn) {
            this.isShowCloseBtn = isShowCloseBtn;
            return this;
        }

        public Builder isFacingFront(boolean isFacingFront) {
            this.isFacingFront = isFacingFront;
            return this;
        }

        public Builder isShowBeep(boolean showBeep) {
            this.showBeep = showBeep;
            return this;
        }

        public Builder isShowVibrate(boolean showVibrate) {
            this.showVibrate = showVibrate;
            return this;
        }

        public Builder isShowLightController(boolean showLightController) {
            this.showLightController = showLightController;
            return this;
        }

        public Builder setFullScreenScan(boolean fullScreenScan) {
            this.isFullScreenScan = fullScreenScan;
            return this;
        }

        public Builder setSupportZoom(boolean supportZoom) {
            this.isSupportZoom = supportZoom;
            return this;
        }

        public Builder setCaptureQuality(String captureQuality) {
            this.captureQuality = captureQuality;
            return this;
        }

        public Builder setAutoZoomEnabled(boolean autoZoomEnabled) {
            this.autoZoomEnabled = autoZoomEnabled;
            return this;
        }

        public Builder setAutoZoomMode(String autoZoomMode) {
            this.autoZoomMode = autoZoomMode;
            return this;
        }

        public Builder setTablet(boolean isTablet) {
            this.isTablet = isTablet;
            return this;
        }
    }
}

