/*
 * Decompiled with CFR 0.152.
 */
package android.app.smdt;

import android.app.smdt.IAppDeleteObserver;
import android.app.smdt.IAppInstallObserver;
import android.app.smdt.IBackUpObserver;
import android.app.smdt.ICopyObserver;
import android.app.smdt.IDataReceiveObserver;
import android.app.smdt.ILogObserver;
import android.app.smdt.IRecoveryObserver;
import android.app.smdt.ISmdtManageNew;
import android.app.smdt.ISmdtManagerNew;
import android.app.smdt.IUpdateObserver;
import android.app.smdt.IWiegandObserver;
import android.app.smdt.NetworkInfoData;
import android.app.smdt.util.ErrorCode;
import android.app.smdt.util.MethodUtil;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import java.util.List;

public class SmdtManagerNew
implements ISmdtManageNew {
    private static SmdtManagerNew instance;
    private ISmdtManagerNew mService;
    private Context mContext;
    private boolean isSystemApp = false;
    private IBinder.DeathRecipient mDeathRecipient = new IBinder.DeathRecipient(){

        public void binderDied() {
            if (SmdtManagerNew.this.mService != null) {
                Log.e((String)"SMDTAPI", (String)"Binder Died!");
                SmdtManagerNew.this.mService.asBinder().unlinkToDeath(SmdtManagerNew.this.mDeathRecipient, 0);
                SmdtManagerNew.this.mService = null;
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SmdtManagerNew getInstance(Context context) {
        if (instance != null) return instance;
        Class<SmdtManagerNew> clazz = SmdtManagerNew.class;
        synchronized (SmdtManagerNew.class) {
            instance = new SmdtManagerNew(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    private SmdtManagerNew(Context context) {
        this.mContext = context.getApplicationContext();
        this.getService();
        int uid = Binder.getCallingUid();
        if (uid == 1000) {
            this.isSystemApp = true;
        }
    }

    private boolean getService() {
        if (this.mService == null || !this.mService.asBinder().isBinderAlive()) {
            IBinder mIBinder = ServiceManager.getService((String)MethodUtil.SERVICENAME);
            this.mService = ISmdtManagerNew.Stub.asInterface(mIBinder);
            Log.d((String)"SMDTAPI", (String)("get service binder :" + this.mService));
            try {
                if (this.mService != null) {
                    mIBinder.linkToDeath(this.mDeathRecipient, 0);
                }
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        return this.mService != null && this.mService.asBinder().isBinderAlive();
    }

    private void DEBUG(int level, String msg) {
        if (!this.getService()) {
            return;
        }
        try {
            this.mService.sys_printApiDebug(level, msg);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int sys_setApiDebugLevel(int level) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_setApiDebugLevel(level);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int sys_getApiDebugLevel() {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_getApiDebugLevel();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public String sys_getErrorDescription(int errorCode) {
        if (!this.getService()) {
            return null;
        }
        try {
            return this.mService.sys_getErrorDescription(errorCode);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return null;
        }
    }

    @Override
    public String info_getApiVersion() {
        if (!this.getService()) {
            return null;
        }
        try {
            return this.mService.info_getApiVersion();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return null;
        }
    }

    @Override
    public String info_getBoardType() {
        if (!this.getService()) {
            return null;
        }
        try {
            return this.mService.info_getBoardType();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return null;
        }
    }

    @Override
    public String info_getModel() {
        if (!this.getService()) {
            return null;
        }
        try {
            return this.mService.info_getModel();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return null;
        }
    }

    @Override
    public String info_getSerialNumber() {
        if (!this.getService()) {
            return null;
        }
        try {
            return this.mService.info_getSerialNumber();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return null;
        }
    }

    @Override
    public int info_setSerialNumber(String serialnumber) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_NG;
        }
        try {
            return this.mService.info_setSerialNumber(serialnumber);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_NG;
        }
    }

    @Override
    public String info_getFactoryCompany() {
        if (!this.getService()) {
            return null;
        }
        try {
            return this.mService.info_getFactoryCompany();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return null;
        }
    }

    @Override
    public String info_getAndroidVersion() {
        if (!this.getService()) {
            return null;
        }
        try {
            return this.mService.info_getAndroidVersion();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return null;
        }
    }

    @Override
    public String info_getSoftwareVersion() {
        if (!this.getService()) {
            return null;
        }
        try {
            return this.mService.info_getSoftwareVersion();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return null;
        }
    }

    @Override
    public String info_getHardwareVersion() {
        if (!this.getService()) {
            return null;
        }
        try {
            return this.mService.info_getHardwareVersion();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return null;
        }
    }

    @Override
    public String info_getKernelVersion() {
        if (!this.getService()) {
            return null;
        }
        try {
            return this.mService.info_getKernelVersion();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return null;
        }
    }

    @Override
    public String info_getMCUVersion() {
        if (!this.getService()) {
            return null;
        }
        try {
            return this.mService.info_getMCUVersion();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return null;
        }
    }

    @Override
    public String info_getSecurityVersion() {
        if (!this.getService()) {
            return null;
        }
        try {
            return this.mService.info_getSecurityVersion();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return null;
        }
    }

    @Override
    public int info_getFaceDetectSupport() {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.info_getFaceDetectSupport();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public String info_getNPUVersion() {
        if (!this.getService()) {
            return null;
        }
        try {
            return this.mService.info_getNPUVersion();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return null;
        }
    }

    @Override
    public String info_getTotalMemory() {
        if (!this.getService()) {
            return null;
        }
        try {
            return this.mService.info_getTotalMemory();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return null;
        }
    }

    @Override
    public String info_getAvailMemory() {
        if (!this.getService()) {
            return null;
        }
        try {
            return this.mService.info_getAvailMemory();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return null;
        }
    }

    @Override
    public String info_getTotalStorage() {
        if (!this.getService()) {
            return null;
        }
        try {
            return this.mService.info_getTotalStorage();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return null;
        }
    }

    @Override
    public String info_getAvailStorage() {
        if (!this.getService()) {
            return null;
        }
        try {
            return this.mService.info_getAvailStorage();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return null;
        }
    }

    @Override
    public String info_getCpuId() {
        if (!this.getService()) {
            return null;
        }
        try {
            return this.mService.info_getCpuId();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return null;
        }
    }

    @Override
    public String info_getCpuTemperature() {
        if (!this.getService()) {
            return null;
        }
        try {
            return this.mService.info_getCpuTemperature();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return null;
        }
    }

    @Override
    public String info_getCpuFrequency() {
        if (!this.getService()) {
            return null;
        }
        try {
            return this.mService.info_getCpuFrequency();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return null;
        }
    }

    @Override
    public String info_getCpuUsage() {
        if (!this.getService()) {
            return null;
        }
        try {
            return this.mService.info_getCpuUsage();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return null;
        }
    }

    @Override
    public String info_getAppUsedMemory(int pid) {
        if (!this.getService()) {
            return null;
        }
        try {
            return this.mService.info_getAppUsedMemory(pid);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return null;
        }
    }

    @Override
    public float info_getDeviceTemperature() {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.info_getDeviceTemperature();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public String info_getWebViewVersion() {
        if (!this.getService()) {
            return null;
        }
        try {
            return this.mService.info_getWebViewVersion();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return null;
        }
    }

    @Override
    public int disp_setDispParams(String params) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.disp_setDispParams(params);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public String disp_getDispParams() {
        if (!this.getService()) {
            return null;
        }
        try {
            return this.mService.disp_getDispParams();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return null;
        }
    }

    @Override
    public int disp_getScreenModel() {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.disp_getScreenModel();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int disp_setLcdBackLight(int screen_id, int brightness, int frequency, boolean save) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.disp_setLcdBackLight(screen_id, brightness, frequency, save);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int disp_getLcdBackLight(int screen_id) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.disp_getLcdBackLight(screen_id);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int disp_getLcdPwmFrequency(int screen_id) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.disp_getLcdPwmFrequency(screen_id);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int disp_getLcdBackLightMaxMin(int screen_id, String type) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.disp_getLcdBackLightMaxMin(screen_id, type);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int disp_setLcdBackLightEnable(int screen_id, boolean enable) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.disp_setLcdBackLightEnable(screen_id, enable);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int disp_getLcdBackLightEnable(int screen_id) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.disp_getLcdBackLightEnable(screen_id);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int disp_setDisplayOverScan(int screen_id, String direction, int value) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.disp_setDisplayOverScan(screen_id, direction, value);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int[] disp_getDisplayOverScan(int screen_id) {
        if (!this.getService()) {
            return null;
        }
        try {
            return this.mService.disp_getDisplayOverScan(screen_id);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return null;
        }
    }

    @Override
    public int disp_setDisplayDensity(int value) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.disp_setDisplayDensity(value);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int disp_getDisplayDensity() {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.disp_getDisplayDensity();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int disp_getScreenWidth(int screen_id) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.disp_getScreenWidth(screen_id);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int disp_getScreenHeight(int screen_id) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.disp_getScreenHeight(screen_id);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public Bitmap disp_getScreenShotBitmap() {
        if (!this.getService()) {
            return null;
        }
        try {
            return this.mService.disp_getScreenShotBitmap();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return null;
        }
    }

    @Override
    public int disp_getScreenShot(String filepath) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.disp_getScreenShot(filepath);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int disp_setDisplayRotation(int screen_id, int degree) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.disp_setDisplayRotation(screen_id, degree);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int disp_getDisplayRotation(int screen_id) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.disp_getDisplayRotation(screen_id);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int disp_setBootLogo(String filepath) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.disp_setBootLogo(filepath);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public String disp_getBootLogo() {
        if (!this.getService()) {
            return "";
        }
        try {
            return this.mService.disp_getBootLogo();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return "";
        }
    }

    @Override
    public int disp_setBootAnimation(String filepath) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.disp_setBootAnimation(filepath);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public String disp_getBootAnimation() {
        if (!this.getService()) {
            return "";
        }
        try {
            return this.mService.disp_getBootAnimation();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return "";
        }
    }

    @Override
    public int disp_setStatusBar(boolean enable) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.disp_setStatusBar(enable);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int disp_getStatusBar() {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.disp_getStatusBar();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int disp_setNavigationBar(boolean enable) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.disp_setNavigationBar(enable);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int disp_getNavigationBar() {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.disp_getNavigationBar();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int disp_setStatusBarDrag(boolean enable) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.disp_setStatusBarDrag(enable);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int disp_getStatusBarDrag() {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.disp_getStatusBarDrag();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int disp_setGestureBar(boolean enable) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.disp_setGestureBar(enable);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int disp_getGestureBar() {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.disp_getGestureBar();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int disp_setSystemUIMode(boolean enable) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.disp_setSystemUIMode(enable);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int disp_getSystemUIMode() {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.disp_getSystemUIMode();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int disp_addAppLauncherHideList(String packageName) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.disp_addAppLauncherHideList(packageName);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public List<String> disp_getAppLauncherHideList() {
        if (!this.getService()) {
            return null;
        }
        try {
            return this.mService.disp_getAppLauncherHideList();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return null;
        }
    }

    @Override
    public int disp_delAppLauncherHideList(String packageName) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.disp_delAppLauncherHideList(packageName);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int disp_getHdmiInStatus() {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.disp_getHdmiInStatus();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int disp_setHdmiInAudio(boolean enable) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.disp_setHdmiInAudio(enable);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int disp_getHdmiInAudio() {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.disp_getHdmiInAudio();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int disp_setHdmiOutStatus(boolean enable) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.disp_setHdmiOutStatus(enable);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int disp_getHdmiOutStatus() {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.disp_getHdmiOutStatus();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int disp_setMediaMode(boolean enable) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.disp_setMediaMode(enable);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int disp_getMediaMode() {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.disp_getMediaMode();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public String net_getMacAddress(String type) {
        if (!this.getService()) {
            return null;
        }
        try {
            return this.mService.net_getMacAddress(type);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return null;
        }
    }

    @Override
    public String net_getCurrentNetType() {
        if (!this.getService()) {
            return null;
        }
        try {
            return this.mService.net_getCurrentNetType();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return null;
        }
    }

    @Override
    public int net_setNetWork(String type, boolean enable) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.net_setNetWork(type, enable);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int net_getNetWork(String type) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.net_getNetWork(type);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int net_setNetWorkModel(String type, int model, String ip, String gaw, String mask, String dns1, String dns2) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.net_setNetWorkModel(type, model, ip, gaw, mask, dns1, dns2);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int net_getNetWorkModel(String type) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.net_getNetWorkModel(type);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public NetworkInfoData net_getNetWorkInf(String type) {
        if (!this.getService()) {
            return null;
        }
        try {
            return this.mService.net_getNetWorkInf(type);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return null;
        }
    }

    @Override
    public int net_setWifiConnect(String account, String pwd, int type, int mode, NetworkInfoData info) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.net_setWifiConnect(account, pwd, type, mode, info);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int net_getWifiRssi(int level) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.net_getWifiRssi(level);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int net_setWifiAp(boolean enable) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.net_setWifiAp(enable);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int net_getWifiAp() {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.net_getWifiAp();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int net_setNetworkProtect(boolean enable, int type, long time, String ip_internet, String ip_intranet, String log_path, boolean reboot) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.net_setNetworkProtect(enable, type, time, ip_internet, ip_intranet, log_path, reboot);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int net_getNetworkProtectEnable() {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.net_getNetworkProtectEnable();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public List<String> net_getNetworkProtectConfig() {
        if (!this.getService()) {
            return null;
        }
        try {
            return this.mService.net_getNetworkProtectConfig();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return null;
        }
    }

    @Override
    public String net_getImeiNumber() {
        if (!this.getService()) {
            return null;
        }
        try {
            return this.mService.net_getImeiNumber();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return null;
        }
    }

    @Override
    public String net_getIccidNumber() {
        if (!this.getService()) {
            return null;
        }
        try {
            return this.mService.net_getIccidNumber();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return null;
        }
    }

    @Override
    public String net_getImsiNumber() {
        if (!this.getService()) {
            return null;
        }
        try {
            return this.mService.net_getImsiNumber();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return null;
        }
    }

    @Override
    public int net_setNetworkPriority(String[] types) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.net_setNetworkPriority(types);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public String[] net_getNetworkPriority() {
        if (!this.getService()) {
            return null;
        }
        try {
            return this.mService.net_getNetworkPriority();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return null;
        }
    }

    @Override
    public int net_setNetworkMultiEnable(boolean enable) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.net_setNetworkMultiEnable(enable);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int net_getNetworkMultiEnable() {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.net_getNetworkMultiEnable();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int sys_setBluetooth(boolean enable) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_setBluetooth(enable);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int sys_getBluetooth() {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_getBluetooth();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int sys_setHwStack(boolean enable) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_setHwStack(enable);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int sys_getHwStack() {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_getHwStack();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int sys_setAirPlane(boolean enable) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_setAirPlane(enable);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int sys_getAirPlane() {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_getAirPlane();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int sys_setLocation(int mode) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_setLocation(mode);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int sys_getLocation() {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_getLocation();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int sys_setNtpServer(String url) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_setNtpServer(url);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public String sys_getNtpServer() {
        if (!this.getService()) {
            return null;
        }
        try {
            return this.mService.sys_getNtpServer();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return null;
        }
    }

    @Override
    public int sys_setSoftKeyboard(boolean enable) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_setSoftKeyboard(enable);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int sys_getSoftKeyboard() {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_getSoftKeyboard();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int sys_setKeyReport(boolean enable) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_setKeyReport(enable);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int sys_getKeyReport() {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_getKeyReport();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int sys_setTouchReport(boolean enable) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_setTouchReport(enable);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int sys_getTouchReport() {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_getTouchReport();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int sys_setPointerLoction(boolean enable) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_setPointerLoction(enable);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int sys_getPointerLoction() {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_getPointerLoction();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public void sys_copyFile(String oldpath, String newpath, CopyCallback callback) {
        if (!this.getService()) {
            return;
        }
        try {
            this.mService.sys_copyFile(oldpath, newpath, callback);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
        }
    }

    @Override
    public int sys_setNationallanguage(String national, String language) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_setNationallanguage(national, language);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public String sys_getNationallanguage() {
        if (!this.getService()) {
            return null;
        }
        try {
            return this.mService.sys_getNationallanguage();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return null;
        }
    }

    @Override
    public int sys_setDefInputMethod(String default_input_method) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_setDefInputMethod(default_input_method);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public String sys_getDefInputMethod() {
        if (!this.getService()) {
            return null;
        }
        try {
            return this.mService.sys_getDefInputMethod();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return null;
        }
    }

    @Override
    public String[] sys_getDefInputMethodList() {
        if (!this.getService()) {
            return null;
        }
        try {
            return this.mService.sys_getDefInputMethodList();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return null;
        }
    }

    @Override
    public int sys_setTimeZone(String timeZone) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_setTimeZone(timeZone);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public String sys_getTimeZone() {
        if (!this.getService()) {
            return null;
        }
        try {
            return this.mService.sys_getTimeZone();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return null;
        }
    }

    @Override
    public int sys_setTimeFormat(String format) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_setTimeFormat(format);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public String sys_getTimeFormat() {
        if (!this.getService()) {
            return null;
        }
        try {
            return this.mService.sys_getTimeFormat();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return null;
        }
    }

    @Override
    public int sys_setTime(long time_millisecond) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_setTime(time_millisecond);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int sys_setSystemFontSize(float size) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_setSystemFontSize(size);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public float sys_getSystemFontSize() {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_getSystemFontSize();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int sys_setNetworkTimeSync(boolean enable) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_setNetworkTimeSync(enable);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int sys_getNetworkTimeSync() {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_getNetworkTimeSync();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int sys_setDefaultLauncher(String packageName) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_setDefaultLauncher(packageName);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public String sys_getDefaultLauncher() {
        if (!this.getService()) {
            return null;
        }
        try {
            return this.mService.sys_getDefaultLauncher();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return null;
        }
    }

    @Override
    public int sys_setSystemBootApp(String packageName) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_setSystemBootApp(packageName);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public String sys_getSystemBootApp() {
        if (!this.getService()) {
            return null;
        }
        try {
            return this.mService.sys_getSystemBootApp();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return null;
        }
    }

    @Override
    public int sys_setDaemonsActivity(String packageName, long time_millisecond, boolean broadcast_enable) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_setDaemonsActivity(packageName, time_millisecond, broadcast_enable);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public String sys_getDaemonsActivity() {
        if (!this.getService()) {
            return null;
        }
        try {
            return this.mService.sys_getDaemonsActivity();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return null;
        }
    }

    @Override
    public void sys_doSilentInstallApp(String apkPath, InstallCallback callback) {
        if (!this.getService()) {
            return;
        }
        try {
            this.mService.sys_doSilentInstallApp(apkPath, callback);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
        }
    }

    @Override
    public void sys_doSilentUninstallApp(String packageName, DeleteCallback callback) {
        if (!this.getService()) {
            return;
        }
        try {
            this.mService.sys_doSilentUninstallApp(packageName, callback);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
        }
    }

    @Override
    public int sys_addBlackWhiteList(String packageName, int type, int function) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_addBlackWhiteList(packageName, type, function);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public List<String> sys_getBlackWhiteList(int type, int function) {
        if (!this.getService()) {
            return null;
        }
        try {
            return this.mService.sys_getBlackWhiteList(type, function);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return null;
        }
    }

    @Override
    public int sys_delBlackWhiteList(String packageName, int type, int function) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_delBlackWhiteList(packageName, type, function);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public void sys_backupApplication(String packageName, BackUpCallback callback) {
        if (!this.getService()) {
            return;
        }
        try {
            this.mService.sys_backupApplication(packageName, callback);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
        }
    }

    @Override
    public void sys_recoveryApplication(String packageName, RecoveryCallback callback) {
        if (!this.getService()) {
            return;
        }
        try {
            this.mService.sys_recoveryApplication(packageName, callback);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
        }
    }

    @Override
    public int sys_setAutoInstallEnable(boolean enable) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_setAutoInstallEnable(enable);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int sys_getAutoInstallEnable() {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_getAutoInstallEnable();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int sys_addAutoInstallAppList(String path, String packageName) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_addAutoInstallAppList(path, packageName);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public List<String> sys_getAutoInstallAppList() {
        if (!this.getService()) {
            return null;
        }
        try {
            return this.mService.sys_getAutoInstallAppList();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return null;
        }
    }

    @Override
    public int sys_delAutoInstallAppList(String path, String packageName) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_delAutoInstallAppList(path, packageName);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int sys_setVolume(int value) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_setVolume(value);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int sys_getVolume() {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_getVolume();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int sys_getVolumeMaxMin(String type) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_getVolumeMaxMin(type);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int sys_setVolumeMute(boolean enable) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_setVolumeMute(enable);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int sys_getVolumeMute() {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_getVolumeMute();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int sys_setOutVolume(int type, int value) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_setOutVolume(type, value);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int sys_getOutVolume(int type) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_getOutVolume(type);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int sys_setInVolume(int type, boolean enable) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_setInVolume(type, enable);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int sys_getInVolume(int type) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_getInVolume(type);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int sys_setAudioOutput(int type) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_setAudioOutput(type);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int sys_getAudioOutput() {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_getAudioOutput();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int sys_setAudioInput(int type) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_setAudioInput(type);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int sys_getAudioInput() {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_getAudioInput();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int sys_setGpioDirection(int io, int direction, int value) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_setGpioDirection(io, direction, value);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int sys_getGpioDirection(int io) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_getGpioDirection(io);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int sys_getGpioValue(int io) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_getGpioValue(io);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int sys_setExGpioDirection(int io, int direction, int value) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_setExGpioDirection(io, direction, value);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int sys_getExGpioDirection(int io) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_getExGpioDirection(io);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int sys_getExGpioValue(int io) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_getExGpioValue(io);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int sys_setControl(int type, boolean enable) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        if (type != 5 && type != 19 && !this.isSystemApp) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL2, "Prohibited use method (sys_setControl) , only support system app!");
            return ErrorCode.RET_API_ERR_NG;
        }
        try {
            return this.mService.sys_setControl(type, enable);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int sys_getControl(int type) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        if (type != 5 && type != 19 && !this.isSystemApp) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL2, "Prohibited use method (sys_getControl) , only support system app!");
            return ErrorCode.RET_API_ERR_NG;
        }
        try {
            return this.mService.sys_getControl(type);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int sys_setWatchDog(boolean enable, int poweroff_time) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_setWatchDog(enable, poweroff_time);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int sys_getWatchDog() {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_getWatchDog();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int sys_setWatchDogFeed() {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_setWatchDogFeed();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int sys_getWatchDogShutDownTime() {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_getWatchDogShutDownTime();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int sys_setAutoPowerOnOff(boolean enable, int[] week, int onHour, int onMinute, int offHour, int offMinute) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_setAutoPowerOnOff(enable, week, onHour, onMinute, offHour, offMinute);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int sys_getAutoPowerOnOffEnable() {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_getAutoPowerOnOffEnable();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public String sys_getAutoPowerOnOff(int type) {
        if (!this.getService()) {
            return null;
        }
        try {
            return this.mService.sys_getAutoPowerOnOff(type);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return null;
        }
    }

    @Override
    public int[] sys_getAutoPowerOnOffRepeat() {
        if (!this.getService()) {
            return null;
        }
        try {
            return this.mService.sys_getAutoPowerOnOffRepeat();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return null;
        }
    }

    @Override
    public int sys_setAutoPowerOnOffTime(boolean enable, long onTimeMillis, long offTimeMillis) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_setAutoPowerOnOffTime(enable, onTimeMillis, offTimeMillis);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int sys_setPowerOff() {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_setPowerOff();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int sys_setReboot() {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_setReboot();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int sys_setRebootByMcu() {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_setRebootByMcu();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int sys_setDeveloperOptions(boolean enable) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_setDeveloperOptions(enable);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int sys_getDeveloperOptions() {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_getDeveloperOptions();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int sys_doUpdatePackage(int type, String filepath) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_doUpdatePackage(type, filepath);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int sys_doUpdatePackageAB(String filepath, UpdateCallback listener) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_doUpdatePackageAB(filepath, listener);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int sys_rebootRecovery() {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_rebootRecovery();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int sys_setSystemLog(boolean enable, int[] type, String dirpath, long fileMaxSize, boolean boot) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_setSystemLog(enable, type, dirpath, fileMaxSize, boot);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int sys_getSystemLog() {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_getSystemLog();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public void sys_getProcessLogcat(LogCallback callback) {
        if (!this.getService()) {
            return;
        }
        try {
            this.mService.sys_getProcessLogcat(callback);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
        }
    }

    @Override
    public int sys_getProcessAnrLog(String filepath) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_getProcessAnrLog(filepath);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int sys_setAdbDebug(int type, boolean enable) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_setAdbDebug(type, enable);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int sys_getAdbDebug(int type) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_getAdbDebug(type);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int sys_setOTGMode(int mode) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_setOTGMode(mode);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int sys_getOTGMode() {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_getOTGMode();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int sys_setFloatBall(boolean enable) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_setFloatBall(enable);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int sys_getFloatBall() {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_getFloatBall();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int sys_setUpdateExState(boolean enable) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_setUpdateExState(enable);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int sys_getUpdateExState() {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_getUpdateExState();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int sys_setPcbaCloudService(boolean enable) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_setPcbaCloudService(enable);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int sys_getPcbaCloudService() {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.sys_getPcbaCloudService();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public String dev_getSDcardPath() {
        if (!this.getService()) {
            return null;
        }
        try {
            return this.mService.dev_getSDcardPath();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return null;
        }
    }

    @Override
    public List<String> dev_getUdiskPath() {
        if (!this.getService()) {
            return null;
        }
        try {
            return this.mService.dev_getUdiskPath();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return null;
        }
    }

    @Override
    public int dev_unmountExternalStorage(String path, boolean force, boolean removeEncryption) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.dev_unmountExternalStorage(path, force, removeEncryption);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int dev_getPublicPartitionSize(int type, int deviceId) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.dev_getPublicPartitionSize(type, deviceId);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public byte[] dev_readPublicPartition(int type, int deviceId, int areaId, int start_addr, int size) {
        if (!this.getService()) {
            return null;
        }
        try {
            return this.mService.dev_readPublicPartition(type, deviceId, areaId, start_addr, size);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return null;
        }
    }

    @Override
    public int dev_writePublicPartition(int type, int deviceId, int areaId, int start_addr, int size, byte[] buf) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.dev_writePublicPartition(type, deviceId, areaId, start_addr, size, buf);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public byte[] dev_readPrivatePartition(int type, int deviceId, int areaId, int start_addr, int size) {
        if (!this.getService()) {
            return null;
        }
        if (!this.isSystemApp) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL2, "Prohibited use method (dev_readPrivatePartition) , only support system app!");
            return null;
        }
        try {
            return this.mService.dev_readPrivatePartition(type, deviceId, areaId, start_addr, size);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return null;
        }
    }

    @Override
    public int dev_writePrivatePartition(int type, int deviceId, int areaId, int start_addr, int size, byte[] buf) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        if (!this.isSystemApp) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL2, "Prohibited use method (dev_writePrivatePartition) , only support system app!");
            return ErrorCode.RET_API_ERR_NG;
        }
        try {
            return this.mService.dev_writePrivatePartition(type, deviceId, areaId, start_addr, size, buf);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public byte[] dev_readMipsPartition(int type, int deviceId, int areaId, int start_addr, int size) {
        if (!this.getService()) {
            return null;
        }
        try {
            return this.mService.dev_readMipsPartition(type, deviceId, areaId, start_addr, size);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return null;
        }
    }

    @Override
    public int dev_writeMipsPartition(int type, int deviceId, int areaId, int start_addr, int size, byte[] buf) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.dev_writeMipsPartition(type, deviceId, areaId, start_addr, size, buf);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public String dev_getAuthStatus() {
        if (!this.getService()) {
            return null;
        }
        try {
            return this.mService.dev_getAuthStatus();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return null;
        }
    }

    @Override
    public int dev_setAuthLic(String licMessage) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.dev_setAuthLic(licMessage);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public String dev_getUartPath(String uart) {
        if (!this.getService()) {
            return null;
        }
        try {
            return this.mService.dev_getUartPath(uart);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return null;
        }
    }

    @Override
    public int dev_openUart(String uartNode, int baudrate, int databits, int stopbits, int parity, int flow_ctrl) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.dev_openUart(uartNode, baudrate, databits, stopbits, parity, flow_ctrl);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int dev_closeUart(String uartNode) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.dev_closeUart(uartNode);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int dev_sendUart(String uartNode, String data, boolean hex) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.dev_sendUart(uartNode, data, hex);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public void dev_receiveUart(String uartNode, DataCallback callback) {
        if (!this.getService()) {
            return;
        }
        try {
            this.mService.dev_receiveUart(uartNode, callback);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
        }
    }

    @Override
    public int[] dev_getCameraConfig(int cameraId) {
        if (!this.getService()) {
            return null;
        }
        try {
            return this.mService.dev_getCameraConfig(cameraId);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return null;
        }
    }

    @Override
    public int dev_setCameraDirection(int cameraId, int cameraDirection) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.dev_setCameraDirection(cameraId, cameraDirection);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int dev_setCameraRotationMode(int cameraId, int rotationMode, int lockRotation) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.dev_setCameraRotationMode(cameraId, rotationMode, lockRotation);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int dev_setCameraMirror(int cameraId, boolean previewMirrorHorizontal, boolean imageMirrorHorizontal, boolean imageMirrorVertical) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.dev_setCameraMirror(cameraId, previewMirrorHorizontal, imageMirrorHorizontal, imageMirrorVertical);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int dev_setCameraImageRotation(int cameraId, int rotation) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.dev_setCameraImageRotation(cameraId, rotation);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int dev_setCameraVideoRotation(int cameraId, int rotation) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.dev_setCameraVideoRotation(cameraId, rotation);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int dev_openI2c(String i2cNode) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.dev_openI2c(i2cNode);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int dev_closeI2c() {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.dev_closeI2c();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int dev_writeI2c(int slave, int reg, byte[] data) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.dev_writeI2c(slave, reg, data);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public byte[] dev_readI2c(int slave, int reg, int len) {
        if (!this.getService()) {
            return null;
        }
        try {
            return this.mService.dev_readI2c(slave, reg, len);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return null;
        }
    }

    @Override
    public int dev_openSpi(String spiNode) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.dev_openSpi(spiNode);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int dev_closeSpi() {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.dev_closeSpi();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public byte[] dev_readSpi(int len) {
        if (!this.getService()) {
            return null;
        }
        try {
            return this.mService.dev_readSpi(len);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return null;
        }
    }

    @Override
    public int dev_writeSpi(byte[] data) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.dev_writeSpi(data);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int dev_openCan(String canNode, int baudrate) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.dev_openCan(canNode, baudrate);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int dev_closeCan(String canNode) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.dev_closeCan(canNode);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int dev_receiveCan() {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.dev_receiveCan();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int dev_sendCan(long canid, byte[] data) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.dev_sendCan(canid, data);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int dev_setUsbPower(int type, int usbId, boolean enable) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.dev_setUsbPower(type, usbId, enable);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int dev_getUsbPower(int type, int usbId) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.dev_getUsbPower(type, usbId);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int dev_setLedLighted(String ledColor, boolean lighted) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.dev_setLedLighted(ledColor, lighted);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int dev_getLedState(String ledColor) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.dev_getLedState(ledColor);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int custom_sendWiegandCard(String idCard, int transformat) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.custom_sendWiegandCard(idCard, transformat);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int custom_sendWiegandCardHIDPID(String HID_value, String PID_value, int transformat) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.custom_sendWiegandCardHIDPID(HID_value, PID_value, transformat);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public void custom_readWiegandData(WiegandCallback callback) {
        if (!this.getService()) {
            return;
        }
        try {
            this.mService.custom_readWiegandData(callback);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
        }
    }

    @Override
    public int custom_releaseWiegandRead() {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.custom_releaseWiegandRead();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int custom_setRelayIoMode(int mode, int delay) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.custom_setRelayIoMode(mode, delay);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int custom_getRelayIoMode() {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.custom_getRelayIoMode();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int custom_setRelayIoEnable(boolean enable) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.custom_setRelayIoEnable(enable);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int custom_getRelayIoEnable() {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.custom_getRelayIoEnable();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int custom_dial(String number) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.custom_dial(number);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int custom_endCall() {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.custom_endCall();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int custom_cleanRecentTasks() {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.custom_cleanRecentTasks();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int custom_killPidProcess(int pid) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.custom_killPidProcess(pid);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int custom_getPidProcess(String packageName) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.custom_getPidProcess(packageName);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public String custom_getPidProcessInfo(int pid) {
        if (!this.getService()) {
            return null;
        }
        try {
            return this.mService.custom_getPidProcessInfo(pid);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return null;
        }
    }

    @Override
    public int custom_addAppliesEncryption(String packageName, String oldpwd, String pwd) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.custom_addAppliesEncryption(packageName, oldpwd, pwd);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public List<String> custom_getAppliesEncryption(String packageName) {
        if (!this.getService()) {
            return null;
        }
        try {
            return this.mService.custom_getAppliesEncryption(packageName);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return null;
        }
    }

    @Override
    public int custom_delAppliesEncryption(String packageName, String pwd) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.custom_delAppliesEncryption(packageName, pwd);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int custom_getLedBrightness(int id) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.custom_getLedBrightness(id);
        }
        catch (Exception e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int custom_setLedBrightness(int id, int value) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.custom_setLedBrightness(id, value);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int custom_getEncryptionResult(int cusResult) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.custom_getEncryptionResult(cusResult);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public int custom_setDesktopApp(String packageName) {
        if (!this.getService()) {
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
        try {
            return this.mService.custom_setDesktopApp(packageName);
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return ErrorCode.RET_API_ERR_EXCEPTION;
        }
    }

    @Override
    public String custom_getDesktopApp() {
        if (!this.getService()) {
            return null;
        }
        try {
            return this.mService.custom_getDesktopApp();
        }
        catch (RemoteException e) {
            this.DEBUG(MethodUtil.DEBUG_LEVEL3, "RemoteException:" + e.toString());
            return null;
        }
    }

    public static abstract class UpdateCallback
    extends IUpdateObserver.Stub {
    }

    public static abstract class LogCallback
    extends ILogObserver.Stub {
    }

    public static abstract class RecoveryCallback
    extends IRecoveryObserver.Stub {
    }

    public static abstract class BackUpCallback
    extends IBackUpObserver.Stub {
    }

    public static abstract class WiegandCallback
    extends IWiegandObserver.Stub {
    }

    public static abstract class DataCallback
    extends IDataReceiveObserver.Stub {
    }

    public static abstract class CopyCallback
    extends ICopyObserver.Stub {
    }

    public static abstract class DeleteCallback
    extends IAppDeleteObserver.Stub {
    }

    public static abstract class InstallCallback
    extends IAppInstallObserver.Stub {
    }
}

