/*
 * Decompiled with CFR 0.152.
 */
package android.app.smdt;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;

public class WifiUtils {
    private WifiManager localWifiManager;
    private List<WifiConfiguration> wifiConfigList;
    private WifiInfo wifiConnectedInfo;
    private WifiManager.WifiLock wifiLock;

    public WifiUtils(Context context) {
        this.localWifiManager = (WifiManager)context.getSystemService("wifi");
        this.wifiConnectedInfo = this.localWifiManager.getConnectionInfo();
    }

    public int wifiCheckState() {
        return this.localWifiManager.getWifiState();
    }

    public void wifiOpen() {
        if (!this.localWifiManager.isWifiEnabled()) {
            this.localWifiManager.setWifiEnabled(true);
        }
    }

    public void wifiClose() {
        if (this.localWifiManager.isWifiEnabled()) {
            this.localWifiManager.setWifiEnabled(false);
        }
    }

    public void wifiStartScan() {
        this.localWifiManager.startScan();
    }

    public List<ScanResult> getScanResults() {
        return this.localWifiManager.getScanResults();
    }

    public List<String> scanResultToString(List<ScanResult> list) {
        ArrayList<String> strReturnList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            ScanResult strScan = list.get(i);
            String str = strScan.toString();
            boolean bool = strReturnList.add(str);
            if (bool) continue;
            Log.i((String)"scanResultToSting", (String)"Addfail");
        }
        return strReturnList;
    }

    @SuppressLint(value={"MissingPermission"})
    public void getConfiguration() {
        this.wifiConfigList = this.localWifiManager.getConfiguredNetworks();
        for (int i = 0; i < this.wifiConfigList.size(); ++i) {
            Log.i((String)"getConfiguration", (String)this.wifiConfigList.get((int)i).SSID);
            Log.i((String)"getConfiguration", (String)String.valueOf(this.wifiConfigList.get((int)i).networkId));
        }
    }

    public int IsConfiguration(String SSID) {
        Log.i((String)"IsConfiguration", (String)String.valueOf(this.wifiConfigList.size()));
        for (int i = 0; i < this.wifiConfigList.size(); ++i) {
            Log.i((String)this.wifiConfigList.get((int)i).SSID, (String)String.valueOf(this.wifiConfigList.get((int)i).networkId));
            if (!this.wifiConfigList.get((int)i).SSID.equals(SSID)) continue;
            return this.wifiConfigList.get((int)i).networkId;
        }
        return -1;
    }

    public int AddWifiConfig(List<ScanResult> wifiList, String ssid, String pwd) {
        int wifiId = -1;
        for (int i = 0; i < wifiList.size(); ++i) {
            ScanResult wifi = wifiList.get(i);
            if (!wifi.SSID.equals(ssid)) continue;
            Log.i((String)"AddWifiConfig", (String)"equals");
            WifiConfiguration wifiCong = new WifiConfiguration();
            wifiCong.SSID = "\"" + wifi.SSID + "\"";
            wifiCong.preSharedKey = "\"" + pwd + "\"";
            wifiCong.hiddenSSID = false;
            wifiCong.status = 2;
            wifiId = this.localWifiManager.addNetwork(wifiCong);
            if (wifiId == -1) continue;
            return wifiId;
        }
        return wifiId;
    }

    public boolean ConnectWifi(int wifiId) {
        for (int i = 0; i < this.wifiConfigList.size(); ++i) {
            WifiConfiguration wifi = this.wifiConfigList.get(i);
            if (wifi.networkId != wifiId) continue;
            while (!this.localWifiManager.enableNetwork(wifiId, true)) {
                Log.i((String)"ConnectWifi", (String)String.valueOf(this.wifiConfigList.get((int)wifiId).status));
            }
            return true;
        }
        return false;
    }

    public void createWifiLock(String lockName) {
        this.wifiLock = this.localWifiManager.createWifiLock(lockName);
    }

    public void acquireWifiLock() {
        this.wifiLock.acquire();
    }

    public void releaseWifiLock() {
        if (this.wifiLock.isHeld()) {
            this.wifiLock.release();
        }
    }

    public void getConnectedInfo() {
        this.wifiConnectedInfo = this.localWifiManager.getConnectionInfo();
    }

    public String getConnectedMacAddr() {
        return this.wifiConnectedInfo == null ? "NULL" : this.wifiConnectedInfo.getMacAddress();
    }

    public String getConnectedSSID() {
        return this.wifiConnectedInfo == null ? "NULL" : this.wifiConnectedInfo.getSSID();
    }

    public String getConnectedIPAddr() {
        return this.wifiConnectedInfo == null ? null : this.intToIp(this.wifiConnectedInfo.getIpAddress());
    }

    public int getConnectedID() {
        return this.wifiConnectedInfo == null ? 0 : this.wifiConnectedInfo.getNetworkId();
    }

    public void disconnectWifi() {
        int id = this.getConnectedID();
        this.localWifiManager.disableNetwork(id);
        this.localWifiManager.disconnect();
        this.wifiConnectedInfo = null;
    }

    public boolean checkNetWorkState() {
        if (this.wifiConnectedInfo != null) {
            Log.i((String)"jiguang", (String)"\u7f51\u7edc\u6b63\u5e38\u5de5\u4f5c");
            return true;
        }
        Log.i((String)"jiguang", (String)"\u7f51\u7edc\u5df2\u65ad\u5f00");
        return false;
    }

    private String intToIp(int i) {
        return (i & 0xFF) + "." + (i >> 8 & 0xFF) + "." + (i >> 16 & 0xFF) + "." + (i >> 24 & 0xFF);
    }
}

