/*
 * Decompiled with CFR 0.152.
 */
package com.smdt.manager;

import android.app.smdt.SmdtManagerNew;
import android.content.Context;
import com.alibaba.fastjson.JSONObject;
import io.dcloud.feature.uniapp.annotation.UniJSMethod;
import io.dcloud.feature.uniapp.bridge.UniJSCallback;
import io.dcloud.feature.uniapp.common.UniModule;
import java.util.List;

public class SmdtManager
extends UniModule {
    private SmdtManagerNew smdtManager;
    private boolean isInitialized = false;

    private void initializeSmdtManager() {
        try {
            Context context = this.mUniSDKInstance.getContext();
            if (context != null) {
                this.smdtManager = SmdtManagerNew.getInstance((Context)context);
                if (this.smdtManager != null) {
                    this.isInitialized = true;
                } else {
                    this.smdtManager = SmdtManagerNew.getInstance((Context)context.getApplicationContext());
                    this.isInitialized = this.smdtManager != null;
                }
            }
        }
        catch (Exception e) {
            this.isInitialized = false;
            e.printStackTrace();
        }
    }

    private boolean ensureInitialized() {
        if (!this.isInitialized || this.smdtManager == null) {
            this.initializeSmdtManager();
        }
        return this.isInitialized && this.smdtManager != null;
    }

    @UniJSMethod(uiThread=false)
    public void isInitialized(UniJSCallback callback) {
        JSONObject result = new JSONObject();
        result.put("initialized", (Object)(this.isInitialized && this.smdtManager != null ? 1 : 0));
        result.put("message", (Object)(this.isInitialized && this.smdtManager != null ? "SMDT Manager initialized successfully" : "SMDT Manager not initialized"));
        callback.invoke((Object)result);
    }

    @UniJSMethod(uiThread=false)
    public void initialize(UniJSCallback callback) {
        try {
            this.initializeSmdtManager();
            JSONObject result = new JSONObject();
            result.put("success", (Object)(this.isInitialized && this.smdtManager != null ? 1 : 0));
            result.put("message", (Object)(this.isInitialized && this.smdtManager != null ? "Reinitialization successful" : "Reinitialization failed"));
            callback.invoke((Object)result);
        }
        catch (Exception e) {
            this.invokeError(callback, "Failed to reinitialize: " + e.getMessage());
        }
    }

    @UniJSMethod(uiThread=false)
    public void getSystemFontSize(UniJSCallback callback) {
        try {
            if (!this.ensureInitialized()) {
                this.invokeError(callback, "SMDT Manager not initialized");
                return;
            }
            float fontSize = this.smdtManager.sys_getSystemFontSize();
            JSONObject result = new JSONObject();
            result.put("fontSize", (Object)Float.valueOf(fontSize));
            callback.invoke((Object)result);
        }
        catch (Exception e) {
            this.invokeError(callback, "Failed to get system font size: " + e.getMessage());
        }
    }

    @UniJSMethod(uiThread=false)
    public void setSystemFontSize(JSONObject options, UniJSCallback callback) {
        try {
            if (!this.ensureInitialized()) {
                this.invokeError(callback, "SMDT Manager not initialized");
                return;
            }
            int fontSize = options.getIntValue("fontSize");
            int result = this.smdtManager.sys_setSystemFontSize((float)fontSize);
            JSONObject response = new JSONObject();
            response.put("result", (Object)result);
            callback.invoke((Object)response);
        }
        catch (Exception e) {
            this.invokeError(callback, "Failed to set system font size: " + e.getMessage());
        }
    }

    @UniJSMethod(uiThread=false)
    public void getTimeFormat(UniJSCallback callback) {
        try {
            if (!this.ensureInitialized()) {
                this.invokeError(callback, "SMDT Manager not initialized");
                return;
            }
            String timeFormat = this.smdtManager.sys_getTimeFormat();
            JSONObject result = new JSONObject();
            result.put("timeFormat", (Object)timeFormat);
            callback.invoke((Object)result);
        }
        catch (Exception e) {
            this.invokeError(callback, "Failed to get time format: " + e.getMessage());
        }
    }

    @UniJSMethod(uiThread=false)
    public void setTimeFormat(JSONObject options, UniJSCallback callback) {
        try {
            if (!this.ensureInitialized()) {
                this.invokeError(callback, "SMDT Manager not initialized");
                return;
            }
            String timeFormat = options.getString("timeFormat");
            int result = this.smdtManager.sys_setTimeFormat(timeFormat);
            JSONObject response = new JSONObject();
            response.put("result", (Object)result);
            callback.invoke((Object)response);
        }
        catch (Exception e) {
            this.invokeError(callback, "Failed to set time format: " + e.getMessage());
        }
    }

    @UniJSMethod(uiThread=false)
    public void setVolume(JSONObject options, UniJSCallback callback) {
        try {
            if (!this.ensureInitialized()) {
                this.invokeError(callback, "SMDT Manager not initialized");
                return;
            }
            int volume = options.getIntValue("volume");
            int result = this.smdtManager.sys_setVolume(volume);
            JSONObject response = new JSONObject();
            response.put("result", (Object)result);
            callback.invoke((Object)response);
        }
        catch (Exception e) {
            this.invokeError(callback, "Failed to set volume: " + e.getMessage());
        }
    }

    @UniJSMethod(uiThread=false)
    public void setAdbDebug(JSONObject options, UniJSCallback callback) {
        try {
            if (!this.ensureInitialized()) {
                this.invokeError(callback, "SMDT Manager not initialized");
                return;
            }
            int mode = options.containsKey((Object)"mode") ? options.getIntValue("mode") : 0;
            boolean enable = options.getBooleanValue("enable");
            int result = this.smdtManager.sys_setAdbDebug(mode, enable);
            JSONObject response = new JSONObject();
            response.put("result", (Object)result);
            callback.invoke((Object)response);
        }
        catch (Exception e) {
            this.invokeError(callback, "Failed to set ADB debug: " + e.getMessage());
        }
    }

    @UniJSMethod(uiThread=false)
    public void getWifiRssi(UniJSCallback callback) {
        try {
            if (!this.ensureInitialized()) {
                this.invokeError(callback, "SMDT Manager not initialized");
                return;
            }
            int rssi = this.smdtManager.net_getWifiRssi(0);
            JSONObject result = new JSONObject();
            result.put("rssi", (Object)rssi);
            callback.invoke((Object)result);
        }
        catch (Exception e) {
            this.invokeError(callback, "Failed to get WiFi RSSI: " + e.getMessage());
        }
    }

    @UniJSMethod(uiThread=false)
    public void getMacAddress(UniJSCallback callback) {
        try {
            if (!this.ensureInitialized()) {
                this.invokeError(callback, "SMDT Manager not initialized");
                return;
            }
            String macAddress = this.smdtManager.net_getMacAddress("wlan0");
            JSONObject result = new JSONObject();
            result.put("macAddress", (Object)macAddress);
            callback.invoke((Object)result);
        }
        catch (Exception e) {
            this.invokeError(callback, "Failed to get MAC address: " + e.getMessage());
        }
    }

    @UniJSMethod(uiThread=false)
    public void getImeiNumber(UniJSCallback callback) {
        try {
            if (!this.ensureInitialized()) {
                this.invokeError(callback, "SMDT Manager not initialized");
                return;
            }
            String imei = this.smdtManager.net_getImeiNumber();
            JSONObject result = new JSONObject();
            result.put("imei", (Object)imei);
            callback.invoke((Object)result);
        }
        catch (Exception e) {
            this.invokeError(callback, "Failed to get IMEI number: " + e.getMessage());
        }
    }

    @UniJSMethod(uiThread=false)
    public void setWifiAp(JSONObject options, UniJSCallback callback) {
        try {
            if (!this.ensureInitialized()) {
                this.invokeError(callback, "SMDT Manager not initialized");
                return;
            }
            boolean enable = options.getBooleanValue("enable");
            int result = this.smdtManager.net_setWifiAp(enable);
            JSONObject response = new JSONObject();
            response.put("result", (Object)result);
            callback.invoke((Object)response);
        }
        catch (Exception e) {
            this.invokeError(callback, "Failed to set WiFi AP: " + e.getMessage());
        }
    }

    @UniJSMethod(uiThread=false)
    public void setLcdBackLight(JSONObject options, UniJSCallback callback) {
        try {
            if (!this.ensureInitialized()) {
                this.invokeError(callback, "SMDT Manager not initialized");
                return;
            }
            int brightness = options.getIntValue("brightness");
            int minBrightness = options.containsKey((Object)"minBrightness") ? options.getIntValue("minBrightness") : 0;
            int maxBrightness = options.containsKey((Object)"maxBrightness") ? options.getIntValue("maxBrightness") : 255;
            boolean enable = options.containsKey((Object)"enable") ? options.getBooleanValue("enable") : true;
            int result = this.smdtManager.disp_setLcdBackLight(brightness, minBrightness, maxBrightness, enable);
            JSONObject response = new JSONObject();
            response.put("result", (Object)result);
            callback.invoke((Object)response);
        }
        catch (Exception e) {
            this.invokeError(callback, "Failed to set LCD backlight: " + e.getMessage());
        }
    }

    @UniJSMethod(uiThread=false)
    public void setDisplayDensity(JSONObject options, UniJSCallback callback) {
        try {
            if (!this.ensureInitialized()) {
                this.invokeError(callback, "SMDT Manager not initialized");
                return;
            }
            int density = options.getIntValue("density");
            int result = this.smdtManager.disp_setDisplayDensity(density);
            JSONObject response = new JSONObject();
            response.put("result", (Object)result);
            callback.invoke((Object)response);
        }
        catch (Exception e) {
            this.invokeError(callback, "Failed to set display density: " + e.getMessage());
        }
    }

    @UniJSMethod(uiThread=false)
    public void setLedLighted(JSONObject options, UniJSCallback callback) {
        try {
            if (!this.ensureInitialized()) {
                this.invokeError(callback, "SMDT Manager not initialized");
                return;
            }
            String ledId = options.getString("ledId");
            boolean enable = options.getBooleanValue("enable");
            int result = this.smdtManager.dev_setLedLighted(ledId, enable);
            JSONObject response = new JSONObject();
            response.put("result", (Object)result);
            callback.invoke((Object)response);
        }
        catch (Exception e) {
            this.invokeError(callback, "Failed to set LED lighted: " + e.getMessage());
        }
    }

    @UniJSMethod(uiThread=false)
    public void getLedState(JSONObject options, UniJSCallback callback) {
        try {
            if (!this.ensureInitialized()) {
                this.invokeError(callback, "SMDT Manager not initialized");
                return;
            }
            String ledId = options.getString("ledId");
            int state = this.smdtManager.dev_getLedState(ledId);
            JSONObject result = new JSONObject();
            result.put("state", (Object)state);
            callback.invoke((Object)result);
        }
        catch (Exception e) {
            this.invokeError(callback, "Failed to get LED state: " + e.getMessage());
        }
    }

    @UniJSMethod(uiThread=false)
    public void getSDcardPath(UniJSCallback callback) {
        try {
            if (!this.ensureInitialized()) {
                this.invokeError(callback, "SMDT Manager not initialized");
                return;
            }
            String path = this.smdtManager.dev_getSDcardPath();
            JSONObject result = new JSONObject();
            result.put("path", (Object)path);
            callback.invoke((Object)result);
        }
        catch (Exception e) {
            this.invokeError(callback, "Failed to get SD card path: " + e.getMessage());
        }
    }

    @UniJSMethod(uiThread=false)
    public void getUdiskPath(UniJSCallback callback) {
        try {
            if (!this.ensureInitialized()) {
                this.invokeError(callback, "SMDT Manager not initialized");
                return;
            }
            List paths = this.smdtManager.dev_getUdiskPath();
            JSONObject result = new JSONObject();
            result.put("paths", (Object)paths);
            callback.invoke((Object)result);
        }
        catch (Exception e) {
            this.invokeError(callback, "Failed to get U disk path: " + e.getMessage());
        }
    }

    @UniJSMethod(uiThread=false)
    public void setUsbPower(JSONObject options, UniJSCallback callback) {
        try {
            if (!this.ensureInitialized()) {
                this.invokeError(callback, "SMDT Manager not initialized");
                return;
            }
            int port = options.getIntValue("port");
            int mode = options.getIntValue("mode");
            boolean enable = options.getBooleanValue("enable");
            int result = this.smdtManager.dev_setUsbPower(port, mode, enable);
            JSONObject response = new JSONObject();
            response.put("result", (Object)result);
            callback.invoke((Object)response);
        }
        catch (Exception e) {
            this.invokeError(callback, "Failed to set USB power: " + e.getMessage());
        }
    }

    private void invokeError(UniJSCallback callback, String message) {
        JSONObject error = new JSONObject();
        error.put("error", (Object)message);
        callback.invoke((Object)error);
    }
}

