/*
 * Decompiled with CFR 0.152.
 */
package com.taiyi.typulse.pulse.fastble.bluetooth;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.taiyi.typulse.pulse.fastble.BleManager;
import com.taiyi.typulse.pulse.fastble.bluetooth.BleConnector;
import com.taiyi.typulse.pulse.fastble.callback.BleGattCallback;
import com.taiyi.typulse.pulse.fastble.callback.BleIndicateCallback;
import com.taiyi.typulse.pulse.fastble.callback.BleMtuChangedCallback;
import com.taiyi.typulse.pulse.fastble.callback.BleNotifyCallback;
import com.taiyi.typulse.pulse.fastble.callback.BleReadCallback;
import com.taiyi.typulse.pulse.fastble.callback.BleRssiCallback;
import com.taiyi.typulse.pulse.fastble.callback.BleWriteCallback;
import com.taiyi.typulse.pulse.fastble.data.BleConnectStateParameter;
import com.taiyi.typulse.pulse.fastble.data.BleDevice;
import com.taiyi.typulse.pulse.fastble.exception.ConnectException;
import com.taiyi.typulse.pulse.fastble.exception.OtherException;
import com.taiyi.typulse.pulse.fastble.exception.TimeoutException;
import com.taiyi.typulse.pulse.fastble.utils.BleLog;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

@TargetApi(value=18)
public class BleBluetooth {
    private BleGattCallback bleGattCallback;
    private BleRssiCallback bleRssiCallback;
    private BleMtuChangedCallback bleMtuChangedCallback;
    private HashMap<String, BleNotifyCallback> bleNotifyCallbackHashMap = new HashMap();
    private HashMap<String, BleIndicateCallback> bleIndicateCallbackHashMap = new HashMap();
    private HashMap<String, BleWriteCallback> bleWriteCallbackHashMap = new HashMap();
    private HashMap<String, BleReadCallback> bleReadCallbackHashMap = new HashMap();
    private LastState lastState;
    private boolean isActiveDisconnect = false;
    private BleDevice bleDevice;
    private BluetoothGatt bluetoothGatt;
    private MainHandler mainHandler = new MainHandler(Looper.getMainLooper());
    private int connectRetryCount = 0;
    private BluetoothGattCallback coreGattCallback = new BluetoothGattCallback(){

        public void onConnectionStateChange(BluetoothGatt gatt, int status, int newState) {
            super.onConnectionStateChange(gatt, status, newState);
            BleLog.i("BluetoothGattCallback\uff1aonConnectionStateChange \nstatus: " + status + '\n' + "newState: " + newState + '\n' + "currentThread: " + Thread.currentThread().getId());
            BleBluetooth.this.bluetoothGatt = gatt;
            BleBluetooth.this.mainHandler.removeMessages(7);
            if (newState == 2) {
                Message message = BleBluetooth.this.mainHandler.obtainMessage();
                message.what = 4;
                BleBluetooth.this.mainHandler.sendMessageDelayed(message, 500L);
            } else if (newState == 0) {
                if (BleBluetooth.this.lastState == LastState.CONNECT_CONNECTING) {
                    Message message = BleBluetooth.this.mainHandler.obtainMessage();
                    message.what = 1;
                    message.obj = new BleConnectStateParameter(status);
                    BleBluetooth.this.mainHandler.sendMessage(message);
                } else if (BleBluetooth.this.lastState == LastState.CONNECT_CONNECTED) {
                    Message message = BleBluetooth.this.mainHandler.obtainMessage();
                    message.what = 2;
                    BleConnectStateParameter para = new BleConnectStateParameter(status);
                    para.setActive(BleBluetooth.this.isActiveDisconnect);
                    message.obj = para;
                    BleBluetooth.this.mainHandler.sendMessage(message);
                }
            }
        }

        public void onServicesDiscovered(BluetoothGatt gatt, int status) {
            super.onServicesDiscovered(gatt, status);
            BleLog.i("BluetoothGattCallback\uff1aonServicesDiscovered \nstatus: " + status + '\n' + "currentThread: " + Thread.currentThread().getId());
            BleBluetooth.this.bluetoothGatt = gatt;
            if (status == 0) {
                Message message = BleBluetooth.this.mainHandler.obtainMessage();
                message.what = 6;
                message.obj = new BleConnectStateParameter(status);
                BleBluetooth.this.mainHandler.sendMessage(message);
            } else {
                Message message = BleBluetooth.this.mainHandler.obtainMessage();
                message.what = 5;
                BleBluetooth.this.mainHandler.sendMessage(message);
            }
        }

        public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) {
            Bundle bundle;
            Message message;
            Handler handler;
            Object callback;
            super.onCharacteristicChanged(gatt, characteristic);
            for (Map.Entry entry : BleBluetooth.this.bleNotifyCallbackHashMap.entrySet()) {
                callback = entry.getValue();
                if (!(callback instanceof BleNotifyCallback)) continue;
                BleNotifyCallback bleNotifyCallback = (BleNotifyCallback)callback;
                if (!characteristic.getUuid().toString().equalsIgnoreCase(bleNotifyCallback.getKey()) || (handler = bleNotifyCallback.getHandler()) == null) continue;
                message = handler.obtainMessage();
                message.what = 19;
                message.obj = bleNotifyCallback;
                bundle = new Bundle();
                bundle.putByteArray("notify_value", characteristic.getValue());
                message.setData(bundle);
                handler.sendMessage(message);
            }
            for (Map.Entry entry : BleBluetooth.this.bleIndicateCallbackHashMap.entrySet()) {
                callback = entry.getValue();
                if (!(callback instanceof BleIndicateCallback)) continue;
                BleIndicateCallback bleIndicateCallback = (BleIndicateCallback)callback;
                if (!characteristic.getUuid().toString().equalsIgnoreCase(bleIndicateCallback.getKey()) || (handler = bleIndicateCallback.getHandler()) == null) continue;
                message = handler.obtainMessage();
                message.what = 35;
                message.obj = bleIndicateCallback;
                bundle = new Bundle();
                bundle.putByteArray("indicate_value", characteristic.getValue());
                message.setData(bundle);
                handler.sendMessage(message);
            }
        }

        public void onDescriptorWrite(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
            Bundle bundle;
            Message message;
            Handler handler;
            Object callback;
            super.onDescriptorWrite(gatt, descriptor, status);
            for (Map.Entry entry : BleBluetooth.this.bleNotifyCallbackHashMap.entrySet()) {
                callback = entry.getValue();
                if (!(callback instanceof BleNotifyCallback)) continue;
                BleNotifyCallback bleNotifyCallback = (BleNotifyCallback)callback;
                if (!descriptor.getCharacteristic().getUuid().toString().equalsIgnoreCase(bleNotifyCallback.getKey()) || (handler = bleNotifyCallback.getHandler()) == null) continue;
                message = handler.obtainMessage();
                message.what = 18;
                message.obj = bleNotifyCallback;
                bundle = new Bundle();
                bundle.putInt("notify_status", status);
                message.setData(bundle);
                handler.sendMessage(message);
            }
            for (Map.Entry entry : BleBluetooth.this.bleIndicateCallbackHashMap.entrySet()) {
                callback = entry.getValue();
                if (!(callback instanceof BleIndicateCallback)) continue;
                BleIndicateCallback bleIndicateCallback = (BleIndicateCallback)callback;
                if (!descriptor.getCharacteristic().getUuid().toString().equalsIgnoreCase(bleIndicateCallback.getKey()) || (handler = bleIndicateCallback.getHandler()) == null) continue;
                message = handler.obtainMessage();
                message.what = 34;
                message.obj = bleIndicateCallback;
                bundle = new Bundle();
                bundle.putInt("indicate_status", status);
                message.setData(bundle);
                handler.sendMessage(message);
            }
        }

        public void onCharacteristicWrite(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            super.onCharacteristicWrite(gatt, characteristic, status);
            for (Map.Entry entry : BleBluetooth.this.bleWriteCallbackHashMap.entrySet()) {
                Handler handler;
                Object callback = entry.getValue();
                if (!(callback instanceof BleWriteCallback)) continue;
                BleWriteCallback bleWriteCallback = (BleWriteCallback)callback;
                if (!characteristic.getUuid().toString().equalsIgnoreCase(bleWriteCallback.getKey()) || (handler = bleWriteCallback.getHandler()) == null) continue;
                Message message = handler.obtainMessage();
                message.what = 50;
                message.obj = bleWriteCallback;
                Bundle bundle = new Bundle();
                bundle.putInt("write_status", status);
                bundle.putByteArray("write_value", characteristic.getValue());
                message.setData(bundle);
                handler.sendMessage(message);
            }
        }

        public void onCharacteristicRead(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            super.onCharacteristicRead(gatt, characteristic, status);
            for (Map.Entry entry : BleBluetooth.this.bleReadCallbackHashMap.entrySet()) {
                Handler handler;
                Object callback = entry.getValue();
                if (!(callback instanceof BleReadCallback)) continue;
                BleReadCallback bleReadCallback = (BleReadCallback)callback;
                if (!characteristic.getUuid().toString().equalsIgnoreCase(bleReadCallback.getKey()) || (handler = bleReadCallback.getHandler()) == null) continue;
                Message message = handler.obtainMessage();
                message.what = 66;
                message.obj = bleReadCallback;
                Bundle bundle = new Bundle();
                bundle.putInt("read_status", status);
                bundle.putByteArray("read_value", characteristic.getValue());
                message.setData(bundle);
                handler.sendMessage(message);
            }
        }

        public void onReadRemoteRssi(BluetoothGatt gatt, int rssi, int status) {
            Handler handler;
            super.onReadRemoteRssi(gatt, rssi, status);
            if (BleBluetooth.this.bleRssiCallback != null && (handler = BleBluetooth.this.bleRssiCallback.getHandler()) != null) {
                Message message = handler.obtainMessage();
                message.what = 82;
                message.obj = BleBluetooth.this.bleRssiCallback;
                Bundle bundle = new Bundle();
                bundle.putInt("rssi_status", status);
                bundle.putInt("rssi_value", rssi);
                message.setData(bundle);
                handler.sendMessage(message);
            }
        }

        public void onMtuChanged(BluetoothGatt gatt, int mtu, int status) {
            Handler handler;
            super.onMtuChanged(gatt, mtu, status);
            if (BleBluetooth.this.bleMtuChangedCallback != null && (handler = BleBluetooth.this.bleMtuChangedCallback.getHandler()) != null) {
                Message message = handler.obtainMessage();
                message.what = 98;
                message.obj = BleBluetooth.this.bleMtuChangedCallback;
                Bundle bundle = new Bundle();
                bundle.putInt("mtu_status", status);
                bundle.putInt("mtu_value", mtu);
                message.setData(bundle);
                handler.sendMessage(message);
            }
        }
    };

    public BleBluetooth(BleDevice bleDevice) {
        this.bleDevice = bleDevice;
    }

    public BleConnector newBleConnector() {
        return new BleConnector(this);
    }

    public synchronized void addConnectGattCallback(BleGattCallback callback) {
        this.bleGattCallback = callback;
    }

    public synchronized void removeConnectGattCallback() {
        this.bleGattCallback = null;
    }

    public synchronized void addNotifyCallback(String uuid, BleNotifyCallback bleNotifyCallback) {
        this.bleNotifyCallbackHashMap.put(uuid, bleNotifyCallback);
    }

    public synchronized void addIndicateCallback(String uuid, BleIndicateCallback bleIndicateCallback) {
        this.bleIndicateCallbackHashMap.put(uuid, bleIndicateCallback);
    }

    public synchronized void addWriteCallback(String uuid, BleWriteCallback bleWriteCallback) {
        this.bleWriteCallbackHashMap.put(uuid, bleWriteCallback);
    }

    public synchronized void addReadCallback(String uuid, BleReadCallback bleReadCallback) {
        this.bleReadCallbackHashMap.put(uuid, bleReadCallback);
    }

    public synchronized void removeNotifyCallback(String uuid) {
        if (this.bleNotifyCallbackHashMap.containsKey(uuid)) {
            this.bleNotifyCallbackHashMap.remove(uuid);
        }
    }

    public synchronized void removeIndicateCallback(String uuid) {
        if (this.bleIndicateCallbackHashMap.containsKey(uuid)) {
            this.bleIndicateCallbackHashMap.remove(uuid);
        }
    }

    public synchronized void removeWriteCallback(String uuid) {
        if (this.bleWriteCallbackHashMap.containsKey(uuid)) {
            this.bleWriteCallbackHashMap.remove(uuid);
        }
    }

    public synchronized void removeReadCallback(String uuid) {
        if (this.bleReadCallbackHashMap.containsKey(uuid)) {
            this.bleReadCallbackHashMap.remove(uuid);
        }
    }

    public synchronized void clearCharacterCallback() {
        if (this.bleNotifyCallbackHashMap != null) {
            this.bleNotifyCallbackHashMap.clear();
        }
        if (this.bleIndicateCallbackHashMap != null) {
            this.bleIndicateCallbackHashMap.clear();
        }
        if (this.bleWriteCallbackHashMap != null) {
            this.bleWriteCallbackHashMap.clear();
        }
        if (this.bleReadCallbackHashMap != null) {
            this.bleReadCallbackHashMap.clear();
        }
    }

    public synchronized void addRssiCallback(BleRssiCallback callback) {
        this.bleRssiCallback = callback;
    }

    public synchronized void removeRssiCallback() {
        this.bleRssiCallback = null;
    }

    public synchronized void addMtuChangedCallback(BleMtuChangedCallback callback) {
        this.bleMtuChangedCallback = callback;
    }

    public synchronized void removeMtuChangedCallback() {
        this.bleMtuChangedCallback = null;
    }

    public String getDeviceKey() {
        return this.bleDevice.getKey();
    }

    public BleDevice getDevice() {
        return this.bleDevice;
    }

    public BluetoothGatt getBluetoothGatt() {
        return this.bluetoothGatt;
    }

    public synchronized BluetoothGatt connect(BleDevice bleDevice, boolean autoConnect, BleGattCallback callback) {
        return this.connect(bleDevice, autoConnect, callback, 0);
    }

    public synchronized BluetoothGatt connect(BleDevice bleDevice, boolean autoConnect, BleGattCallback callback, int connectRetryCount) {
        BleLog.i("connect device: " + bleDevice.getName() + "\nmac: " + bleDevice.getMac() + "\nautoConnect: " + autoConnect + "\ncurrentThread: " + Thread.currentThread().getId() + "\nconnectCount:" + (connectRetryCount + 1));
        if (connectRetryCount == 0) {
            this.connectRetryCount = 0;
        }
        this.addConnectGattCallback(callback);
        this.lastState = LastState.CONNECT_CONNECTING;
        this.bluetoothGatt = Build.VERSION.SDK_INT >= 23 ? bleDevice.getDevice().connectGatt(BleManager.getInstance().getContext(), autoConnect, this.coreGattCallback, 2) : bleDevice.getDevice().connectGatt(BleManager.getInstance().getContext(), autoConnect, this.coreGattCallback);
        if (this.bluetoothGatt != null) {
            if (this.bleGattCallback != null) {
                this.bleGattCallback.onStartConnect();
            }
            Message message = this.mainHandler.obtainMessage();
            message.what = 7;
            this.mainHandler.sendMessageDelayed(message, BleManager.getInstance().getConnectOverTime());
        } else {
            this.disconnectGatt();
            this.refreshDeviceCache();
            this.closeBluetoothGatt();
            this.lastState = LastState.CONNECT_FAILURE;
            BleManager.getInstance().getMultipleBluetoothController().removeConnectingBle(this);
            if (this.bleGattCallback != null) {
                this.bleGattCallback.onConnectFail(bleDevice, new OtherException("GATT connect exception occurred!"));
            }
        }
        return this.bluetoothGatt;
    }

    public synchronized void disconnect() {
        this.isActiveDisconnect = true;
        this.disconnectGatt();
    }

    public synchronized void destroy() {
        this.lastState = LastState.CONNECT_IDLE;
        this.disconnectGatt();
        this.refreshDeviceCache();
        this.closeBluetoothGatt();
        this.removeConnectGattCallback();
        this.removeRssiCallback();
        this.removeMtuChangedCallback();
        this.clearCharacterCallback();
        this.mainHandler.removeCallbacksAndMessages(null);
    }

    private synchronized void disconnectGatt() {
        if (this.bluetoothGatt != null) {
            this.bluetoothGatt.disconnect();
        }
    }

    private synchronized void refreshDeviceCache() {
        try {
            Method refresh = BluetoothGatt.class.getMethod("refresh", new Class[0]);
            if (refresh != null && this.bluetoothGatt != null) {
                boolean success = (Boolean)refresh.invoke((Object)this.bluetoothGatt, new Object[0]);
                BleLog.i("refreshDeviceCache, is success:  " + success);
            }
        }
        catch (Exception e) {
            BleLog.i("exception occur while refreshing device: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private synchronized void closeBluetoothGatt() {
        if (this.bluetoothGatt != null) {
            this.bluetoothGatt.close();
        }
    }

    static enum LastState {
        CONNECT_IDLE,
        CONNECT_CONNECTING,
        CONNECT_CONNECTED,
        CONNECT_FAILURE,
        CONNECT_DISCONNECT;

    }

    private final class MainHandler
    extends Handler {
        MainHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    BleBluetooth.this.disconnectGatt();
                    BleBluetooth.this.refreshDeviceCache();
                    BleBluetooth.this.closeBluetoothGatt();
                    if (BleBluetooth.this.connectRetryCount < BleManager.getInstance().getReConnectCount()) {
                        BleLog.e("Connect fail, try reconnect " + BleManager.getInstance().getReConnectInterval() + " millisecond later");
                        ++BleBluetooth.this.connectRetryCount;
                        Message message = BleBluetooth.this.mainHandler.obtainMessage();
                        message.what = 3;
                        BleBluetooth.this.mainHandler.sendMessageDelayed(message, BleManager.getInstance().getReConnectInterval());
                        break;
                    }
                    BleBluetooth.this.lastState = LastState.CONNECT_FAILURE;
                    BleManager.getInstance().getMultipleBluetoothController().removeConnectingBle(BleBluetooth.this);
                    BleConnectStateParameter para = (BleConnectStateParameter)msg.obj;
                    int status = para.getStatus();
                    if (BleBluetooth.this.bleGattCallback == null) break;
                    BleBluetooth.this.bleGattCallback.onConnectFail(BleBluetooth.this.bleDevice, new ConnectException(BleBluetooth.this.bluetoothGatt, status));
                    break;
                }
                case 2: {
                    BleBluetooth.this.lastState = LastState.CONNECT_DISCONNECT;
                    BleManager.getInstance().getMultipleBluetoothController().removeBleBluetooth(BleBluetooth.this);
                    BleBluetooth.this.disconnect();
                    BleBluetooth.this.refreshDeviceCache();
                    BleBluetooth.this.closeBluetoothGatt();
                    BleBluetooth.this.removeRssiCallback();
                    BleBluetooth.this.removeMtuChangedCallback();
                    BleBluetooth.this.clearCharacterCallback();
                    BleBluetooth.this.mainHandler.removeCallbacksAndMessages(null);
                    BleConnectStateParameter para = (BleConnectStateParameter)msg.obj;
                    boolean isActive = para.isActive();
                    int status = para.getStatus();
                    if (BleBluetooth.this.bleGattCallback == null) break;
                    BleBluetooth.this.bleGattCallback.onDisConnected(isActive, BleBluetooth.this.bleDevice, BleBluetooth.this.bluetoothGatt, status);
                    break;
                }
                case 3: {
                    BleBluetooth.this.connect(BleBluetooth.this.bleDevice, false, BleBluetooth.this.bleGattCallback, BleBluetooth.this.connectRetryCount);
                    break;
                }
                case 7: {
                    BleBluetooth.this.disconnectGatt();
                    BleBluetooth.this.refreshDeviceCache();
                    BleBluetooth.this.closeBluetoothGatt();
                    BleBluetooth.this.lastState = LastState.CONNECT_FAILURE;
                    BleManager.getInstance().getMultipleBluetoothController().removeConnectingBle(BleBluetooth.this);
                    if (BleBluetooth.this.bleGattCallback == null) break;
                    BleBluetooth.this.bleGattCallback.onConnectFail(BleBluetooth.this.bleDevice, new TimeoutException());
                    break;
                }
                case 4: {
                    if (BleBluetooth.this.bluetoothGatt != null) {
                        boolean discoverServiceResult = BleBluetooth.this.bluetoothGatt.discoverServices();
                        if (discoverServiceResult) break;
                        Message message = BleBluetooth.this.mainHandler.obtainMessage();
                        message.what = 5;
                        BleBluetooth.this.mainHandler.sendMessage(message);
                        break;
                    }
                    Message message = BleBluetooth.this.mainHandler.obtainMessage();
                    message.what = 5;
                    BleBluetooth.this.mainHandler.sendMessage(message);
                    break;
                }
                case 5: {
                    BleBluetooth.this.disconnectGatt();
                    BleBluetooth.this.refreshDeviceCache();
                    BleBluetooth.this.closeBluetoothGatt();
                    BleBluetooth.this.lastState = LastState.CONNECT_FAILURE;
                    BleManager.getInstance().getMultipleBluetoothController().removeConnectingBle(BleBluetooth.this);
                    if (BleBluetooth.this.bleGattCallback == null) break;
                    BleBluetooth.this.bleGattCallback.onConnectFail(BleBluetooth.this.bleDevice, new OtherException("GATT discover services exception occurred!"));
                    break;
                }
                case 6: {
                    BleBluetooth.this.lastState = LastState.CONNECT_CONNECTED;
                    BleBluetooth.this.isActiveDisconnect = false;
                    BleManager.getInstance().getMultipleBluetoothController().removeConnectingBle(BleBluetooth.this);
                    BleManager.getInstance().getMultipleBluetoothController().addBleBluetooth(BleBluetooth.this);
                    BleConnectStateParameter para = (BleConnectStateParameter)msg.obj;
                    int status = para.getStatus();
                    if (BleBluetooth.this.bleGattCallback == null) break;
                    BleBluetooth.this.bleGattCallback.onConnectSuccess(BleBluetooth.this.bleDevice, BleBluetooth.this.bluetoothGatt, status);
                    break;
                }
                default: {
                    super.handleMessage(msg);
                }
            }
        }
    }
}

