/*
 * Decompiled with CFR 0.152.
 */
package com.taiyi.typulse.tyusbsdk;

import com.taiyi.typulse.tyusbsdk.HexUtil;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class ByteDataUtil {
    public static byte[] reverse(byte[] data) {
        int i = 0;
        int j = data.length - 1;
        while (i < data.length / 2) {
            int n = i;
            data[n] = (byte)(data[n] ^ data[j]);
            int n2 = j;
            data[n2] = (byte)(data[n2] ^ data[i]);
            int n3 = i++;
            data[n3] = (byte)(data[n3] ^ data[j]);
            --j;
        }
        return data;
    }

    public static String byteToHex(byte b) {
        String hex = Integer.toHexString(b & 0xFF);
        if (hex.length() < 2) {
            hex = "0" + hex;
        }
        return hex;
    }

    public static String bytesToHex(byte[] bytes) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            String hex = Integer.toHexString(bytes[i] & 0xFF);
            if (hex.length() < 2) {
                sb.append(0);
            }
            sb.append(hex);
        }
        return sb.toString();
    }

    public static byte hexToByte(String inHex) {
        return (byte)Integer.parseInt(inHex, 16);
    }

    public static byte[] hexToByteArray(String inHex) {
        byte[] result;
        int hexlen = inHex.length();
        if (hexlen % 2 == 1) {
            result = new byte[++hexlen / 2];
            inHex = "0" + inHex;
        } else {
            result = new byte[hexlen / 2];
        }
        int j = 0;
        for (int i = 0; i < hexlen; i += 2) {
            result[j] = ByteDataUtil.hexToByte(inHex.substring(i, i + 2));
            ++j;
        }
        return result;
    }

    public static String hexStrToStr(String hexStr) {
        String str = "0123456789ABCDEF";
        char[] hexs = hexStr.toCharArray();
        byte[] bytes = new byte[hexStr.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            int n = str.indexOf(hexs[2 * i]) * 16;
            bytes[i] = (byte)((n += str.indexOf(hexs[2 * i + 1])) & 0xFF);
        }
        return new String(bytes);
    }

    public static byte[] IntToLBytes(int paramInt) {
        return new byte[]{(byte)(paramInt & 0xFF), (byte)(paramInt >> 8 & 0xFF), (byte)(paramInt >> 16 & 0xFF), (byte)(paramInt >> 24 & 0xFF)};
    }

    public static byte[] MergerArray(byte[] paramArrayOfByte, byte paramByte) {
        byte[] arrayOfByte = new byte[paramArrayOfByte.length + 1];
        System.arraycopy(paramArrayOfByte, 0, arrayOfByte, 0, paramArrayOfByte.length);
        arrayOfByte[paramArrayOfByte.length] = paramByte;
        return arrayOfByte;
    }

    public static byte[] MergerArray(byte[] paramArrayOfByte1, byte[] paramArrayOfByte2) {
        byte[] arrayOfByte = new byte[paramArrayOfByte1.length + paramArrayOfByte2.length];
        System.arraycopy(paramArrayOfByte1, 0, arrayOfByte, 0, paramArrayOfByte1.length);
        System.arraycopy(paramArrayOfByte2, 0, arrayOfByte, paramArrayOfByte1.length, paramArrayOfByte2.length);
        return arrayOfByte;
    }

    public static byte[] SubArray(byte[] paramArrayOfByte, int paramInt1, int paramInt2) {
        byte[] arrayOfByte = new byte[paramInt2];
        int i = 0;
        while (i < paramInt2) {
            arrayOfByte[i] = paramArrayOfByte[i + paramInt1];
            ++i;
        }
        return arrayOfByte;
    }

    public static byte[] intsToBytes(int[] paramArrayOfInt) {
        byte[] arrayOfByte = new byte[paramArrayOfInt.length];
        int i = 0;
        while (i < paramArrayOfInt.length) {
            arrayOfByte[i] = (byte)paramArrayOfInt[i];
            ++i;
        }
        return arrayOfByte;
    }

    public static byte[] stringToBytes(String paramString, int paramInt) {
        while (paramString.getBytes().length < paramInt) {
            paramString = paramString + " ";
        }
        return paramString.getBytes();
    }

    public static String intToHex(int n) {
        StringBuffer s = new StringBuffer();
        char[] b = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        while (n != 0) {
            s = s.append(b[n % 16]);
            n /= 16;
        }
        String a = s.reverse().toString();
        return a;
    }

    public static String shortToString(Integer value) {
        ByteBuffer buffer = ByteBuffer.allocate(2);
        buffer.putShort(value.shortValue());
        return HexUtil.formatHexString(buffer.array());
    }

    public static byte[] shortToByte(Integer value) {
        ByteBuffer buffer = ByteBuffer.allocate(2);
        buffer.putShort(value.shortValue());
        return buffer.array();
    }

    public static String byteToString8(Integer value) {
        ByteBuffer buffer = ByteBuffer.allocate(2);
        buffer.putShort(value.byteValue());
        return HexUtil.formatHexString(buffer.array());
    }

    public static byte[] shortToBytes(Integer value) {
        ByteBuffer buffer = ByteBuffer.allocate(2);
        buffer.putShort(value.shortValue());
        return buffer.array();
    }

    public static byte[] intToBytes(Integer value) {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.putInt(value);
        return buffer.array();
    }

    public static int byteToInt(byte b) {
        return b & 0xFF;
    }

    public static int byte2Int(byte[] b) {
        int intValue = 0;
        for (int i = 0; i < b.length; ++i) {
            intValue += (b[i] & 0xFF) << 8 * (3 - i);
        }
        return intValue;
    }

    public static short byteToShort(byte[] b) {
        return (short)(b[1] & 0xFF | (b[0] & 0xFF) << 8);
    }

    public static Integer getLen(byte[] bytes) {
        return 4 + ByteDataUtil.getDataLen(bytes);
    }

    public static Integer getLen(int len) {
        return 4 + len;
    }

    public static Integer getDataLen(byte[] payload) {
        return 2 + (payload == null ? 0 : payload.length);
    }

    public static byte[] getData(Integer writeSerial, Short type, byte[] payload) {
        byte byteSerial = writeSerial.byteValue();
        byte[] bytesHead = new byte[]{byteSerial, type.byteValue()};
        if (payload == null) {
            return bytesHead;
        }
        return ByteDataUtil.MergerArray(bytesHead, payload);
    }

    public static byte[] getCommandBytes(byte[] byteHeader, Integer writeSerial, byte[] payload, short command) {
        Integer len = ByteDataUtil.getLen(ByteDataUtil.getDataLen(payload));
        byte[] bytesLen = ByteDataUtil.shortToByte(len);
        byte[] byteTotal = ByteDataUtil.MergerArray(byteHeader, bytesLen);
        byte[] bytesData = ByteDataUtil.getData(writeSerial, command, payload);
        byteTotal = ByteDataUtil.MergerArray(byteTotal, bytesData);
        byte[] bytesCheck = ByteDataUtil.getCheckBytes(byteTotal);
        byteTotal = ByteDataUtil.MergerArray(byteTotal, bytesCheck);
        return byteTotal;
    }

    public static String getCommandString(Integer writeSerial, String head, short command) {
        byte[] payload = new byte[]{1};
        Integer len = ByteDataUtil.getLen(ByteDataUtil.getDataLen(payload));
        String strLen = ByteDataUtil.shortToString(len);
        String strData = HexUtil.formatHexString(ByteDataUtil.getData(writeSerial, command, payload));
        String strCheck = ByteDataUtil.getCheckStr(head + strLen + strData);
        String total = head + strLen + strData + strCheck;
        return total;
    }

    public static byte[] getCheckBytes(byte[] byteTotal) {
        return ByteDataUtil.shortToByte(ByteDataUtil.getBytesSum(byteTotal));
    }

    public static int getBytesSum(byte[] byteTotal) {
        int sum = 0;
        for (int i = 0; i < byteTotal.length; ++i) {
            sum += ByteDataUtil.byteToInt(byteTotal[i]);
        }
        return sum;
    }

    public static String getCheckStr(String s) {
        byte[] bytes = HexUtil.hexStringToBytes(s);
        int sum = 0;
        for (int i = 0; i < bytes.length; ++i) {
            sum += ByteDataUtil.byteToInt(bytes[i]);
        }
        byte[] bytes1 = ByteDataUtil.shortToByte(sum);
        return HexUtil.formatHexString(bytes1);
    }

    public static boolean checkValue(byte[] b) {
        if (b.length <= 2) {
            return false;
        }
        byte[] bytesData = ByteDataUtil.SubArray(b, 0, b.length - 2);
        byte[] byteTail = ByteDataUtil.SubArray(b, b.length - 2, 2);
        if (byteTail.length == 2) {
            byte[] byteCheck = new byte[]{byteTail[1], byteTail[0]};
            return ByteDataUtil.getBytesSum(bytesData) == ByteDataUtil.byteToInt2(byteCheck);
        }
        return false;
    }

    public static int GetIndexOf(byte[] data, byte[] bytesHead) {
        if (data == null || bytesHead == null || data.length == 0 || bytesHead.length == 0) {
            return -1;
        }
        if (data.length < bytesHead.length) {
            return -1;
        }
        for (int i = 0; i < data.length; ++i) {
            int j;
            if (data[i] != bytesHead[0]) continue;
            for (j = 1; j < bytesHead.length && i + j < data.length && data[i + j] == bytesHead[j]; ++j) {
            }
            if (j != bytesHead.length) continue;
            return i;
        }
        return -1;
    }

    public static List<Integer> getIndexListOf(byte[] data, byte[] bytesHead) {
        ArrayList<Integer> pos = new ArrayList<Integer>();
        if (data == null || bytesHead == null || data.length == 0 || bytesHead.length == 0) {
            return null;
        }
        for (int i = 0; i < data.length; ++i) {
            int j;
            if (data[i] != bytesHead[0]) continue;
            for (j = 1; j < bytesHead.length && i + j < data.length && data[i + j] == bytesHead[j]; ++j) {
            }
            if (j != bytesHead.length) continue;
            pos.add(i);
        }
        return pos;
    }

    public static byte[] charToByte(char c) {
        byte[] b = new byte[]{(byte)((c & 0xFF00) >> 8), (byte)(c & 0xFF)};
        return b;
    }

    public static char byteToChar(byte[] b) {
        char c = (char)((b[0] & 0xFF) << 8 | b[1] & 0xFF);
        return c;
    }

    public static String convertHexToString(String hex) {
        StringBuilder sb = new StringBuilder();
        StringBuilder temp = new StringBuilder();
        for (int i = 0; i < hex.length() - 1; i += 2) {
            String output = hex.substring(i, i + 2);
            int decimal = Integer.parseInt(output, 16);
            sb.append((char)decimal);
            temp.append(decimal);
        }
        return sb.toString();
    }

    public static int byteToInt2(byte[] b) {
        return b[1] & 0xFF | (b[0] & 0xFF) << 8;
    }
}

