/*
 * Decompiled with CFR 0.152.
 */
package com.taiyi.typulse.tyusbsdk;

import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.annotation.Nullable;
import com.github.mikephil.charting.charts.CombinedChart;
import com.github.mikephil.charting.components.Legend;
import com.github.mikephil.charting.data.BubbleData;
import com.github.mikephil.charting.data.BubbleDataSet;
import com.github.mikephil.charting.data.BubbleEntry;
import com.github.mikephil.charting.data.CombinedData;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.data.LineData;
import com.github.mikephil.charting.data.LineDataSet;
import com.github.mikephil.charting.interfaces.datasets.ILineDataSet;
import com.taiyi.typulse.R;
import com.taiyi.typulse.tyusbsdk.RealTimeDataItem;
import com.taiyi.typulse.tyusbsdk.pulse.util.LogUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class RealTimeDataGraphView
extends LinearLayout {
    private final CombinedChart[] charts = new CombinedChart[3];
    private float minTrueY = -40.0f;
    private float maxTrueY = 40.0f;
    private int maxX = 135;
    private int lineSize = 10;
    private float intervalY = 0.0f;
    private float maxRealY = 0.0f;
    private float minRealY = 0.0f;
    private List<List<Float>> chartsData = new ArrayList<List<Float>>();
    private List<String> timeArray = new ArrayList<String>();
    private final int[] colors = new int[]{Color.rgb((int)217, (int)102, (int)67), Color.rgb((int)20, (int)144, (int)121), Color.rgb((int)55, (int)99, (int)73), Color.rgb((int)102, (int)199, (int)238), Color.rgb((int)238, (int)105, (int)105), Color.rgb((int)39, (int)109, (int)151), Color.rgb((int)102, (int)142, (int)238), Color.rgb((int)177, (int)102, (int)238), Color.rgb((int)238, (int)110, (int)213), Color.rgb((int)0, (int)141, (int)180)};
    private Handler timerHandler = new Handler();
    private Runnable timerRunnable = new Runnable(){

        @Override
        public void run() {
        }
    };

    public RealTimeDataGraphView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    private void init(Context context) {
        View layout2 = LayoutInflater.from((Context)context).inflate(R.layout.realtime_data_graph_view, (ViewGroup)this);
        this.charts[0] = (CombinedChart)layout2.findViewById(R.id.chart1);
        this.charts[1] = (CombinedChart)layout2.findViewById(R.id.chart2);
        this.charts[2] = (CombinedChart)layout2.findViewById(R.id.chart3);
        for (int i = 0; i < this.charts.length; ++i) {
            this.setupChart(this.charts[i]);
        }
    }

    private void setupChart(CombinedChart chart) {
        chart.getDescription().setEnabled(false);
        chart.setDrawGridBackground(false);
        chart.setTouchEnabled(false);
        chart.setDragEnabled(false);
        chart.setScaleEnabled(false);
        chart.setPinchZoom(false);
        chart.setDrawOrder(new CombinedChart.DrawOrder[]{CombinedChart.DrawOrder.LINE, CombinedChart.DrawOrder.BUBBLE});
        chart.setBackgroundColor(0);
        chart.setViewPortOffsets(10.0f, 0.0f, 10.0f, 0.0f);
        CombinedData data = new CombinedData();
        ArrayList<LineDataSet> lineDataSets = new ArrayList<LineDataSet>();
        for (int i = 0; i < this.lineSize; ++i) {
            ArrayList values = new ArrayList();
            LineDataSet d = new LineDataSet(values, "");
            d.setMode(LineDataSet.Mode.CUBIC_BEZIER);
            int color2 = this.colors[this.colors.length - 1 - i % this.colors.length];
            d.setDrawValues(false);
            d.setCircleColor(Color.rgb((int)235, (int)51, (int)32));
            d.setCircleHoleColor(Color.rgb((int)235, (int)51, (int)32));
            d.setCircleRadius(1.5f);
            d.setDrawCircles(false);
            d.setColor(color2);
            d.setLineWidth(1.0f);
            lineDataSets.add(d);
        }
        data.setData(new LineData(lineDataSets));
        ArrayList<BubbleDataSet> bubbleDataSets = new ArrayList<BubbleDataSet>();
        for (int i = 0; i < this.lineSize; ++i) {
            ArrayList values = new ArrayList();
            BubbleDataSet set = new BubbleDataSet(values, "");
            set.setColor(Color.rgb((int)235, (int)51, (int)32));
            set.setDrawValues(false);
            set.setDrawIcons(false);
            set.setHighlightEnabled(false);
            set.setNormalizeSizeEnabled(false);
            bubbleDataSets.add(set);
        }
        data.setData(new BubbleData(bubbleDataSets));
        chart.setData(data);
        Legend l = chart.getLegend();
        l.setEnabled(false);
        chart.getAxisLeft().setEnabled(false);
        chart.getAxisLeft().setSpaceTop(40.0f);
        chart.getAxisLeft().setSpaceBottom(40.0f);
        chart.getAxisRight().setEnabled(false);
        chart.getXAxis().setEnabled(false);
        chart.getAxisLeft().setAxisMaximum((this.maxTrueY - this.minTrueY + this.intervalY) * (float)this.lineSize);
        chart.getAxisLeft().setAxisMinimum(0.0f);
        chart.animateX(1000);
    }

    public void addLinePoint(RealTimeDataItem realTimeData) {
        this.timeArray.add(realTimeData.time);
        ArrayList<Float> columnData = new ArrayList<Float>();
        for (int x = 0; x < this.charts.length; ++x) {
            CombinedChart chart = this.charts[x];
            CombinedData data = (CombinedData)chart.getData();
            if (data == null) continue;
            LineData lineData = data.getLineData();
            for (int i = 0; i < lineData.getDataSets().size(); ++i) {
                ILineDataSet set = (ILineDataSet)lineData.getDataSetByIndex(i);
                int realTimeDataIndex = 0;
                if (x == 0) {
                    realTimeDataIndex = 1 + i * 3;
                } else if (x == 1) {
                    realTimeDataIndex = 33 + i * 3;
                } else if (x == 2) {
                    realTimeDataIndex = 65 + i * 3;
                }
                float realTimeDataPoint = realTimeData.dataArray.get(realTimeDataIndex).floatValue();
                if (realTimeDataPoint > this.maxRealY) {
                    this.maxRealY = realTimeDataPoint;
                }
                if (realTimeDataPoint < this.minRealY) {
                    this.minRealY = realTimeDataPoint;
                }
                columnData.add(Float.valueOf(realTimeDataPoint));
                lineData.addEntry(new Entry((float)set.getEntryCount(), (float)((double)realTimeDataPoint + (double)(this.maxTrueY - this.minTrueY) * 0.5 + (double)this.intervalY * 0.5 + (double)i * ((double)(this.maxTrueY - this.minTrueY) + (double)this.intervalY * 0.5))), i);
            }
            data.notifyDataChanged();
            chart.notifyDataSetChanged();
            chart.setVisibleXRangeMaximum((float)this.maxX);
            chart.moveViewToX((float)data.getLineData().getEntryCount());
        }
        this.chartsData.add(columnData);
    }

    public void addBubblePoint(List<Integer> indexArray) {
        if (Build.VERSION.SDK_INT >= 24) {
            LogUtil.d("RealTimeDataGraphView", "\u5468\u671f\u63cf\u70b9" + indexArray.stream().map(String::valueOf).collect(Collectors.joining(",")));
        }
        for (int x = 0; x < this.charts.length; ++x) {
            CombinedChart chart = this.charts[x];
            CombinedData data = (CombinedData)chart.getData();
            if (data == null) continue;
            BubbleData bubbleData = data.getBubbleData();
            LineData lineData = data.getLineData();
            for (int i = 0; i < bubbleData.getDataSets().size(); ++i) {
                int endJIndex;
                int targetTime;
                int j;
                int startBubbleTime = indexArray.get(x * 2);
                int endBubbleTime = indexArray.get(x * 2 + 1);
                if (startBubbleTime > 0) {
                    int startJIndex;
                    int startBubbleIndex = -1;
                    for (j = startJIndex = this.timeArray.size() - this.maxX - 20 < 0 ? 0 : this.timeArray.size() - this.maxX - 20; j < this.timeArray.size(); ++j) {
                        targetTime = Integer.parseInt(this.timeArray.get(j));
                        if (startBubbleTime != targetTime) continue;
                        startBubbleIndex = j;
                        break;
                    }
                    if (startBubbleIndex > 0) {
                        bubbleData.addEntry((Entry)new BubbleEntry((float)startBubbleIndex, ((ILineDataSet)lineData.getDataSetByIndex(i)).getEntryForIndex(startBubbleIndex).getY(), 3.0f), i);
                    }
                }
                if (endBubbleTime <= 0) continue;
                int endBubbleIndex = -1;
                for (j = endJIndex = this.timeArray.size() - this.maxX - 20 < 0 ? 0 : this.timeArray.size() - this.maxX - 20; j < this.timeArray.size(); ++j) {
                    targetTime = Integer.parseInt(this.timeArray.get(j));
                    if (endBubbleTime != targetTime) continue;
                    endBubbleIndex = j;
                    break;
                }
                if (endBubbleIndex <= 0) continue;
                bubbleData.addEntry((Entry)new BubbleEntry((float)endBubbleIndex, ((ILineDataSet)lineData.getDataSetByIndex(i)).getEntryForIndex(endBubbleIndex).getY(), 3.0f), i);
            }
        }
    }
}

