/*
 * Decompiled with CFR 0.152.
 */
package com.taiyi.typulse.tyusbsdk.pulse.net;

import android.content.Context;
import android.text.TextUtils;
import android.widget.Toast;
import com.android.volley.AuthFailureError;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.BaseHttpStack;
import com.android.volley.toolbox.HurlStack;
import com.android.volley.toolbox.JsonObjectRequest;
import com.android.volley.toolbox.StringRequest;
import com.android.volley.toolbox.Volley;
import com.taiyi.typulse.tyusbsdk.USBDataTemp;
import com.taiyi.typulse.tyusbsdk.pulse.TaiyiManager;
import com.taiyi.typulse.tyusbsdk.pulse.bean.BaseBean;
import com.taiyi.typulse.tyusbsdk.pulse.bean.PulseParam;
import com.taiyi.typulse.tyusbsdk.pulse.bean.PulseParamTen;
import com.taiyi.typulse.tyusbsdk.pulse.net.FormPostStringRequest;
import com.taiyi.typulse.tyusbsdk.pulse.net.HttpImpl;
import com.taiyi.typulse.tyusbsdk.pulse.net.KeyStringRequest;
import com.taiyi.typulse.tyusbsdk.pulse.net.ResponseParser;
import com.taiyi.typulse.tyusbsdk.pulse.net.TokenOverDueHttpImpl;
import com.taiyi.typulse.tyusbsdk.pulse.net.TokenPostJsonRequest;
import com.taiyi.typulse.tyusbsdk.pulse.net.TokenStringRequest;
import com.taiyi.typulse.tyusbsdk.pulse.util.LogUtil;
import com.taiyi.typulse.tyusbsdk.pulse.util.ProgressDialogUtil;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class HttpUtil {
    private final String TAG = "HttpUtil";
    private RequestQueue mQueue = null;
    private Context mContext;
    public static String SDKClientHeaderKey = "X-SDKClient-API-Key";
    public static String SDKClientHeaderValue = "e517ed538290423083825f6078985c9b";
    public static String AuthorizationKey = "Authorization";
    public static String AuthorizationValue;
    private static String baseUrl;
    private static String checkUrl;
    private static String uuidUrl;
    private static String saveMaiHeatReportUrl;
    private static String measurePulseSaveUrl;
    private static String measurePulseResultUrl;
    private static String saveCombinedUrl;
    private static String saveMaiReportUrl;
    private static String getCombinedReportDesc;
    public static final String OVERDUE_CODE = "10000401";
    private static HttpUtil instance;

    public HttpUtil getRequestQueue(Context context) {
        this.mContext = context;
        if (this.mQueue == null) {
            try {
                this.mQueue = Volley.newRequestQueue((Context)context.getApplicationContext(), (BaseHttpStack)this.getHurlStack(this.mContext.getAssets().open("girl_client.bks"), "123456", this.mContext.getAssets().open("boy_server.cer")));
            }
            catch (Exception e) {
                LogUtil.w("HttpUtil", "volley init error" + e.getMessage());
                try {
                    this.mQueue = Volley.newRequestQueue((Context)context.getApplicationContext());
                }
                catch (Exception ex) {
                    LogUtil.w("HttpUtil", "default volley init error" + ex.getMessage());
                }
            }
        }
        if (this.mQueue != null) {
            this.mQueue.addRequestEventListener(new RequestQueue.RequestEventListener(){

                public void onRequestEvent(Request<?> request, int event) {
                    if (event == 5) {
                        LogUtil.w("volley", request.getUrl() + "---------" + event);
                        Map headers = null;
                        try {
                            headers = request.getHeaders();
                        }
                        catch (AuthFailureError e) {
                            throw new RuntimeException(e);
                        }
                        if (!headers.isEmpty()) {
                            for (Map.Entry stringStringEntry : headers.entrySet()) {
                                LogUtil.w("volley", "header.key:" + (String)stringStringEntry.getKey() + ",header.value:" + (String)stringStringEntry.getValue());
                            }
                        }
                    }
                }
            });
        }
        LogUtil.w("HttpUtil", "mQueue==null" + (this.mQueue == null));
        return this;
    }

    private HurlStack getHurlStack(InputStream bksFile, String password, InputStream ... certificates) {
        return new HurlStack(null, HttpUtil.initCertificates(bksFile, password, certificates));
    }

    private HttpUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HttpUtil getInstance() {
        if (instance != null) return instance;
        Class<HttpUtil> clazz = HttpUtil.class;
        synchronized (HttpUtil.class) {
            if (instance != null) return instance;
            instance = new HttpUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void check(HttpImpl httpImpl) {
        String url = checkUrl + "?appId=" + TaiyiManager.getInstance().getAppId() + "&appSecret=" + TaiyiManager.getInstance().getAppSecret();
        LogUtil.w("HttpUtil", "check url:" + url);
        this.mQueue.add((Request)this.getKeyStringRequest(url, httpImpl));
    }

    public void webViewCheck(HttpImpl httpImpl) {
        String url = checkUrl + "?appId=" + TaiyiManager.getInstance().getAppId() + "&appSecret=" + TaiyiManager.getInstance().getAppSecret();
        LogUtil.w("HttpUtil", "check url:" + url);
        this.mQueue.add((Request)this.getKeyStringRequestNoLoading(url, httpImpl));
    }

    public void getUUID(TokenOverDueHttpImpl<String> httpImpl) {
        LogUtil.w("HttpUtil", "uuid url:" + uuidUrl);
        this.mQueue.add((Request)this.getFormRequest(uuidUrl, httpImpl));
    }

    public void measurePulseSave(PulseParamTen paramTen, TokenOverDueHttpImpl<String> tokenOverDueHttpImpl) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("session", paramTen.session);
        map.put("measure_id", paramTen.measure_id);
        map.put("hand", paramTen.hand);
        map.put("app_name", paramTen.app_name);
        map.put("system_name", paramTen.system_name);
        map.put("system_version", paramTen.system_version);
        map.put("device_version", paramTen.device_version);
        map.put("device_model", paramTen.device_model);
        map.put("firmware_version", paramTen.firmware_version);
        map.put("hardware_version", paramTen.hardware_version);
        map.put("alg_version", paramTen.alg_version);
        map.put("channel_id", paramTen.channel_id);
        map.put("timezone", paramTen.timezone);
        map.put("time", paramTen.time);
        map.put("consumer", paramTen.consumer);
        map.put("provider", paramTen.provider);
        map.put("data_url", paramTen.data_url);
        map.put("upDownFlag", paramTen.upDownFlag);
        map.put("sortFlag", paramTen.sortFlag);
        map.put("score", 0);
        JSONObject object = new JSONObject(map);
        LogUtil.w("HttpUtil", "save url:" + measurePulseSaveUrl + "\n" + object.toString());
        this.mQueue.add((Request)this.getJsonObjectRequest(measurePulseSaveUrl, object, tokenOverDueHttpImpl));
    }

    public void getMeasurePulseResult(TokenOverDueHttpImpl<String> httpImpl) {
        String url = measurePulseResultUrl + "?measureId=" + USBDataTemp.getInstance().measure_id + "&access_session=" + AuthorizationValue;
        LogUtil.w("HttpUtil", "result url:" + url);
        this.mQueue.add((Request)this.getKeyStringRequest(url, httpImpl));
    }

    public void saveCombined(String measure_id_left, String measure_id_right, TokenOverDueHttpImpl<String> httpImpl) {
        String url = saveCombinedUrl;
        if (!TextUtils.isEmpty((CharSequence)measure_id_left) && !TextUtils.isEmpty((CharSequence)measure_id_right)) {
            url = url + "?measure_id_left=" + measure_id_left + "&measure_id_right=" + measure_id_right;
        } else if (!TextUtils.isEmpty((CharSequence)measure_id_left)) {
            url = url + "?measure_id_left=" + measure_id_left;
        } else if (!TextUtils.isEmpty((CharSequence)measure_id_right)) {
            url = url + "?measure_id_right=" + measure_id_right;
        }
        LogUtil.w("HttpUtil", "result url:" + url);
        this.mQueue.add((Request)this.getTokenStringRequest(url, httpImpl));
    }

    public void getCombinedDesc(String combinedId, TokenOverDueHttpImpl<String> httpImpl) {
        String url = getCombinedReportDesc + "?combinedId=" + combinedId + "&access_session=" + AuthorizationValue + "&X_SDKClient_API_Key=" + SDKClientHeaderValue;
        LogUtil.w("HttpUtil", "result url:" + url);
        this.mQueue.add((Request)this.getPulseDescRequest(url, httpImpl));
    }

    public void getPulseTotalDesc(String combinedId, TokenOverDueHttpImpl<String> httpImpl) {
        String url = getCombinedReportDesc + "?combinedId=" + combinedId + "&access_session=" + AuthorizationValue + "&X_SDKClient_API_Key=" + SDKClientHeaderValue;
        LogUtil.w("HttpUtil", "result url:" + url);
        this.mQueue.add((Request)this.getTotalPulseDescRequest(url, httpImpl));
    }

    public void saveMai(PulseParam pulseParam, TokenOverDueHttpImpl<String> tokenOverDueHttpImpl) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("access_session", pulseParam.access_session);
        map.put("measure_id", pulseParam.measure_id);
        map.put("app_name", pulseParam.app_name);
        map.put("appId", pulseParam.appId);
        map.put("uid", pulseParam.uid);
        map.put("system_name", pulseParam.system_name);
        map.put("system_version", pulseParam.system_version);
        map.put("device_model", pulseParam.device_model);
        map.put("firmware_version", pulseParam.firmware_version);
        map.put("hardware_version", pulseParam.hardware_version);
        map.put("alg_version", pulseParam.alg_version);
        map.put("consumer", pulseParam.consumer);
        map.put("provider", pulseParam.provider);
        map.put("hand", pulseParam.hand);
        map.put("heart_rate", pulseParam.heart_rate);
        map.put("cun_xian_ruan", Float.valueOf(pulseParam.cun_xian_ruan));
        map.put("cun_hua_xi", Float.valueOf(pulseParam.cun_hua_xi));
        map.put("cun_fu_chen", Float.valueOf(pulseParam.cun_fu_chen));
        map.put("cun_kong_shi", Float.valueOf(pulseParam.cun_kong_shi));
        map.put("guan_xian_ruan", Float.valueOf(pulseParam.guan_xian_ruan));
        map.put("guan_hua_xi", Float.valueOf(pulseParam.guan_hua_xi));
        map.put("guan_fu_chen", Float.valueOf(pulseParam.guan_fu_chen));
        map.put("guan_kong_shi", Float.valueOf(pulseParam.guan_kong_shi));
        map.put("chi_xian_ruan", Float.valueOf(pulseParam.chi_xian_ruan));
        map.put("chi_hua_xi", Float.valueOf(pulseParam.chi_hua_xi));
        map.put("chi_fu_chen", Float.valueOf(pulseParam.chi_fu_chen));
        map.put("chi_kong_shi", Float.valueOf(pulseParam.chi_kong_shi));
        map.put("shu_chi", Float.valueOf(pulseParam.shu_chi));
        map.put("cun_amp_max", Float.valueOf(pulseParam.cun_amp_max));
        map.put("cun_emerge_force", pulseParam.cun_emerge_force);
        map.put("cun_width", Float.valueOf(pulseParam.cun_width));
        map.put("cun_a_w_ratio", pulseParam.cun_a_w_ratio);
        map.put("cun_vital_pres", pulseParam.cun_vital_pres);
        map.put("guan_amp_max", Float.valueOf(pulseParam.guan_amp_max));
        map.put("guan_emerge_force", pulseParam.guan_emerge_force);
        map.put("guan_width", Float.valueOf(pulseParam.guan_width));
        map.put("guan_a_w_ratio", pulseParam.guan_a_w_ratio);
        map.put("guan_vital_pres", pulseParam.guan_vital_pres);
        map.put("chi_amp_max", Float.valueOf(pulseParam.chi_amp_max));
        map.put("chi_emerge_force", pulseParam.chi_emerge_force);
        map.put("chi_width", Float.valueOf(pulseParam.chi_width));
        map.put("chi_a_w_ratio", pulseParam.chi_a_w_ratio);
        map.put("chi_vital_pres", pulseParam.chi_vital_pres);
        map.put("cun_desc", pulseParam.cun_desc);
        map.put("guan_desc", pulseParam.guan_desc);
        map.put("chi_desc", pulseParam.chi_desc);
        map.put("shuchi_desc", pulseParam.shuchi_desc);
        map.put("shu", pulseParam.shu);
        map.put("chi", pulseParam.chi);
        map.put("hua", pulseParam.hua);
        map.put("xi", pulseParam.xi);
        map.put("xian", pulseParam.xian);
        map.put("ruan", pulseParam.ruan);
        map.put("fu", pulseParam.fu);
        map.put("chen", pulseParam.chen);
        map.put("shi", pulseParam.shi);
        map.put("kong", pulseParam.kong);
        map.put("score", Float.valueOf(pulseParam.score));
        map.put("cal_qiblood", pulseParam.cal_qiblood);
        map.put("channel_id", pulseParam.channel_id);
        map.put("cun_solid", pulseParam.cun_solid);
        map.put("guan_solid", pulseParam.guan_solid);
        map.put("chi_solid", pulseParam.chi_solid);
        map.put("timezone", pulseParam.timezone);
        map.put("time", pulseParam.time);
        JSONObject object = new JSONObject(map);
        this.mQueue.add((Request)this.getJsonObjectRequest(saveMaiReportUrl, object, tokenOverDueHttpImpl));
    }

    public void saveHeatMapMai(PulseParam pp, TokenOverDueHttpImpl<String> tokenOverDueHttpImpl) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("access_session", pp.access_session);
        map.put("measure_id", pp.measure_id);
        map.put("app_name", pp.app_name);
        map.put("appId", pp.appId);
        map.put("uid", pp.uid);
        map.put("system_name", pp.system_name);
        map.put("system_version", pp.system_version);
        map.put("device_model", pp.device_model);
        map.put("firmware_version", pp.firmware_version);
        map.put("hardware_version", pp.hardware_version);
        map.put("alg_version", pp.alg_version);
        map.put("consumer", pp.consumer);
        map.put("provider", pp.provider);
        map.put("hand", pp.hand);
        map.put("heart_rate", pp.heart_rate);
        map.put("cun_xian_ruan", Float.valueOf(pp.cun_xian_ruan));
        map.put("cun_hua_xi", Float.valueOf(pp.cun_hua_xi));
        map.put("cun_fu_chen", Float.valueOf(pp.cun_fu_chen));
        map.put("cun_kong_shi", Float.valueOf(pp.cun_kong_shi));
        map.put("guan_xian_ruan", Float.valueOf(pp.guan_xian_ruan));
        map.put("guan_hua_xi", Float.valueOf(pp.guan_hua_xi));
        map.put("guan_fu_chen", Float.valueOf(pp.guan_fu_chen));
        map.put("guan_kong_shi", Float.valueOf(pp.guan_kong_shi));
        map.put("chi_xian_ruan", Float.valueOf(pp.chi_xian_ruan));
        map.put("chi_hua_xi", Float.valueOf(pp.chi_hua_xi));
        map.put("chi_fu_chen", Float.valueOf(pp.chi_fu_chen));
        map.put("chi_kong_shi", Float.valueOf(pp.chi_kong_shi));
        map.put("shu_chi", Float.valueOf(pp.shu_chi));
        map.put("cun_amp_max", Float.valueOf(pp.cun_amp_max));
        map.put("cun_emerge_force", pp.cun_emerge_force);
        map.put("cun_width", Float.valueOf(pp.cun_width));
        map.put("cun_a_w_ratio", pp.cun_a_w_ratio);
        map.put("cun_vital_pres", pp.cun_vital_pres);
        map.put("guan_amp_max", Float.valueOf(pp.guan_amp_max));
        map.put("guan_emerge_force", pp.guan_emerge_force);
        map.put("guan_width", Float.valueOf(pp.guan_width));
        map.put("guan_a_w_ratio", pp.guan_a_w_ratio);
        map.put("guan_vital_pres", pp.guan_vital_pres);
        map.put("chi_amp_max", Float.valueOf(pp.chi_amp_max));
        map.put("chi_emerge_force", pp.chi_emerge_force);
        map.put("chi_width", Float.valueOf(pp.chi_width));
        map.put("chi_a_w_ratio", pp.chi_a_w_ratio);
        map.put("chi_vital_pres", pp.chi_vital_pres);
        map.put("cun_desc", pp.cun_desc);
        map.put("guan_desc", pp.guan_desc);
        map.put("chi_desc", pp.chi_desc);
        map.put("shuchi_desc", pp.shuchi_desc);
        map.put("shu", pp.shu);
        map.put("chi", pp.chi);
        map.put("hua", pp.hua);
        map.put("xi", pp.xi);
        map.put("xian", pp.xian);
        map.put("ruan", pp.ruan);
        map.put("fu", pp.fu);
        map.put("chen", pp.chen);
        map.put("shi", pp.shi);
        map.put("kong", pp.kong);
        map.put("score", Float.valueOf(pp.score));
        map.put("cal_qiblood", pp.cal_qiblood);
        map.put("channel_id", pp.channel_id);
        map.put("cun_solid", pp.cun_solid);
        map.put("guan_solid", pp.guan_solid);
        map.put("chi_solid", pp.chi_solid);
        map.put("timezone", pp.timezone);
        map.put("time", pp.time);
        map.put("heatmap_data_raw_url", pp.heatmap_data_raw_url);
        map.put("upDownFlag", pp.upDownFlag);
        map.put("sortFlag", pp.sortFlag);
        JSONObject object = new JSONObject(map);
        this.mQueue.add((Request)this.getJsonObjectRequest(saveMaiHeatReportUrl, object, tokenOverDueHttpImpl));
    }

    public void getResultStatus(String measureId, TokenOverDueHttpImpl<String> httpImpl) {
        String url = measurePulseResultUrl + "?measureId=" + measureId + "&access_session=" + AuthorizationValue;
        this.mQueue.add((Request)this.getStatusRequest(url, httpImpl));
    }

    private StringRequest getStatusRequest(String url, final HttpImpl<String> httpImpl) {
        return new KeyStringRequest(0, url, new Response.Listener<String>(){

            public void onResponse(String s) {
                if (httpImpl != null) {
                    BaseBean bean = ResponseParser.parse(s);
                    if (bean.success()) {
                        httpImpl.showResponse(bean.data);
                    } else {
                        httpImpl.showError(bean.message);
                    }
                } else {
                    Toast.makeText((Context)HttpUtil.this.mContext, (CharSequence)"\u8bf7\u8bbe\u7f6ehttpImpl", (int)0).show();
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError volleyError) {
                ProgressDialogUtil.close();
                if (httpImpl != null) {
                    httpImpl.showError(volleyError.getMessage());
                } else {
                    Toast.makeText((Context)HttpUtil.this.mContext, (CharSequence)"\u8bf7\u8bbe\u7f6ehttpImpl", (int)0).show();
                }
            }
        });
    }

    private StringRequest getKeyStringRequest(String url, final HttpImpl<String> httpImpl) {
        ProgressDialogUtil.show(this.mContext);
        return new KeyStringRequest(0, url, new Response.Listener<String>(){

            public void onResponse(String s) {
                LogUtil.w("HttpUtil", s.toString());
                ProgressDialogUtil.close();
                if (httpImpl != null) {
                    BaseBean bean = ResponseParser.parse(s);
                    if (bean.success()) {
                        httpImpl.showResponse(bean.data);
                    } else {
                        httpImpl.showError(bean.message);
                    }
                } else {
                    Toast.makeText((Context)HttpUtil.this.mContext, (CharSequence)"\u8bf7\u8bbe\u7f6ehttpImpl", (int)0).show();
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError volleyError) {
                ProgressDialogUtil.close();
                if (httpImpl != null) {
                    httpImpl.showError(volleyError.getMessage());
                } else {
                    Toast.makeText((Context)HttpUtil.this.mContext, (CharSequence)"\u8bf7\u8bbe\u7f6ehttpImpl", (int)0).show();
                }
            }
        });
    }

    private StringRequest getKeyStringRequestNoLoading(String url, final HttpImpl<String> httpImpl) {
        return new KeyStringRequest(0, url, new Response.Listener<String>(){

            public void onResponse(String s) {
                LogUtil.w("HttpUtil", s.toString());
                if (httpImpl != null) {
                    BaseBean bean = ResponseParser.parse(s);
                    if (bean.success()) {
                        httpImpl.showResponse(bean.data);
                    } else {
                        httpImpl.showError(bean.message);
                    }
                } else {
                    Toast.makeText((Context)HttpUtil.this.mContext, (CharSequence)"\u8bf7\u8bbe\u7f6ehttpImpl", (int)0).show();
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError volleyError) {
                if (httpImpl != null) {
                    httpImpl.showError(volleyError.getMessage());
                } else {
                    Toast.makeText((Context)HttpUtil.this.mContext, (CharSequence)"\u8bf7\u8bbe\u7f6ehttpImpl", (int)0).show();
                }
            }
        });
    }

    private StringRequest getTokenStringRequest(String url, final TokenOverDueHttpImpl<String> httpImpl) {
        ProgressDialogUtil.show(this.mContext);
        return new TokenStringRequest(0, url, new Response.Listener<String>(){

            public void onResponse(String s) {
                block9: {
                    LogUtil.w("HttpUtil", s.toString());
                    ProgressDialogUtil.close();
                    if (httpImpl != null) {
                        BaseBean bean = ResponseParser.parse(s);
                        if (bean.success()) {
                            try {
                                JSONObject jsonObject = new JSONObject(bean.data);
                                if (jsonObject.has("measure_id")) {
                                    String measureId = jsonObject.getString("measure_id");
                                    httpImpl.showResponse(measureId);
                                    break block9;
                                }
                                httpImpl.showError(bean.data);
                            }
                            catch (JSONException e) {
                                e.printStackTrace();
                                httpImpl.showError("\u6570\u636e\u89e3\u6790\u9519\u8bef: " + e.getMessage());
                            }
                        } else if (bean.overdue()) {
                            httpImpl.overdue();
                        } else {
                            httpImpl.showError(bean.message);
                        }
                    } else {
                        Toast.makeText((Context)HttpUtil.this.mContext, (CharSequence)"\u8bf7\u8bbe\u7f6ehttpImpl", (int)0).show();
                    }
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError volleyError) {
                ProgressDialogUtil.close();
                if (httpImpl != null) {
                    httpImpl.showError(volleyError.getMessage());
                } else {
                    Toast.makeText((Context)HttpUtil.this.mContext, (CharSequence)"\u8bf7\u8bbe\u7f6ehttpImpl", (int)0).show();
                }
            }
        });
    }

    private StringRequest getPulseDescRequest(String url, final TokenOverDueHttpImpl<String> httpImpl) {
        ProgressDialogUtil.show(this.mContext);
        return new TokenStringRequest(0, url, new Response.Listener<String>(){

            public void onResponse(String s) {
                block18: {
                    LogUtil.w("HttpUtil", s.toString());
                    ProgressDialogUtil.close();
                    if (httpImpl != null) {
                        BaseBean bean = ResponseParser.parse(s);
                        if (bean.success()) {
                            try {
                                JSONObject jsonObject = new JSONObject(bean.data);
                                if (jsonObject.has("summary_desc")) {
                                    JSONObject rightSummary;
                                    JSONObject summaryDesc = new JSONObject(jsonObject.getString("summary_desc"));
                                    String sum = "";
                                    if (summaryDesc.has("summary")) {
                                        JSONArray sumArray = summaryDesc.getJSONArray("summary");
                                        for (int i = 0; i < sumArray.length(); ++i) {
                                            sum = sum + sumArray.getString(i);
                                        }
                                    } else if (summaryDesc.has("left")) {
                                        JSONObject leftSummary = new JSONObject(summaryDesc.getString("left"));
                                        if (leftSummary.has("summary")) {
                                            JSONArray sumArray = leftSummary.getJSONArray("summary");
                                            for (int i = 0; i < sumArray.length(); ++i) {
                                                sum = sum + sumArray.getString(i);
                                            }
                                        }
                                    } else if (summaryDesc.has("right") && (rightSummary = new JSONObject(summaryDesc.getString("right"))).has("summary")) {
                                        JSONArray sumArray = rightSummary.getJSONArray("summary");
                                        for (int i = 0; i < sumArray.length(); ++i) {
                                            sum = sum + sumArray.getString(i);
                                        }
                                    }
                                    httpImpl.showResponse(sum);
                                    break block18;
                                }
                                httpImpl.showError(bean.data);
                            }
                            catch (JSONException e) {
                                e.printStackTrace();
                                httpImpl.showError("\u6570\u636e\u89e3\u6790\u9519\u8bef: " + e.getMessage());
                            }
                        } else if (bean.overdue()) {
                            httpImpl.overdue();
                        } else {
                            httpImpl.showError(bean.message);
                        }
                    } else {
                        Toast.makeText((Context)HttpUtil.this.mContext, (CharSequence)"\u8bf7\u8bbe\u7f6ehttpImpl", (int)0).show();
                    }
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError volleyError) {
                ProgressDialogUtil.close();
                if (httpImpl != null) {
                    httpImpl.showError(volleyError.getMessage());
                } else {
                    Toast.makeText((Context)HttpUtil.this.mContext, (CharSequence)"\u8bf7\u8bbe\u7f6ehttpImpl", (int)0).show();
                }
            }
        });
    }

    private StringRequest getTotalPulseDescRequest(String url, final TokenOverDueHttpImpl<String> httpImpl) {
        ProgressDialogUtil.show(this.mContext);
        return new TokenStringRequest(0, url, new Response.Listener<String>(){

            public void onResponse(String s) {
                block9: {
                    LogUtil.w("HttpUtil", "Raw response: " + s);
                    ProgressDialogUtil.close();
                    if (httpImpl != null) {
                        BaseBean bean = ResponseParser.parse(s);
                        if (bean.success()) {
                            try {
                                JSONObject jsonObject = new JSONObject(bean.data);
                                if (jsonObject.has("summary_desc")) {
                                    LogUtil.w("HttpUtil", "Sending data to showResponse: " + bean.data);
                                    httpImpl.showResponse(bean.data);
                                    break block9;
                                }
                                httpImpl.showError(bean.data);
                            }
                            catch (JSONException e) {
                                e.printStackTrace();
                                LogUtil.e("HttpUtil", "JSON parsing error in HttpUtil: " + e.getMessage());
                                LogUtil.e("HttpUtil", "Bean data causing error: " + bean.data);
                                httpImpl.showError("\u6570\u636e\u89e3\u6790\u9519\u8bef: " + e.getMessage());
                            }
                        } else if (bean.overdue()) {
                            httpImpl.overdue();
                        } else {
                            httpImpl.showError(bean.message);
                        }
                    } else {
                        Toast.makeText((Context)HttpUtil.this.mContext, (CharSequence)"\u8bf7\u8bbe\u7f6ehttpImpl", (int)0).show();
                    }
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError volleyError) {
                ProgressDialogUtil.close();
                if (httpImpl != null) {
                    httpImpl.showError(volleyError.getMessage());
                } else {
                    Toast.makeText((Context)HttpUtil.this.mContext, (CharSequence)"\u8bf7\u8bbe\u7f6ehttpImpl", (int)0).show();
                }
            }
        });
    }

    private StringRequest getFormRequest(String url, final TokenOverDueHttpImpl<String> httpImpl) {
        ProgressDialogUtil.show(this.mContext);
        return new FormPostStringRequest(1, url, new Response.Listener<String>(){

            public void onResponse(String s) {
                LogUtil.w("HttpUtil", s.toString());
                ProgressDialogUtil.close();
                if (httpImpl != null) {
                    BaseBean bean = ResponseParser.parse(s);
                    if (bean.success()) {
                        httpImpl.showResponse(bean.data);
                    } else if (bean.overdue()) {
                        httpImpl.overdue();
                    } else {
                        httpImpl.showError(bean.message);
                    }
                } else {
                    Toast.makeText((Context)HttpUtil.this.mContext, (CharSequence)"\u8bf7\u8bbe\u7f6ehttpImpl", (int)0).show();
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError volleyError) {
                ProgressDialogUtil.close();
                if (httpImpl != null) {
                    httpImpl.showError(volleyError.getMessage());
                } else {
                    Toast.makeText((Context)HttpUtil.this.mContext, (CharSequence)"\u8bf7\u8bbe\u7f6ehttpImpl", (int)0).show();
                }
            }
        });
    }

    private JsonObjectRequest getJsonObjectRequest(String url, JSONObject jsonObject, final TokenOverDueHttpImpl<String> httpImpl) {
        return new TokenPostJsonRequest(1, url, jsonObject, new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject object) {
                LogUtil.w("HttpUtil", object.toString());
                if (httpImpl != null) {
                    BaseBean bean = ResponseParser.parse(object.toString());
                    if (bean.success()) {
                        httpImpl.showResponse(bean.data);
                    } else if (bean.overdue()) {
                        httpImpl.overdue();
                    } else {
                        httpImpl.showError(bean.message);
                    }
                } else {
                    Toast.makeText((Context)HttpUtil.this.mContext, (CharSequence)"\u8bf7\u8bbe\u7f6ehttpImpl", (int)0).show();
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError volleyError) {
                if (httpImpl != null) {
                    httpImpl.showError(volleyError.getMessage());
                } else {
                    Toast.makeText((Context)HttpUtil.this.mContext, (CharSequence)"\u8bf7\u8bbe\u7f6ehttpImpl", (int)0).show();
                }
            }
        });
    }

    public static SSLSocketFactory initCertificates(InputStream bksFile, String password, InputStream[] certificates) {
        try {
            TrustManager[] trustManagers = HttpUtil.prepareTrustManager(certificates);
            KeyManager[] keyManagers = HttpUtil.prepareKeyManager(bksFile, password);
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(keyManagers, new TrustManager[]{new MyTrustManager(HttpUtil.chooseTrustManager(trustManagers))}, new SecureRandom());
            return sslContext.getSocketFactory();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static TrustManager[] prepareTrustManager(InputStream ... certificates) {
        if (certificates == null || certificates.length <= 0) {
            return null;
        }
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null);
            int index = 0;
            for (InputStream certificate : certificates) {
                String certificateAlias = Integer.toString(index++);
                keyStore.setCertificateEntry(certificateAlias, certificateFactory.generateCertificate(certificate));
                try {
                    if (certificate == null) continue;
                    certificate.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            TrustManagerFactory trustManagerFactory = null;
            trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
            return trustManagers;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static KeyManager[] prepareKeyManager(InputStream bksFile, String password) {
        try {
            if (bksFile == null || password == null) {
                return null;
            }
            KeyStore clientKeyStore = KeyStore.getInstance("BKS");
            clientKeyStore.load(bksFile, password.toCharArray());
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(clientKeyStore, password.toCharArray());
            return keyManagerFactory.getKeyManagers();
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (UnrecoverableKeyException e) {
            e.printStackTrace();
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static X509TrustManager chooseTrustManager(TrustManager[] trustManagers) {
        for (TrustManager trustManager : trustManagers) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            return (X509TrustManager)trustManager;
        }
        return null;
    }

    static {
        baseUrl = "https://api.reborn-tech.com/";
        checkUrl = baseUrl + "pmsecurity/sdk/app/check";
        uuidUrl = baseUrl + "pmsecurity/measure/uuid";
        saveMaiHeatReportUrl = baseUrl + "pmsecurity/measure/heatmapSave";
        measurePulseSaveUrl = baseUrl + "pmsecurity/measure/measurePulseSave";
        measurePulseResultUrl = baseUrl + "pmsecurity/measure/getMeasurePulseResult";
        saveCombinedUrl = baseUrl + "pmsecurity/measure/saveCombined";
        saveMaiReportUrl = baseUrl + "pmsecurity/measure/save";
        getCombinedReportDesc = baseUrl + "pmsecurity/report/getCombinedMai";
    }

    private static class MyTrustManager
    implements X509TrustManager {
        private X509TrustManager defaultTrustManager;
        private X509TrustManager localTrustManager;

        public MyTrustManager(X509TrustManager localTrustManager) throws NoSuchAlgorithmException, KeyStoreException {
            TrustManagerFactory var4 = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            var4.init((KeyStore)null);
            this.defaultTrustManager = HttpUtil.chooseTrustManager(var4.getTrustManagers());
            this.localTrustManager = localTrustManager;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            try {
                this.defaultTrustManager.checkServerTrusted(chain, authType);
            }
            catch (CertificateException ce) {
                this.localTrustManager.checkServerTrusted(chain, authType);
            }
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

