/*
 * Decompiled with CFR 0.152.
 */
package com.taiyi.typulse.tyusbsdk.pulse.ui;

import android.annotation.SuppressLint;
import android.app.Dialog;
import android.content.Context;
import android.os.Build;
import android.os.CountDownTimer;
import android.speech.tts.TextToSpeech;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.taiyi.typulse.R;
import com.taiyi.typulse.tyusbsdk.HandType;
import com.taiyi.typulse.tyusbsdk.MeasureType;
import com.taiyi.typulse.tyusbsdk.RealTimeMeasureStatus;
import com.taiyi.typulse.tyusbsdk.TYUsbDeviceActivity;
import com.taiyi.typulse.tyusbsdk.UsbEvent;
import com.taiyi.typulse.tyusbsdk.pulse.TaiyiManager;
import com.taiyi.typulse.tyusbsdk.pulse.bean.PulseParamTen;
import com.taiyi.typulse.tyusbsdk.pulse.bean.RealtimeWaveItem;
import com.taiyi.typulse.tyusbsdk.pulse.net.HttpUtil;
import com.taiyi.typulse.tyusbsdk.pulse.net.TokenOverDueHttpImpl;
import com.taiyi.typulse.tyusbsdk.pulse.util.AutoScrollRecyclerView;
import com.taiyi.typulse.tyusbsdk.pulse.util.DialogTipUtil;
import com.taiyi.typulse.tyusbsdk.pulse.util.LoadingView;
import com.taiyi.typulse.tyusbsdk.pulse.util.MaiFlowAdapter;
import com.taiyi.typulse.tyusbsdk.pulse.util.OnClickNoDoubleListener;
import com.taiyi.typulse.tyusbsdk.pulse.util.scenery.ElectricFanLoadingRenderer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.greenrobot.eventbus.EventBus;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Measure3DFlowActivity
extends TYUsbDeviceActivity {
    TextView mTvHand;
    ImageView mIvCancel;
    TextView mTvCun;
    TextView mTvGuan;
    TextView mTvChi;
    AutoScrollRecyclerView mAsrCun;
    AutoScrollRecyclerView mAsrGuan;
    AutoScrollRecyclerView mAsrChi;
    ImageView mIvHand;
    ConstraintLayout mClLoading;
    LoadingView mLv;
    private String measureId;
    private int hand;
    private MaiFlowAdapter cunAdapter;
    private MaiFlowAdapter guanAdapter;
    private MaiFlowAdapter chiAdapter;
    private int current = 4;
    private int[] changImgIds = new int[]{R.mipmap.mai_0, R.mipmap.chang_2, R.mipmap.chang_4, R.mipmap.chang_6, R.mipmap.chang_8, R.mipmap.chang_10, R.mipmap.chang_12, R.mipmap.chang_14, R.mipmap.chang_16, R.mipmap.chang_18, R.mipmap.chang_20, R.mipmap.chang_25, R.mipmap.chang_30, R.mipmap.chang_35, R.mipmap.chang_40};
    private int[] xiImgIds = new int[]{R.mipmap.mai_0, R.mipmap.xi_2, R.mipmap.xi_4, R.mipmap.xi_6, R.mipmap.xi_8, R.mipmap.xi_10, R.mipmap.xi_12, R.mipmap.xi_14, R.mipmap.xi_16, R.mipmap.xi_18, R.mipmap.xi_20, R.mipmap.xi_25, R.mipmap.xi_30, R.mipmap.xi_35, R.mipmap.xi_40};
    private int[] huaImgIds = new int[]{R.mipmap.mai_0, R.mipmap.hua_2, R.mipmap.hua_4, R.mipmap.hua_6, R.mipmap.hua_8, R.mipmap.hua_10, R.mipmap.hua_12, R.mipmap.hua_14, R.mipmap.hua_16, R.mipmap.hua_18, R.mipmap.hua_20, R.mipmap.hua_25, R.mipmap.hua_30, R.mipmap.hua_35, R.mipmap.hua_40};
    private TextToSpeech textToSpeech;
    private CountDownTimer mCountTimer;
    Dialog showDialog;

    @Override
    @SuppressLint(value={"CheckResult"})
    protected void init() {
        this.getWindow().addFlags(128);
        this.mTvHand = (TextView)this.findViewById(R.id.tv_hand);
        this.mIvCancel = (ImageView)this.findViewById(R.id.iv_cancel);
        this.mTvCun = (TextView)this.findViewById(R.id.tv_cun);
        this.mTvGuan = (TextView)this.findViewById(R.id.tv_guan);
        this.mTvChi = (TextView)this.findViewById(R.id.tv_chi);
        this.mAsrCun = (AutoScrollRecyclerView)this.findViewById(R.id.asr_cun);
        this.mAsrGuan = (AutoScrollRecyclerView)this.findViewById(R.id.asr_guan);
        this.mAsrChi = (AutoScrollRecyclerView)this.findViewById(R.id.asr_chi);
        this.mIvHand = (ImageView)this.findViewById(R.id.iv_hand);
        this.mClLoading = (ConstraintLayout)this.findViewById(R.id.cl_loading);
        this.mLv = (LoadingView)this.findViewById(R.id.lv);
        this.measureId = this.getIntent().getStringExtra("measureId");
        this.hand = this.getIntent().getIntExtra("hand", 0);
        this.mIvCancel.setColorFilter(ContextCompat.getColor((Context)this, (int)R.color.text_black));
        this.mTvHand.setText(this.hand == 0 ? R.string.measure_left_hand : R.string.measure_right_hand);
        this.mIvHand.setImageResource(this.hand == 0 ? R.mipmap.hand_left : R.mipmap.hand_right);
        this.mIvCancel.postDelayed(new Runnable(){

            @Override
            public void run() {
                Measure3DFlowActivity.this.startMeasure(Measure3DFlowActivity.this.hand == 0 ? HandType.LEFT_HAND : HandType.RIGHT_HAND, MeasureType.STEP_TYPE);
            }
        }, 300L);
        this.mAsrCun.post(new Runnable(){

            @Override
            public void run() {
                Measure3DFlowActivity.this.initFlow();
            }
        });
        this.mIvCancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Measure3DFlowActivity.this.showCancelDialog();
            }
        });
        ElectricFanLoadingRenderer renderer = new ElectricFanLoadingRenderer.Builder((Context)this).build();
        renderer.setRepeatCount(0);
        this.mLv.setLoadingRenderer(renderer);
        this.mLv.startAnimation();
        this.mClLoading.setOnClickListener((View.OnClickListener)new OnClickNoDoubleListener(){

            @Override
            public void onNoDoubleClick(View view) {
            }
        });
        this.initTTS();
    }

    private void initTTS() {
        this.textToSpeech = new TextToSpeech((Context)this, new TextToSpeech.OnInitListener(){

            public void onInit(int status) {
                if (status == 0) {
                    int result = Measure3DFlowActivity.this.textToSpeech.setLanguage(Locale.SIMPLIFIED_CHINESE);
                    if (result == -1 || result == -2) {
                        Log.d((String)"TextToSpeech", (String)"Not Support Chinese");
                        return;
                    }
                    Measure3DFlowActivity.this.textToSpeech.setPitch(1.0f);
                    Measure3DFlowActivity.this.textToSpeech.setSpeechRate(1.0f);
                } else {
                    Log.d((String)"TextToSpeech", (String)"Failed");
                }
            }
        });
    }

    private void changeFlowImg(AutoScrollRecyclerView asr, MaiFlowAdapter adapter, int[] data) {
        int lastVisibleItemPosition = ((LinearLayoutManager)asr.getLayoutManager()).findLastVisibleItemPosition();
        if (lastVisibleItemPosition != -1) {
            int[] imgIds;
            int level = data[0];
            if (level > 14) {
                level = 14;
            }
            switch (data[1]) {
                case 1: {
                    imgIds = this.xiImgIds;
                    break;
                }
                case 2: {
                    imgIds = this.huaImgIds;
                    break;
                }
                default: {
                    imgIds = this.changImgIds;
                }
            }
            for (int i = lastVisibleItemPosition + 1; i < adapter.getData().size(); ++i) {
                adapter.getData().set(i, imgIds[level]);
            }
            adapter.notifyDataSetChanged();
        }
    }

    private void changeWidth(int show) {
        if (this.current != show) {
            this.current = show;
            this.cunAdapter.setWidth(this.mAsrCun.getWidth() / show);
            this.guanAdapter.setWidth(this.mAsrGuan.getWidth() / show);
            this.chiAdapter.setWidth(this.mAsrChi.getWidth() / show);
        }
    }

    private void initFlow() {
        int speed = 100;
        LinearLayoutManager layoutCun = new LinearLayoutManager((Context)this, 0, false);
        this.mAsrCun.setLayoutManager((RecyclerView.LayoutManager)layoutCun);
        if (this.cunAdapter == null) {
            this.cunAdapter = new MaiFlowAdapter(this.mAsrCun.getWidth() / 2);
        }
        ArrayList<Integer> cun = new ArrayList<Integer>();
        for (int i = 0; i < 1000; ++i) {
            cun.add(R.mipmap.mai_0);
        }
        this.cunAdapter.setNewData(cun);
        this.mAsrCun.setAdapter((RecyclerView.Adapter)this.cunAdapter);
        this.mAsrCun.openAutoScroll(speed, false);
        LinearLayoutManager layoutGuan = new LinearLayoutManager((Context)this, 0, false);
        this.mAsrGuan.setLayoutManager((RecyclerView.LayoutManager)layoutGuan);
        if (this.guanAdapter == null) {
            this.guanAdapter = new MaiFlowAdapter(this.mAsrGuan.getWidth() / 2);
        }
        ArrayList<Integer> guan = new ArrayList<Integer>();
        for (int i = 0; i < 1000; ++i) {
            guan.add(R.mipmap.mai_0);
        }
        this.guanAdapter.setNewData(guan);
        this.mAsrGuan.setAdapter((RecyclerView.Adapter)this.guanAdapter);
        this.mAsrGuan.openAutoScroll(speed, false);
        LinearLayoutManager layoutChi = new LinearLayoutManager((Context)this, 0, false);
        this.mAsrChi.setLayoutManager((RecyclerView.LayoutManager)layoutChi);
        if (this.chiAdapter == null) {
            this.chiAdapter = new MaiFlowAdapter(this.mAsrChi.getWidth() / 2);
        }
        ArrayList<Integer> chi = new ArrayList<Integer>();
        for (int i = 0; i < 1000; ++i) {
            chi.add(R.mipmap.mai_0);
        }
        this.chiAdapter.setNewData(chi);
        this.mAsrChi.setAdapter((RecyclerView.Adapter)this.chiAdapter);
        this.mAsrChi.openAutoScroll(speed, false);
    }

    @Override
    public void sendMeasureStartCommand() {
        super.sendMeasureStartCommand();
    }

    private void showCancelDialog() {
        this.showDialog = DialogTipUtil.showSelectDialog((Context)this, this.getString(R.string.measure_cancel), this.getString(R.string.measure_cancel_tip), R.string.app_cancel, R.string.app_confirm, new DialogTipUtil.OptionClickCallback_I(){

            @Override
            public void leftClick() {
                Measure3DFlowActivity.this.showDialog = null;
            }

            @Override
            public void rightClick() {
                Measure3DFlowActivity.this.sendCancelMeasureCommand();
                Measure3DFlowActivity.this.finish();
            }
        });
    }

    @Override
    protected int initLayoutResId() {
        return R.layout.activity_measure_3dflow;
    }

    @Override
    protected void onRealTimeWaveGet(RealtimeWaveItem dataItem) {
        int show = Math.round((float)(dataItem.heart * 4) / 75.0f);
        if (show < 3) {
            show = 3;
        }
        if (show > 5) {
            show = 5;
        }
        Log.w((String)"MeasureFlowActivity", (String)("heart:" + show + " heart:" + (float)(dataItem.heart * 4) / 75.0f));
        this.changeFlowImg(this.mAsrCun, this.cunAdapter, dataItem.waveCun);
        this.changeFlowImg(this.mAsrGuan, this.guanAdapter, dataItem.waveGuan);
        this.changeFlowImg(this.mAsrChi, this.chiAdapter, dataItem.waveChi);
        this.changeWidth(2);
    }

    @Override
    protected void onMeasureStatusChanged(RealTimeMeasureStatus status) {
        this.textToSpeech.speak(status.getDescription(), 0, null);
    }

    @Override
    protected void onMeasureFinished() {
        super.onMeasureFinished();
        this.mAsrCun.openAutoScroll(0, false);
        this.mAsrGuan.openAutoScroll(0, false);
        this.mAsrChi.openAutoScroll(0, false);
        if (ActivityCompat.checkSelfPermission((Context)this, (String)"android.permission.WRITE_EXTERNAL_STORAGE") == 0) {
            this.uploadCsv();
        } else {
            this.popupPermissionTip("android.permission.WRITE_EXTERNAL_STORAGE", R.string.permission_storage_2);
        }
    }

    @Override
    protected void onPermissionGet(int requestCode) {
        this.uploadCsv();
    }

    private void uploadCsv() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Measure3DFlowActivity.this.showLoading();
            }
        });
        final String uid = TaiyiManager.getInstance().getUid();
        this.uploadCSV(uid, new TYUsbDeviceActivity.OssInterface(){

            @Override
            public void onStartUpload() {
            }

            @Override
            public void onSuccessUpload(String url) {
                Measure3DFlowActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                    }
                });
                PulseParamTen pulseParam = PulseParamTen.getParams("", Measure3DFlowActivity.this.hand, "20", "Android", Build.VERSION.SDK_INT + "", uid, uid, url, 0, "F");
                Measure3DFlowActivity.this.uploadPulseData(pulseParam);
            }

            @Override
            public void onFailedUpload() {
                Measure3DFlowActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        DialogTipUtil.showIKnow((Context)Measure3DFlowActivity.this, Measure3DFlowActivity.this.getString(R.string.unify_8), new DialogTipUtil.CommonCallback_I(){

                            @Override
                            public void onSuccess(String str) {
                                Measure3DFlowActivity.this.setResult(-1);
                                Measure3DFlowActivity.this.finish();
                            }
                        });
                    }
                });
            }
        });
    }

    private void showLoading() {
        this.mClLoading.setVisibility(0);
        this.mLv.startAnimation();
    }

    private void dismissLoading() {
        this.mLv.stopAnimation();
        this.mClLoading.setVisibility(8);
    }

    private void uploadPulseData(PulseParamTen pulseParam) {
        HttpUtil.getInstance().measurePulseSave(pulseParam, new TokenOverDueHttpImpl<String>(){

            @Override
            public void overdue() {
            }

            @Override
            public void showError(String error) {
                Measure3DFlowActivity.this.showDialog = DialogTipUtil.showIKnow((Context)Measure3DFlowActivity.this, Measure3DFlowActivity.this.getString(R.string.measure_data_uploading_failed), new DialogTipUtil.CommonCallback_I(){

                    @Override
                    public void onSuccess(String str) {
                        Measure3DFlowActivity.this.setResult(-1);
                        Measure3DFlowActivity.this.finish();
                    }
                });
            }

            @Override
            public void showResponse(String response) {
                Measure3DFlowActivity.this.startGetResultStatus();
            }
        });
    }

    private void startGetResultStatus() {
        if (this.mCountTimer == null) {
            this.mCountTimer = new CountDownTimer(26000L, 3000L){

                public void onTick(long millisUntilFinished) {
                    Measure3DFlowActivity.this.getResultStatus();
                }

                public void onFinish() {
                    Measure3DFlowActivity.this.showDialog = DialogTipUtil.showIKnow((Context)Measure3DFlowActivity.this, Measure3DFlowActivity.this.getString(R.string.measure_data_uploading_failed), new DialogTipUtil.CommonCallback_I(){

                        @Override
                        public void onSuccess(String str) {
                            Measure3DFlowActivity.this.setResult(-1);
                            Measure3DFlowActivity.this.finish();
                        }
                    });
                }
            };
        }
        this.mCountTimer.start();
    }

    private void getResultStatus() {
        HttpUtil.getInstance().getMeasurePulseResult(new TokenOverDueHttpImpl<String>(){

            @Override
            public void overdue() {
            }

            @Override
            public void showError(String error) {
            }

            @Override
            public void showResponse(String usbResultStatus) {
                if (usbResultStatus != null) {
                    Measure3DFlowActivity.this.dismissLoading();
                    Map<String, Object> usbResult = Measure3DFlowActivity.this.jsonToMap(usbResultStatus);
                    int resultCode = Integer.valueOf((String)usbResult.get("measure_result"));
                    if (resultCode != 0) {
                        Measure3DFlowActivity.this.setResult(-1);
                        Measure3DFlowActivity.this.finish();
                    } else {
                        Measure3DFlowActivity.this.showDialog = DialogTipUtil.showIKnow((Context)Measure3DFlowActivity.this, Measure3DFlowActivity.this.getString(R.string.measure_data_uploading_failed), new DialogTipUtil.CommonCallback_I(){

                            @Override
                            public void onSuccess(String str) {
                                Measure3DFlowActivity.this.setResult(-1);
                                Measure3DFlowActivity.this.finish();
                            }
                        });
                    }
                    if (Measure3DFlowActivity.this.mCountTimer != null) {
                        Measure3DFlowActivity.this.mCountTimer.cancel();
                        Measure3DFlowActivity.this.mCountTimer = null;
                    }
                }
            }
        });
    }

    @Override
    protected void onUsbDetached() {
        super.onUsbDetached();
        this.showDialog = DialogTipUtil.showIKnow((Context)this, this.getString(R.string.usb_detach_tip), new DialogTipUtil.CommonCallback_I(){

            @Override
            public void onSuccess(String str) {
                EventBus.getDefault().post((Object)new UsbEvent());
                Measure3DFlowActivity.this.finish();
            }
        });
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        this.textToSpeech.stop();
        this.textToSpeech.shutdown();
        this.getWindow().clearFlags(128);
        if (this.showDialog != null) {
            this.showDialog.dismiss();
        }
    }

    @Override
    protected boolean fitSystemWindows() {
        return false;
    }

    @Override
    protected boolean translucentStatus() {
        return true;
    }

    public void onBackPressed() {
        this.showCancelDialog();
    }

    Map<String, Object> jsonToMap(String content) {
        content = content.trim();
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            if (content.charAt(0) == '[') {
                JSONArray jsonArray = new JSONArray(content);
                for (int i = 0; i < jsonArray.length(); ++i) {
                    Object value = jsonArray.get(i);
                    if (value instanceof JSONArray || value instanceof JSONObject) {
                        result.put(i + "", this.jsonToMap(value.toString().trim()));
                        continue;
                    }
                    result.put(i + "", jsonArray.getString(i));
                }
            } else if (content.charAt(0) == '{') {
                JSONObject jsonObject = new JSONObject(content);
                Iterator iterator = jsonObject.keys();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    Object value = jsonObject.get(key);
                    if (value instanceof JSONArray || value instanceof JSONObject) {
                        result.put(key, this.jsonToMap(value.toString().trim()));
                        continue;
                    }
                    result.put(key, value.toString().trim());
                }
            } else {
                Log.e((String)"\u5f02\u5e38", (String)"json2Map: \u5b57\u7b26\u4e32\u683c\u5f0f\u9519\u8bef");
            }
        }
        catch (JSONException e) {
            Log.e((String)"\u5f02\u5e38", (String)"json2Map: ", (Throwable)e);
            result = null;
        }
        return result;
    }
}

