/*
 * Decompiled with CFR 0.152.
 */
package com.taiyi.typulse.tyusbsdk.pulse.ui;

import android.annotation.SuppressLint;
import android.app.Dialog;
import android.content.Context;
import android.os.Build;
import android.os.CountDownTimer;
import android.speech.tts.TextToSpeech;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import com.jakewharton.rxbinding2.view.RxView;
import com.taiyi.typulse.R;
import com.taiyi.typulse.tyusbsdk.HandType;
import com.taiyi.typulse.tyusbsdk.MeasureType;
import com.taiyi.typulse.tyusbsdk.RealTimeAmpGraphView;
import com.taiyi.typulse.tyusbsdk.RealTimeDataGraphView;
import com.taiyi.typulse.tyusbsdk.RealTimeDataItem;
import com.taiyi.typulse.tyusbsdk.RealTimeMeasureStatus;
import com.taiyi.typulse.tyusbsdk.RealTimeMeasureView;
import com.taiyi.typulse.tyusbsdk.TYUsbDeviceActivity;
import com.taiyi.typulse.tyusbsdk.UsbEvent;
import com.taiyi.typulse.tyusbsdk.pulse.TaiyiManager;
import com.taiyi.typulse.tyusbsdk.pulse.bean.PulseParamTen;
import com.taiyi.typulse.tyusbsdk.pulse.net.HttpUtil;
import com.taiyi.typulse.tyusbsdk.pulse.net.TokenOverDueHttpImpl;
import com.taiyi.typulse.tyusbsdk.pulse.util.DialogTipUtil;
import com.taiyi.typulse.tyusbsdk.pulse.util.LoadingView;
import com.taiyi.typulse.tyusbsdk.pulse.util.OnClickNoDoubleListener;
import com.taiyi.typulse.tyusbsdk.pulse.util.scenery.ElectricFanLoadingRenderer;
import io.reactivex.functions.Consumer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.greenrobot.eventbus.EventBus;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MeasureFlowActivity
extends TYUsbDeviceActivity {
    private String measureId;
    private int hand;
    LinearLayout mLlBack;
    ImageView mIvBack;
    RealTimeMeasureView measureView;
    RealTimeDataGraphView realtimeView;
    RealTimeAmpGraphView ampView;
    ConstraintLayout mClLoading;
    LoadingView mLv;
    TextView mTvTitle1;
    TextView mTvTitle2;
    private TextToSpeech textToSpeech;
    private CountDownTimer mCountTimer;
    Dialog showDialog;

    @Override
    @SuppressLint(value={"CheckResult"})
    protected void init() {
        this.mLlBack = (LinearLayout)this.findViewById(R.id.ll_back);
        this.mIvBack = (ImageView)this.findViewById(R.id.iv_back);
        this.measureView = (RealTimeMeasureView)this.findViewById(R.id.rtmv);
        this.realtimeView = (RealTimeDataGraphView)this.findViewById(R.id.rtdgv);
        this.ampView = (RealTimeAmpGraphView)this.findViewById(R.id.rtagv);
        this.mClLoading = (ConstraintLayout)this.findViewById(R.id.cl_loading);
        this.mLv = (LoadingView)this.findViewById(R.id.lv);
        this.mTvTitle1 = (TextView)this.findViewById(R.id.title_1);
        this.mTvTitle2 = (TextView)this.findViewById(R.id.title_2);
        this.measureId = this.getIntent().getStringExtra("measureId");
        this.hand = this.getIntent().getIntExtra("hand", 0);
        this.getWindow().addFlags(128);
        this.mIvBack.setColorFilter(ContextCompat.getColor((Context)this, (int)R.color.white));
        RxView.clicks((View)this.mLlBack).throttleFirst(1L, TimeUnit.SECONDS).subscribe((Consumer)new Consumer<Object>(){

            public void accept(Object o) throws Exception {
                MeasureFlowActivity.this.showCancelDialog();
            }
        });
        ElectricFanLoadingRenderer renderer = new ElectricFanLoadingRenderer.Builder((Context)this).build();
        renderer.setRepeatCount(0);
        this.mLv.setLoadingRenderer(renderer);
        this.mLv.startAnimation();
        this.mClLoading.setOnClickListener((View.OnClickListener)new OnClickNoDoubleListener(){

            @Override
            public void onNoDoubleClick(View view) {
            }
        });
        this.mIvBack.postDelayed(new Runnable(){

            @Override
            public void run() {
                MeasureFlowActivity.this.startMeasure(MeasureFlowActivity.this.hand == 0 ? HandType.LEFT_HAND : HandType.RIGHT_HAND, MeasureType.STEP_TYPE);
                MeasureFlowActivity.this.measureView.startTimerCountDown();
            }
        }, 300L);
        this.initTTS();
    }

    private void initTTS() {
        this.textToSpeech = new TextToSpeech((Context)this, new TextToSpeech.OnInitListener(){

            public void onInit(int status) {
                if (status == 0) {
                    int result = MeasureFlowActivity.this.textToSpeech.setLanguage(Locale.SIMPLIFIED_CHINESE);
                    if (result == -1 || result == -2) {
                        Log.d((String)"TextToSpeech", (String)"Not Support Chinese");
                        return;
                    }
                    MeasureFlowActivity.this.textToSpeech.setPitch(1.0f);
                    MeasureFlowActivity.this.textToSpeech.setSpeechRate(1.0f);
                } else {
                    Log.d((String)"TextToSpeech", (String)"Failed");
                }
            }
        });
    }

    @Override
    public void sendMeasureStartCommand() {
        super.sendMeasureStartCommand();
    }

    private void showCancelDialog() {
        this.showDialog = DialogTipUtil.showSelectDialog((Context)this, this.getString(R.string.measure_cancel), this.getString(R.string.measure_cancel_tip), R.string.app_cancel, R.string.app_confirm, new DialogTipUtil.OptionClickCallback_I(){

            @Override
            public void leftClick() {
                MeasureFlowActivity.this.showDialog = null;
            }

            @Override
            public void rightClick() {
                MeasureFlowActivity.this.sendCancelMeasureCommand();
                MeasureFlowActivity.this.finish();
            }
        });
    }

    @Override
    protected int initLayoutResId() {
        return R.layout.activity_measure_flow;
    }

    @Override
    protected void onMeasureStatusChanged(RealTimeMeasureStatus status) {
        this.mTvTitle1.setText((CharSequence)"");
        this.mTvTitle2.setText((CharSequence)status.getDescription());
        if (status == RealTimeMeasureStatus.START_MEASURE) {
            this.measureView.startTimerCountDown();
        }
        if (status != RealTimeMeasureStatus.WAITING_INFLATE) {
            if (status == RealTimeMeasureStatus.START_MEASURE) {
                this.measureView.startTimerCountDown();
            } else if (status == RealTimeMeasureStatus.FINISH_MEASURE || status == RealTimeMeasureStatus.END_MEASURE) {
                // empty if block
            }
        }
        this.textToSpeech.speak(status.getDescription(), 0, null);
    }

    @Override
    protected void onMeasureDataReceived(long currentTime, long totalTime, String[] measureData) {
        this.measureView.setProgressValue(Integer.valueOf(measureData[98]) / 100);
    }

    @Override
    protected void onReceiveAmplitudeData(List<Integer> indexArray) {
        this.ampView.addData(indexArray, this.measureView.getNowTime());
    }

    @Override
    protected void onMeasureInOtherStatus(String[] measureData) {
        if (this.measureView != null) {
            this.measureView.setProgressValue(Integer.valueOf(measureData[98]) / 100);
        }
    }

    @Override
    protected void onMeasureFinished() {
        super.onMeasureFinished();
        if (ActivityCompat.checkSelfPermission((Context)this, (String)"android.permission.WRITE_EXTERNAL_STORAGE") == 0) {
            this.uploadCsv();
        } else {
            this.popupPermissionTip("android.permission.WRITE_EXTERNAL_STORAGE", R.string.permission_storage_2);
        }
    }

    @Override
    protected void onReceiveRealTimeData(RealTimeDataItem realtimeData) {
        this.realtimeView.addLinePoint(realtimeData);
    }

    @Override
    protected void onReceivePeriodicFeatureData(List<Integer> indexArray) {
        this.realtimeView.addBubblePoint(indexArray);
    }

    @Override
    protected void onPermissionGet(int requestCode) {
        this.uploadCsv();
    }

    private void uploadCsv() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                MeasureFlowActivity.this.showLoading();
            }
        });
        final String uid = TaiyiManager.getInstance().getUid();
        this.uploadCSV(uid, new TYUsbDeviceActivity.OssInterface(){

            @Override
            public void onStartUpload() {
            }

            @Override
            public void onSuccessUpload(String url) {
                MeasureFlowActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                    }
                });
                PulseParamTen pulseParam = PulseParamTen.getParams("", MeasureFlowActivity.this.hand, "20", "Android", Build.VERSION.SDK_INT + "", uid, uid, url, 0, "F");
                MeasureFlowActivity.this.uploadPulseData(pulseParam);
            }

            @Override
            public void onFailedUpload() {
                MeasureFlowActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        DialogTipUtil.showIKnow((Context)MeasureFlowActivity.this, MeasureFlowActivity.this.getString(R.string.unify_8), new DialogTipUtil.CommonCallback_I(){

                            @Override
                            public void onSuccess(String str) {
                                MeasureFlowActivity.this.setResult(-1);
                                MeasureFlowActivity.this.finish();
                            }
                        });
                    }
                });
            }
        });
    }

    private void showLoading() {
        this.mClLoading.setVisibility(0);
        this.mLv.startAnimation();
    }

    private void dismissLoading() {
        this.mLv.stopAnimation();
        this.mClLoading.setVisibility(8);
    }

    private void uploadPulseData(PulseParamTen pulseParam) {
        HttpUtil.getInstance().measurePulseSave(pulseParam, new TokenOverDueHttpImpl<String>(){

            @Override
            public void overdue() {
            }

            @Override
            public void showError(String error) {
                MeasureFlowActivity.this.showDialog = DialogTipUtil.showIKnow((Context)MeasureFlowActivity.this, MeasureFlowActivity.this.getString(R.string.measure_data_uploading_failed), new DialogTipUtil.CommonCallback_I(){

                    @Override
                    public void onSuccess(String str) {
                        MeasureFlowActivity.this.setResult(-1);
                        MeasureFlowActivity.this.finish();
                    }
                });
            }

            @Override
            public void showResponse(String response) {
                MeasureFlowActivity.this.startGetResultStatus();
            }
        });
    }

    private void startGetResultStatus() {
        if (this.mCountTimer == null) {
            this.mCountTimer = new CountDownTimer(26000L, 3000L){

                public void onTick(long millisUntilFinished) {
                    MeasureFlowActivity.this.getResultStatus();
                }

                public void onFinish() {
                    MeasureFlowActivity.this.showDialog = DialogTipUtil.showIKnow((Context)MeasureFlowActivity.this, MeasureFlowActivity.this.getString(R.string.measure_data_uploading_failed), new DialogTipUtil.CommonCallback_I(){

                        @Override
                        public void onSuccess(String str) {
                            MeasureFlowActivity.this.setResult(-1);
                            MeasureFlowActivity.this.finish();
                        }
                    });
                }
            };
        }
        this.mCountTimer.start();
    }

    private void getResultStatus() {
        HttpUtil.getInstance().getMeasurePulseResult(new TokenOverDueHttpImpl<String>(){

            @Override
            public void overdue() {
            }

            @Override
            public void showError(String error) {
            }

            @Override
            public void showResponse(String usbResultStatus) {
                if (usbResultStatus != null) {
                    MeasureFlowActivity.this.dismissLoading();
                    Map<String, Object> usbResult = MeasureFlowActivity.this.jsonToMap(usbResultStatus);
                    int resultCode = Integer.valueOf((String)usbResult.get("measure_result"));
                    if (resultCode != 0) {
                        MeasureFlowActivity.this.setResult(-1);
                        MeasureFlowActivity.this.finish();
                    } else {
                        MeasureFlowActivity.this.showDialog = DialogTipUtil.showIKnow((Context)MeasureFlowActivity.this, MeasureFlowActivity.this.getString(R.string.measure_data_uploading_failed), new DialogTipUtil.CommonCallback_I(){

                            @Override
                            public void onSuccess(String str) {
                                MeasureFlowActivity.this.setResult(-1);
                                MeasureFlowActivity.this.finish();
                            }
                        });
                    }
                    if (MeasureFlowActivity.this.mCountTimer != null) {
                        MeasureFlowActivity.this.mCountTimer.cancel();
                        MeasureFlowActivity.this.mCountTimer = null;
                    }
                }
            }
        });
    }

    @Override
    protected void onUsbDetached() {
        super.onUsbDetached();
        this.showDialog = DialogTipUtil.showIKnow((Context)this, this.getString(R.string.usb_detach_tip), new DialogTipUtil.CommonCallback_I(){

            @Override
            public void onSuccess(String str) {
                EventBus.getDefault().post((Object)new UsbEvent());
                MeasureFlowActivity.this.finish();
            }
        });
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        this.textToSpeech.stop();
        this.textToSpeech.shutdown();
        this.getWindow().clearFlags(128);
        if (this.showDialog != null) {
            this.showDialog.dismiss();
        }
    }

    @Override
    protected boolean fitSystemWindows() {
        return false;
    }

    @Override
    protected boolean translucentStatus() {
        return true;
    }

    public void onBackPressed() {
        this.showDialog();
    }

    private void showDialog() {
        this.showDialog = DialogTipUtil.showSelectDialog((Context)this, this.getString(R.string.measure_cancel), this.getString(R.string.measure_cancel_tip), R.string.app_cancel, R.string.app_confirm, new DialogTipUtil.OptionClickCallback_I(){

            @Override
            public void leftClick() {
                MeasureFlowActivity.this.showDialog = null;
            }

            @Override
            public void rightClick() {
                MeasureFlowActivity.this.finish();
            }
        });
    }

    Map<String, Object> jsonToMap(String content) {
        content = content.trim();
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            if (content.charAt(0) == '[') {
                JSONArray jsonArray = new JSONArray(content);
                for (int i = 0; i < jsonArray.length(); ++i) {
                    Object value = jsonArray.get(i);
                    if (value instanceof JSONArray || value instanceof JSONObject) {
                        result.put(i + "", this.jsonToMap(value.toString().trim()));
                        continue;
                    }
                    result.put(i + "", jsonArray.getString(i));
                }
            } else if (content.charAt(0) == '{') {
                JSONObject jsonObject = new JSONObject(content);
                Iterator iterator = jsonObject.keys();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    Object value = jsonObject.get(key);
                    if (value instanceof JSONArray || value instanceof JSONObject) {
                        result.put(key, this.jsonToMap(value.toString().trim()));
                        continue;
                    }
                    result.put(key, value.toString().trim());
                }
            } else {
                Log.e((String)"\u5f02\u5e38", (String)"json2Map: \u5b57\u7b26\u4e32\u683c\u5f0f\u9519\u8bef");
            }
        }
        catch (JSONException e) {
            Log.e((String)"\u5f02\u5e38", (String)"json2Map: ", (Throwable)e);
            result = null;
        }
        return result;
    }
}

