/*
 * Decompiled with CFR 0.152.
 */
package com.taiyi.typulse.tyusbsdk.pulse.ui;

import android.annotation.SuppressLint;
import android.app.Dialog;
import android.content.Context;
import android.os.Build;
import android.os.CountDownTimer;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import com.jakewharton.rxbinding2.view.RxView;
import com.taiyi.typulse.R;
import com.taiyi.typulse.tyusbsdk.HandType;
import com.taiyi.typulse.tyusbsdk.MeasureType;
import com.taiyi.typulse.tyusbsdk.PressureViewNew;
import com.taiyi.typulse.tyusbsdk.RealTimeDataGraphView;
import com.taiyi.typulse.tyusbsdk.RealTimeDataItem;
import com.taiyi.typulse.tyusbsdk.TYUsbDeviceActivity;
import com.taiyi.typulse.tyusbsdk.UsbEvent;
import com.taiyi.typulse.tyusbsdk.pulse.TaiyiManager;
import com.taiyi.typulse.tyusbsdk.pulse.bean.PulseParamTen;
import com.taiyi.typulse.tyusbsdk.pulse.net.HttpUtil;
import com.taiyi.typulse.tyusbsdk.pulse.net.TokenOverDueHttpImpl;
import com.taiyi.typulse.tyusbsdk.pulse.util.DialogTipUtil;
import com.taiyi.typulse.tyusbsdk.pulse.util.LoadingView;
import com.taiyi.typulse.tyusbsdk.pulse.util.OnClickNoDoubleListener;
import com.taiyi.typulse.tyusbsdk.pulse.util.scenery.ElectricFanLoadingRenderer;
import io.reactivex.functions.Consumer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.greenrobot.eventbus.EventBus;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MeasureStepFlowActivity
extends TYUsbDeviceActivity {
    private String measureId;
    private int hand;
    LinearLayout mLlBack;
    ImageView mIvBack;
    PressureViewNew mPv;
    RealTimeDataGraphView mRealTimeView;
    ConstraintLayout mClLoading;
    LoadingView mLv;
    Dialog showDialog;
    private CountDownTimer mCountTimer;

    @Override
    @SuppressLint(value={"CheckResult"})
    protected void init() {
        this.getWindow().addFlags(128);
        this.mLlBack = (LinearLayout)this.findViewById(R.id.ll_back);
        this.mIvBack = (ImageView)this.findViewById(R.id.iv_back);
        this.mPv = (PressureViewNew)this.findViewById(R.id.pv);
        this.mRealTimeView = (RealTimeDataGraphView)this.findViewById(R.id.realtime_view);
        this.mClLoading = (ConstraintLayout)this.findViewById(R.id.cl_loading);
        this.mLv = (LoadingView)this.findViewById(R.id.lv);
        this.measureId = this.getIntent().getStringExtra("measureId");
        this.hand = this.getIntent().getIntExtra("hand", 0);
        this.mIvBack.setColorFilter(ContextCompat.getColor((Context)this, (int)R.color.white));
        RxView.clicks((View)this.mLlBack).throttleFirst(1L, TimeUnit.SECONDS).subscribe((Consumer)new Consumer<Object>(){

            public void accept(Object o) throws Exception {
                MeasureStepFlowActivity.this.showCancelDialog();
            }
        });
        ElectricFanLoadingRenderer renderer = new ElectricFanLoadingRenderer.Builder((Context)this).build();
        renderer.setRepeatCount(0);
        this.mLv.setLoadingRenderer(renderer);
        this.mLv.startAnimation();
        this.mClLoading.setOnClickListener((View.OnClickListener)new OnClickNoDoubleListener(){

            @Override
            public void onNoDoubleClick(View view) {
            }
        });
        this.mPv.post(new Runnable(){

            @Override
            public void run() {
                MeasureStepFlowActivity.this.startMeasure(MeasureStepFlowActivity.this.hand == 0 ? HandType.LEFT_HAND : HandType.RIGHT_HAND, MeasureType.STEP_TYPE);
                MeasureStepFlowActivity.this.mPv.start();
            }
        });
    }

    private void showCancelDialog() {
        this.showDialog = DialogTipUtil.showSelectDialog((Context)this, this.getString(R.string.measure_cancel), this.getString(R.string.measure_cancel_tip), R.string.app_cancel, R.string.app_confirm, new DialogTipUtil.OptionClickCallback_I(){

            @Override
            public void leftClick() {
                MeasureStepFlowActivity.this.showDialog = null;
            }

            @Override
            public void rightClick() {
                MeasureStepFlowActivity.this.sendCancelMeasureCommand();
                MeasureStepFlowActivity.this.finish();
            }
        });
    }

    @Override
    protected int initLayoutResId() {
        return R.layout.activity_measure_step_flow;
    }

    @Override
    protected void onMeasureDataReceived(long currentTime, long totalTime, String[] measureData) {
        String pressure = measureData[97];
        float presF = Float.parseFloat(pressure) / 100.0f;
        this.mPv.addPressure(presF);
    }

    @Override
    protected void onMeasureFinished() {
        super.onMeasureFinished();
        if (ActivityCompat.checkSelfPermission((Context)this, (String)"android.permission.WRITE_EXTERNAL_STORAGE") == 0) {
            this.uploadCsv();
        } else {
            this.popupPermissionTip("android.permission.WRITE_EXTERNAL_STORAGE", R.string.permission_storage_2);
        }
    }

    @Override
    protected void onPermissionGet(int requestCode) {
        this.uploadCsv();
    }

    private void uploadCsv() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                MeasureStepFlowActivity.this.showLoading();
            }
        });
        final String uid = TaiyiManager.getInstance().getUid();
        this.uploadCSV(uid, new TYUsbDeviceActivity.OssInterface(){

            @Override
            public void onStartUpload() {
            }

            @Override
            public void onSuccessUpload(String url) {
                MeasureStepFlowActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                    }
                });
                PulseParamTen pulseParam = PulseParamTen.getParams("", MeasureStepFlowActivity.this.hand, "20", "Android", Build.VERSION.SDK_INT + "", uid, uid, url, 0, "F");
                MeasureStepFlowActivity.this.uploadPulseData(pulseParam);
            }

            @Override
            public void onFailedUpload() {
                MeasureStepFlowActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        DialogTipUtil.showIKnow((Context)MeasureStepFlowActivity.this, MeasureStepFlowActivity.this.getString(R.string.unify_8), new DialogTipUtil.CommonCallback_I(){

                            @Override
                            public void onSuccess(String str) {
                                MeasureStepFlowActivity.this.setResult(-1);
                                MeasureStepFlowActivity.this.finish();
                            }
                        });
                    }
                });
            }
        });
    }

    private void showLoading() {
        this.mClLoading.setVisibility(0);
        this.mLv.startAnimation();
    }

    private void dismissLoading() {
        this.mLv.stopAnimation();
        this.mClLoading.setVisibility(8);
    }

    private void uploadPulseData(PulseParamTen pulseParam) {
        HttpUtil.getInstance().measurePulseSave(pulseParam, new TokenOverDueHttpImpl<String>(){

            @Override
            public void overdue() {
            }

            @Override
            public void showError(String error) {
                MeasureStepFlowActivity.this.showDialog = DialogTipUtil.showIKnow((Context)MeasureStepFlowActivity.this, MeasureStepFlowActivity.this.getString(R.string.measure_data_uploading_failed), new DialogTipUtil.CommonCallback_I(){

                    @Override
                    public void onSuccess(String str) {
                        MeasureStepFlowActivity.this.setResult(-1);
                        MeasureStepFlowActivity.this.finish();
                    }
                });
            }

            @Override
            public void showResponse(String response) {
                MeasureStepFlowActivity.this.startGetResultStatus();
            }
        });
    }

    private void startGetResultStatus() {
        if (this.mCountTimer == null) {
            this.mCountTimer = new CountDownTimer(26000L, 3000L){

                public void onTick(long millisUntilFinished) {
                    MeasureStepFlowActivity.this.getResultStatus();
                }

                public void onFinish() {
                    MeasureStepFlowActivity.this.showDialog = DialogTipUtil.showIKnow((Context)MeasureStepFlowActivity.this, MeasureStepFlowActivity.this.getString(R.string.measure_data_uploading_failed), new DialogTipUtil.CommonCallback_I(){

                        @Override
                        public void onSuccess(String str) {
                            MeasureStepFlowActivity.this.setResult(-1);
                            MeasureStepFlowActivity.this.finish();
                        }
                    });
                }
            };
        }
        this.mCountTimer.start();
    }

    private void getResultStatus() {
        HttpUtil.getInstance().getMeasurePulseResult(new TokenOverDueHttpImpl<String>(){

            @Override
            public void overdue() {
            }

            @Override
            public void showError(String error) {
            }

            @Override
            public void showResponse(String usbResultStatus) {
                if (usbResultStatus != null) {
                    MeasureStepFlowActivity.this.dismissLoading();
                    Map<String, Object> usbResult = MeasureStepFlowActivity.this.jsonToMap(usbResultStatus);
                    int resultCode = Integer.valueOf((String)usbResult.get("measure_result"));
                    if (resultCode != 0) {
                        MeasureStepFlowActivity.this.setResult(-1);
                        MeasureStepFlowActivity.this.finish();
                    } else {
                        MeasureStepFlowActivity.this.showDialog = DialogTipUtil.showIKnow((Context)MeasureStepFlowActivity.this, MeasureStepFlowActivity.this.getString(R.string.measure_data_uploading_failed), new DialogTipUtil.CommonCallback_I(){

                            @Override
                            public void onSuccess(String str) {
                                MeasureStepFlowActivity.this.setResult(-1);
                                MeasureStepFlowActivity.this.finish();
                            }
                        });
                    }
                    if (MeasureStepFlowActivity.this.mCountTimer != null) {
                        MeasureStepFlowActivity.this.mCountTimer.cancel();
                        MeasureStepFlowActivity.this.mCountTimer = null;
                    }
                }
            }
        });
    }

    @Override
    protected void onReceiveRealTimeData(RealTimeDataItem realtimeData) {
        this.mRealTimeView.addLinePoint(realtimeData);
    }

    @Override
    protected void onReceivePeriodicFeatureData(List<Integer> indexArray) {
        this.mRealTimeView.addBubblePoint(indexArray);
    }

    @Override
    protected void onUsbDetached() {
        super.onUsbDetached();
        this.showDialog = DialogTipUtil.showIKnow((Context)this, this.getString(R.string.usb_detach_tip), new DialogTipUtil.CommonCallback_I(){

            @Override
            public void onSuccess(String str) {
                EventBus.getDefault().post((Object)new UsbEvent());
                MeasureStepFlowActivity.this.finish();
            }
        });
    }

    @Override
    protected boolean fitSystemWindows() {
        return false;
    }

    @Override
    protected boolean translucentStatus() {
        return true;
    }

    public void onBackPressed() {
        this.showDialog();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        this.getWindow().clearFlags(128);
    }

    private void showDialog() {
        this.showDialog = DialogTipUtil.showSelectDialog((Context)this, this.getString(R.string.measure_cancel), this.getString(R.string.measure_cancel_tip), R.string.app_cancel, R.string.app_confirm, new DialogTipUtil.OptionClickCallback_I(){

            @Override
            public void leftClick() {
                MeasureStepFlowActivity.this.showDialog = null;
            }

            @Override
            public void rightClick() {
                MeasureStepFlowActivity.this.finish();
            }
        });
    }

    Map<String, Object> jsonToMap(String content) {
        content = content.trim();
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            if (content.charAt(0) == '[') {
                JSONArray jsonArray = new JSONArray(content);
                for (int i = 0; i < jsonArray.length(); ++i) {
                    Object value = jsonArray.get(i);
                    if (value instanceof JSONArray || value instanceof JSONObject) {
                        result.put(i + "", this.jsonToMap(value.toString().trim()));
                        continue;
                    }
                    result.put(i + "", jsonArray.getString(i));
                }
            } else if (content.charAt(0) == '{') {
                JSONObject jsonObject = new JSONObject(content);
                Iterator iterator = jsonObject.keys();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    Object value = jsonObject.get(key);
                    if (value instanceof JSONArray || value instanceof JSONObject) {
                        result.put(key, this.jsonToMap(value.toString().trim()));
                        continue;
                    }
                    result.put(key, value.toString().trim());
                }
            } else {
                Log.e((String)"\u5f02\u5e38", (String)"json2Map: \u5b57\u7b26\u4e32\u683c\u5f0f\u9519\u8bef");
            }
        }
        catch (JSONException e) {
            Log.e((String)"\u5f02\u5e38", (String)"json2Map: ", (Throwable)e);
            result = null;
        }
        return result;
    }
}

