/*
 * Decompiled with CFR 0.152.
 */
package com.taiyi.typulse.tyusbsdk.pulse.util;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.animation.LinearInterpolator;
import com.taiyi.typulse.tyusbsdk.pulse.util.DensityUtil;

public abstract class LoadingRenderer {
    private static final long ANIMATION_DURATION = 1333L;
    private static final float DEFAULT_SIZE = 56.0f;
    private final ValueAnimator.AnimatorUpdateListener mAnimatorUpdateListener = new ValueAnimator.AnimatorUpdateListener(){

        public void onAnimationUpdate(ValueAnimator animation) {
            LoadingRenderer.this.computeRender(((Float)animation.getAnimatedValue()).floatValue());
            LoadingRenderer.this.invalidateSelf();
        }
    };
    protected final Rect mBounds = new Rect();
    private Drawable.Callback mCallback;
    private ValueAnimator mRenderAnimator;
    protected long mDuration;
    protected float mWidth;
    protected float mHeight;

    public LoadingRenderer(Context context) {
        this.initParams(context);
        this.setupAnimators();
    }

    @Deprecated
    protected void draw(Canvas canvas, Rect bounds) {
    }

    protected void draw(Canvas canvas) {
        this.draw(canvas, this.mBounds);
    }

    protected abstract void computeRender(float var1);

    protected abstract void setAlpha(int var1);

    protected abstract void setColorFilter(ColorFilter var1);

    protected abstract void reset();

    protected void addRenderListener(Animator.AnimatorListener animatorListener) {
        this.mRenderAnimator.addListener(animatorListener);
    }

    public void start() {
        this.reset();
        this.mRenderAnimator.addUpdateListener(this.mAnimatorUpdateListener);
        this.mRenderAnimator.setDuration(this.mDuration);
        this.mRenderAnimator.start();
    }

    public void setRepeatCount(int count) {
        this.mRenderAnimator.setRepeatCount(count);
    }

    public void stop() {
        this.mRenderAnimator.removeUpdateListener(this.mAnimatorUpdateListener);
        this.mRenderAnimator.setRepeatCount(0);
        this.mRenderAnimator.setDuration(0L);
        this.mRenderAnimator.end();
    }

    boolean isRunning() {
        return this.mRenderAnimator.isRunning();
    }

    void setCallback(Drawable.Callback callback) {
        this.mCallback = callback;
    }

    void setBounds(Rect bounds) {
        this.mBounds.set(bounds);
    }

    private void initParams(Context context) {
        this.mWidth = DensityUtil.dip2px(context, 56.0f);
        this.mHeight = DensityUtil.dip2px(context, 56.0f);
        this.mDuration = 1333L;
    }

    @SuppressLint(value={"WrongConstant"})
    private void setupAnimators() {
        this.mRenderAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        this.mRenderAnimator.setRepeatCount(-1);
        this.mRenderAnimator.setRepeatMode(1);
        this.mRenderAnimator.setDuration(this.mDuration);
        this.mRenderAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        this.mRenderAnimator.addUpdateListener(this.mAnimatorUpdateListener);
    }

    private void invalidateSelf() {
        this.mCallback.invalidateDrawable(null);
    }
}

