/*
 * Decompiled with CFR 0.152.
 */
package com.taiyi.typulse.tyusbsdk.pulse.util;

import android.content.Context;
import android.util.SparseArray;
import com.taiyi.typulse.tyusbsdk.pulse.util.LoadingRenderer;
import com.taiyi.typulse.tyusbsdk.pulse.util.animal.FishLoadingRenderer;
import com.taiyi.typulse.tyusbsdk.pulse.util.animal.GhostsEyeLoadingRenderer;
import com.taiyi.typulse.tyusbsdk.pulse.util.goods.BalloonLoadingRenderer;
import com.taiyi.typulse.tyusbsdk.pulse.util.goods.WaterBottleLoadingRenderer;
import com.taiyi.typulse.tyusbsdk.pulse.util.jump.CollisionLoadingRenderer;
import com.taiyi.typulse.tyusbsdk.pulse.util.jump.DanceLoadingRenderer;
import com.taiyi.typulse.tyusbsdk.pulse.util.jump.GuardLoadingRenderer;
import com.taiyi.typulse.tyusbsdk.pulse.util.jump.SwapLoadingRenderer;
import com.taiyi.typulse.tyusbsdk.pulse.util.rotate.GearLoadingRenderer;
import com.taiyi.typulse.tyusbsdk.pulse.util.rotate.LevelLoadingRenderer;
import com.taiyi.typulse.tyusbsdk.pulse.util.rotate.MaterialLoadingRenderer;
import com.taiyi.typulse.tyusbsdk.pulse.util.rotate.WhorlLoadingRenderer;
import com.taiyi.typulse.tyusbsdk.pulse.util.scenery.DayNightLoadingRenderer;
import com.taiyi.typulse.tyusbsdk.pulse.util.scenery.ElectricFanLoadingRenderer;
import com.taiyi.typulse.tyusbsdk.pulse.util.shapechange.CircleBroodLoadingRenderer;
import com.taiyi.typulse.tyusbsdk.pulse.util.shapechange.CoolWaitLoadingRenderer;
import java.lang.reflect.Constructor;

public final class LoadingRendererFactory {
    private static final SparseArray<Class<? extends LoadingRenderer>> LOADING_RENDERERS = new SparseArray();

    private LoadingRendererFactory() {
    }

    public static LoadingRenderer createLoadingRenderer(Context context, int loadingRendererId) throws Exception {
        Constructor<?>[] constructors;
        Class loadingRendererClazz = (Class)LOADING_RENDERERS.get(loadingRendererId);
        for (Constructor<?> constructor : constructors = loadingRendererClazz.getDeclaredConstructors()) {
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            if (parameterTypes == null || parameterTypes.length != 1 || !parameterTypes[0].equals(Context.class)) continue;
            constructor.setAccessible(true);
            return (LoadingRenderer)constructor.newInstance(context);
        }
        throw new InstantiationException();
    }

    static {
        LOADING_RENDERERS.put(0, MaterialLoadingRenderer.class);
        LOADING_RENDERERS.put(1, LevelLoadingRenderer.class);
        LOADING_RENDERERS.put(2, WhorlLoadingRenderer.class);
        LOADING_RENDERERS.put(3, GearLoadingRenderer.class);
        LOADING_RENDERERS.put(4, SwapLoadingRenderer.class);
        LOADING_RENDERERS.put(5, GuardLoadingRenderer.class);
        LOADING_RENDERERS.put(6, DanceLoadingRenderer.class);
        LOADING_RENDERERS.put(7, CollisionLoadingRenderer.class);
        LOADING_RENDERERS.put(8, DayNightLoadingRenderer.class);
        LOADING_RENDERERS.put(9, ElectricFanLoadingRenderer.class);
        LOADING_RENDERERS.put(10, FishLoadingRenderer.class);
        LOADING_RENDERERS.put(11, GhostsEyeLoadingRenderer.class);
        LOADING_RENDERERS.put(12, BalloonLoadingRenderer.class);
        LOADING_RENDERERS.put(13, WaterBottleLoadingRenderer.class);
        LOADING_RENDERERS.put(14, CircleBroodLoadingRenderer.class);
        LOADING_RENDERERS.put(15, CoolWaitLoadingRenderer.class);
    }
}

