/*
 * Decompiled with CFR 0.152.
 */
package com.taiyi.typulse.tyusbsdk.pulse.util;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import androidx.appcompat.widget.AppCompatImageView;
import com.taiyi.typulse.R;
import com.taiyi.typulse.tyusbsdk.pulse.util.LoadingDrawable;
import com.taiyi.typulse.tyusbsdk.pulse.util.LoadingRenderer;
import com.taiyi.typulse.tyusbsdk.pulse.util.LoadingRendererFactory;

public class LoadingView
extends AppCompatImageView {
    private LoadingDrawable mLoadingDrawable;

    public LoadingView(Context context) {
        super(context);
    }

    public LoadingView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initAttrs(context, attrs);
    }

    private void initAttrs(Context context, AttributeSet attrs) {
        try {
            TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.LoadingView);
            int loadingRendererId = ta.getInt(R.styleable.LoadingView_loading_renderer, 0);
            LoadingRenderer loadingRenderer = LoadingRendererFactory.createLoadingRenderer(context, loadingRendererId);
            this.setLoadingRenderer(loadingRenderer);
            ta.recycle();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setLoadingRenderer(LoadingRenderer loadingRenderer) {
        this.mLoadingDrawable = new LoadingDrawable(loadingRenderer);
        this.setImageDrawable(this.mLoadingDrawable);
    }

    public void startAnimation() {
        if (this.mLoadingDrawable != null) {
            this.mLoadingDrawable.start();
        }
    }

    public void stopAnimation() {
        if (this.mLoadingDrawable != null) {
            this.mLoadingDrawable.stop();
        }
    }
}

