/*
 * Decompiled with CFR 0.152.
 */
package com.taiyi.typulse.tyusbsdk.pulse.util.jump;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathMeasure;
import android.graphics.Rect;
import android.graphics.RectF;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import androidx.interpolator.view.animation.FastOutSlowInInterpolator;
import com.taiyi.typulse.tyusbsdk.pulse.util.DensityUtil;
import com.taiyi.typulse.tyusbsdk.pulse.util.LoadingRenderer;

public class GuardLoadingRenderer
extends LoadingRenderer {
    private static final Interpolator MATERIAL_INTERPOLATOR = new FastOutSlowInInterpolator();
    private static final Interpolator ACCELERATE_INTERPOLATOR = new AccelerateInterpolator();
    private static final Interpolator DECELERATE_INTERPOLATOR = new DecelerateInterpolator();
    private static final long ANIMATION_DURATION = 5000L;
    private static final float DEFAULT_STROKE_WIDTH = 1.0f;
    private static final float DEFAULT_CENTER_RADIUS = 12.5f;
    private static final float DEFAULT_SKIP_BALL_RADIUS = 1.0f;
    private static final float START_TRIM_INIT_ROTATION = -0.5f;
    private static final float START_TRIM_MAX_ROTATION = -0.25f;
    private static final float END_TRIM_INIT_ROTATION = 0.25f;
    private static final float END_TRIM_MAX_ROTATION = 0.75f;
    private static final float START_TRIM_DURATION_OFFSET = 0.23f;
    private static final float WAVE_DURATION_OFFSET = 0.36f;
    private static final float BALL_SKIP_DURATION_OFFSET = 0.74f;
    private static final float BALL_SCALE_DURATION_OFFSET = 0.82f;
    private static final float END_TRIM_DURATION_OFFSET = 1.0f;
    private static final int DEFAULT_COLOR = -1;
    private static final int DEFAULT_BALL_COLOR = -65536;
    private final Paint mPaint = new Paint();
    private final RectF mTempBounds = new RectF();
    private final RectF mCurrentBounds = new RectF();
    private final float[] mCurrentPosition = new float[2];
    private float mStrokeInset;
    private float mSkipBallSize;
    private float mScale;
    private float mEndTrim;
    private float mRotation;
    private float mStartTrim;
    private float mWaveProgress;
    private float mStrokeWidth;
    private float mCenterRadius;
    private int mColor;
    private int mBallColor;
    private PathMeasure mPathMeasure;

    private GuardLoadingRenderer(Context context) {
        super(context);
        this.mDuration = 5000L;
        this.init(context);
        this.setupPaint();
    }

    private void init(Context context) {
        this.mStrokeWidth = DensityUtil.dip2px(context, 1.0f);
        this.mCenterRadius = DensityUtil.dip2px(context, 12.5f);
        this.mSkipBallSize = DensityUtil.dip2px(context, 1.0f);
        this.mColor = -1;
        this.mBallColor = -65536;
    }

    private void setupPaint() {
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStrokeWidth(this.mStrokeWidth);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
        this.setInsets((int)this.mWidth, (int)this.mHeight);
    }

    @Override
    protected void draw(Canvas canvas, Rect bounds) {
        RectF arcBounds = this.mTempBounds;
        arcBounds.set(bounds);
        arcBounds.inset(this.mStrokeInset, this.mStrokeInset);
        this.mCurrentBounds.set(arcBounds);
        int saveCount = canvas.save();
        float startAngle = (this.mStartTrim + this.mRotation) * 360.0f;
        float endAngle = (this.mEndTrim + this.mRotation) * 360.0f;
        float sweepAngle = endAngle - startAngle;
        if (sweepAngle != 0.0f) {
            this.mPaint.setColor(this.mColor);
            this.mPaint.setStyle(Paint.Style.STROKE);
            canvas.drawArc(arcBounds, startAngle, sweepAngle, false, this.mPaint);
        }
        if (this.mWaveProgress < 1.0f) {
            this.mPaint.setColor(Color.argb((int)((int)((float)Color.alpha((int)this.mColor) * (1.0f - this.mWaveProgress))), (int)Color.red((int)this.mColor), (int)Color.green((int)this.mColor), (int)Color.blue((int)this.mColor)));
            this.mPaint.setStyle(Paint.Style.STROKE);
            float radius = Math.min(arcBounds.width(), arcBounds.height()) / 2.0f;
            canvas.drawCircle(arcBounds.centerX(), arcBounds.centerY(), radius * (1.0f + this.mWaveProgress), this.mPaint);
        }
        if (this.mPathMeasure != null) {
            this.mPaint.setColor(this.mBallColor);
            this.mPaint.setStyle(Paint.Style.FILL);
            canvas.drawCircle(this.mCurrentPosition[0], this.mCurrentPosition[1], this.mSkipBallSize * this.mScale, this.mPaint);
        }
        canvas.restoreToCount(saveCount);
    }

    @Override
    protected void computeRender(float renderProgress) {
        if (renderProgress <= 0.23f) {
            float startTrimProgress = renderProgress / 0.23f;
            this.mEndTrim = -MATERIAL_INTERPOLATOR.getInterpolation(startTrimProgress);
            this.mRotation = -0.5f + -0.25f * MATERIAL_INTERPOLATOR.getInterpolation(startTrimProgress);
        }
        if (renderProgress <= 0.36f && renderProgress > 0.23f) {
            float waveProgress = (renderProgress - 0.23f) / 0.13000001f;
            this.mWaveProgress = ACCELERATE_INTERPOLATOR.getInterpolation(waveProgress);
        }
        if (renderProgress <= 0.74f && renderProgress > 0.36f) {
            if (this.mPathMeasure == null) {
                this.mPathMeasure = new PathMeasure(this.createSkipBallPath(), false);
            }
            float ballSkipProgress = (renderProgress - 0.36f) / 0.38f;
            this.mPathMeasure.getPosTan(ballSkipProgress * this.mPathMeasure.getLength(), this.mCurrentPosition, null);
            this.mWaveProgress = 1.0f;
        }
        if (renderProgress <= 0.82f && renderProgress > 0.74f) {
            float ballScaleProgress = (renderProgress - 0.74f) / 0.07999998f;
            this.mScale = ballScaleProgress < 0.5f ? 1.0f + DECELERATE_INTERPOLATOR.getInterpolation(ballScaleProgress * 2.0f) : 2.0f - ACCELERATE_INTERPOLATOR.getInterpolation((ballScaleProgress - 0.5f) * 2.0f) * 2.0f;
        }
        if (renderProgress >= 0.82f) {
            float endTrimProgress = (renderProgress - 0.74f) / 0.26f;
            this.mEndTrim = -1.0f + MATERIAL_INTERPOLATOR.getInterpolation(endTrimProgress);
            this.mRotation = 0.25f + 0.75f * MATERIAL_INTERPOLATOR.getInterpolation(endTrimProgress);
            this.mScale = 1.0f;
            this.mPathMeasure = null;
        }
    }

    @Override
    protected void setAlpha(int alpha) {
        this.mPaint.setAlpha(alpha);
    }

    @Override
    protected void setColorFilter(ColorFilter cf) {
        this.mPaint.setColorFilter(cf);
    }

    @Override
    protected void reset() {
        this.mScale = 1.0f;
        this.mEndTrim = 0.0f;
        this.mRotation = 0.0f;
        this.mStartTrim = 0.0f;
        this.mWaveProgress = 1.0f;
    }

    private Path createSkipBallPath() {
        float radius = Math.min(this.mCurrentBounds.width(), this.mCurrentBounds.height()) / 2.0f;
        float radiusPow2 = (float)Math.pow(radius, 2.0);
        float originCoordinateX = this.mCurrentBounds.centerX();
        float originCoordinateY = this.mCurrentBounds.centerY();
        float[] coordinateX = new float[]{0.0f, 0.0f, -0.8f * radius, 0.75f * radius, -0.45f * radius, 0.9f * radius, -0.5f * radius};
        float[] sign = new float[]{1.0f, -1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f};
        Path path = new Path();
        for (int i = 0; i < coordinateX.length; ++i) {
            if (i == 0) {
                path.moveTo(originCoordinateX + coordinateX[i], originCoordinateY + sign[i] * (float)Math.sqrt((double)radiusPow2 - Math.pow(coordinateX[i], 2.0)));
                continue;
            }
            path.lineTo(originCoordinateX + coordinateX[i], originCoordinateY + sign[i] * (float)Math.sqrt((double)radiusPow2 - Math.pow(coordinateX[i], 2.0)));
            if (i != coordinateX.length - 1) continue;
            path.lineTo(originCoordinateX, originCoordinateY);
        }
        return path;
    }

    private void setInsets(int width, int height) {
        float minEdge = Math.min(width, height);
        float insets = this.mCenterRadius <= 0.0f || minEdge < 0.0f ? (float)Math.ceil(this.mStrokeWidth / 2.0f) : minEdge / 2.0f - this.mCenterRadius;
        this.mStrokeInset = insets;
    }

    public static class Builder {
        private Context mContext;

        public Builder(Context mContext) {
            this.mContext = mContext;
        }

        public GuardLoadingRenderer build() {
            GuardLoadingRenderer loadingRenderer = new GuardLoadingRenderer(this.mContext);
            return loadingRenderer;
        }
    }
}

