/*
 * Decompiled with CFR 0.152.
 */
package com.taiyi.typulse.tyusbsdk.pulse.util.jump;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Interpolator;
import com.taiyi.typulse.tyusbsdk.pulse.util.DensityUtil;
import com.taiyi.typulse.tyusbsdk.pulse.util.LoadingRenderer;

public class SwapLoadingRenderer
extends LoadingRenderer {
    private static final Interpolator ACCELERATE_DECELERATE_INTERPOLATOR = new AccelerateDecelerateInterpolator();
    private static final long ANIMATION_DURATION = 2500L;
    private static final int DEFAULT_CIRCLE_COUNT = 5;
    private static final float DEFAULT_BALL_RADIUS = 7.5f;
    private static final float DEFAULT_WIDTH = 165.0f;
    private static final float DEFAULT_HEIGHT = 75.0f;
    private static final float DEFAULT_STROKE_WIDTH = 1.5f;
    private static final int DEFAULT_COLOR = -1;
    private final Paint mPaint = new Paint(1);
    private int mColor;
    private int mSwapIndex;
    private int mBallCount;
    private float mBallSideOffsets;
    private float mBallCenterY;
    private float mBallRadius;
    private float mBallInterval;
    private float mSwapBallOffsetX;
    private float mSwapBallOffsetY;
    private float mASwapThreshold;
    private float mStrokeWidth;

    private SwapLoadingRenderer(Context context) {
        super(context);
        this.init(context);
        this.adjustParams();
        this.setupPaint();
    }

    private void init(Context context) {
        this.mWidth = DensityUtil.dip2px(context, 165.0f);
        this.mHeight = DensityUtil.dip2px(context, 75.0f);
        this.mBallRadius = DensityUtil.dip2px(context, 7.5f);
        this.mStrokeWidth = DensityUtil.dip2px(context, 1.5f);
        this.mColor = -1;
        this.mDuration = 2500L;
        this.mBallCount = 5;
        this.mBallInterval = this.mBallRadius;
    }

    private void adjustParams() {
        this.mBallCenterY = this.mHeight / 2.0f;
        this.mBallSideOffsets = (this.mWidth - this.mBallRadius * 2.0f * (float)this.mBallCount - this.mBallInterval * (float)(this.mBallCount - 1)) / 2.0f;
        this.mASwapThreshold = 1.0f / (float)this.mBallCount;
    }

    private void setupPaint() {
        this.mPaint.setColor(this.mColor);
        this.mPaint.setStrokeWidth(this.mStrokeWidth);
    }

    @Override
    protected void draw(Canvas canvas) {
        int saveCount = canvas.save();
        for (int i = 0; i < this.mBallCount; ++i) {
            if (i == this.mSwapIndex) {
                this.mPaint.setStyle(Paint.Style.FILL);
                canvas.drawCircle(this.mBallSideOffsets + this.mBallRadius * (float)(i * 2 + 1) + (float)i * this.mBallInterval + this.mSwapBallOffsetX, this.mBallCenterY - this.mSwapBallOffsetY, this.mBallRadius, this.mPaint);
                continue;
            }
            if (i == (this.mSwapIndex + 1) % this.mBallCount) {
                this.mPaint.setStyle(Paint.Style.STROKE);
                canvas.drawCircle(this.mBallSideOffsets + this.mBallRadius * (float)(i * 2 + 1) + (float)i * this.mBallInterval - this.mSwapBallOffsetX, this.mBallCenterY + this.mSwapBallOffsetY, this.mBallRadius - this.mStrokeWidth / 2.0f, this.mPaint);
                continue;
            }
            this.mPaint.setStyle(Paint.Style.STROKE);
            canvas.drawCircle(this.mBallSideOffsets + this.mBallRadius * (float)(i * 2 + 1) + (float)i * this.mBallInterval, this.mBallCenterY, this.mBallRadius - this.mStrokeWidth / 2.0f, this.mPaint);
        }
        canvas.restoreToCount(saveCount);
    }

    @Override
    protected void computeRender(float renderProgress) {
        this.mSwapIndex = (int)(renderProgress / this.mASwapThreshold);
        float swapTraceProgress = ACCELERATE_DECELERATE_INTERPOLATOR.getInterpolation((renderProgress - (float)this.mSwapIndex * this.mASwapThreshold) / this.mASwapThreshold);
        float swapTraceRadius = this.mSwapIndex == this.mBallCount - 1 ? (this.mBallRadius * 2.0f * (float)(this.mBallCount - 1) + this.mBallInterval * (float)(this.mBallCount - 1)) / 2.0f : (this.mBallRadius * 2.0f + this.mBallInterval) / 2.0f;
        this.mSwapBallOffsetX = this.mSwapIndex == this.mBallCount - 1 ? -swapTraceProgress * swapTraceRadius * 2.0f : swapTraceProgress * swapTraceRadius * 2.0f;
        float xCoordinate = this.mSwapIndex == this.mBallCount - 1 ? this.mSwapBallOffsetX + swapTraceRadius : this.mSwapBallOffsetX - swapTraceRadius;
        this.mSwapBallOffsetY = (float)(this.mSwapIndex % 2 == 0 && this.mSwapIndex != this.mBallCount - 1 ? Math.sqrt(Math.pow(swapTraceRadius, 2.0) - Math.pow(xCoordinate, 2.0)) : -Math.sqrt(Math.pow(swapTraceRadius, 2.0) - Math.pow(xCoordinate, 2.0)));
    }

    @Override
    protected void setAlpha(int alpha) {
        this.mPaint.setAlpha(alpha);
    }

    @Override
    protected void setColorFilter(ColorFilter cf) {
        this.mPaint.setColorFilter(cf);
    }

    @Override
    protected void reset() {
    }

    private void apply(Builder builder) {
        this.mWidth = builder.mWidth > 0 ? (float)builder.mWidth : this.mWidth;
        this.mHeight = builder.mHeight > 0 ? (float)builder.mHeight : this.mHeight;
        this.mStrokeWidth = builder.mStrokeWidth > 0 ? (float)builder.mStrokeWidth : this.mStrokeWidth;
        this.mBallRadius = builder.mBallRadius > 0 ? (float)builder.mBallRadius : this.mBallRadius;
        this.mBallInterval = builder.mBallInterval > 0 ? (float)builder.mBallInterval : this.mBallInterval;
        this.mBallCount = builder.mBallCount > 0 ? builder.mBallCount : this.mBallCount;
        this.mColor = builder.mColor != 0 ? builder.mColor : this.mColor;
        this.mDuration = builder.mDuration > 0 ? (long)builder.mDuration : this.mDuration;
        this.adjustParams();
        this.setupPaint();
    }

    public static class Builder {
        private Context mContext;
        private int mWidth;
        private int mHeight;
        private int mStrokeWidth;
        private int mBallCount;
        private int mBallRadius;
        private int mBallInterval;
        private int mDuration;
        private int mColor;

        public Builder(Context mContext) {
            this.mContext = mContext;
        }

        public Builder setWidth(int width) {
            this.mWidth = width;
            return this;
        }

        public Builder setHeight(int height) {
            this.mHeight = height;
            return this;
        }

        public Builder setStrokeWidth(int strokeWidth) {
            this.mStrokeWidth = strokeWidth;
            return this;
        }

        public Builder setBallRadius(int ballRadius) {
            this.mBallRadius = ballRadius;
            return this;
        }

        public Builder setBallInterval(int ballInterval) {
            this.mBallInterval = ballInterval;
            return this;
        }

        public Builder setBallCount(int ballCount) {
            this.mBallCount = ballCount;
            return this;
        }

        public Builder setColor(int color2) {
            this.mColor = color2;
            return this;
        }

        public Builder setDuration(int duration) {
            this.mDuration = duration;
            return this;
        }

        public SwapLoadingRenderer build() {
            SwapLoadingRenderer loadingRenderer = new SwapLoadingRenderer(this.mContext);
            loadingRenderer.apply(this);
            return loadingRenderer;
        }
    }
}

