/*
 * Decompiled with CFR 0.152.
 */
package com.taiyi.typulse.tyusbsdk.pulse.util.rotate;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.RectF;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import androidx.annotation.IntRange;
import com.taiyi.typulse.tyusbsdk.pulse.util.DensityUtil;
import com.taiyi.typulse.tyusbsdk.pulse.util.LoadingRenderer;

public class GearLoadingRenderer
extends LoadingRenderer {
    private static final Interpolator ACCELERATE_INTERPOLATOR = new AccelerateInterpolator();
    private static final Interpolator DECELERATE_INTERPOLATOR = new DecelerateInterpolator();
    private static final int GEAR_COUNT = 4;
    private static final int NUM_POINTS = 3;
    private static final int MAX_ALPHA = 255;
    private static final int DEGREE_360 = 360;
    private static final int DEFAULT_GEAR_SWIPE_DEGREES = 60;
    private static final float FULL_GROUP_ROTATION = 1080.0f;
    private static final float START_SCALE_DURATION_OFFSET = 0.3f;
    private static final float START_TRIM_DURATION_OFFSET = 0.5f;
    private static final float END_TRIM_DURATION_OFFSET = 0.7f;
    private static final float END_SCALE_DURATION_OFFSET = 1.0f;
    private static final float DEFAULT_CENTER_RADIUS = 12.5f;
    private static final float DEFAULT_STROKE_WIDTH = 2.5f;
    private static final int DEFAULT_COLOR = -1;
    private final Paint mPaint = new Paint();
    private final RectF mTempBounds = new RectF();
    private final Animator.AnimatorListener mAnimatorListener = new AnimatorListenerAdapter(){

        public void onAnimationRepeat(Animator animator) {
            super.onAnimationRepeat(animator);
            GearLoadingRenderer.this.storeOriginals();
            GearLoadingRenderer.this.mStartDegrees = GearLoadingRenderer.this.mEndDegrees;
            GearLoadingRenderer.this.mRotationCount = (GearLoadingRenderer.this.mRotationCount + 1.0f) % 3.0f;
        }

        public void onAnimationStart(Animator animation) {
            super.onAnimationStart(animation);
            GearLoadingRenderer.this.mRotationCount = 0.0f;
        }
    };
    private int mColor;
    private int mGearCount;
    private int mGearSwipeDegrees;
    private float mStrokeInset;
    private float mRotationCount;
    private float mGroupRotation;
    private float mScale;
    private float mEndDegrees;
    private float mStartDegrees;
    private float mSwipeDegrees;
    private float mOriginEndDegrees;
    private float mOriginStartDegrees;
    private float mStrokeWidth;
    private float mCenterRadius;

    private GearLoadingRenderer(Context context) {
        super(context);
        this.init(context);
        this.setupPaint();
        this.addRenderListener(this.mAnimatorListener);
    }

    private void init(Context context) {
        this.mStrokeWidth = DensityUtil.dip2px(context, 2.5f);
        this.mCenterRadius = DensityUtil.dip2px(context, 12.5f);
        this.mColor = -1;
        this.mGearCount = 4;
        this.mGearSwipeDegrees = 60;
    }

    private void setupPaint() {
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStrokeWidth(this.mStrokeWidth);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
        this.initStrokeInset(this.mWidth, this.mHeight);
    }

    @Override
    protected void draw(Canvas canvas) {
        int saveCount = canvas.save();
        this.mTempBounds.set(this.mBounds);
        this.mTempBounds.inset(this.mStrokeInset, this.mStrokeInset);
        this.mTempBounds.inset(this.mTempBounds.width() * (1.0f - this.mScale) / 2.0f, this.mTempBounds.width() * (1.0f - this.mScale) / 2.0f);
        canvas.rotate(this.mGroupRotation, this.mTempBounds.centerX(), this.mTempBounds.centerY());
        this.mPaint.setColor(this.mColor);
        this.mPaint.setAlpha((int)(255.0f * this.mScale));
        this.mPaint.setStrokeWidth(this.mStrokeWidth * this.mScale);
        if (this.mSwipeDegrees != 0.0f) {
            for (int i = 0; i < this.mGearCount; ++i) {
                canvas.drawArc(this.mTempBounds, this.mStartDegrees + (float)(360 / this.mGearCount * i), this.mSwipeDegrees, false, this.mPaint);
            }
        }
        canvas.restoreToCount(saveCount);
    }

    @Override
    protected void computeRender(float renderProgress) {
        if (renderProgress <= 0.3f) {
            float startScaleProgress = renderProgress / 0.3f;
            this.mScale = DECELERATE_INTERPOLATOR.getInterpolation(startScaleProgress);
        }
        if (renderProgress <= 0.5f && renderProgress > 0.3f) {
            float startTrimProgress = (renderProgress - 0.3f) / 0.19999999f;
            this.mStartDegrees = this.mOriginStartDegrees + (float)this.mGearSwipeDegrees * startTrimProgress;
        }
        if (renderProgress <= 0.7f && renderProgress > 0.5f) {
            float endTrimProgress = (renderProgress - 0.5f) / 0.19999999f;
            this.mEndDegrees = this.mOriginEndDegrees + (float)this.mGearSwipeDegrees * endTrimProgress;
        }
        if (renderProgress > 0.7f) {
            float endScaleProgress = (renderProgress - 0.7f) / 0.3f;
            this.mScale = 1.0f - ACCELERATE_INTERPOLATOR.getInterpolation(endScaleProgress);
        }
        if (renderProgress <= 0.7f && renderProgress > 0.3f) {
            float rotateProgress = (renderProgress - 0.3f) / 0.39999998f;
            this.mGroupRotation = 360.0f * rotateProgress + 1080.0f * (this.mRotationCount / 3.0f);
        }
        if (Math.abs(this.mEndDegrees - this.mStartDegrees) > 0.0f) {
            this.mSwipeDegrees = this.mEndDegrees - this.mStartDegrees;
        }
    }

    @Override
    protected void setAlpha(int alpha) {
        this.mPaint.setAlpha(alpha);
    }

    @Override
    protected void setColorFilter(ColorFilter cf) {
        this.mPaint.setColorFilter(cf);
    }

    @Override
    protected void reset() {
        this.resetOriginals();
    }

    private void initStrokeInset(float width, float height) {
        float minStrokeInset;
        float minSize = Math.min(width, height);
        float strokeInset = minSize / 2.0f - this.mCenterRadius;
        this.mStrokeInset = strokeInset < (minStrokeInset = (float)Math.ceil(this.mStrokeWidth / 2.0f)) ? minStrokeInset : strokeInset;
    }

    private void storeOriginals() {
        this.mOriginEndDegrees = this.mEndDegrees;
        this.mOriginStartDegrees = this.mEndDegrees;
    }

    private void resetOriginals() {
        this.mOriginEndDegrees = 0.0f;
        this.mOriginStartDegrees = 0.0f;
        this.mEndDegrees = 0.0f;
        this.mStartDegrees = 0.0f;
        this.mSwipeDegrees = 1.0f;
    }

    private void apply(Builder builder) {
        this.mWidth = builder.mWidth > 0 ? (float)builder.mWidth : this.mWidth;
        this.mHeight = builder.mHeight > 0 ? (float)builder.mHeight : this.mHeight;
        this.mStrokeWidth = builder.mStrokeWidth > 0 ? (float)builder.mStrokeWidth : this.mStrokeWidth;
        this.mCenterRadius = builder.mCenterRadius > 0 ? (float)builder.mCenterRadius : this.mCenterRadius;
        this.mDuration = builder.mDuration > 0 ? (long)builder.mDuration : this.mDuration;
        this.mColor = builder.mColor != 0 ? builder.mColor : this.mColor;
        this.mGearCount = builder.mGearCount > 0 ? builder.mGearCount : this.mGearCount;
        this.mGearSwipeDegrees = builder.mGearSwipeDegrees > 0 ? builder.mGearSwipeDegrees : this.mGearSwipeDegrees;
        this.setupPaint();
        this.initStrokeInset(this.mWidth, this.mHeight);
    }

    public static class Builder {
        private Context mContext;
        private int mWidth;
        private int mHeight;
        private int mStrokeWidth;
        private int mCenterRadius;
        private int mDuration;
        private int mColor;
        private int mGearCount;
        private int mGearSwipeDegrees;

        public Builder(Context mContext) {
            this.mContext = mContext;
        }

        public Builder setWidth(int width) {
            this.mWidth = width;
            return this;
        }

        public Builder setHeight(int height) {
            this.mHeight = height;
            return this;
        }

        public Builder setStrokeWidth(int strokeWidth) {
            this.mStrokeWidth = strokeWidth;
            return this;
        }

        public Builder setCenterRadius(int centerRadius) {
            this.mCenterRadius = centerRadius;
            return this;
        }

        public Builder setDuration(int duration) {
            this.mDuration = duration;
            return this;
        }

        public Builder setColor(int color2) {
            this.mColor = color2;
            return this;
        }

        public Builder setGearCount(int gearCount) {
            this.mGearCount = gearCount;
            return this;
        }

        public Builder setGearSwipeDegrees(@IntRange(from=0L, to=360L) int gearSwipeDegrees) {
            this.mGearSwipeDegrees = gearSwipeDegrees;
            return this;
        }

        public GearLoadingRenderer build() {
            GearLoadingRenderer loadingRenderer = new GearLoadingRenderer(this.mContext);
            loadingRenderer.apply(this);
            return loadingRenderer;
        }
    }
}

