/*
 * Decompiled with CFR 0.152.
 */
package com.taiyi.typulse.ui;

import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import com.taiyi.typulse.tyusbsdk.pulse.TaiyiManager;
import com.taiyi.typulse.ui.TYUsbDeviceActivity;

public class MainMeasureActivity
extends TYUsbDeviceActivity {
    private static final String TAG = "MainMeasureActivity";
    private TaiyiManager taiyiManager;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent intent = this.getIntent();
        String patientName = intent.getStringExtra("patientName");
        String patientAge = intent.getStringExtra("patientAge");
        String patientGender = intent.getStringExtra("patientGender");
        String patientId = intent.getStringExtra("patientId");
        Log.d((String)TAG, (String)("\u60a3\u8005\u4fe1\u606f - \u59d3\u540d: " + patientName + ", \u5e74\u9f84: " + patientAge + ", \u6027\u522b: " + patientGender));
        this.taiyiManager = TaiyiManager.getInstance();
        if (patientName != null) {
            this.taiyiManager.setPatientName(patientName);
        }
        if (patientGender != null) {
            this.taiyiManager.setPatientGender(patientGender);
        }
        if (patientAge != null) {
            try {
                this.taiyiManager.setPatientAge(Integer.parseInt(patientAge));
            }
            catch (NumberFormatException e) {
                Log.e((String)TAG, (String)("\u5e74\u9f84\u683c\u5f0f\u9519\u8bef: " + patientAge));
            }
        }
        Log.d((String)TAG, (String)"MainMeasureActivity\u5df2\u542f\u52a8\uff0c\u7b49\u5f85\u6d4b\u91cf\u7ed3\u679c\u901a\u8fc7TyPulseManager\u56de\u8c03");
        TaiyiManager.getInstance().setSkipInterface(new TaiyiManager.SkipInterface(){

            @Override
            public void onSkip() {
                Log.d((String)MainMeasureActivity.TAG, (String)"\u7528\u6237\u8df3\u8fc7\u6d4b\u8109");
                MainMeasureActivity.this.setResult(0);
                MainMeasureActivity.this.finish();
            }
        });
        this.checkUsbDevice();
        this.startMeasurement();
    }

    private void checkUsbDevice() {
        Log.d((String)TAG, (String)"\u68c0\u67e5USB\u8bbe\u5907\u8fde\u63a5\u72b6\u6001");
    }

    private void startMeasurement() {
        Log.d((String)TAG, (String)"\u5f00\u59cb\u6d4b\u8109\u6d41\u7a0b");
        new Thread(() -> {
            try {
                Thread.sleep(3000L);
                this.runOnUiThread(() -> TaiyiManager.getInstance().onResult("75", "pulseResult", "MEASURE_" + System.currentTimeMillis(), "\u6a21\u62df\u6d4b\u8109\u62a5\u544a\u6570\u636e"));
            }
            catch (InterruptedException e) {
                Log.e((String)TAG, (String)"\u6d4b\u8109\u8fc7\u7a0b\u88ab\u4e2d\u65ad", (Throwable)e);
            }
        }).start();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        Log.d((String)TAG, (String)"MainMeasureActivity\u9500\u6bc1");
    }
}

