/*
 * Decompiled with CFR 0.152.
 */
package com.taiyi.typulse.zhimai.common.util;

import android.app.Activity;
import android.content.Context;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.WindowManager;
import com.taiyi.typulse.tyusbsdk.pulse.util.LogUtil;

public class AppSizeCalUtil {
    private static int width = 0;
    private static int height = 0;
    private static int statusBar = -1;

    private static void getWH(Context context) {
        if (width == 0 || height == 0) {
            DisplayMetrics dm = new DisplayMetrics();
            WindowManager wm = (WindowManager)context.getSystemService("window");
            wm.getDefaultDisplay().getMetrics(dm);
            width = dm.widthPixels;
            height = dm.heightPixels;
            LogUtil.i("AutoUtil-", "width=" + width);
            LogUtil.i("AutoUtil-", "height=" + height);
        }
        if (statusBar == -1) {
            int resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
            if (resourceId > 0) {
                statusBar = context.getResources().getDimensionPixelSize(resourceId);
            }
            LogUtil.i("AutoUtil-", "statusBar=" + statusBar);
        }
    }

    public static int getHeight(Context context) {
        DisplayMetrics dm = new DisplayMetrics();
        WindowManager wm = (WindowManager)context.getSystemService("window");
        wm.getDefaultDisplay().getMetrics(dm);
        LogUtil.i("AutoUtil-", "height=" + dm.heightPixels);
        return dm.heightPixels;
    }

    public static int dp2px(Context context, float dpValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public static int px2dip(Context context, float pxValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(pxValue / scale + 0.5f);
    }

    public static int sp2px(Context context, float spVal) {
        return (int)TypedValue.applyDimension((int)2, (float)spVal, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public static float px2sp(Context context, float pxVal) {
        return pxVal / context.getResources().getDisplayMetrics().scaledDensity;
    }

    public static int getWidth(Context context) {
        AppSizeCalUtil.getWH(context);
        return width;
    }

    public static DisplayMetrics getDisplayMetrics(Context context) {
        DisplayMetrics metric = new DisplayMetrics();
        ((Activity)context).getWindowManager().getDefaultDisplay().getMetrics(metric);
        return metric;
    }
}

