/*
 * Decompiled with CFR 0.152.
 */
package com.taiyi.typulse.zhimai.ui.activity.measure;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.blelib.bean.SanBuJiuHou;
import com.blelib.ble.BleController;
import com.blelib.ble.IMeasureListener;
import com.taiyi.typulse.R;
import com.taiyi.typulse.tyusbsdk.pulse.TaiyiManager;
import com.taiyi.typulse.tyusbsdk.pulse.bean.PulseCharacter;
import com.taiyi.typulse.tyusbsdk.pulse.bean.PulseFigure;
import com.taiyi.typulse.tyusbsdk.pulse.bean.PulseParam;
import com.taiyi.typulse.tyusbsdk.pulse.bean.Pulsebean;
import com.taiyi.typulse.tyusbsdk.pulse.bean.TotalPulse;
import com.taiyi.typulse.tyusbsdk.pulse.net.HttpImpl;
import com.taiyi.typulse.tyusbsdk.pulse.net.HttpUtil;
import com.taiyi.typulse.tyusbsdk.pulse.net.TokenOverDueHttpImpl;
import com.taiyi.typulse.tyusbsdk.pulse.util.AppManager;
import com.taiyi.typulse.tyusbsdk.pulse.util.DialogTipUtil;
import com.taiyi.typulse.tyusbsdk.pulse.util.LogUtil;
import com.taiyi.typulse.zhimai.ui.activity.BleStateActivity;
import com.taiyi.typulse.zhimai.ui.widget.GradientView;
import com.taiyi.typulse.zhimai.ui.widget.Pulse3View;
import java.util.ArrayList;
import java.util.Arrays;

public class Measure3Activity
extends BleStateActivity {
    TextView mTvHand;
    ImageView mIc;
    RelativeLayout mRl;
    ImageView mIvCancel;
    Pulse3View mPv;
    GradientView mGv;
    TextView mTvCun;
    TextView mTvGuan;
    TextView mTvChi;
    private int hand;
    private PulseParam mPulseParam;

    @Override
    protected int initLayoutResId() {
        return R.layout.activity_measure3;
    }

    @Override
    protected void init() {
        super.init();
        this.mTvHand = (TextView)this.findViewById(R.id.tv_hand);
        this.mIc = (ImageView)this.findViewById(R.id.ic);
        this.mRl = (RelativeLayout)this.findViewById(R.id.rl);
        this.mIvCancel = (ImageView)this.findViewById(R.id.iv_cancel);
        this.mPv = (Pulse3View)this.findViewById(R.id.pv);
        this.mGv = (GradientView)this.findViewById(R.id.gv);
        this.mTvCun = (TextView)this.findViewById(R.id.tv_cun);
        this.mTvGuan = (TextView)this.findViewById(R.id.tv_guan);
        this.mTvChi = (TextView)this.findViewById(R.id.tv_chi);
        this.getWindow().addFlags(128);
        this.mRl.post(new Runnable(){

            @Override
            public void run() {
                RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)Measure3Activity.this.mRl.getLayoutParams();
                params.height = Measure3Activity.this.mRl.getWidth();
                Measure3Activity.this.mRl.setLayoutParams((ViewGroup.LayoutParams)params);
            }
        });
        this.hand = BleController.getInstance().getHand();
        this.mTvHand.setText(this.hand == 0 ? R.string.measure_left_hand : R.string.measure_right_hand);
        BleController.getInstance().setMeasureId(11111111);
        BleController.getInstance().setIMeasureListener(new IMeasureListener(){

            @Override
            public void onStartMeasure() {
                Measure3Activity.this.mGv.start();
                Measure3Activity.this.mPv.start();
            }

            @Override
            public void onRealTimeWaveGet(int[] cun, int[] guan, int[] chi, int heart) {
                LogUtil.w("Measure3Activity", "cun:" + Arrays.toString(cun));
                LogUtil.w("Measure3Activity", "guan:" + Arrays.toString(guan));
                LogUtil.w("Measure3Activity", "chi:" + Arrays.toString(chi));
                LogUtil.w("Measure3Activity", "heart:" + heart);
            }

            @Override
            public void onProgress(int progress) {
                Measure3Activity.this.mPv.setProgress(progress);
            }

            @Override
            public void onCancelMeasure() {
                Measure3Activity.this.mPv.stop();
                Measure3Activity.this.mGv.end();
                Measure3Activity.this.finish();
            }

            @Override
            @SuppressLint(value={"MissingPermission"})
            public void onPulseResult(Pulsebean pulsebean, PulseFigure pulseFigure, ArrayList<SanBuJiuHou> sanBuJiuHou, PulseCharacter pulseCharacter, TotalPulse totalPulse) {
                Measure3Activity.this.mPv.setProgress(100);
                Measure3Activity.this.mGv.end();
                Measure3Activity.this.uploadResult(pulsebean, pulseFigure, pulseCharacter, totalPulse);
            }

            @Override
            public void onMeasureFailed(Pulsebean pulsebean) {
                Measure3Activity.this.mPv.stop();
                Measure3Activity.this.mGv.end();
                DialogTipUtil.showIKnow((Context)Measure3Activity.this, Measure3Activity.this.getString(R.string.measure_failed), new DialogTipUtil.CommonCallback_I(){

                    @Override
                    public void onSuccess(String str) {
                        Measure3Activity.this.setResult(-1);
                        Measure3Activity.this.finish();
                    }
                });
            }

            @Override
            public void onTimeOut() {
                DialogTipUtil.showIKnow((Context)Measure3Activity.this, Measure3Activity.this.getString(R.string.measure_timeout), new DialogTipUtil.CommonCallback_I(){

                    @Override
                    public void onSuccess(String str) {
                        Measure3Activity.this.setResult(-1);
                        Measure3Activity.this.finish();
                    }
                });
            }
        });
        this.mPv.post(new Runnable(){

            @Override
            public void run() {
                BleController.getInstance().startMeasure();
            }
        });
        this.mIvCancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Measure3Activity.this.showDialog();
            }
        });
    }

    @SuppressLint(value={"MissingPermission"})
    private void uploadResult(Pulsebean pulsebean, PulseFigure pulseFigure, PulseCharacter pulseCharacter, TotalPulse totalPulse) {
        String uid = TaiyiManager.getInstance().getUid();
        this.mPulseParam = PulseParam.getParams(TaiyiManager.getInstance().getAppId(), uid, "Android", Build.VERSION.SDK_INT + "", BleController.getInstance().getBleDevice().getName(), uid, uid, pulsebean, pulseFigure, pulseCharacter, totalPulse, null, uid, BleController.getInstance().getGjversion(), BleController.getInstance().getYjversion(), BleController.getInstance().getSjversion(), BleController.getInstance().getHand());
        this.saveReport();
    }

    private void saveReport() {
        HttpUtil.getInstance().saveMai(this.mPulseParam, new TokenOverDueHttpImpl<String>(){

            @Override
            public void overdue() {
                Measure3Activity.this.getToken();
            }

            @Override
            public void showError(String error) {
                DialogTipUtil.showSelectDialog((Context)Measure3Activity.this, Measure3Activity.this.getString(R.string.dialog_tip_tip), Measure3Activity.this.getString(R.string.measure_skip_tip_1), R.string.measure_skip, R.string.dialog_tip_retry, new DialogTipUtil.OptionClickCallback_I(){

                    @Override
                    public void leftClick() {
                        TaiyiManager.getInstance().clearMeasure();
                        if (TaiyiManager.getInstance().getSkipInterface() != null) {
                            TaiyiManager.getInstance().getSkipInterface().onSkip();
                        }
                        Measure3Activity.this.finish();
                    }

                    @Override
                    public void rightClick() {
                        Measure3Activity.this.saveReport();
                    }
                });
            }

            @Override
            public void showResponse(String response) {
                Measure3Activity.this.setResult(-1);
                Measure3Activity.this.finish();
            }
        });
    }

    private void getToken() {
        HttpUtil.getInstance().getRequestQueue((Context)this).check(new HttpImpl<String>(){

            @Override
            public void showError(String error) {
                DialogTipUtil.showIKnow((Context)Measure3Activity.this, error, new DialogTipUtil.CommonCallback_I(){

                    @Override
                    public void onSuccess(String str) {
                        AppManager.getAppManager().finishAllActivity();
                    }
                });
            }

            @Override
            public void showResponse(String response) {
                HttpUtil.AuthorizationValue = response;
                Measure3Activity.this.saveReport();
            }
        });
    }

    @Override
    protected void onDestroy() {
        if (this.mPv != null) {
            this.mPv.stop();
        }
        if (this.mGv != null) {
            this.mGv.end();
        }
        super.onDestroy();
    }

    private void showDialog() {
        DialogTipUtil.showSelectDialog((Context)this, this.getString(R.string.measure_cancel), this.getString(R.string.measure_cancel_tip), R.string.app_cancel, R.string.app_confirm, new DialogTipUtil.OptionClickCallback_I(){

            @Override
            public void leftClick() {
            }

            @Override
            public void rightClick() {
                BleController.getInstance().cancelMeasure();
            }
        });
    }

    public void onBackPressed() {
        this.showDialog();
    }

    @Override
    protected void otherAction() {
        if (this.mGv != null) {
            this.mGv.pause();
        }
        if (this.mPv != null) {
            this.mPv.pause();
        }
    }
}

