/*
 * Decompiled with CFR 0.152.
 */
package com.ba.camera.analyser;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.camera.core.ImageAnalysis;
import androidx.camera.core.ImageProxy;
import androidx.camera.view.PreviewView;
import com.ba.camera.callback.OnCameraAnalyserCallback;
import com.ba.camera.utils.BitmapUtil;
import com.ba.camera.utils.BitmapUtils;
import java.io.File;

public class BaCameraAnalyser
implements ImageAnalysis.Analyzer {
    private OnCameraAnalyserCallback onCameraAnalyserCallback;
    private Context context;
    private PreviewView mPreviewView;
    Bitmap bitmapFull = null;

    public void setOnCameraAnalyserCallback(OnCameraAnalyserCallback onCameraAnalyserCallback) {
        this.onCameraAnalyserCallback = onCameraAnalyserCallback;
    }

    public void setPreviewView(PreviewView mPreviewView) {
        this.mPreviewView = mPreviewView;
    }

    private Bitmap cropBitmap(Bitmap bitmap, int cropWidth, int cropHeight) {
        int w = bitmap.getWidth();
        int h = bitmap.getHeight();
        return Bitmap.createBitmap((Bitmap)bitmap, (int)((w - cropWidth) / 2), (int)((h - cropHeight) / 2), (int)cropWidth, (int)cropHeight, null, (boolean)false);
    }

    @SuppressLint(value={"UnsafeOptInUsageError"})
    public void analyze(@NonNull ImageProxy imageProxy) {
        Bitmap bitmap = null;
        try {
            if (Build.VERSION.SDK_INT >= 21) {
                bitmap = BitmapUtils.getBitmap(imageProxy);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.bitmapFull = bitmap;
        imageProxy.close();
    }

    public boolean takePhoto(String path, boolean isFull, boolean isPreviewSize, float zoom) {
        Bitmap bitmap = isFull ? this.bitmapFull : this.cropToPreview(this.bitmapFull, isPreviewSize, zoom);
        if (bitmap == null) {
            return false;
        }
        try {
            File fileImg = new File(path);
            BitmapUtil.saveBitmap(bitmap, fileImg);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public Bitmap cropToPreview(Bitmap bitmap) {
        return this.cropToPreview(bitmap, true, 0.0f);
    }

    public Bitmap cropToPreview(Bitmap bitmap, boolean isPreviewSize, float zoom) {
        if (bitmap != null && this.mPreviewView != null) {
            int height = this.mPreviewView.getHeight();
            int width = this.mPreviewView.getWidth();
            if ((float)bitmap.getHeight() / (float)bitmap.getWidth() > (float)this.mPreviewView.getHeight() / (float)this.mPreviewView.getWidth()) {
                int newHeight = bitmap.getWidth() * height / width;
                bitmap = this.cropBitmap(bitmap, bitmap.getWidth(), newHeight);
            } else if ((float)bitmap.getHeight() / (float)bitmap.getWidth() < (float)this.mPreviewView.getHeight() / (float)this.mPreviewView.getWidth()) {
                int newWith = bitmap.getHeight() * width / height;
                bitmap = this.cropBitmap(bitmap, newWith, bitmap.getHeight());
            }
            if (isPreviewSize) {
                bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)width, (int)height, (boolean)true);
            } else if (zoom > 0.0f) {
                bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)((int)((float)bitmap.getWidth() * zoom)), (int)((int)((float)bitmap.getHeight() * zoom)), (boolean)true);
            }
        }
        return bitmap;
    }
}

