/*
 * Decompiled with CFR 0.152.
 */
package android.app.smdt;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Date;

public class LogcatFileManager {
    private static LogcatFileManager INSTANCE = null;
    private static String PATH_LOGCAT;
    private LogDumper mLogDumper = null;
    private int mPId;
    private SimpleDateFormat simpleDateFormat1 = new SimpleDateFormat("yyyyMMddHHmmss");
    private SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static LogcatFileManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new LogcatFileManager();
        }
        return INSTANCE;
    }

    private LogcatFileManager() {
        this.mPId = android.os.Process.myPid();
    }

    public void smdtStartLogcat(String folderPath) {
        LogcatFileManager.getInstance().start(folderPath);
    }

    public void stopLogcatManager() {
        LogcatFileManager.getInstance().stop();
    }

    private void setFolderPath(String folderPath) {
        File folder = new File(folderPath);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        if (!folder.isDirectory()) {
            throw new IllegalArgumentException("The logcat folder path is not a directory: " + folderPath);
        }
        PATH_LOGCAT = folderPath.endsWith("/") ? folderPath : folderPath + "/";
    }

    public void start(String saveDirectoy) {
        this.setFolderPath(saveDirectoy);
        if (this.mLogDumper == null) {
            this.mLogDumper = new LogDumper(String.valueOf(this.mPId), PATH_LOGCAT);
        }
        if (!this.mLogDumper.isAlive()) {
            this.mLogDumper.start();
        }
    }

    public void stop() {
        if (this.mLogDumper != null) {
            this.mLogDumper.stopLogs();
            this.mLogDumper = null;
        }
    }

    private class LogDumper
    extends Thread {
        private Process logcatProc;
        private BufferedReader mReader = null;
        private boolean mRunning = true;
        String cmds = null;
        private String mPID;
        private FileOutputStream out = null;

        public LogDumper(String pid, String dir) {
            this.mPID = pid;
            try {
                this.out = new FileOutputStream(new File(dir, "logcat-" + LogcatFileManager.this.simpleDateFormat1.format(new Date()) + ".log"), true);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            this.cmds = "logcat *:e *:w | grep \"(" + this.mPID + ")\"";
        }

        public void stopLogs() {
            this.mRunning = false;
        }

        @Override
        public void run() {
            try {
                this.logcatProc = Runtime.getRuntime().exec(this.cmds);
                this.mReader = new BufferedReader(new InputStreamReader(this.logcatProc.getInputStream()), 1024);
                String line = null;
                while (this.mRunning && (line = this.mReader.readLine()) != null) {
                    if (!this.mRunning) {
                        break;
                    }
                    if (line.length() == 0 || this.out == null || !line.contains(this.mPID)) continue;
                    this.out.write((LogcatFileManager.this.simpleDateFormat2.format(new Date()) + "  " + line + "\n").getBytes());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (this.logcatProc != null) {
                    this.logcatProc.destroy();
                    this.logcatProc = null;
                }
                if (this.mReader != null) {
                    try {
                        this.mReader.close();
                        this.mReader = null;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (this.out != null) {
                    try {
                        this.out.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    this.out = null;
                }
            }
        }
    }
}

