/*
 * Decompiled with CFR 0.152.
 */
package android.app.smdt.util;

import android.os.Build;
import android.os.SystemProperties;
import android.text.TextUtils;

public class MethodUtil {
    public static final String TAG = "SMDTAPI";
    public static String SERVICENAME = "smdtserver";
    public static int DEBUG_LEVEL0 = 0;
    public static int DEBUG_LEVEL1 = 1;
    public static int DEBUG_LEVEL2 = 2;
    public static int DEBUG_LEVEL3 = 3;
    public static int AndroidSDK = Build.VERSION.SDK_INT;
    public static int AndroidSDK_51 = 22;
    public static int AndroidSDK_71 = 25;
    public static int AndroidSDK_8 = 26;
    public static int AndroidSDK_9 = 28;
    public static int AndroidSDK_10 = 29;
    public static int AndroidSDK_11 = 30;
    public static int AndroidSDK_12 = 31;

    public static Platform getPlatform() {
        String board = SystemProperties.get((String)"ro.board.platform");
        if (MethodUtil.isDevice("527", "527")) {
            return Platform.AW_527;
        }
        if (MethodUtil.isDevice("A311D", "A311D")) {
            return Platform.AMLOGIC_A311D;
        }
        if (MethodUtil.isDevice("3288", "3288")) {
            return Platform.RK3288;
        }
        if (MethodUtil.isDevice("3399", "3399")) {
            return Platform.RK3399;
        }
        if (MethodUtil.isDevice("3568", "3568")) {
            return Platform.RK3568;
        }
        if (MethodUtil.isDevice("3566", "3566")) {
            return Platform.RK3566;
        }
        if (MethodUtil.isDevice("3588", "3588")) {
            return Platform.RK3588;
        }
        if (board.contains("rk")) {
            return Platform.RK;
        }
        return Platform.UNKNOW_PLATFORM;
    }

    private static boolean isDevice(String keyModel, String keyHardware) {
        String osHardware = SystemProperties.get((String)"ro.shimetaos.hardware", (String)"");
        String osModel = SystemProperties.get((String)"ro.shimetaos.model", (String)"");
        String hardware = Build.HARDWARE;
        String model = Build.MODEL;
        keyModel = keyModel.toUpperCase();
        keyHardware = keyHardware.toUpperCase();
        osHardware = osHardware.toUpperCase();
        osModel = osModel.toUpperCase();
        hardware = hardware.toUpperCase();
        model = model.toUpperCase();
        return !TextUtils.isEmpty((CharSequence)osHardware) && osHardware.contains(keyHardware) || !TextUtils.isEmpty((CharSequence)osModel) && osModel.contains(keyModel) || !TextUtils.isEmpty((CharSequence)hardware) && hardware.contains(keyHardware) || !TextUtils.isEmpty((CharSequence)model) && model.contains(keyModel);
    }

    public static enum Platform {
        UNKNOW_PLATFORM,
        RK,
        RK3288,
        RK3399,
        RK3568,
        RK3566,
        RK3588,
        AMLOGIC_A311D,
        AW_527;

    }
}

