/*
 * Decompiled with CFR 0.152.
 */
package com.taiyi.typulse.pulse.fastble.bluetooth;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import com.taiyi.typulse.pulse.fastble.BleManager;
import com.taiyi.typulse.pulse.fastble.bluetooth.BleBluetooth;
import com.taiyi.typulse.pulse.fastble.callback.BleWriteCallback;
import com.taiyi.typulse.pulse.fastble.exception.BleException;
import com.taiyi.typulse.pulse.fastble.exception.OtherException;
import com.taiyi.typulse.pulse.fastble.utils.BleLog;
import java.util.LinkedList;
import java.util.Queue;

public class SplitWriter {
    private HandlerThread mHandlerThread = new HandlerThread("splitWriter");
    private Handler mHandler;
    private BleBluetooth mBleBluetooth;
    private String mUuid_service;
    private String mUuid_write;
    private byte[] mData;
    private int mCount;
    private boolean mSendNextWhenLastSuccess;
    private long mIntervalBetweenTwoPackage;
    private BleWriteCallback mCallback;
    private Queue<byte[]> mDataQueue;
    private int mTotalNum;

    public SplitWriter() {
        this.mHandlerThread.start();
        this.mHandler = new Handler(this.mHandlerThread.getLooper()){

            public void handleMessage(Message msg) {
                super.handleMessage(msg);
                if (msg.what == 51) {
                    SplitWriter.this.write();
                }
            }
        };
    }

    public void splitWrite(BleBluetooth bleBluetooth, String uuid_service, String uuid_write, byte[] data, boolean sendNextWhenLastSuccess, long intervalBetweenTwoPackage, BleWriteCallback callback) {
        this.mBleBluetooth = bleBluetooth;
        this.mUuid_service = uuid_service;
        this.mUuid_write = uuid_write;
        this.mData = data;
        this.mSendNextWhenLastSuccess = sendNextWhenLastSuccess;
        this.mIntervalBetweenTwoPackage = intervalBetweenTwoPackage;
        this.mCount = BleManager.getInstance().getSplitWriteNum();
        this.mCallback = callback;
        this.splitWrite();
    }

    private void splitWrite() {
        if (this.mData == null) {
            throw new IllegalArgumentException("data is Null!");
        }
        if (this.mCount < 1) {
            throw new IllegalArgumentException("split count should higher than 0!");
        }
        this.mDataQueue = SplitWriter.splitByte(this.mData, this.mCount);
        this.mTotalNum = this.mDataQueue.size();
        this.write();
    }

    private void write() {
        if (this.mDataQueue.peek() == null) {
            this.release();
            return;
        }
        byte[] data = this.mDataQueue.poll();
        this.mBleBluetooth.newBleConnector().withUUIDString(this.mUuid_service, this.mUuid_write).writeCharacteristic(data, new BleWriteCallback(){

            @Override
            public void onWriteSuccess(int current, int total, byte[] justWrite) {
                int position = SplitWriter.this.mTotalNum - SplitWriter.this.mDataQueue.size();
                if (SplitWriter.this.mCallback != null) {
                    SplitWriter.this.mCallback.onWriteSuccess(position, SplitWriter.this.mTotalNum, justWrite);
                }
                if (SplitWriter.this.mSendNextWhenLastSuccess) {
                    Message message = SplitWriter.this.mHandler.obtainMessage(51);
                    SplitWriter.this.mHandler.sendMessageDelayed(message, SplitWriter.this.mIntervalBetweenTwoPackage);
                }
            }

            @Override
            public void onWriteFailure(BleException exception) {
                if (SplitWriter.this.mCallback != null) {
                    SplitWriter.this.mCallback.onWriteFailure(new OtherException("exception occur while writing: " + exception.getDescription()));
                }
                if (SplitWriter.this.mSendNextWhenLastSuccess) {
                    Message message = SplitWriter.this.mHandler.obtainMessage(51);
                    SplitWriter.this.mHandler.sendMessageDelayed(message, SplitWriter.this.mIntervalBetweenTwoPackage);
                }
            }
        }, this.mUuid_write);
        if (!this.mSendNextWhenLastSuccess) {
            Message message = this.mHandler.obtainMessage(51);
            this.mHandler.sendMessageDelayed(message, this.mIntervalBetweenTwoPackage);
        }
    }

    private void release() {
        this.mHandlerThread.quit();
        this.mHandler.removeCallbacksAndMessages(null);
    }

    private static Queue<byte[]> splitByte(byte[] data, int count) {
        if (count > 20) {
            BleLog.w("Be careful: split count beyond 20! Ensure MTU higher than 23!");
        }
        LinkedList<byte[]> byteQueue = new LinkedList<byte[]>();
        int pkgCount = data.length % count == 0 ? data.length / count : Math.round(data.length / count + 1);
        if (pkgCount > 0) {
            for (int i = 0; i < pkgCount; ++i) {
                byte[] dataPkg;
                if (pkgCount == 1 || i == pkgCount - 1) {
                    int j = data.length % count == 0 ? count : data.length % count;
                    dataPkg = new byte[j];
                    System.arraycopy(data, i * count, dataPkg, 0, j);
                } else {
                    dataPkg = new byte[count];
                    System.arraycopy(data, i * count, dataPkg, 0, count);
                }
                byteQueue.offer(dataPkg);
            }
        }
        return byteQueue;
    }
}

