/*
 * Decompiled with CFR 0.152.
 */
package com.taiyi.typulse.pulse.fastble.utils;

import com.taiyi.typulse.pulse.fastble.bluetooth.BleBluetooth;
import java.util.LinkedHashMap;
import java.util.Map;

public class BleLruHashMap<K, V>
extends LinkedHashMap<K, V> {
    private final int MAX_SIZE;

    public BleLruHashMap(int saveSize) {
        super((int)Math.ceil((double)saveSize / 0.75) + 1, 0.75f, true);
        this.MAX_SIZE = saveSize;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry eldest) {
        if (this.size() > this.MAX_SIZE && eldest.getValue() instanceof BleBluetooth) {
            ((BleBluetooth)eldest.getValue()).disconnect();
        }
        return this.size() > this.MAX_SIZE;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.entrySet()) {
            sb.append(String.format("%s:%s ", entry.getKey(), entry.getValue()));
        }
        return sb.toString();
    }
}

