/*
 * Decompiled with CFR 0.152.
 */
package com.taiyi.typulse.tyusbsdk;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.github.mikephil.charting.charts.LineChart;
import com.github.mikephil.charting.components.Legend;
import com.github.mikephil.charting.components.XAxis;
import com.github.mikephil.charting.components.YAxis;
import com.github.mikephil.charting.data.ChartData;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.data.LineData;
import com.github.mikephil.charting.data.LineDataSet;
import com.github.mikephil.charting.interfaces.datasets.ILineDataSet;
import com.github.mikephil.charting.utils.ColorTemplate;
import com.taiyi.typulse.R;
import java.util.ArrayList;
import java.util.List;

public class RealTimeAmpGraphView
extends RelativeLayout {
    private LineChart chart;
    private ArrayList<Entry> cunValues;
    private ArrayList<Entry> guanValues;
    private ArrayList<Entry> chiValues;

    public RealTimeAmpGraphView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    private void init(Context context) {
        View layout2 = LayoutInflater.from((Context)context).inflate(R.layout.realtime_amp_graph_view, (ViewGroup)this);
        this.cunValues = new ArrayList();
        this.guanValues = new ArrayList();
        this.chiValues = new ArrayList();
        this.chart = (LineChart)layout2.findViewById(R.id.lineChart);
        this.chart.getDescription().setEnabled(false);
        this.chart.setTouchEnabled(true);
        this.chart.setDragDecelerationFrictionCoef(0.9f);
        this.chart.setDragEnabled(false);
        this.chart.setScaleEnabled(true);
        this.chart.setDrawGridBackground(false);
        this.chart.setHighlightPerDragEnabled(false);
        this.chart.setPinchZoom(true);
        this.chart.setBackgroundColor(-1);
        this.chart.getAxisRight().setEnabled(false);
        this.chart.animateX(1500);
        Legend l = this.chart.getLegend();
        l.setEnabled(false);
        XAxis xAxis = this.chart.getXAxis();
        xAxis.setTextSize(10.0f);
        xAxis.setTypeface(Typeface.DEFAULT_BOLD);
        xAxis.setTextColor(Color.parseColor((String)"#555555"));
        xAxis.setAxisMaximum(100.0f);
        xAxis.setAxisMinimum(0.0f);
        xAxis.setDrawGridLines(false);
        xAxis.setDrawAxisLine(true);
        xAxis.setAxisLineColor(Color.parseColor((String)"#f6f6f6"));
        xAxis.setAxisLineWidth(2.0f);
        xAxis.setPosition(XAxis.XAxisPosition.BOTTOM);
        xAxis.setLabelCount(5);
        xAxis.setGranularity(25.0f);
        YAxis leftAxis = this.chart.getAxisLeft();
        leftAxis.setTextSize(10.0f);
        leftAxis.setTypeface(Typeface.DEFAULT_BOLD);
        leftAxis.setTextColor(Color.parseColor((String)"#555555"));
        leftAxis.setAxisMaximum(200.0f);
        leftAxis.setAxisMinimum(0.0f);
        leftAxis.setDrawGridLines(true);
        leftAxis.setGridLineWidth(2.0f);
        leftAxis.setGridColor(Color.parseColor((String)"#f6f6f6"));
        leftAxis.setDrawAxisLine(false);
        leftAxis.setGranularityEnabled(true);
        leftAxis.setLabelCount(5);
        leftAxis.setGranularity(50.0f);
        LineDataSet set1 = new LineDataSet(this.cunValues, "cun");
        set1.setAxisDependency(YAxis.AxisDependency.LEFT);
        set1.setColor(Color.parseColor((String)"#4f81bd"));
        set1.setCircleColor(Color.parseColor((String)"#4f81bd"));
        set1.setLineWidth(2.0f);
        set1.setCircleRadius(3.0f);
        set1.setFillAlpha(65);
        set1.setFillColor(Color.parseColor((String)"#4f81bd"));
        set1.setDrawCircleHole(false);
        LineDataSet set2 = new LineDataSet(this.guanValues, "guan");
        set2.setAxisDependency(YAxis.AxisDependency.RIGHT);
        set2.setColor(Color.parseColor((String)"#c0504d"));
        set2.setCircleColor(Color.parseColor((String)"#c0504d"));
        set2.setLineWidth(2.0f);
        set2.setCircleRadius(3.0f);
        set2.setFillAlpha(65);
        set2.setFillColor(Color.parseColor((String)"#c0504d"));
        set2.setDrawCircleHole(false);
        LineDataSet set3 = new LineDataSet(this.chiValues, "chi");
        set3.setAxisDependency(YAxis.AxisDependency.RIGHT);
        set3.setColor(Color.parseColor((String)"#9bbb5a"));
        set3.setCircleColor(Color.parseColor((String)"#9bbb5a"));
        set3.setLineWidth(2.0f);
        set3.setCircleRadius(3.0f);
        set3.setFillAlpha(65);
        set3.setFillColor(ColorTemplate.colorWithAlpha((int)Color.parseColor((String)"#9bbb5a"), (int)200));
        set3.setDrawCircleHole(false);
        LineData data = new LineData(new ILineDataSet[]{set1, set2, set3});
        data.setValueTextColor(-1);
        data.setValueTextSize(0.0f);
        this.chart.setData((ChartData)data);
        this.chart.invalidate();
    }

    public void addData(List<Integer> indexArray, float timeSeconds) {
        if (indexArray.size() < 4 || timeSeconds == -1.0f) {
            return;
        }
        this.cunValues.add(new Entry(timeSeconds, (float)indexArray.get(1).intValue()));
        this.guanValues.add(new Entry(timeSeconds, (float)indexArray.get(2).intValue()));
        this.chiValues.add(new Entry(timeSeconds, (float)indexArray.get(3).intValue()));
        if (this.chart.getData() != null && ((LineData)this.chart.getData()).getDataSetCount() > 0) {
            LineDataSet set1 = (LineDataSet)((LineData)this.chart.getData()).getDataSetByIndex(0);
            LineDataSet set2 = (LineDataSet)((LineData)this.chart.getData()).getDataSetByIndex(1);
            LineDataSet set3 = (LineDataSet)((LineData)this.chart.getData()).getDataSetByIndex(2);
            set1.setValues(this.cunValues);
            set2.setValues(this.guanValues);
            set3.setValues(this.chiValues);
            ((LineData)this.chart.getData()).notifyDataChanged();
            this.chart.notifyDataSetChanged();
        }
        if (indexArray.get(1) > 300 || indexArray.get(2) > 300 || indexArray.get(3) > 300) {
            int maxY = indexArray.get(1) > indexArray.get(2) ? indexArray.get(1) : indexArray.get(2);
            maxY = maxY > indexArray.get(3) ? maxY : indexArray.get(3);
            this.chart.getAxisLeft().setAxisMaximum((float)maxY);
        }
        this.chart.invalidate();
    }
}

